<?php

namespace UncannyAutomator\AddOn\UserLists\User;

use UncannyAutomator\AddOn\UserLists\Lists\User_List;

/**
 *
 */
class Users_Page {



	/**
	 * @var
	 */
	private static $plugin;

	/**
	 * @var
	 */
	private static $all_lists;

	/**
	 * @param $plugin
	 */
	public function __construct( $plugin ) {
		self::$plugin = $plugin;

		// The column
		add_filter( 'manage_users_columns', array( $this, 'modify_user_table' ) );
		add_filter( 'manage_users_custom_column', array( $this, 'modify_user_table_row' ), 10, 3 );

		// The filter
		add_action( 'manage_users_extra_tablenav', array( $this, 'user_lists_dropdown' ) );
		add_action( 'pre_get_users', array( $this, 'filter_users_by_user_list' ), 99, 1 );
	}

	/**
	 * filter_users_by_user_list
	 *
	 * @param  mixed $query
	 * @return void
	 */
	public function filter_users_by_user_list( $query ) {

		if ( ! is_admin() ) {
			return;
		}

		global $pagenow;

		if ( 'users.php' !== $pagenow ) {
			return;
		}

		if ( ! automator_filter_has_var( 'ua_user_list' ) ) {
			return;
		}

		$selected_list = automator_filter_input( 'ua_user_list' );

		if ( '0' === $selected_list ) {
			return;
		}

		$list_users = User_List::get_list_users( $selected_list );

		if ( empty( $list_users ) ) {
			$query->set( 'include', array( 0 ) );
			return;
		}

		$query->set( 'include', array_keys( $list_users ) );
	}

	/**
	 * modify_user_table
	 *
	 * @param  mixed $column
	 * @return array
	 */
	public function modify_user_table( $column ) {
		$column['user-lists'] = __( 'User lists', 'uaul' );
		return $column;
	}

	/**
	 * modify_user_table_row
	 *
	 * @param  string $val
	 * @param  string $column_name
	 * @param  mixed  $user_id
	 * @return string
	 */
	public function modify_user_table_row( $val, $column_name, $user_id ) {

		$user_lists = User_List::get_user_lists( $user_id );

		$output = array();

		foreach ( $user_lists as $list ) {
			$output[] = $list->name;
		}

		switch ( $column_name ) {
			case 'user-lists':
				return implode( ', ', $output );
			default:
		}

		return $val;
	}

	/**
	 * user_lists_dropdown
	 *
	 * @return void
	 */
	public function user_lists_dropdown( $which ) {

		if ( 'top' !== $which ) {
			return;
		}

		$allowed_html = array(
			'option' => array(
				'value' => array(),
				'selected' => array(),
			),
		);
		?>

		<div class="user-list-filter">
			<select name="ua_user_list">
			<?php echo wp_kses( $this->dropdown_options(), $allowed_html ); ?>
			</select>
			<input type="submit" class="button action" value="Filter">
		</div>

		<?php
	}

	/**
	 * dropdown_options
	 *
	 * @return array
	 */
	public function dropdown_options() {

		$selected_list = 0;

		if ( automator_filter_has_var( 'ua_user_list' ) ) {
			$selected_list = intval( automator_filter_input( 'ua_user_list' ) );
		}

		$options = '<option value="0">' . __( 'All user lists', 'uaul' ) . '</option>';

		$user_lists = User_List::get_all();

		foreach ( $user_lists as $list ) {

			$selected = '';

			if ( $selected_list === intval( $list->get_id() ) ) {
				$selected = ' selected="selected"';
			}

			$options .= '<option value="' . $list->get_id() . '"' . $selected . '>' . $list->get_name() . ' (' . $list->users_count() . ')</option>';
		}

		return $options;
	}
}
