<?php

namespace UncannyAutomator\AddOn\UserLists\User;

/**
 *
 */
class User_Hash {


	private static $secret;

	/**
	 * generate
	 *
	 * @param  mixed $user_id
	 * @return string
	 */
	public static function generate( $user_id ) {
		$encrypted_id = openssl_encrypt( $user_id . '', 'aes-128-cbc', self::get_secret(), 0, self::get_secret() );
		return base64_encode( $encrypted_id ); // phpcs:ignore WordPress.PHP.DiscouragedPHPFunctions.obfuscation_base64_encode
	}

	/**
	 * decode
	 *
	 * @param  mixed $hash
	 * @return string
	 */
	public static function decode( $hash ) {
		$encrypted_id = base64_decode( $hash ); // phpcs:ignore WordPress.PHP.DiscouragedPHPFunctions.obfuscation_base64_decode
		$decrypted_id = openssl_decrypt( $encrypted_id, 'aes-128-cbc', self::get_secret(), 0, self::get_secret() );

		if ( false === $decrypted_id ) {
			return 0;
		}

		return absint( $decrypted_id );
	}

	/**
	 * make_16_bytes_long
	 *
	 * @param  string $str
	 * @return string
	 */
	private static function make_16_bytes_long( $str ) {
		return substr( $str . 'longer-than-16-characters', 0, 16 );
	}

	/**
	 * get_secret
	 *
	 * @return string
	 */
	private static function get_secret() {

		if ( null === self::$secret ) {
			self::$secret = self::make_16_bytes_long( wp_salt( 'nonce' ) );
		}

		return self::$secret;
	}
}
