<?php

namespace UncannyAutomator\AddOn\UserLists\User;

use UncannyAutomator\AddOn\UserLists\Lists\User_List;

/**
 *
 */
class Shortcode {


	const SHORTCODE = 'automator_ul';

	const URL_PARAM = 'uaul-user';

	const SALT = 'uaul-salt';

	/**
	 * user_lists
	 *
	 * @var array
	 */
	private $user_lists;

	/**
	 * user_data
	 *
	 * @var object
	 */
	private $user_data;

	/**
	 * __construct
	 *
	 * @return void
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'register_shortcode' ) );
		add_action( 'init', array( $this, 'maybe_save_lists' ) );
	}

	/**
	 * register_shortcode
	 *
	 * @return void
	 */
	public function register_shortcode() {
		add_shortcode( self::SHORTCODE, array( $this, 'user_lists_shortcode' ) );
	}

	/**
	 * user_lists_shortcode
	 *
	 * @param mixed $atts
	 * @param mixed $content
	 *
	 * @return string
	 */
	public function user_lists_shortcode( $atts, $content ) {

		$defaults = array(
			'user_id' => get_current_user_id(),
		);

		$atts = shortcode_atts( $defaults, $atts, self::SHORTCODE );

		$user_id = $this->maybe_get_user_id_from_url( $atts['user_id'] );

		$this->user_data = get_userdata( $user_id );

		if ( 0 === $user_id ) {
			return $this->unauthorized_message();
		}

		$table = new User_Lists_Table( $user_id, true, true );

		ob_start();
		$table->html();
		$table_html = ob_get_clean();

		return $this->header() . $table_html . $this->footer();
	}

	public function header() {

		ob_start(); ?>

		<form method='POST' id="uaul-shortcode">
		<?php echo esc_attr( __( 'Manage subscriptions for:', 'uaul' ) . ' ' . $this->user_data->user_email ); ?>

		<?php
		return ob_get_clean();
	}

	public function footer() {
		ob_start();

		// Apply filter ua_ul_user_manage_lists_button_css_class
		$button_css_class = apply_filters( 'automator_ul_user_manage_lists_button_css_class', 'button button-primary' );

		?>
			<input type="hidden" name="uaul-user-id" value="<?php echo esc_attr( $this->user_data->ID ); ?>" />
			<input type="hidden" name="uaul-lists-submitted" value="1" />
			<input 
				type="submit" 
				value="<?php echo esc_attr__( 'Apply', 'uaul' ); ?>" 
				class="<?php echo esc_attr( $button_css_class ); ?>"
			/>
		</form>

		<?php
		return ob_get_clean();
	}

	public function maybe_get_user_id_from_url( $user_id ) {

		// Only proceed if no user logged in.
		if ( 0 !== $user_id ) {
			return $user_id;
		}

		// Only proceed if there is a URL param.
		if ( ! automator_filter_has_var( self::URL_PARAM ) ) {
			return $user_id;
		}

		// No user is logged and URL param is present. Decode the hash.
		return $this->decode_url_param();
	}

	public function decode_url_param() {

		$user_hash = automator_filter_input( self::URL_PARAM );

		return User_Hash::decode( $user_hash );
	}

	public function unauthorized_message() {
		return __( 'Please log in to manage your lists', 'uaul' );
	}

	public function maybe_save_lists() {

		if ( ! automator_filter_has_var( 'uaul-lists-submitted', INPUT_POST ) ) {
			return;
		}

		try {
			$user_id = absint( automator_filter_input( 'uaul-user-id', INPUT_POST ) );

			$unsubscribed_list = User_List::get_unsubscribed_list();
	
			if ( automator_filter_has_var( $unsubscribed_list->get_slug(), INPUT_POST ) ) {
				$unsubscribed_list->add_user( $user_id );
				return;
			}
	
			$user_lists = User_List::get_user_lists( $user_id );
	
			foreach ( $user_lists as $list ) {
	
				if ( ! automator_filter_has_var( $list->get_input_name(), INPUT_POST ) ) {
					$list->remove_user( $user_id );
				}
			}
		} catch ( \Exception $e ) {
			// Maybe handle errors
			// $e->getMessage();
		}
	}
}
