<?php

namespace UncannyAutomator\AddOn\UserLists\User;

use UncannyAutomator\AddOn\UserLists\Lists\User_List;

/**
 *
 */
class Profile {


	/**
	 * @var
	 */
	private static $plugin;

	/**
	 * @var false|mixed|null
	 */
	private static $all_lists;

	/**
	 * @var
	 */
	private $user;

	/**
	 * @var
	 */
	private $user_lists;

	/**
	 * @param $plugin
	 */
	public function __construct( $plugin ) {
		self::$plugin    = $plugin;
		self::$all_lists = User_List::get_all();
		add_action( 'show_user_profile', array( $this, 'add_profile_lists' ) );
		add_action( 'edit_user_profile', array( $this, 'add_profile_lists' ) );

		add_action( 'personal_options_update', array( $this, 'save_lists' ) );
		add_action( 'edit_user_profile_update', array( $this, 'save_lists' ) );
	}

	/**
	 * @param $user
	 *
	 * @return void
	 */
	public function add_profile_lists( $user ) {
		$this->user       = $user;
		$this->user_lists = User_List::get_user_lists( $this->user->ID );

		$show_only_subscribed = true;
		$show_unsubscribed    = false;

		if ( current_user_can( 'edit_users' ) ) {
			$show_only_subscribed = false;
			$show_unsubscribed    = true;
		}

		$table = new User_Lists_Table( $this->user->ID, $show_only_subscribed, $show_unsubscribed );
		$this->header();
		$table->html();
	}

	/**
	 * @return void
	 */
	public function header() {
		?>
		<h3><?php echo esc_attr__( 'Uncanny Automator User Lists', 'uaul' ); ?></h3>
		<?php
	}

	/**
	 * @param $user_id
	 *
	 * @return void
	 */
	public function save_lists( $user_id ) {

		if ( ! $this->allowed_to_update_users( $user_id ) ) {
			return;
		}

		$unsubscribed_list = User_List::get_unsubscribed_list();

		if ( automator_filter_has_var( $unsubscribed_list->get_slug(), INPUT_POST ) ) {
			$unsubscribed_list->add_user( $user_id );
			return;
		}

		foreach ( self::$all_lists as $list ) {

			try {
				if ( automator_filter_has_var( $list->get_input_name(), INPUT_POST ) ) {
					$list->add_user( $user_id );
				} else {
					$list->remove_user( $user_id );
				}
			} catch ( \Exception $e ) {
				// Maybe handle errors
				//$e->getMessage();
			}
			
		}

	}

	/**
	 * @param $user_id
	 *
	 * @return bool
	 */
	public function allowed_to_update_users( $user_id ) {

		$nonce = automator_filter_input( '_wpnonce', INPUT_POST );

		if ( empty( $nonce ) ) {
			return false;
		}

		if ( ! wp_verify_nonce( $nonce, 'update-user_' . $user_id ) ) {
			return false;
		}

		if ( ! current_user_can( 'edit_user', $user_id ) ) {
			return false;
		}

		return true;
	}

}
