<?php

namespace UncannyAutomator\AddOn\RestrictContent\Licensing;

/**
 *
 */
class Updater {


	/**
	 * @param $plugin
	 */
	public function __construct( $plugin ) {
		add_action( 'admin_init', array( $this, 'init' ), 0 );
	}

	/**
	 * @return void
	 */
	public function init() {
		// retrieve our license key from the DB
		$license_key = trim( automator_get_option( 'uap_automator_pro_license_key' ) );

		if ( defined( 'AUTOMATOR_STORE_URL' ) ) {
			$url = AUTOMATOR_STORE_URL;
		} else {
			$url = AUTOMATOR_PRO_STORE_URL;
		}

		// setup the updater
		new EDD_SL_Plugin_Updater(
			$url,
			UAUL_PLUGIN_FILE,
			array(
				'version'   => UAUL_PLUGIN_VERSION,
				'license'   => $license_key,
				'item_id'   => UAUL_ITEM_ID,
				'item_name' => UAUL_ITEM_NAME,
				'author'    => 'Uncanny Automator',
				'beta'      => null,
			)
		);
	}
}
