<?php

namespace UncannyAutomator\AddOn\UserLists\Integration;

use UncannyAutomator\AddOn\UserLists\Licensing\License;
use UncannyAutomator\AddOn\UserLists\Integration\Automator_Integration as Integration;

use UncannyAutomator\AddOn\UserLists\Integration\Triggers\User_Added_To_List;
use UncannyAutomator\AddOn\UserLists\Integration\Triggers\User_Removed_From_List;
use UncannyAutomator\AddOn\UserLists\Integration\Actions\Add_User_To_List;
use UncannyAutomator\AddOn\UserLists\Integration\Actions\Remove_User_From_List;
use UncannyAutomator\AddOn\UserLists\Integration\Actions\Create_List;
use UncannyAutomator\AddOn\UserLists\Integration\Actions\Email_Actions_Changes;
use UncannyAutomator\AddOn\UserLists\Integration\Tokens\Unsubscribe_Link_Token;
use UncannyAutomator\AddOn\UserLists\Integration\Tokens\Unsubscribe_Url_Token;
use UncannyAutomator\AddOn\UserLists\Integration\Tokens\User_Lists_Token;
use UncannyAutomator\AddOn\UserLists\Integration\Tokens\User_Lists_Ids_Token;
use UncannyAutomator\AddOn\UserLists\Integration\Conditions\User_On_List;
use UncannyAutomator\AddOn\UserLists\Integration\Conditions\User_Not_On_List;
use UncannyAutomator\AddOn\UserLists\Integration\Loop_Filters\User_On_List as User_On_List_Loop_Filter;


/**
 * Class Automator_Integration
 *
 * @package Uncanny_Automator
 */
class Automator_Integration extends \Uncanny_Automator\Integration {


	/**
	 * @var
	 */
	public $tokens;

	/**
	 *
	 */
	protected function setup() {
		$this->set_integration( 'UAUSERLISTS' );
		$this->set_name( 'User Lists' );
		$this->set_icon_url( plugin_dir_url( __FILE__ ) . 'img/user-lists-icon.svg' );
	}

	/**
	 * load
	 *
	 * @return void
	 */
	protected function load() {

		$helpers = new UAUL_Helpers();

		new Settings( $helpers );
		new Unsubscribe_Link_Token( $helpers );
		new Unsubscribe_Url_Token( $helpers );
		new User_Lists_Token( $helpers );
		new User_Lists_Ids_Token( $helpers );
		new User_Added_To_List( $helpers );
		new User_Removed_From_List( $helpers );
		new Add_User_To_List( $helpers );
		new Remove_User_From_List( $helpers );
		new Create_List( $helpers );
		new User_On_List();
		new User_Not_On_List();

		new Email_Actions_Changes();

		if ( method_exists( 'Uncanny_Automator_Pro\Loops\Filter\Base\Loop_Filter', 'load_as_external' ) ) {
			new User_On_List_Loop_Filter();
		}

	}
}
