<?php

namespace UncannyAutomator\AddOn\UserLists\Integration\Triggers;

/**
 * Class User_Added_To_List
 */
class User_Added_To_List extends \Uncanny_Automator\Recipe\Trigger {


	protected $helpers;
	protected $dependencies;

	/**
	 * This is a logged-in trigger example that requires a user and allows counting/limiting how many times a user can
	 * trigger the recipe. Logged-in recipes also allow using multiple triggers in a single recipe.
	 */
	protected function setup_trigger() {

		// Store a dependency (optional)
		$this->helpers = array_shift( $this->dependencies );

		// Define the Trigger's info
		$this->set_integration( 'UAUSERLISTS' );
		$this->set_trigger_code( 'USER_ADDED_TO_LIST' );
		$this->set_trigger_meta( 'LIST' );
		$this->set_is_pro( true );

		// translators: Access list name
		$this->set_sentence( sprintf( esc_attr__( 'A user is added to {{a list:%1$s}}', 'uaul' ), 'LIST' ) );
		$this->set_readable_sentence( esc_attr__( 'A user is added to {{a list}}', 'uaul' ) );

		// Trigger wp hook
		$this->add_action( 'automator_ul_user_added_to_list', 10, 3 );
	}

	/**
	 * options
	 *
	 * @return void
	 */
	public function options() {

		$lists_dropdown = array(
			'input_type'  => 'select',
			'option_code' => 'LIST',
			'label'       => __( 'User list', 'uaul' ),
			'required'    => true,
			'options'     => $this->helpers->user_lists_options( true ),
			'placeholder' => __( 'Please select a list', 'uaul' ),
		);

		return array(
			$lists_dropdown,
		);
	}

	/**
	 * @return bool
	 */
	public function validate( $trigger, $hook_args ) {

		// Make sure the trigger has some value selected in the options
		if ( ! isset( $trigger['meta']['LIST'] ) ) {
			//Something is wrong, the trigger doesn't have the required option value.
			return false;
		}

		// Get the dropdown value
		$selected_list = $trigger['meta']['LIST'];

		// Parse the args from the wp_after_insert_post hook
		list( $user_id, $list_id, $list ) = $hook_args;

		$valid_trigger = false;

		if ( '-1' === $selected_list ) {
			$valid_trigger = true;
		}

		if ( intval( $selected_list ) === $list_id ) {
			$valid_trigger = true;
		}

		if ( $valid_trigger ) {
			$this->set_user_id( $user_id );
		}

		return $valid_trigger;
	}

	/**
	 * define_tokens
	 *
	 * Alter this method if you want to add some additional tokens.
	 *
	 * @param  mixed $tokens
	 * @param  mixed $trigger - options selected in the current recipe/trigger
	 * @return array
	 */
	public function define_tokens( $trigger, $tokens ) {

		$tokens[] = array(
			'tokenId'   => 'LIST_NAME',
			'tokenName' => __( 'List name', 'uaul' ),
			'tokenType' => 'text',
		);

		return $tokens;
	}

	/**
	 * hydrate_tokens
	 *
	 * Here you need to pass the values for the trigger tokens.
	 * Note that each token field also has a token that has to be populated in this method.
	 *
	 * @param  mixed $trigger
	 * @param  mixed $hook_args
	 * @return void
	 */
	public function hydrate_tokens( $trigger, $hook_args ) {

		list( $user_id, $list_id, $list ) = $hook_args;

		$token_values = array(
			'LIST'      => $list->id,
			'LIST_NAME' => $list->name,
		);

		return $token_values;
	}
}
