<?php

namespace UncannyAutomator\AddOn\UserLists\Integration\Tokens;

use UncannyAutomator\AddOn\UserLists\Lists\User_List;
use Uncanny_Automator\Tokens\Universal_Token;

/**
 *
 */
class User_Lists_Ids_Token extends Universal_Token {


	/**
	 * @var string
	 */
	protected $integration;
	/**
	 * @var
	 */
	protected $fields;

	/**
	 * @var
	 */
	protected $helpers;

	/**
	 * @param $meta
	 * @param $name
	 */
	public function __construct( $helpers ) {

		$this->integration   = 'UAUSERLISTS';
		$this->id            = 'USER_LISTS_IDS';
		$this->name          = __( "User's lists IDs", 'uaul' );
		$this->helpers       = $helpers;
		$this->requires_user = true;
		$this->cacheable     = false;

		parent::__construct();
	}

	/**
	 * @param $return
	 * @param $pieces
	 * @param $recipe_id
	 * @param $trigger_data
	 * @param $user_id
	 * @param $replace_args
	 *
	 * @return mixed|string
	 */
	public function parse_integration_token( $return, $pieces, $recipe_id, $trigger_data, $user_id, $replace_args ) {

		if ( empty( $user_id ) ) {
			return '';
		}

		$user_lists = User_List::get_user_lists( $user_id );

		$lists_ids = array();

		foreach ( $user_lists as $list ) {
			$lists_ids[] = $list->id;
		}

		return implode( ', ', $lists_ids );
	}
}
