<?php

namespace UncannyAutomator\AddOn\UserLists\Integration\Tokens;

use UncannyAutomator\AddOn\UserLists\Integration\Settings;
use UncannyAutomator\AddOn\UserLists\User\User_Hash;

use Uncanny_Automator\Tokens\Universal_Token;
use UncannyAutomator\AddOn\UserLists\User\Shortcode;

/**
 *
 */
class Unsubscribe_Url_Token extends Universal_Token {


	/**
	 * @var string
	 */
	protected $integration;
	/**
	 * @var
	 */
	protected $fields;

	/**
	 * @var
	 */
	protected $helpers;

	/**
	 * @param $meta
	 * @param $name
	 */
	public function __construct( $helpers ) {

		$this->integration   = 'UAUSERLISTS';
		$this->id            = 'UNSUBSCRIBE_URL';
		$this->name          = __( 'Unsubscribe URL', 'uaul' );
		$this->helpers       = $helpers;
		$this->requires_user = false;
		$this->cacheable     = false;

		parent::__construct();
	}

	/**
	 * @param $return
	 * @param $pieces
	 * @param $recipe_id
	 * @param $trigger_data
	 * @param $user_id
	 * @param $replace_args
	 *
	 * @return mixed|string
	 */
	public function parse_integration_token( $return, $pieces, $recipe_id, $trigger_data, $user_id, $replace_args ) {
		
		if ( empty( $user_id ) ) {
			return '';
		}
		
		$user_hash = User_Hash::generate( $user_id );

		$manage_emails_page_path = Settings::get( 'link_path' );

		$manage_emails_url = get_home_url() . $manage_emails_page_path;

		$url = add_query_arg( Shortcode::URL_PARAM, $user_hash, $manage_emails_url );

		return $url;
	}
}
