<?php

namespace UncannyAutomator\AddOn\UserLists\Integration;

use UncannyAutomator\AddOn\UserLists\Licensing\License;

/**
 *
 */
class Settings {


	/**
	 *
	 */
	const TAB_PRIORITY = 15;

	/**
	 *
	 */
	const ENABLED_OPTION_NAME = 'uaul_enabled';

	/**
	 *
	 */
	const SETTINGS_OPTION_NAME = 'uaul_settings';

	/**
	 *
	 */
	const SETTINGS_GROUP = 'uaul';

	/**
	 * @var
	 */
	private static $plugin;

	/**
	 * @var
	 */
	private $default_plugin_settings;

	/**
	 *
	 */
	public function __construct() {
		\add_filter( 'automator_settings_addons_tabs', array( $this, 'create_tab' ), self::TAB_PRIORITY, 1 );
		\add_action( 'admin_init', array( $this, 'register_settings' ) );
	}

	/**
	 * register_settings
	 *
	 * @return void
	 */
	public function register_settings() {

		\automator_add_option( self::ENABLED_OPTION_NAME, '1' );

		$args = array(
			'type'              => 'boolean',
			'sanitize_callback' => array( $this, 'validate_uaul_enabled' ),
		);

		\register_setting( 'uaul', self::ENABLED_OPTION_NAME, $args );
	}

	/**
	 * Adds the tab using the automator_settings_tab filter
	 */
	public function create_tab( $tabs ) {

		if ( 200 === License::uaul_available() ) {
			$tabs['user_lists'] = (object) array(
				'name'     => esc_html__( 'User lists', 'uaul' ),
				'function' => array( $this, 'tab_output' ),
				'preload'  => false,
			);
		};

		return $tabs;
	}

	/**
	 * Outputs the content of the "Custom user lists" tab
	 */
	public function tab_output() {

		// $this->load_css();
		$this->load_js();

		?>

		<form method="POST" action="options.php">

		<?php \settings_fields( self::SETTINGS_GROUP ); ?>

			<div class="uap-settings-panel uaul-settings">

				<div class="uap-settings-panel-top">

					<div class="uap-settings-panel-title">
		<?php esc_html_e( 'User lists', 'uaul' ); ?>
					</div>

					<div class="uap-settings-panel-content">

		<?php $this->tab_content(); ?>

					</div>
				</div>

			</div><!--.uap-settings-panel-->

		</form>
		<?php
	}

	/**
	 * @return void
	 */
	private function tab_content() {
		?>
		<uap-user-lists-settings></uap-user-lists-settings>
		<?php
	}

	/**
	 * validate_uaul_enabled
	 *
	 * Fires when someone tries to enable/disable uaul functionality on the settings page.
	 *
	 * @param mixed $value
	 *
	 * @return mixed
	 */
	public function validate_uaul_enabled( $value ) {
		return $value;
	}

	/**
	 * @return void
	 */
	public function load_js() {

		$script_url = \plugins_url( 'dist/settings.js', UAUL_PLUGIN_FILE );

		\wp_register_script( 'uaul-settings', $script_url, array( 'wp-api', 'wp-api-fetch' ), true, true );
		\wp_localize_script( 'uaul-settings', 'UncannyAutomatorUserListsSettings', $this->pass_to_js() );
		\wp_enqueue_script( 'uaul-settings' );

	}

	/**
	 * @return mixed|null
	 */
	public function pass_to_js() {

		$settings = automator_get_option( 'uaul_settings', $this->default_plugin_settings );

		return \apply_filters(
			'automator_ul_settings_pass_to_js',
			array(
				'i18n'                    => array(
					'addList'                       => esc_html__( 'Add list', 'uaul' ),
					'noLists'                       => esc_html__( 'No lists', 'uaul' ),
					'editList'                      => esc_html__( 'Edit list', 'uaul' ),
					'createList'                    => esc_html__( 'Create list', 'uaul' ),
					'savingList'                    => esc_html__( 'Saving list', 'uaul' ),
					'listSavedSuccessfully'         => esc_html__( 'List saved successfully', 'uaul' ),
					'listID'                        => esc_html__( 'ID', 'uaul' ),
					'listName'                      => esc_html__( 'List name', 'uaul' ),
					'slug'                          => esc_html__( 'Slug', 'uaul' ),
					'save'                          => esc_html_x( 'Save', 'Verb. Button action', 'uaul' ),
					'cancel'                        => esc_html_x( 'Cancel', 'Verb. Button action', 'uaul' ),
					'customSlug'                    => esc_html__( 'Use custom slug', 'uaul' ),
					'yes'                           => esc_html__( 'Yes', 'uaul' ),
					'no'                            => esc_html__( 'No', 'uaul' ),
					'autogenerated'                 => esc_html__( '(autogenerated)', 'uaul' ),
					'users'                         => esc_html__( 'Users', 'uaul' ),
					'usersExplain'                  => esc_html__( 'Users that are added to this list.', 'uaul' ),
					'accessLists'                   => esc_html__( 'Access lists', 'uaul' ),
					'deleteList'                    => esc_html__( 'Delete list', 'uaul' ),
					'deletingList'                  => esc_html__( 'Deleting list', 'uaul' ),
					'listDeletedSuccessfully'       => esc_html__( 'List deleted successfully', 'uaul' ),
					'deleteNoticeMessage'           => esc_html__( 'Deleting the list will remove it from the list and from tokens in Automator recipes, but no data will be deleted for users in the database.', 'uaul' ),
					'unusbscribeLinkTextFieldLabel' => esc_html__( 'Unsubscribe link text', 'uaul' ),
					'unusbscribeLinkPathFieldLabel' => esc_html__( 'Unsubscribe URL', 'uaul' ),
					'updateLink'                    => esc_html__( 'Save link settings', 'uaul' ),
					'updatingLink'                  => esc_html__( 'Saving settings', 'uaul' ),
					'linkUpdatedSuccessfully'       => esc_html__( 'Settings updated successfully', 'uaul' ),
				),
				'unsubscribeLinkSettings' => array(
					'linkText' => $settings['link_text'],
					'linkPath' => $settings['link_path'],
				),
				'usersTableLink' 		 => \admin_url( 'users.php?ua_user_list=' )
			)
		);
	}

	/**
	 * update
	 *
	 * @param  array $new_settings
	 * @return void
	 */
	public static function update( $new_settings ) {

		$current_settings = automator_get_option( self::SETTINGS_OPTION_NAME, array() );

		$updated_settings = array_merge( $current_settings, $new_settings );

		automator_update_option( self::SETTINGS_OPTION_NAME, $updated_settings );

		return $updated_settings;
	}

	/**
	 * get
	 *
	 * Returns all settings or a specific key from the plugin's settings.
	 *
	 * @param  mixed $setting
	 * @return void
	 */
	public static function get( $setting = null ) {

		$current_seetings = automator_get_option( self::SETTINGS_OPTION_NAME, array() );

		if ( null === $setting ) {
			return $current_seetings;
		}

		return $current_seetings[ $setting ];
	}
}
