<?php
namespace UncannyAutomator\AddOn\UserLists\Integration\Loop_Filters;

use Uncanny_Automator_Pro\Loops\Filter\Base\Loop_Filter;
use UncannyAutomator\AddOn\UserLists\Integration\UAUL_Helpers;
use UncannyAutomator\AddOn\UserLists\Lists\User_List;


/**
 * Loop filter User has {{a specific role}}
 *
 * @since 5.0
 */
class User_On_List extends Loop_Filter {


	private $helpers;

	public function setup() {

		$this->helpers = new UAUL_Helpers();

		$this->set_integration( 'UAUSERLISTS' );

		$this->set_meta( 'LIST' );

		$this->set_sentence( esc_html_x( 'The user {{is/is not}} on {{a list}}', 'uaul' ) );

		$this->set_sentence_readable(
			sprintf(
			/* translators: Filter sentence */
				esc_html_x( 'The user {{is/is not:%1$s}} on {{a list:%2$s}}', 'Filter sentence', 'uaul' ),
				'CRITERIA',
				$this->get_meta()
			)
		);

		$this->set_fields( array( $this, 'load_options' ) );

		$this->set_entities( array( $this, 'retrieve_users_from_list' ) );

		$this->load_as_external( self::class, $this->get_meta() );

	}

	/**
	 * @return mixed[]
	 */
	public function load_options() {

		return array(
			$this->get_meta() => array(
				array(
					'option_code'           => 'CRITERIA',
					'type'                  => 'select',
					'label'                 => esc_html_x( 'Criteria', 'User Lists', 'uaul' ),
					'options'               => array(
						array(
							'text'  => esc_html_x( 'is', 'User Lists', 'uaul' ),
							'value' => esc_html_x( 'is-on', 'User Lists', 'uaul' ),
						),
						array(
							'text'  => esc_html_x( 'is not', 'User Lists', 'uaul' ),
							'value' => esc_html_x( 'not-on', 'User Lists', 'uaul' ),
						),
					),
					'required'              => true,
					'supports_custom_value' => false,
					'options_show_id'       => false,
				),
				array(
					'option_code' => $this->get_meta(),
					'type'        => 'select',
					'label'       => esc_html_x( 'List', 'User Lists', 'uaul' ),
					'options'     => $this->helpers->user_lists_options(),
				),
			),
		);
	}

	/**
	 * @param array{LIST:string,CRITERIA:string} $fields
	 *
	 * @return int[]
	 */
	public function retrieve_users_from_list( $fields ) {

		$criteria = $fields['CRITERIA'];
		$list     = $fields['LIST'];

		$entities = array_keys( User_List::get_list_users( $list ) );

		if ( 'not-on' === $criteria ) {
			$user_q   = new \WP_User_Query( array( 'exclude' => $entities ) );
			$results  = $user_q->get_results();
			$entities = ! empty( $results ) ? array_column( $results, 'ID' ) : array();
		}

		return $entities;

	}

}
