<?php

namespace UncannyAutomator\AddOn\UserLists\Integration;

use UncannyAutomator\AddOn\UserLists\Lists\User_List;

class UAUL_Helpers {

	/**
	 * user_lists_options
	 *
	 * @return array
	 */
	public function user_lists_options( $add_any_option = false ) {

		$lists = User_List::get_all();

		$options = array();

		if ( $add_any_option ) {

			$options[] = array(
				'text'  => __( 'Any list', 'uaul' ),
				'value' => '-1',
			);

		}

		foreach ( $lists as $list ) {
			$options[] = array(
				'value' => $list->id,
				'text'  => $list->name,
			);
		}

		return $options;
	}
}
