<?php

namespace UncannyAutomator\AddOn\UserLists\Integration\Conditions;

use UncannyAutomator\AddOn\UserLists\Integration\UAUL_Helpers;
use UncannyAutomator\AddOn\UserLists\Lists\User_List;

/**
 * Class User_Not_On_List
 */
class User_Not_On_List extends \Uncanny_Automator_Pro\Action_Condition {

	/**
	 * @var
	 */
	public $helpers;

	/**
	 * @return void
	 */
	public function define_condition() {

		$this->helpers = new UAUL_Helpers();

		$this->integration = 'UAUSERLISTS';

		$this->name = __( 'The user is not on {{a list}}', 'uaul' );

		// Condition code
		$this->code = 'USER_NOT_ON_LIST';

		// Dynamic name
		$this->dynamic_name = sprintf(
		// translators: Access list name
			esc_html__( 'The user is not on {{a list:%s}}', 'uaul' ),
			'LIST'
		);

		// This particular condition requires a user
		$this->requires_user = true;
	}

	/**
	 * Method fields
	 *
	 * @return array
	 */
	public function fields() {

		$lists_dropdown = array(
			'input_type'  => 'select',
			'option_code' => 'LIST',
			'label'       => __( 'User list', 'uaul' ),
			'required'    => true,
			'options'     => $this->helpers->user_lists_options(),
			'placeholder' => __( 'Please select a list', 'uaul' ),
		);

		return array(
			$lists_dropdown,
		);
	}

	/**
	 * Evaluate_condition
	 *
	 * Has to use the $this->condition_failed( $message ); method if the condition is not met.
	 *
	 * @return void
	 */
	public function evaluate_condition() {

		// Get the text that users entered in the condition option
		$list_id = mb_strtolower( $this->get_parsed_option( 'LIST' ) );

		$list = User_List::get( $list_id );

		if ( true === $list->has_user( $this->user_id ) ) {

			$list = User_List::get( $list_id );

			// Create any error string
			// translators: User list name
			$log_error = sprintf( __( 'User is on "%s" list', 'uaul' ), $list->name );

			// Pass the error to the condition_failed method
			// This will prevent the action from running
			$this->condition_failed( $log_error );

		}

		// If the condition is met, do nothing and let the action run.
	}
}
