<?php

namespace UncannyAutomator\AddOn\UserLists\Integration\Actions;

use UncannyAutomator\AddOn\UserLists\Lists\User_List;

/**
 * Class Remove_User_From_List
 */
class Remove_User_From_List extends \Uncanny_Automator\Recipe\Action {


	protected $helpers;
	protected $dependencies;

	/**
	 *
	 */
	protected function setup_action() {

		$this->helpers = array_shift( $this->dependencies );

		// Define the Actions's info
		$this->set_integration( 'UAUSERLISTS' );
		$this->set_action_code( 'REMOVE_USER_FROM_LIST' );
		$this->set_action_meta( 'LIST' );
		$this->set_is_pro( true );

		// Define the Action's sentence
		// translators: Access list name
		$this->set_sentence( sprintf( esc_attr__( 'Remove the user from {{a list:%1$s}}', 'uaul' ), $this->get_action_meta() ) );
		$this->set_readable_sentence( esc_attr__( 'Remove the user from {{a list}}', 'uaul' ) );
	}

	/**
	 * Define the Action's options
	 *
	 * @return void
	 */
	public function options() {

		$lists_dropdown = array(
			'input_type'            => 'select',
			'option_code'           => 'LIST',
			'label'                 => __( 'User list', 'uaul' ),
			'required'              => true,
			'options'               => $this->helpers->user_lists_options(),
			'placeholder'           => __( 'Please select a list', 'uaul' ),
			'supports_custom_value' => true,
		);

		return array(
			$lists_dropdown,
		);
	}

	/**
	 * @param int   $user_id
	 * @param array $action_data
	 * @param int   $recipe_id
	 * @param array $args
	 * @param $parsed
	 */
	protected function process_action( $user_id, $action_data, $recipe_id, $args, $parsed ) {

		$action_meta = $action_data['meta'];

		// Get the field values
		$list = Automator()->parse->text( $action_meta['LIST'], $recipe_id, $user_id, $args );

		$list = User_List::get( $list );

		if ( ! $list ) {
			throw new \Exception( __( "List wasn't found", 'uaul' ) );
		}

		return $list->remove_user( $user_id );;
	}
}
