<?php

namespace UncannyAutomator\AddOn\UserLists\Integration\Actions;

use UncannyAutomator\AddOn\UserLists\Lists\User_List;

/**
 * Class Email_Actions_Changes
 */
class Email_Actions_Changes {


	const ACTIONS = array(
		'EMAILS>SENDEMAIL',
		'LD>EMAILACERTIFICATE',
		'WC>WCCREATEANDEMAILCOUPON',
	);

	/**
	 * __construct
	 *
	 * @return void
	 */
	public function __construct() {
		add_filter( 'automator_options_callback_response', array( $this, 'maybe_add_option' ), 10, 5 );
		add_filter( 'automator_email_to', array( $this, 'check_email_addresses' ), 10, 4 );
	}

	/**
	 * maybe_add_option
	 *
	 * @param  array $options
	 * @param  mixed $callback
	 * @param  array $item
	 * @param  array $recipe
	 * @param  mixed $type
	 * @return array
	 */
	public function maybe_add_option( $options, $callback, $item, $recipe, $type ) {

		$item_meta = $item['meta'];

		if ( ! in_array( $item_meta['integration'] . '>' . $item_meta['code'], self::ACTIONS, true ) ) {
			return $options;
		}

		if ( ! isset( $options['options_group'] ) ) {
			return $options;
		}

		$action_meta = $this->get_action_meta( $options );

		$fields = $options['options_group'][ $action_meta ];

		$emailto_field_index = $this->find_emailto_field_index( $fields );

		$fields = $this->insert_after( $fields, $emailto_field_index, $this->checkbox() );

		$options['options_group'][ $action_meta ] = $fields;

		return $options;
	}

	/**
	 * get_action_meta
	 *
	 * @param  array $options
	 * @return string
	 */
	public function get_action_meta( $options ) {
		$keys = array_keys( $options['options_group'] );
		return array_shift( $keys );
	}

	/**
	 * find_emailto_field_index
	 *
	 * @param  mixed $fields
	 * @return int
	 */
	public function find_emailto_field_index( $fields ) {

		foreach ( $fields as $key => $field ) {
			if ( 'EMAILTO' !== $field['option_code'] ) {
				continue;
			}

			return $key;
		}
	}

	/**
	 * insert_after
	 *
	 * @param  array $target_array
	 * @param  mixed $new_item
	 * @param  int   $after_index
	 * @return array
	 */
	public function insert_after( $target_array, $after_index, $new_item ) {
		array_splice( $target_array, $after_index, 0, array( $new_item ) );
		return $target_array;
	}

	/**
	 * checkbox
	 *
	 * @return array
	 */
	public function checkbox() {
		return array(
			'option_code' => 'USERLISTOVERRIDE',
			'label'       => __( 'Bypass Unsubscribed list', 'uaul' ),
			'description' => __( 'If this is not checked, the email will not be sent if the target user/email is on the Unsubscribed list.', 'uaul' ),
			'input_type'  => 'checkbox',
		);
	}

	/**
	 * check_email_addresses
	 *
	 * @param  bool  $send
	 * @param  array $email_params
	 * @param  mixed $action_data
	 * @param  mixed $action
	 * @return bool
	 */
	public function check_email_addresses( $emailto, $action ) {

		$action_data = $action->get_actions_data();

		$action_meta = $action_data['args']['action_meta'];

		if ( ! isset( $action_meta['USERLISTOVERRIDE'] ) ) {
			return $emailto;
		}

		$bypass = filter_var( $action_meta['USERLISTOVERRIDE'], FILTER_VALIDATE_BOOLEAN );

		if ( $bypass ) {
			return $emailto;
		}

		$emailto = $this->remove_unsubscribed_emails( $emailto, $action, $action_data );

		return $emailto;
	}

	/**
	 * remove_unsubscribed_emails
	 *
	 * @param  array $email_params
	 * @param  mixed $action
	 * @return array
	 */
	public function remove_unsubscribed_emails( $emailto, $action, $action_data ) {

		$unsubscribed_list = User_List::get_unsubscribed_list();

		foreach ( $emailto as $key => $email ) {

			$user = get_user_by( 'email', $email );

			if ( false === $user ) {
				continue;
			}

			if ( $unsubscribed_list->has_user( $user->ID ) ) {
				// translators: email address
				$action->set_error_message( sprintf( __( 'Email address %s was removed from the email recipients because the user has unsubscribed from all emails.', 'uaul' ), $email ) );
				$action_data['data']['complete_with_notice'] = true;
				unset( $emailto[ $key ] );
			}
		}

		return $emailto;
	}
}
