<?php

namespace UncannyAutomator\AddOn\UserLists\Integration\Actions;

use UncannyAutomator\AddOn\UserLists\Lists\User_List;

/**
 * Class Create_List
 */
class Create_List extends \Uncanny_Automator\Recipe\Action {


	protected $helpers;
	protected $dependencies;

	/**
	 *
	 */
	protected function setup_action() {

		$this->helpers = array_shift( $this->dependencies );

		// Define the Actions's info
		$this->set_integration( 'UAUSERLISTS' );
		$this->set_action_code( 'CREATE_LIST' );
		$this->set_action_meta( 'LIST' );
		$this->set_is_pro( true );

		// Define the Action's sentence
		// translators: Access list name
		$this->set_sentence( sprintf( esc_attr__( 'Create {{a list:%1$s}}', 'uaul' ), $this->get_action_meta() ) );
		$this->set_readable_sentence( esc_attr__( 'Create {{a list}}', 'uaul' ) );
	}

	/**
	 * Define the Action's options
	 *
	 * @return void
	 */
	public function options() {

		$list_name_input = array(
			'input_type'            => 'text',
			'option_code'           => 'LIST',
			'label'                 => __( 'List name', 'uaul' ),
			'required'              => true,
			'supports_custom_value' => true,
		);

		return array(
			$list_name_input,
		);
	}

	/**
	 * @param int   $user_id
	 * @param array $action_data
	 * @param int   $recipe_id
	 * @param array $args
	 * @param $parsed
	 */
	protected function process_action( $user_id, $action_data, $recipe_id, $args, $parsed ) {

		$action_meta = $action_data['meta'];

		$list_name = Automator()->parse->text( $action_meta['LIST'], $recipe_id, $user_id, $args );

		$list = User_List::create( $list_name );

		return true;
	}
}
