<?php

namespace UncannyAutomator\AddOn\UserLists\Framework;

use UncannyAutomator\AddOn\UserLists\Lists\Post_Type;

/**
 * Plugin_Lifecycle_Events
 *
 * This class will fire hook when the plugin is installed, activated, deactivated, uninstalled and updated.
 */
class Plugin_Lifecycle_Events {

	/**
	 *
	 */
	public function __construct() {

		register_activation_hook(
			UAUL_PLUGIN_FILE,
			array( $this, 'plugin_activated' )
		);

		register_deactivation_hook(
			UAUL_PLUGIN_FILE,
			array( $this, 'plugin_deactivated' )
		);

		register_uninstall_hook(
			UAUL_PLUGIN_FILE,
			array( self::class, 'plugin_uninstalled' )
		);

		add_action( 'automator_ul_plugin_activated', array( $this, 'check_version' ) );
	}

	/**
	 * @return void
	 */
	public static function plugin_uninstalled() {
		do_action( 'automator_ul_plugin_uninstalled' );
	}

	/**
	 * @return void
	 */
	public function check_version() {

		$old_version = Plugin::get_version();
		$new_version = UAUL_PLUGIN_VERSION;

		if ( '0' === $old_version ) {
			$this->plugin_installed();
		}

		if ( version_compare( $old_version, $new_version, '<' ) ) {
			$this->plugin_updated( $old_version, $new_version );
		}
	}

	/**
	 * @return void
	 */
	public function plugin_installed() {
		automator_update_option( Plugin::OPTION_VERSION, UAUL_PLUGIN_VERSION );
		do_action( 'automator_ul_plugin_installed' );
	}

	/**
	 * @param $old_version
	 * @param $new_version
	 *
	 * @return void
	 */
	public function plugin_updated( $old_version, $new_version ) {
		automator_update_option( Plugin::OPTION_VERSION, $new_version );
		do_action( 'automator_ul_plugin_updated', $old_version, $new_version );
	}

	/**
	 * @return void
	 */
	public function plugin_activated() {
		// This will fire before plugins_loaded
		do_action( 'automator_ul_plugin_activated' );
	}

	/**
	 * @return void
	 */
	public function plugin_deactivated() {
		do_action( 'automator_ul_plugin_deactivated' );
	}
}
