<?php

namespace UncannyAutomator\AddOn\UserLists\Framework;

/**
 *
 */
class Admin_Notifications {


	/**
	 * @var
	 */
	private $notifications;

	/**
	 * @param $notifications
	 */
	public function __construct( $notifications ) {

		$this->notifications = $notifications;

		if ( empty( $this->notifications ) ) {
			return;
		}

		add_action( 'automator_show_internal_admin_notice', array( $this, 'output_notices' ) );
	}

	/**
	 * @return void
	 */
	public function output_notices() {
		foreach ( $this->notifications as $notification ) {
			$this->notice_html( $notification['class'], $notification['message'] );
		}
	}

	/**
	 * @param $class
	 * @param $message
	 *
	 * @return void
	 */
	public function notice_html( $class, $message ) {

		$allowed_html = array(
			'<strong>'  => array(),
		);

		printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), wp_kses( $message, $allowed_html ) );
	}
}
