<?php

namespace Uncanny_Automator_Pro\Integrations\Easy_Digital_Downloads;

/**
 * Class EDD_ANON_FILE_DOWNLOADED
 *
 * @package Uncanny_Automator_Pro
 */
class EDD_ANON_FILE_DOWNLOADED extends \Uncanny_Automator\Recipe\Trigger {

	/**
	 * @return mixed|void
	 */
	protected function setup_trigger() {
		$this->set_integration( 'EDD' );
		$this->set_trigger_code( 'EDD_FILE_DOWNLOADED' );
		$this->set_trigger_meta( 'EDD_PRODUCTS' );
		$this->set_is_pro( true );
		$this->set_trigger_type( 'anonymous' );
		$this->set_sentence(
			sprintf(
			// translators: %1$s: Download
				esc_html_x( '{{A file:%1$s}} is downloaded', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
				$this->get_trigger_meta()
			)
		);
		$this->set_readable_sentence( esc_html_x( '{{A file}} is downloaded', 'Easy Digital Downloads', 'uncanny-automator-pro' ) );
		$this->add_action( 'edd_process_verified_download', 10, 4 );
	}

	/**
	 * Options.
	 *
	 * @return array
	 */
	public function options() {
		return array(
			$this->get_item_helpers()->all_edd_downloads( esc_html_x( 'Download', 'Easy Digital Downloads', 'uncanny-automator' ), $this->get_trigger_meta() ),
		);
	}

	/**
	 * @param $trigger
	 * @param $hook_args
	 *
	 * @return bool
	 */
	public function validate( $trigger, $hook_args ) {
		if ( ! isset( $trigger['meta'][ $this->get_trigger_meta() ] ) ) {
			return false;
		}

		$selected_product_id = $trigger['meta'][ $this->get_trigger_meta() ];
		$download_id         = $hook_args[0];

		if ( intval( '-1' ) !== intval( $selected_product_id ) && absint( $selected_product_id ) !== absint( $download_id ) ) {
			return false;
		}

		return true;
	}

	/**
	 * @param $trigger
	 * @param $tokens
	 *
	 * @return array|array[]
	 */
	public function define_tokens( $trigger, $tokens ) {
		$trigger_tokens = array(
			array(
				'tokenId'   => 'DOWNLOAD_ID',
				'tokenName' => esc_html_x( 'Download ID', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
				'tokenType' => 'int',
			),
			array(
				'tokenId'   => 'DOWNLOAD_NAME',
				'tokenName' => esc_html_x( 'Download name', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
				'tokenType' => 'text',
			),
			array(
				'tokenId'   => 'DOWNLOAD_QTY',
				'tokenName' => esc_html_x( 'Download quantity', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
				'tokenType' => 'int',
			),
			array(
				'tokenId'   => 'DOWNLOAD_SUBTOTAL',
				'tokenName' => esc_html_x( 'Download subtotal', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
				'tokenType' => 'int',
			),
			array(
				'tokenId'   => 'DOWNLOAD_TAX',
				'tokenName' => esc_html_x( 'Download tax', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
				'tokenType' => 'int',
			),
			array(
				'tokenId'   => 'DOWNLOAD_PRICE',
				'tokenName' => esc_html_x( 'Download price', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
				'tokenType' => 'int',
			),
		);

		return array_merge( $tokens, $trigger_tokens );
	}

	/**
	 * hydrate_tokens
	 *
	 * @param $trigger
	 * @param $hook_args
	 *
	 * @return array
	 */
	public function hydrate_tokens( $trigger, $hook_args ) {
		$download_id = $hook_args[0];

		$cart_items = edd_get_payment_meta_cart_details( $hook_args[2] );
		foreach ( $cart_items as $item ) {
			if ( absint( $item['id'] ) === absint( $download_id ) ) {

				return array(
					'DOWNLOAD_NAME'     => $item['name'],
					'DOWNLOAD_ID'       => $download_id,
					'DOWNLOAD_QTY'      => $item['quantity'],
					'DOWNLOAD_SUBTOTAL' => edd_currency_filter( edd_format_amount( $item['subtotal'] ) ),
					'DOWNLOAD_TAX'      => edd_currency_filter( edd_format_amount( $item['tax'] ) ),
					'DOWNLOAD_PRICE'    => edd_currency_filter( edd_format_amount( $item['price'] ) ),
				);
			}
		}
	}
}
