<?php
namespace Uncanny_Automator_Pro;

use Exception;

/**
 * Class EDD_USER_HAS_PURCHASED_DOWNLOAD
 *
 * @since 5.2
 *
 * @package Uncanny_Automator_Pro
 */
class EDD_USER_HAS_PURCHASED_DOWNLOAD extends \Uncanny_Automator_Pro\Action_Condition {

	/**
	 * Defines the condition.
	 *
	 * @return void
	 */
	public function define_condition() {

		$this->integration   = 'EDD';
		$this->name          = esc_html_x( 'The user {{has/has not}} purchased {{a download}}', 'Easy Digital Downloads', 'uncanny-automator-pro' );
		$this->code          = 'EDD_ACTIVE_SUBSCRIPTION';
		$this->requires_user = true;
		$this->dynamic_name  = sprintf(
			// translators: %1$s: Condition, %2$s: Download
			esc_html_x( 'The user {{%1$s}} purchased {{a download:%2$s}}', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
			'CONDITION',
			'EDD_DOWNLOAD'
		);
	}

	/**
	 * Defines the fields.
	 *
	 * @return array
	 */
	public function fields() {

		$edd_helper = new \Uncanny_Automator_Pro\Integrations\Easy_Digital_Downloads\Edd_Pro_Helpers();

		return array(
			array(
				'option_code' => 'CONDITION',
				'label'       => esc_html_x( 'Condition', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
				'input_type'  => 'select',
				'required'    => true,
				'options'     => array(
					array(
						'text'  => esc_html_x( 'has', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
						'value' => 'has',
					),
					array(
						'text'  => esc_html_x( 'has not', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
						'value' => 'has-not',
					),
				),
			),
			$edd_helper->all_edd_downloads( esc_html_x( 'Download', 'Easy Digital Downloads', 'uncanny-automator' ), 'EDD_DOWNLOAD', false, false, false ),
		);
	}

	/**
	 * Evaluates the condition.
	 *
	 * Has to use the $this->condition_failed( $message ); method if the condition is not met.
	 *
	 * @return void
	 */
	public function evaluate_condition() {

		$download_id = absint( $this->get_parsed_option( 'EDD_DOWNLOAD' ) );
		$condition   = trim( $this->get_parsed_option( 'CONDITION' ) );
		// @todo: Introduce a getter method in the parent class so the IDE does not complain the that property $user_id is not defined.
		$user_id = absint( $this->user_id );

		if ( ! function_exists( 'edd_has_user_purchased' ) ) {
			$this->condition_failed( 'The function "edd_has_user_purchased" is not defined' );
			return;
		}

		if ( 'has-not' === $condition && true === edd_has_user_purchased( $user_id, $download_id ) ) {
			$this->condition_failed( sprintf( 'The user (ID: %1$d) has purchased the specified download (ID: %2$d)', $user_id, $download_id ) );
			return;
		}

		if ( 'has' === $condition && false === edd_has_user_purchased( $user_id, $download_id ) ) {
			$this->condition_failed( sprintf( 'The user (ID: %1$d) has not purchased the specified download (ID: %2$d)', $user_id, $download_id ) );
			return;
		}
	}

	/**
	 * Check if EDD dependencies are active
	 *
	 * @return bool
	 */
	protected function is_dependency_active() {
		return function_exists( 'EDD' );
	}
}
