<?php

namespace Uncanny_Automator_Pro;

/**
 * Class EDD_USER_DOES_NOT_HAVE_ACTIVE_SUBSCRIPTION
 *
 * @package Uncanny_Automator_Pro
 */
class EDD_USER_DOES_NOT_HAVE_ACTIVE_SUBSCRIPTION extends \Uncanny_Automator_Pro\Action_Condition {

	/**
	 * @return void
	 */
	public function define_condition() {
		$this->integration  = 'EDD';
		$this->name         = esc_html_x( 'The user does not have an active subscription to {{a specific download}}', 'Easy Digital Downloads', 'uncanny-automator-pro' );
		$this->code         = 'EDD_NOT_ACTIVE_SUBSCRIPTION';
		$this->dynamic_name = sprintf(
			// translators: %s: Download
			esc_html_x( 'The user does not have an active subscription to {{a specific download:%s}}', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
			'EDD_DOWNLOAD'
		);
		$this->requires_user = true;
	}

	/**
	 * Method fields
	 *
	 * @return array
	 */
	public function fields() {

		$edd_helper = new \Uncanny_Automator_Pro\Integrations\Easy_Digital_Downloads\Edd_Pro_Helpers();

		return array(
			$edd_helper->all_edd_downloads( esc_html_x( 'Download', 'Easy Digital Downloads', 'uncanny-automator' ), 'EDD_DOWNLOAD', false, false, true ),
		);
	}

	/**
	 * Evaluate_condition
	 *
	 * Has to use the $this->condition_failed( $message ); method if the condition is not met.
	 *
	 * @return void
	 */
	public function evaluate_condition() {
		$download_id = $this->get_parsed_option( 'EDD_DOWNLOAD' );
		$subscriber  = new \EDD_Recurring_Subscriber( $this->user_id, true );

		if ( ! empty( $subscriber->get_subscriptions( $download_id, array( 'active' ) ) ) ) {
			$this->condition_failed(
				sprintf(
					// translators: %s: Download name
					esc_html_x( 'The user has an active subscription to "%s".', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
					$this->get_option( 'EDD_DOWNLOAD_readable' )
				)
			);
		}

		// If the condition is met, do nothing and let the action run.
	}

	/**
	 * Check if EDD Recurring dependencies are active
	 *
	 * @return bool
	 */
	protected function is_dependency_active() {
		return class_exists( 'EDD_Recurring' );
	}
}
