<?php

namespace Uncanny_Automator_Pro\Integrations\Asana;

/**
 * Asana Integration
 *
 * Extends the free version of the Asana integration to include triggers.
 *
 * @package Uncanny_Automator_Pro\Integrations\Asana
 */
class Asana_Pro_Integration extends \Uncanny_Automator\Integrations\Asana\Asana_Integration {

	/**
	 * Setup the integration.
	 *
	 * @return void
	 */
	public function setup() {
		// Define helpers with Pro helpers using the same config values.
		$this->helpers = new Asana_Pro_App_Helpers( self::get_config() );

		// Set the icon URL.
		$this->set_icon_url( plugin_dir_url( __FILE__ ) . 'img/asana-icon.svg' );

		// Finalize setup via the parent class with the common config.
		$this->setup_app_integration( self::get_config() );
	}

	/**
	 * Load Integration Classes.
	 *
	 * @return void
	 */
	public function load() {
		// Load settings page.
		new Asana_Pro_Settings(
			$this->dependencies,
			$this->get_settings_config()
		);

		// Load triggers.
		new TASK_CREATED_IN_PROJECT( $this->dependencies );
		new TASK_UPDATED_IN_PROJECT( $this->dependencies );
		new COMMENT_ADDED_TO_TASK( $this->dependencies );
		new APPROVAL_STATUS_CHANGED( $this->dependencies );
		new TASK_CUSTOM_FIELD_CHANGED( $this->dependencies );
	}

	/**
	 * Register hooks.
	 *
	 * @return void
	 */
	public function register_hooks() {
		// Load webhook AJAX handlers.
		add_action( 'wp_ajax_automator_asana_get_webhook_workspace_options', array( $this->helpers, 'get_webhook_workspace_options_ajax' ) );
		add_action( 'wp_ajax_automator_asana_get_webhook_project_options', array( $this->helpers, 'get_webhook_project_options_ajax' ) );
		add_action( 'wp_ajax_automator_asana_get_webhook_task_options', array( $this->helpers, 'get_webhook_task_options_ajax' ) );
		add_action( 'wp_ajax_automator_asana_get_webhook_project_custom_fields', array( $this->helpers, 'get_webhook_project_custom_fields_ajax' ) );

		// Redefined for extended Pro helpers to over-ride get_standard_task_fields method.
		// Handler lives in Asana_App_Helpers in base plugin.
		add_action( 'wp_ajax_automator_asana_pro_get_field_options', array( $this->helpers, 'get_field_options_ajax' ) );
	}
}
