<?php

namespace Uncanny_Automator_Pro;

/**
 * Class Add_Bo_Integration
 *
 * @package Uncanny_Automator_Pro
 */
class Add_Ameliabooking_Integration {

	/**
	 * Integration code
	 *
	 * @var string
	 */
	public static $integration = 'AMELIABOOKING';

	/**
	 * Only load this integration and its triggers and actions if the related plugin is active
	 *
	 * @param $status
	 * @param $plugin
	 *
	 * @return bool
	 */
	public function plugin_active( $status, $plugin ) {
		$is_plugin_active = class_exists( '\AmeliaBooking\Plugin', false );

		if ( true === $is_plugin_active ) {
			include_once __DIR__ . '/triggers/amelia-user-event-booking-status-updated.php';
			new AMELIA_USER_EVENT_BOOKING_STATUS_UPDATED();

			return true;
		}

		return false;
	}

	/**
	 * Set the directories that the auto loader will run in
	 *
	 * @param $directory
	 *
	 * @return array
	 */
	public function add_integration_directory_func( $directory ) {

		$directory[] = __DIR__ . '/helpers';
		$directory[] = __DIR__ . '/actions';
		$directory[] = __DIR__ . '/triggers';
		$directory[] = __DIR__ . '/tokens';

		return $directory;
	}

	/**
	 * Register the integration by pushing it into the global automator object
	 */
	public function add_integration_func() {
		Automator()->register->integration(
			self::$integration,
			array(
				'name'     => 'Amelia',
				'icon_svg' => Utilities::get_integration_icon( 'amelia-icon.svg' ),
			)
		);
	}
}
