<?php
namespace Uncanny_Automator_Pro;

use Uncanny_Automator\Thrive_Apprentice_Helpers;
/**
 * Class Thrive_Apprentice_Pro_Helpers
 *
 * Use this class to extend pro integration.
 *
 * @package Uncanny_Automator_Pro
 */
class Thrive_Apprentice_Pro_Helpers extends Thrive_Apprentice_Helpers {

	public function __construct() {
		// Nothing to initialize for now
	}

	/**
	 * Get course progress percentage for a user
	 *
	 * @param int $user_id The user ID
	 * @param int $course_id The course ID
	 * @return string The progress percentage (e.g. "75%")
	 */
	public function get_course_progress_percentage( $user_id, $course_id ) {
		$progress = '0%';

		if ( class_exists( '\TVA_Customer' ) && class_exists( '\TVA_Course_V2' ) ) {
			$customer      = new \TVA_Customer( $user_id );
			$tva_course    = new \TVA_Course_V2( $course_id );
			$progress_data = $customer->calculate_progress( $tva_course );
			$progress      = isset( $progress_data['progress'] ) ? $progress_data['progress'] : '0%';
		}

		return $progress;
	}
}
