<?php

namespace UncannyAutomator\AddOn\CustomUserFields\User;

use UncannyAutomator\AddOn\CustomUserFields\Fields\Factory as Fields_Factory;

/**
 *
 */
class Profile {

	/**
	 * @var
	 */
	private static $plugin;
	/**
	 * @var false|mixed|null
	 */
	private static $all_fields;
	/**
	 * @var
	 */
	private $user;

	/**
	 * @param $plugin
	 */
	public function __construct( $plugin ) {
		self::$plugin     = $plugin;
		self::$all_fields = Fields_Factory::get_all();
		add_action( 'show_user_profile', array( $this, 'add_profile_fields' ) );
		add_action( 'edit_user_profile', array( $this, 'add_profile_fields' ) );

		add_action( 'personal_options_update', array( $this, 'save_fields' ) );
		add_action( 'edit_user_profile_update', array( $this, 'save_fields' ) );
	}

	/**
	 * @param $user
	 *
	 * @return void
	 */
	public function add_profile_fields( $user ) {
		$this->user = $user;
		echo $this->header();
		echo $this->table();
	}

	/**
	 * @return void
	 */
	public function header() { ?>

		<h3><?php _e( 'Uncanny Automator Custom User Fields', 'uacuf' ); ?></h3>

		<?php
	}

	/**
	 * @return void
	 */
	public function table() {
		?>
		<table class="form-table">
			<?php
			foreach ( self::$all_fields as $field ) {
				echo $this->row( $field );
			}
			?>
		</table>
		<?php
	}

	/**
	 * @param $field
	 *
	 * @return void
	 */
	public function row( $field ) {
		?>
		<tr>
			<?php echo $this->label( $field ); ?>
			<?php echo $this->input( $field ); ?>
			
		</tr>
		<?php
	}

	/**
	 * @param $field
	 *
	 * @return void
	 */
	public function label( $field ) {
		?>
		<th>
			<label for="<?php echo $field->get_meta(); ?>"><?php echo $field->get_name(); ?></label>
		</th>
		<?php
	}

	/**
	 * @param $field
	 *
	 * @return void
	 */
	public function input( $field ) {

		$value = get_user_meta( $this->user->ID, $field->get_meta(), true );

		?>
		<td>
			<input type="<?php echo $field->get_type(); ?>" name="<?php echo $field->get_meta(); ?>" id="<?php echo $field->get_meta(); ?>" value="<?php echo esc_attr( $value ); ?>" class="regular-text" /><br />
		</td>
		<?php
	}

	/**
	 * @param $user_id
	 *
	 * @return void
	 */
	public function save_fields( $user_id ) {

		if ( ! $this->allowed_to_update_users( $user_id ) ) {
			return;
		}

		foreach ( self::$all_fields as $field ) {

			$meta = $field->get_meta();

			if ( isset( $_POST[ $meta ] ) ) {
				update_user_meta( $user_id, $meta, $_POST[ $meta ] );
			}
		}

	}

	/**
	 * @param $user_id
	 *
	 * @return bool
	 */
	public function allowed_to_update_users( $user_id ) {

		if ( empty( $_POST['_wpnonce'] ) ) {
			return false;
		}

		if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'update-user_' . $user_id ) ) {
			return false;
		}

		if ( ! current_user_can( 'edit_user', $user_id ) ) {
			return false;
		}

		return true;
	}

}
