<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Shortcodes;

use UncannyAutomator\AddOn\CustomUserFields\Fields\Factory as Fields_Factory;

/**
 *
 */
class User_Meta {
	/**
	 * @param $plugin
	 */
	public function __construct( $plugin ) {
		add_shortcode( 'automator_user_fields', array( $this, 'shortcode' ) );
		add_shortcode( 'automator_uf', array( $this, 'shortcode' ) );
		add_shortcode( 'uacuf', array( $this, 'shortcode' ) );
	}

	/**
	 * @param $atts
	 *
	 * @return mixed|void
	 */
	public function shortcode( $atts ) {

		$defaults = array(
			'user_id'  => get_current_user_id(),
			'meta_key' => '',
		);

		$atts = shortcode_atts( $defaults, $atts, 'uacuf' );

		if ( empty( $atts['meta_key'] ) ) {
			return;
		}

		$meta    = $atts['meta_key'];
		$user_id = $atts['user_id'];

		return get_user_meta( $user_id, $meta, true );
	}
}
