<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Licensing;

/**
 *
 */
class Updater {

	/**
	 * @param $plugin
	 */
	public function __construct( $plugin ) {
		add_action( 'admin_init', array( $this, 'init' ), 0 );
	}

	/**
	 * @return void
	 */
	public function init() {
		// retrieve our license key from the DB
		$license_key = trim( automator_get_option( 'uap_automator_pro_license_key' ) );

		// setup the updater
		new EDD_SL_Plugin_Updater(
			AUTOMATOR_PRO_STORE_URL,
			UACUF_PLUGIN_FILE,
			array(
				'version'   => UACUF_PLUGIN_VERSION,
				'license'   => $license_key,
				'item_id'   => UACUF_ITEM_ID,
				'item_name' => UACUF_ITEM_NAME,
				'author'    => 'Uncanny Automator',
				'beta'      => null,
			)
		);
	}
}
