<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Licensing;

use \Uncanny_Automator\Api_Server as Automator_Api;

/**
 *
 */
class License {

	/**
	 * __construct
	 *
	 * @return void
	 */
	public function __construct() {
		add_filter( 'automator_settings_sections', array( $this, 'maybe_force_license_check' ) );
		add_action( 'update_option_uap_automator_pro_license_key', array( $this, 'force_license_check' ) );
		add_action( 'uacuf_plugin_deactivated', array( $this, 'force_license_check' ) );
	}

	/**
	 *
	 */
	const TRANSIENT = 'uacuf_available';

	/**
	 * @return int
	 */
	public static function uacuf_available() {

		$pro_license_key = trim( automator_get_option( 'uap_automator_pro_license_key' ) );

		if ( empty( $pro_license_key ) ) {
			return false;
		}

		$uacuf_available = get_transient( self::TRANSIENT );

		if ( false !== $uacuf_available ) {
			return (int) $uacuf_available;
		}

		$params = array(
			'endpoint' => 'v2/automatorplugin',
			'body'     => array(
				'action' => 'uacuf_available',
			),
		);

		$response_cache_duration = DAY_IN_SECONDS;

		try {
			$response        = Automator_Api::api_call( $params );
			$uacuf_available = $response['statusCode'];
		} catch ( \Exception $e ) {
			$response_cache_duration = HOUR_IN_SECONDS;
			$uacuf_available         = $e->getCode();
		}

		set_transient( self::TRANSIENT, (int) $uacuf_available, $response_cache_duration );

		return (int) $uacuf_available;
	}

	/**
	 * @return void
	 */
	public function maybe_force_license_check( $tabs ) {

		$uacuf_available = (int) get_transient( self::TRANSIENT );

		// If there was an error previously, delete the transient and force a new license check
		// (Because we are on the settings page)
		if ( 200 !== $uacuf_available ) {
			$this->force_license_check();
		}

		return $tabs;
	}

	public function force_license_check() {
		delete_transient( self::TRANSIENT );
	}
}
