<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Integration\Triggers;

/**
 * Class Custom user field updated to a value
 */
class Users_Usermeta_Updated_Value extends \Uncanny_Automator\Recipe\Trigger {

	/**
	 * @var \UncannyAutomator\AddOn\CustomUserFields\Integration\UACUF_Helpers
	 */
	protected $helpers;
	/**
	 * @var
	 */
	protected $dependencies;

	/**
	 * This is a logged-in trigger example that requires a user and allows counting/limiting how many times a user can
	 * trigger the recipe. Logged-in recipes also allow using multiple triggers in a single recipe.
	 *
	 */
	protected function setup_trigger() {

		// Store a dependency (optional)
		$this->helpers = array_shift( $this->dependencies );

		// Define the Trigger's info
		$this->set_integration( 'CUSTOMUSERFIELDS' );
		$this->set_trigger_code( 'USERS_USERMETA_UPDATED_VALUE' );
		$this->set_trigger_meta( 'METAKEY' );
		$this->set_is_pro( true );

		// translators: Access level name
		$this->set_sentence( sprintf( esc_attr__( "A user's {{custom user field:%1\$s}} is updated to {{a value:%2\$s}}", 'uacuf' ), $this->get_trigger_meta(), 'META_VALUE:' . $this->get_trigger_meta() ) );
		$this->set_readable_sentence( esc_attr__( "A user's {{custom user field}} is updated to {{a value}}", 'uacuf' ) );

		// Trigger wp hook
		$this->add_action( array( 'added_user_meta', 'updated_user_meta' ) );

		$this->set_action_args_count( 4 );
	}

	/**
	 * @return array[]
	 */
	public function options() {

		return array(
			array(
				'input_type'  => 'select',
				'option_code' => $this->get_trigger_meta(),
				'label'       => __( 'Custom user field', 'uacuf' ),
				'required'    => true,
				'options'     => $this->helpers->load_custom_field_options( true, true ),
				'placeholder' => __( 'Please select a user field', 'uacuf' ),
			),
			array(
				'input_type'  => 'text',
				'token_name'  => __( 'Custom field value', 'uacuf' ),
				'option_code' => 'META_VALUE',
				'label'       => __( 'Value', 'uacuf' ),
				'required'    => true,
				'placeholder' => __( 'Automator', 'uacuf' ),
			),
		);
	}

	/**
	 * @return bool
	 */
	public function validate( $trigger, $hook_args ) {

		// Make sure the trigger has some value selected in the options
		if ( ! isset( $trigger['meta'][ $this->get_trigger_meta() ] ) ) {
			//Something is wrong, the trigger doesn't have the required option value.
			return false;
		}

		// Get the dropdown value
		$selected_field = $trigger['meta'][ $this->get_trigger_meta() ];
		$selected_value = $trigger['meta']['META_VALUE'];

		// Parse the args from the wp_after_insert_post hook
		list( $meta_id, $user_id, $meta_key, $_meta_value ) = $hook_args;

		if ( '-1' === $selected_field && $_meta_value === $selected_value ) {
			return true;
		}

		if ( trim( $selected_field ) === trim( $meta_key ) && trim( $_meta_value ) === trim( $selected_value ) ) {
			return true;
		}

		return false;
	}

	/**
	 * define_tokens
	 *
	 * Alter this method if you want to add some additional tokens.
	 *
	 * @param mixed $tokens
	 * @param mixed $trigger - options selected in the current recipe/trigger
	 *
	 * @return array
	 */
	public function define_tokens( $trigger, $tokens ) {

		$tokens[] = array(
			'tokenId'   => 'META_KEY_NAME',
			'tokenName' => __( 'Custom field name', 'uacuf' ),
			'tokenType' => 'text',
		);

		return $tokens;
	}

	/**
	 * hydrate_tokens
	 *
	 * Here you need to pass the values for the trigger tokens.
	 * Note that each token field also has a token that has to be populated in this method.
	 *
	 * @param mixed $trigger
	 * @param mixed $hook_args
	 *
	 * @return array
	 * @throws \Exception
	 */
	public function hydrate_tokens( $trigger, $hook_args ) {

		list( $meta_id, $user_id, $meta_key, $_meta_value ) = $hook_args;

		$field = $this->helpers->get_field_by_meta_key( $meta_key );

		$token_values = array(
			$this->get_trigger_meta() => $meta_key,
			'META_KEY_NAME'           => is_object( $field ) ? $field->get_name() : $meta_key,
			'META_VALUE'              => $_meta_value,
		);

		return $token_values;
	}
}
