<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Integration\Tokens;

use UncannyAutomator\AddOn\CustomUserFields\Fields\Factory as Fields_Factory;

use Uncanny_Automator\Tokens\Universal_Token;

/**
 *
 */
class User_Meta_Value_Token extends Universal_Token {

	/**
	 * @var string
	 */
	protected $integration;
	/**
	 * @var
	 */
	protected $fields;

	/**
	 * @param $meta
	 * @param $name
	 * @param $is_meta_key
	 */
	public function __construct( $meta, $name, $is_meta_key ) {

		$this->integration   = 'CUSTOMUSERFIELDS';
		$this->id            = $meta;
		$this->name          = $name;
		$this->requires_user = $is_meta_key ? false : true;
		$this->cacheable     = false;

		parent::__construct();
	}

	/**
	 * @param $return
	 * @param $pieces
	 * @param $recipe_id
	 * @param $trigger_data
	 * @param $user_id
	 * @param $replace_args
	 *
	 * @return mixed|string
	 */
	public function parse_integration_token( $return, $pieces, $recipe_id, $trigger_data, $user_id, $replace_args ) {

		$user_meta = $pieces[2];

		// Change the user ID to the current iterated user in the context of a Loop.
		if ( isset( $replace_args['loop'] ) && is_array( $replace_args['loop'] ) && isset( $replace_args['loop']['user_id'] ) ) {
			$user_id = absint( $replace_args['loop']['user_id'] );
		}

		// If its uacuf meta key AND contains _uacuf_metakey, return the meta key instead of the meta value
		$substring = '_uacuf_metakey';
		if ( strpos( $user_meta, $substring ) && 0 === substr_compare( $user_meta, $substring, - strlen( $substring ) ) ) {
			return str_replace( '_uacuf_metakey', '', $user_meta );
		}

		return get_user_meta( $user_id, $user_meta );
	}
}
