<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Integration\Tokens;

use UncannyAutomator\AddOn\CustomUserFields\Fields\Factory as Fields_Factory;

use Uncanny_Automator\Tokens\Token;

/**
 *
 */
class Register_Tokens {

	/**
	 * @var
	 */
	protected $integration;
	/**
	 * @var false|mixed|null
	 */
	protected $fields;

	/**
	 *
	 */
	public function __construct() {

		// Get all fields
		// Loop through
		$this->fields = Fields_Factory::get_all();

		foreach ( $this->fields as $field ) {
			$this->define_token( $field );
		}
	}

	/**
	 * @param $field
	 *
	 * @return void
	 */
	public function define_token( $field ) {

		$meta_key = $field->get_meta();
		$label    = $field->get_name();

		// Value token
		new User_Meta_Value_Token( $meta_key, $label, false );

		// Key token
		$meta_key .= '_uacuf_metakey';
		$label    .= ' - ' . _x( 'Meta key', 'Token dropdown identifier', 'uacuf' );
		new User_Meta_Value_Token( $meta_key, $label, true );
	}
}
