<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Integration;

use UncannyAutomator\AddOn\CustomUserFields\Licensing\License;

/**
 *
 */
class Settings {

	/**
	 *
	 */
	const TAB_PRIORITY = 15;
	/**
	 *
	 */
	const OPTION_NAME = 'uacuf_enabled';
	/**
	 *
	 */
	const SETTINGS_GROUP = 'uacuf';
	/**
	 * @var
	 */
	private static $plugin;

	/**
	 *
	 */
	public function __construct() {
		add_filter( 'automator_settings_addons_tabs', array( $this, 'create_tab' ), self::TAB_PRIORITY, 1 );
		add_action( 'admin_init', array( $this, 'register_settings' ) );
	}

	/**
	 * register_settings
	 *
	 * @return void
	 */
	public function register_settings() {

		automator_add_option( self::OPTION_NAME, '1' );

		$args = array(
			'type'              => 'boolean',
			'sanitize_callback' => array( $this, 'validate_uacuf_enabled' ),
		);

		register_setting( 'uacuf', self::OPTION_NAME, $args );
	}

	/**
	 * Adds the tab using the automator_settings_tab filter
	 */
	public function create_tab( $tabs ) {

		if ( 200 === License::uacuf_available() ) {
			$tabs['user_fields'] = (object) array(
				'name'     => esc_html__( 'Custom user fields', 'uacuf' ),
				'function' => array( $this, 'tab_output' ),
				'preload'  => false, // Determines if the content should be loaded even if the tab is not selected
			);
		};

		return $tabs;
	}

	/**
	 * Outputs the content of the "Custom user fields" tab
	 */
	public function tab_output() {

		// $this->load_css();
		$this->load_js();

		?>

		<form method="POST" action="options.php">

			<?php settings_fields( self::SETTINGS_GROUP ); ?>

			<div class="uap-settings-panel uacuf-settings">

				<div class="uap-settings-panel-top">

					<div class="uap-settings-panel-title">
						<?php esc_html_e( 'Custom user fields', 'uacuf' ); ?>
					</div>

					<div class="uap-settings-panel-content">

					<?php $this->tab_content(); ?>

					</div>
				</div>

			</div><!--.uap-settings-panel-->

			</form>
		<?php
	}

	/**
	 * @return void
	 */
	private function tab_content() {
		?>
		 <uap-custom-fields-settings></uap-custom-fields-settings> 
		<?php
	}

	/**
	 * validate_uacuf_enabled
	 *
	 * Fires when someone tries to enable/disable uacuf functionality on the settings page.
	 *
	 * @param  mixed $value
	 * @return mixed
	 */
	public function validate_uacuf_enabled( $value ) {
		return $value;
	}

	/**
	 * @return void
	 */
	public function load_js() {

		$script_url = plugins_url( 'src/assets/dist/bundle.min.js', UACUF_PLUGIN_FILE );

		wp_register_script( 'uacuf-settings', $script_url, array( 'wp-api' ), true );
		wp_localize_script( 'uacuf-settings', 'UncannyAutomatorUserFields', $this->pass_to_js() );
		wp_enqueue_script( 'uacuf-settings' );

	}

	/**
	 * @return mixed|null
	 */
	public function pass_to_js() {
		return apply_filters(
			'uacuf_settings_pass_to_js',
			array(
				'i18n'              => array(
					'addField'                 => esc_html__( 'Add field', 'uacuf' ),
					'noFields'                 => esc_html__( 'No fields', 'uacuf' ),
					'editField'                => esc_html__( 'Edit field', 'uacuf' ),
					'createField'              => esc_html__( 'Create field', 'uacuf' ),
					'savingField'              => esc_html__( 'Saving field', 'uacuf' ),
					'fieldSavedSuccessfully'   => esc_html__( 'Field saved successfully', 'uacuf' ),
					'fieldName'                => esc_html__( 'Field name', 'uacuf' ),
					'metaKey'                  => esc_html__( 'Meta key', 'uacuf' ),
					'save'                     => esc_html_x( 'Save', 'Verb. Button action', 'uacuf' ),
					'cancel'                   => esc_html_x( 'Cancel', 'Verb. Button action', 'uacuf' ),
					'customMetaKey'            => esc_html__( 'Use custom meta key', 'uacuf' ),
					'yes'                      => esc_html__( 'Yes', 'uacuf' ),
					'no'                       => esc_html__( 'No', 'uacuf' ),
					'autogenerated'            => esc_html__( '(autogenerated)', 'uacuf' ),
					'fieldName'                => esc_html__( 'Field name', 'uacuf' ),
					'shortcode'                => esc_html__( 'Shortcode', 'uacuf' ),
					'shortcodeExplain'         => __( "Use the shortcode to display the field's value for the user viewing it.", 'uacuf' ),
					'deleteField'              => esc_html__( 'Delete field', 'uacuf' ),
					'deletingField'            => esc_html__( 'Deleting field', 'uacuf' ),
					'fieldDeletedSuccessfully' => esc_html__( 'Field deleted successfully', 'uacuf' ),
					'deleteNoticeMessage'      => esc_html__( 'Deleting the field will remove it from the list and from tokens in Automator recipes, but no data will be deleted for users in the database.', 'uacuf' ),
				),
				'shortcodeTemplate' => '[automator_uf meta_key="%1$s"]',
			)
		);
	}

	// public function load_css() {

	// 	$style_url = plugins_url( 'src/assets/dist/bundle.min.css', UACUF_PLUGIN_FILE );

	// 	wp_register_style( 'uacuf-settings', $style_url );
	// 	wp_enqueue_style( 'uacuf-settings' );
	// }
}
