<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Integration;

use UncannyAutomator\AddOn\CustomUserFields\Fields\Factory as Fields_Factory;

/**
 *
 */
class UACUF_Helpers {
	/**
	 * @param $no_meta_keys
	 * @param $add_any_option
	 *
	 * @return array
	 */
	public function load_custom_field_options( $no_meta_keys = false, $add_any_option = false ) {

		$fields = Fields_Factory::get_all();

		$options = array();

		if ( $add_any_option ) {

			$options[] = array(
				'text'  => __( 'Any custom field', 'uacuf' ),
				'value' => '-1',
			);

		}

		foreach ( $fields as $field ) {
			$text  = $field->get_name();
			$value = $field->get_meta();

			$options[] = array(
				'text'  => $text,
				'value' => $value,
			);

			if ( ! $no_meta_keys ) {
				$value .= '_uacuf_metakey';
				$text  .= ' - ' . _x( 'Meta key', 'Token dropdown identifier', 'uacuf' );

				$options[] = array(
					'text'  => $text,
					'value' => $value,
				);
			}
		}

		return $options;
	}

	/**
	 * @param $meta_key
	 *
	 * @return false|mixed|void|null
	 */
	public function get_field_by_meta_key( $meta_key ) {
		$fields = Fields_Factory::get_all();
		foreach ( $fields as $field ) {
			if ( $meta_key !== $field->get_meta() ) {
				continue;
			}

			return $field;
		}
	}
}
