<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Integration;

/**
 * Class Automator_Integration
 *
 * @package Uncanny_Automator
 */
class Automator_Integration extends \Uncanny_Automator\Integration {

	/**
	 * @var
	 */
	public $tokens;

	/**
	 *
	 */
	protected function setup() {
		$this->set_integration( 'CUSTOMUSERFIELDS' );
		$this->set_name( 'Custom User Fields' );
		$this->set_icon_url( plugin_dir_url( __FILE__ ) . 'img/custom-user-fields-icon.svg' );
	}

	/**
	 * load
	 *
	 * @return void
	 */
	protected function load() {
		$helpers = new UACUF_Helpers();
		new Settings();
		new Tokens\Register_Tokens();
		new Conditions\User_Meta_Meets_Condition();
		new Triggers\Users_Usermeta_Updated( $helpers );
		new Triggers\Users_Usermeta_Updated_Value( $helpers );
		new Actions\Users_Update_Metafield( $helpers );
	}
}
