<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Integration\Actions;

/**
 * Class Add user meta value
 */
class Users_Update_Metafield extends \Uncanny_Automator\Recipe\Action {

	/**
	 * @var \UncannyAutomator\AddOn\CustomUserFields\Integration\UACUF_Helpers
	 */
	protected $helpers;
	/**
	 * @var
	 */
	protected $dependencies;

	/**
	 *
	 */
	protected function setup_action() {

		$this->helpers = array_shift( $this->dependencies );

		// Define the Actions's info
		$this->set_integration( 'CUSTOMUSERFIELDS' );
		$this->set_action_code( 'UPDATE_USER_METAFIELD' );
		$this->set_action_meta( 'METAKEY' );
		$this->set_is_pro( true );

		// Define the Action's sentence
		// translators: Access level name
		$this->set_sentence( sprintf( esc_attr__( "Update the user's {{custom user field:%1\$s}} to {{a value:%2\$s}}", 'uacuf' ), $this->get_action_meta(), 'META_VALUE:' . $this->get_action_meta() ) );
		$this->set_readable_sentence( esc_attr__( "Update the user's {{custom user field}} to {{a value}}", 'uacuf' ) );
	}

	/**
	 * Define the Action's options
	 *
	 * @return array
	 */
	public function options() {

		return array(
			array(
				'input_type'  => 'select',
				'option_code' => $this->get_action_meta(),
				'label'       => __( 'Custom user field', 'uacuf' ),
				'required'    => true,
				'options'     => $this->helpers->load_custom_field_options( true, true ),
				'placeholder' => __( 'Please select a user field', 'uacuf' ),
			),
			array(
				'input_type'  => 'text',
				'option_code' => 'META_VALUE',
				'label'       => __( 'Value', 'uacuf' ),
				'required'    => true,
				'placeholder' => __( 'Automator', 'uacuf' ),
			),
		);
	}

	/**
	 * @param int $user_id
	 * @param array $action_data
	 * @param int $recipe_id
	 * @param array $args
	 * @param $parsed
	 *
	 * @return true|void
	 */
	protected function process_action( $user_id, $action_data, $recipe_id, $args, $parsed ) {

		$action_meta = $action_data['meta'];

		// Get the field values
		$meta_field = Automator()->parse->text( $action_meta[ $this->get_action_meta() ], $recipe_id, $user_id, $args );
		$meta_value = Automator()->parse->text( $action_meta['META_VALUE'], $recipe_id, $user_id, $args );

		$result = update_user_meta( $user_id, $meta_field, $meta_value );

		if ( ! $result ) {
			$this->add_log_error( __( 'Custom field update failed', 'uacuf' ) );

			return;
		}

		return true;
	}
}
