<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Framework;

/**
 * Plugin_Lifecycle_Events
 *
 * This class will fire hook when the plugin is installed, activated, deactivated, uninstalled and updated.
 *
 */
class Plugin_Lifecycle_Events {

	/**
	 *
	 */
	public function __construct() {

		register_activation_hook(
			UACUF_PLUGIN_FILE,
			array( $this, 'plugin_activated' )
		);

		register_deactivation_hook(
			UACUF_PLUGIN_FILE,
			array( $this, 'plugin_deactivated' )
		);

		register_uninstall_hook(
			UACUF_PLUGIN_FILE,
			array( self::class, 'plugin_uninstalled' )
		);

		add_action( 'uacuf_plugin_activated', array( $this, 'check_version' ) );
	}

	/**
	 * @return void
	 */
	public function check_version() {

		$old_version = Plugin::get_version();
		$new_version = UACUF_PLUGIN_VERSION;

		if ( '0' === $old_version ) {
			$this->plugin_installed();
			return;
		}

		if ( version_compare( $old_version, $new_version, '<' ) ) {
			$this->plugin_updated( $old_version, $new_version );
		}
	}

	/**
	 * @return void
	 */
	public function plugin_installed() {
		do_action( 'uacuf_plugin_installed' );
	}

	/**
	 * @param $old_version
	 * @param $new_version
	 *
	 * @return void
	 */
	public function plugin_updated( $old_version, $new_version ) {
		automator_update_option( Plugin::OPTION_VERSION, $new_version );
		do_action( 'uacuf_plugin_updated', $old_version, $new_version );

	}

	/**
	 * @return void
	 */
	public function plugin_activated() {
		do_action( 'uacuf_plugin_activated' );
	}

	/**
	 * @return void
	 */
	public function plugin_deactivated() {
		do_action( 'uacuf_plugin_deactivated' );
	}

	/**
	 * @return void
	 */
	public static function plugin_uninstalled() {
		do_action( 'uacuf_plugin_uninstalled' );
	}
}
