<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Framework;

/**
 *
 */
class Admin_Notifications {

	/**
	 * @var
	 */
	private $notifications;

	/**
	 * @param $notifications
	 */
	public function __construct( $notifications ) {

		$this->notifications = $notifications;

		if ( empty( $this->notifications ) ) {
			return;
		}

		add_action( 'admin_notices', array( $this, 'output_notices' ) );
	}

	/**
	 * @return void
	 */
	public function output_notices() {
		foreach ( $this->notifications as $notification ) {
			$this->notice_html( $notification['class'], $notification['message'] );
		}
	}

	/**
	 * @param $class
	 * @param $message
	 *
	 * @return void
	 */
	public function notice_html( $class, $message ) {
		printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), $message );
	}
}
