<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Fields;

use UncannyAutomator\AddOn\CustomUserFields\Fields\Factory as Fields_Factory;

/**
 *
 */
class Field implements \JsonSerializable {

	/**
	 * @var
	 */
	private $id;
	/**
	 * @var
	 */
	private $meta;
	/**
	 * @var
	 */
	private $name;
	/**
	 * @var
	 */
	private $editable_meta_key;
	/**
	 * @var
	 */
	private $description;

	/**
	 * @var string
	 */
	protected $type = 'text';

	/**
	 * @param $meta
	 * @param $name
	 *
	 * @throws \Exception
	 */
	public function __construct( $meta, $name ) {

		$this->set_id( $this->generate_unique_id() );

		$this->set_meta( $meta );

		$this->set_name( $name );
	}

	/**
	 * @param $id
	 *
	 * @return void
	 */
	public function set_id( $id ) {
		$this->id = $id;
	}

	/**
	 * @param $meta
	 *
	 * @return void
	 * @throws \Exception
	 */
	public function set_meta( $meta ) {

		$meta = $this->sanitize_meta_key( $meta );

		if ( empty( $meta ) ) {
			throw new \Exception( __( 'Field meta is required', 'uacuf' ), 400 );
		}

		$this->meta = $meta;
	}

	/**
	 * @param $name
	 *
	 * @return void
	 * @throws \Exception
	 */
	public function set_name( $name ) {

		if ( empty( $name ) ) {
			throw new \Exception( __( 'Field name is required', 'uacuf' ), 400 );
		}

		$this->name = $name;
	}

	/**
	 * @param $type
	 *
	 * @return void
	 */
	public function set_type( $type ) {
		$this->type = $type;
	}

	/**
	 * @param $description
	 *
	 * @return void
	 */
	public function set_description( $description ) {
		$this->description = $description;
	}

	/**
	 * @param $editable_meta_key
	 *
	 * @return void
	 */
	public function set_editable_meta_key( $editable_meta_key ) {
		$this->editable_meta_key = filter_var( $editable_meta_key, FILTER_VALIDATE_BOOLEAN );
	}

	/**
	 * @return mixed
	 */
	public function get_id() {
		return $this->id;
	}

	/**
	 * @return mixed
	 */
	public function get_meta() {
		return $this->meta;
	}

	/**
	 * @return mixed
	 */
	public function get_name() {
		return $this->name;
	}

	/**
	 * @return string
	 */
	public function get_type() {
		return $this->type;
	}

	/**
	 * @return mixed
	 */
	public function get_description() {
		return $this->description;
	}

	/**
	 * @return mixed
	 */
	public function get_editable_meta_key() {
		return filter_var( $this->editable_meta_key, FILTER_VALIDATE_BOOLEAN );
	}

	/**
	 * @return mixed
	 */
	public function jsonSerialize() {
		return array(
			'id'                => $this->id,
			'meta'              => $this->meta,
			'name'              => $this->name,
			'type'              => $this->type,
			'description'       => $this->description,
			'editable_meta_key' => $this->editable_meta_key,
		);
	}

	/**
	 * @return string
	 */
	public function generate_unique_id() {

		do {
			$unique_id = uniqid();
		} while ( Fields_Factory::exist( $unique_id ) ); // Double check that the ID is unique and doesn't exist.

		return $unique_id;
	}

	/**
	 * @param $meta_key
	 *
	 * @return array|string|string[]
	 */
	public function sanitize_meta_key( $meta_key ) {

		$meta_key = sanitize_title( $meta_key );

		$meta_key = str_replace( '-', '_', $meta_key );

		return $meta_key;
	}
}
