<?php

namespace UncannyAutomator\AddOn\CustomUserFields\Fields;

/**
 *
 */
class Factory {

	/**
	 *
	 */
	const FIELDS_OPTION = 'uacuf_all_fields';
	/**
	 * @var
	 */
	private static $all_fields;

	/**
	 * @return false|mixed|null
	 */
	public static function get_all() {

		if ( null === self::$all_fields ) {
			self::$all_fields = automator_get_option( self::FIELDS_OPTION, array() );
		}

		// Backward compatibility if the option is empty
		if ( empty( self::$all_fields ) && '' === get_option( 'ua_cuf_migration_completed', '' ) ) {
			self::$all_fields = get_option( self::FIELDS_OPTION );
			if ( ! empty( self::$all_fields ) ) {
				automator_update_option( self::FIELDS_OPTION, self::$all_fields );
			}
			add_option( 'ua_cuf_migration_completed', time() );
		}

		return self::$all_fields;
	}

	/**
	 * @param $type
	 * @param $meta
	 * @param $name
	 *
	 * @return Field
	 * @throws \Exception
	 */
	public static function create( $type, $meta, $name ) {

		switch ( $type ) {
			case 'text':
				$field = new Field( $meta, $name );
				break;

			default:
				$field = new Field( $meta, $name );
				break;
		}

		$new_field_id = $field->get_id();

		self::get_all();
		self::$all_fields[ $new_field_id ] = $field;

		self::save();

		return $field;
	}

	/**
	 * @param $id
	 *
	 * @return false|mixed|null
	 * @throws \Exception
	 */
	public static function get( $id = null ) {

		if ( null === $id ) {
			return self::get_all();
		}

		if ( ! self::exist( $id ) ) {
			throw new \Exception( __( 'Field does not exists', 'uacuf' ), 404 );
		}

		return self::get_all()[ $id ];
	}

	/**
	 * @param $field_attributes
	 *
	 * @return array|false[]|null[]
	 * @throws \Exception
	 */
	public static function update( $field_attributes ) {

		$id = $field_attributes['id'];

		unset( $field_attributes['id'] );

		$old_field = self::get( $id );

		$new_field = clone $old_field;

		foreach ( $field_attributes as $attr => $value ) {

			$method = 'set_' . $attr;

			if ( ! method_exists( $new_field, $method ) ) {
				continue;
			}

			$new_field->$method( $value );
		}

		self::$all_fields[ $id ] = $new_field;

		self::save();

		return array(
			'before' => $old_field,
			'after'  => $new_field,
		);
	}

	/**
	 * @param $id
	 *
	 * @return mixed
	 * @throws \Exception
	 */
	public static function delete( $id ) {

		if ( ! self::exist( $id ) ) {
			throw new \Exception( __( 'Field does not exists', 'uacuf' ), 404 );
		}

		unset( self::$all_fields[ $id ] );

		self::save();

		return $id;
	}

	/**
	 * @return void
	 */
	public static function save() {
		automator_update_option( self::FIELDS_OPTION, self::get_all() );
	}

	/**
	 * @param $id
	 *
	 * @return bool
	 */
	public static function exist( $id ) {

		$all_fields = self::get_all();

		if ( empty( $all_fields[ $id ] ) ) {
			return false;
		}

		return true;
	}
}
