<?php
/**
 * Render.php
 *
 * @see https://github.com/WordPress/gutenberg/blob/trunk/docs/reference-guides/block-api/block-metadata.md#render
 * @package custom-user-field
 *
 * @param array $attributes - The block attributes.
 * @param string $content - The block default content.
 * @param WP_Block $block - The block instance.
 *
 * @return string - The block HTML.
 */

namespace UncannyAutomator\AddOn\CustomUserFields\Blocks;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Exit if attributes are not set.
if ( ! isset( $attributes ) || ! is_array( $attributes ) || empty( $attributes ) ) {
	return;
}

// Get the meta key.
$user_meta_key = isset( $attributes['meta'] ) ? $attributes['meta'] : '';
if ( empty( $user_meta_key ) ) {
	return;
}

// Get current user id.
$user_id = get_current_user_id();
if ( empty( $user_id ) ) {
	return;
}

// Get the user meta value.
$user_meta_value = get_user_meta( $user_id, $user_meta_key, true );
if ( empty( $user_meta_value ) ) {
	return;
}

// Output the user meta value.
echo $user_meta_value;
