# Changelog

### [6.15.13.1] 2026-01-07

* Fix - Corrective language fix for Category Colors. [TEC-36]

### [6.15.13] 2025-12-18

* Security - Strengthen the user access level in the system information opt-in functionality. [SVUL-35]

### [6.15.12.2] 2025-11-20

* Fix - Removes the <main /> element as a wrapper in events related pages, avoiding the calendar page rendering issues for many themes. Adds a `role="main"` to the first element printed by The Events Calendar on those pages to maintain accessibility. [TEC-5729]

### [6.15.12.1] 2025-11-19

* Fix - Provides context to a translatable placeholder which could result in an error when using existing translation. [TEC-5728]
* Language - 1 new strings added, 5 updated, 0 fuzzied, and 0 obsoleted.

### [6.15.12] 2025-11-18

* Version - The Events Calendar 6.15.12 is only compatible with Event Tickets 5.27.0 or higher.
* Version - The Events Calendar 6.15.12 is only compatible with Events Pro 7.7.11 or higher.
* Fix - Correct use of globals in admin scripts.
* Tweak - Added filters: `tec_events_rest_v1_events_read_params`, `tec_events_rest_v1_venues_read_params`, `tec_events_main_container_id`
* Tweak - Removed filters: `tec_events_rest_v1_events_read_args`, `tec_events_rest_v1_venues_read_args`
* Tweak - Changed views: `v2/components/content-title`, `v2/day/time-separator`, `v2/list/event/title`, `v2/list/month-separator`, `v2/month/calendar-body/day/date`
* Tweak - Correct notice display on the troubleshooting page. [TEC-5724]
* Tweak - Updates Shepherd library to 0.0.9 from 0.0.6 including various improvements. Shepherd's changelog can be found here https://github.com/stellarwp/shepherd/blob/0.0.9/CHANGELOG.md
* Tweak - Improve Day View accessibility by using semantic H2 headings for time separators to create a proper heading hierarchy. [TEC-5627]
* Tweak - Improve mini calendar accessibility by adding descriptive ARIA labels and clarifying focus indicators for color-based event markers. [TEC-5630]
* Tweak - Update heading levels for “Events at this venue” and “Events from this organizer” to improve accessibility and semantic hierarchy. [TEC-5636]
* Accessibility - Add filter to wrap event content in a main landmark if needed, which allows for the 'Skip to Content' button to work. [TEC-5628]
* Compatibility - Make method signatures in Builder explicitly nullable to resolve PHP 8.4 deprecation warnings. [TEC-5725]
* Compatibility - Updates to support TEC v1 REST API Changes.
* Language - 3 new strings added, 75 updated, 0 fuzzied, and 1 obsoleted.

### [6.15.11] 2025-11-04

* Tweak - Add JavaScript logic to move keyboard focus to expanded date content and announce event counts for screen reader users in month view mobile calendar [TEC-5231]
* Tweak - Avoid logging a warning when bulk deleting events. [TEC-5721]
* Tweak - Changed views: `blocks/parts/details`, `blocks/parts/organizer`, `blocks/parts/venue`, `modules/meta/details`, `modules/meta/organizer`, `modules/meta/venue`, `v2/month`, `v2/month/calendar-body/day/date-extras`, `v2/month/calendar-body/day/date`, `v2/month/calendar-header`
* Tweak - Improve accessibility in the mini calendar by replacing <em> elements used for event dots with semantic <span>s and removing redundant aria-label and title attributes [TEC-5228]
* Accessibility - Improve screen reader accessibility for weekday headers in month view calendar. [TEC-5719]
* Accessibility - Remove the presentational role from the Month View table. [TEC-5719]
* Accessibility - Replace misuse of definition list (`<dl>/<dt>/<dd>`) tags with semantic unordered lists (`<ul>/<li>`) in event details, organizer, and venue meta sections to improve screen reader accessibility and reduce confusion.[TEC-5224]
* Language - 3 new strings added, 53 updated, 1 fuzzied, and 4 obsoleted.

### [6.15.10] 2025-10-28

* Security - Improve authorization checks in QR codes. [SVUL-28]
* Security - Improve `ORDER BY` clause validation. [SVUL-26]

### [6.15.9] 2025-10-21

* Fix - Alter logic so category colors CSS is ony enqueued on event archive pages. [TEC-5419]
* Tweak - Added actions: `tec_conditional_content_assets`
* Tweak - Add upsell banner for recurrence functionality in classic editor. [TEC-5589]
* Tweak - Add `tec_is_valid_view()` helper to check whether the current context represents a valid registered view. [TEC-5419]
* Tweak - Disable Yoast SEO pagination meta tags on Events Calendar views to prevent invalid rel=next/prev links. [TEC-5000]
* Tweak - Revert automatic CSS combination handling for Avada to restore default behavior. [TEC-5682]
* Language - 3 new strings added, 8 updated, 0 fuzzied, and 0 obsoleted.

### [6.15.8] 2025-10-14

* Fix - Tweak a few style rules to ensure Kadence overrides work. [TEC-5504]
* Tweak - Automatically disabled Avada’s “Combine Third Party CSS Files” option when The Events Calendar is active to prevent stylesheet conflicts.  [TEC-5682]
* Tweak - Events list view structure updated to use proper list HTML. [TEC-5210]
* Tweak - Make Tooltips on calendar view dismissable with `esc` key. [TEC-5217]
* Language - 7 new strings added, 23 updated, 0 fuzzied, and 0 obsoleted.
* Language - Fixed text domains and improved string translations across multiple components for better internationalization support.
* Language - Move 'Free' string to TEC text domain for improved i18n. [TEC-5603]

### [6.15.7] 2025-10-07

* Tweak - Added `aria-label` to nav tags to make page landmarks unique. [TEC-5208]
* Tweak - Event Date time block structure updated to improve accessibility. [TEC-5531]
* Tweak - Add ARIA landmark roles and `aria-current` attributes to breadcrumbs to improve screen reader support. [TEC-5205]
* Tweak - Replace breadcrumbs with a "Back to Events" link on Venue and Organizer single pages for clearer navigation and improved accessibility.[TEC-5207][TEC-5205]
* Tweak - Change default opt-in status to prevent false positives in checks when the value is not set. [TEC-5583]
* Tweak - Changed views: `blocks/event-datetime`, `v2/components/backlink`, `v2/components/breadcrumbs`, `v2/components/breadcrumbs/breadcrumb`, `v2/components/breadcrumbs/linked-breadcrumb`, `v2/components/header`, `v2/list/nav`, `v2/list/top-bar/nav`
* Language - 4 new strings added, 6 updated, 0 fuzzied, and 0 obsoleted.

### [6.15.6] 2025-09-30

* Version - The Events Calendar 6.15.6 is only compatible with Events Pro 7.7.6 and higher.
* Fix - Elementor Venue widget now shows the map show or hide option with proper styling options. [TEC-5092]
* Fix - Enhanced iCal feed timezone definitions to include extended DST transition data for better calendar compatibility. [TEC-5061]
* Fix - Onboarding wizard now shows loading spinner properly while waiting for Event Tickets installation. [TEC-5584]
* Fix - Prevent ICS download from redirecting when List view is disabled. [TEC-5609]
* Tweak - Added filters: `tec_events_views_v2_should_redirect`, `tec_events_ical_timezone_extend_years`
* Tweak - Changed views: `v2/month/calendar-body/day/cell-title`, `v2/month/calendar-body/day/cell`, `v2/month/calendar-body/day/more-events`, `v2/month/mobile-events/mobile-day`, `v2/month/mobile-events/mobile-day/more-events`
* Tweak - Hide the Event Tickets upsell on the currency page when Event Tickets is enabled. [TEC-5585]
* Tweak - Introduce subtabs for the Integration settings for better organization. [TEC-5681]
* Tweak - Updated Community Addon upsell link to go to the proper page. [TEC-5586]
* Accessibility - Add aria-label for the more events link in month view. [TEC-5216]
* Accessibility - Adjust aria-label for month view day link to use formatting from TEC settings. [TEC-5214]
* Compatibility - Conditionally remove template option if Elementor Pro is active to avoid conflicts. [TEC-5610]
* Language - 4 new strings added, 75 updated, 0 fuzzied, and 0 obsoleted.

### [6.15.5] 2025-09-23

* Tweak - Adds search capabilities to the countries dropdown in onboarding. [TEC-5581]
* Language - 0 new strings added, 0 updated, 0 fuzzied, and 0 obsoleted.

### [6.15.4] 2025-09-16

* Fix - Add more robust checking for dates to handle occurrences and similar non-post events. [TEC-1052]
* Fix - Fixed an issue where Venues and Organizers created via Community Events could have missing permalinks when events were published. [CE-330]
* Tweak - Changed views: `blocks/event-venue`, `blocks/parts/map`, `blocks/parts/venue`, `modules/meta/map`, `modules/meta/organizer`, `modules/meta/venue`, `v2/components/header`, `v2/day/event/venue`, `v2/list`, `v2/list/event/venue`
* Accessibility - Return keyboard focus to the triggering button after closing the datepicker for improved accessibility. [CE-278]
* Language - 0 new strings added, 13 updated, 0 fuzzied, and 0 obsoleted.

### [6.15.3] 2025-09-10

* Tweak - Changed views: `blocks/event-venue`, `blocks/parts/map`, `blocks/parts/venue`, `modules/meta/map`, `modules/meta/organizer`, `modules/meta/venue`, `v2/components/header`, `v2/day`, `v2/day/event/venue`, `v2/list`, `v2/list/event/venue`
* Security - Ensures password protected Venues and Organizers have their data protected. [SVUL-19]
* Language - 0 new strings added, 59 updated, 0 fuzzied, and 0 obsoleted.

### [6.15.2] 2025-09-09

* Fix - Corrected path for enqueuing ACF scripts to avoid 404 errors. [TEC-5604]
* Fix - Fix the process of updating event time zone data. [TEC-5423]
* Fix - Make sure the user is redirected to the correct settings page after clicking on the "Fix Time Zone Data" button. [TEC-5423]
* Tweak - Added search capabilities to the currency dropdown in onboarding. [TEC-5580]
* Tweak - Added search capabilities to the timezone dropdown in onboarding. [TEC-5579]
* Tweak - Changed views: `blocks/parts/subscribe-list`, `v2/components/subscribe-links/item`.
* Tweak - Hide unsupported items from the Subscribe to Calendar dropdown for archive pages. [TEC-4242]
* Tweak - Visual updates to the ECP teaser pill in TEC->Settings->Display.
* Language - 0 new strings added, 20 updated, 1 fuzzied, and 1 obsoleted.

### [6.15.1.1] 2025-09-03

* Security - Ensures only known values are accepted for the ORDER BY query clause. [SVUL-19]

### [6.15.1] 2025-09-02

* Fix - Figure out where assets are located in complex environments with a mix of symlinked or normally placed plugins. Resolving as a result issues with Recurring Events UI in WordPress.com. [ECP-1929]
* Tweak - Changed views: `blocks/event-links`, `integrations/elementor/templates/starter`, `integrations/event-tickets/emails/template-parts/header/head/tec-styles`
* Compatibility - PHP 8.3 compatibility improvements. [TEC-5571]
* Language - 0 new strings added, 2 updated, 0 fuzzied, and 0 obsoleted.

### [6.15.0.1] 2025-08-20

* Fix - Ensures the Actions Scheduler Logs table is present before attempting to use it. [TCMN-190]
* Fix - Resolves issues with Day breaking in multiple lines above the Calendar's month view. [TEC-5590]

### [6.15.0] 2025-08-19

* Version - The Events Calendar 6.15.0 is only compatible with Event Tickets 5.26.0 and higher.
* [EXPERIMENTAL] Feature - Introduced new REST endpoints for managing your Events, Venues and Organizers. Note: This API is for experimental use only and requires the X-TEC-EEA header. It may be subject to breaking changes in upcoming releases.
* Language - 153 new strings added, 140 updated, 1 fuzzied, and 0 obsoleted.

### [6.14.2] 2025-07-22

* Tweak - Implemented an Enable setting for Category Colors. [TEC-5533]
* Tweak - Updated the Category Colors settings to add a tooltip to the Reset Button option that explains Superpowers must be enabled. [TEC-5534]
* Tweak - Changed views: `v2/components/top-bar/category-color-picker`, `v2/day/event/featured-image`, `v2/list/event/featured-image`, `v2/month`, `v2/month/calendar-body/day`, `v2/month/calendar-body/day/calendar-events/calendar-event/featured-image`, `v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/featured-image`, `v2/month/calendar-body/day/cell-title`, `v2/month/calendar-header`
* Performance - Avoid use of TIMESTAMPDIFF when fetching overlapping events. [TEC-5537]
* Accessibility - Updated day views with proper aria label and titles for event linked featured images. [TEC-5179]
* Language - 2 new strings added, 24 updated, 0 fuzzied, and 0 obsoleted.

### [6.14.1] 2025-07-16

* Fix - Ensure all featured images on calendar views have dimensions set to reduce layout shifts. [TEC-4715]
* Fix - Ensure views selector links have proper aria-current attributes.
 Tweak - Changed views: `v2/components/events-bar/views/list/item`, `v2/day/event/featured-image`, `v2/latest-past/event/featured-image`, `v2/list/event/featured-image`, `v2/month/calendar-body/day/calendar-events/calendar-event/featured-image`, `v2/month/mobile-events/mobile-day/mobile-event/featured-image`
* Language - 0 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted.

### [6.14.0] 2025-07-03

* Feature - Category Colors functionality has been merged into The Events Calendar. [TEC-5364]
* Feature - Events Variables for Yoast SEO [TEC-5437]
* Fix - Add width and height attributes on images displayed in our Events pages [TEC-4715]
* Fix - Disabled Event Views should redirect to default view [TEC-5427]
* Fix - Recognize when the theme is registering single or archive Event templates when using a Block theme, and avoid registering our own. [TEC-5525]
* Tweak - Added actions: `tec_events_category_colors_saved`, `tec_events_category_colors_migration_status_updated`, `tec_events_category_colors_migration_reset`, `tribe_log`, `tec_events_category_colors_migration_preprocessor_start`, `tec_events_category_colors_migration_preprocessor_end`, `tec_events_category_colors_migration_validator_start`, `tec_events_category_colors_migration_validator_end`, `tec_events_category_colors_migration_runner_start`, `tec_events_category_colors_migration_runner_end`, `tec_events_category_colors_migration_post_schedule_action`, `tec_events_category_colors_migration_post_cancel_action`, `tec_events_settings_tab_display_category_colors`, `tec_conditional_content_header_notice`
* Tweak - Added filters: `tec_events_category_color_generator_batch_size`, `tec_events_category_colors_enabled`, `tec_events_category_colors_show_frontend_ui`, `tec_events_category_validate_meta_key`, `tec_events_category_validate_meta_value`, `tec_events_category_colors_force_migration_notice`, `tec_category_colors_is_tec_admin_page`, `tec_events_category_colors_migration_batch_size`, `tec_events_category_colors_migration_pre_schedule_action`, `tec_events_category_colors_migration_pre_execute_action`, `tec_events_category_colors_migration_`, `tec_events_category_colors_migration_pre_cancel_action`, `tec_events_category_color_enabled_views`, `tec_events_category_color_dropdown_categories`, `tec_events_category_color_raw_categories`, `tec_events_category_color_category_meta`, `tec_events_category_color_filtered_categories`, `tec_events_category_color_sorted_categories`, `tec_events_category_color_highest_priority_category`, `tec_events_category_color_event_categories`, `tec_events_category_color_category_priorities`, `tec_events_views_v2_view_template_vars`
* Tweak - Add the conditional content notice to Event Aggregator pages [TEC-5530]
* Tweak - Changed views: `blocks/classic-event-details`, `blocks/event-category`, `blocks/event-datetime`, `blocks/event-organizer`, `blocks/event-price`, `blocks/event-tags`, `blocks/event-venue`, `blocks/event-website`, `blocks/parts/subscribe-list`, `blocks/parts/subscribe-single`, `integrations/elementor/widgets/empty`, `integrations/elementor/widgets/event-calendar-link`, `integrations/elementor/widgets/event-categories`, `integrations/elementor/widgets/event-categories/header`, `integrations/elementor/widgets/event-cost`, `integrations/elementor/widgets/event-cost/header`, `integrations/elementor/widgets/event-datetime`, `integrations/elementor/widgets/event-datetime/all-day`, `integrations/elementor/widgets/event-datetime/end-date`, `integrations/elementor/widgets/event-datetime/end-time`, `integrations/elementor/widgets/event-datetime/header`, `integrations/elementor/widgets/event-datetime/range-separator`, `integrations/elementor/widgets/event-datetime/start-date`, `integrations/elementor/widgets/event-datetime/start-time`, `integrations/elementor/widgets/event-datetime/time-separator`, `integrations/elementor/widgets/event-export`, `integrations/elementor/widgets/event-export/button`, `integrations/elementor/widgets/event-export/link`, `integrations/elementor/widgets/event-export/list-item`, `integrations/elementor/widgets/event-image`, `integrations/elementor/widgets/event-navigation`, `integrations/elementor/widgets/event-navigation/next`, `integrations/elementor/widgets/event-navigation/previous`, `integrations/elementor/widgets/event-organizer`, `integrations/elementor/widgets/event-organizer/details`, `integrations/elementor/widgets/event-organizer/details/email`, `integrations/elementor/widgets/event-organizer/details/email/content`, `integrations/elementor/widgets/event-organizer/details/email/header`, `integrations/elementor/widgets/event-organizer/details/phone`, `integrations/elementor/widgets/event-organizer/details/phone/content`, `integrations/elementor/widgets/event-organizer/details/phone/header`, `integrations/elementor/widgets/event-organizer/details/website`, `integrations/elementor/widgets/event-organizer/details/website/content`, `integrations/elementor/widgets/event-organizer/details/website/header`, `integrations/elementor/widgets/event-organizer/header`, `integrations/elementor/widgets/event-organizer/names`, `integrations/elementor/widgets/event-status/passed`, `integrations/elementor/widgets/event-status/status`, `integrations/elementor/widgets/event-tags`, `integrations/elementor/widgets/event-tags/content`, `integrations/elementor/widgets/event-tags/header`, `integrations/elementor/widgets/event-title`, `integrations/elementor/widgets/event-venue`, `integrations/elementor/widgets/event-venue/address`, `integrations/elementor/widgets/event-venue/address/address`, `integrations/elementor/widgets/event-venue/address/header`, `integrations/elementor/widgets/event-venue/address/map_link`, `integrations/elementor/widgets/event-venue/header`, `integrations/elementor/widgets/event-venue/map`, `integrations/elementor/widgets/event-venue/name`, `integrations/elementor/widgets/event-venue/phone`, `integrations/elementor/widgets/event-venue/phone/header`, `integrations/elementor/widgets/event-venue/phone/phone`, `integrations/elementor/widgets/event-venue/single-venue`, `integrations/elementor/widgets/event-venue/website`, `integrations/elementor/widgets/event-venue/website/header`, `integrations/elementor/widgets/event-venue/website/website`, `integrations/elementor/widgets/event-website`, `integrations/elementor/widgets/event-website/header`, `integrations/elementor/widgets/event-website/link`, `modules/meta/venue`, `single-event`, `v2/components/events-bar`, `v2/components/events-bar/views`, `v2/components/header`, `v2/components/messages`, `v2/components/messages/error-icon`, `v2/components/messages/notice-icon`, `v2/components/top-bar/category-color-picker`, `v2/components/top-bar/today`, `v2/day`, `v2/day/event`, `v2/day/event/category`, `v2/day/event/date/featured`, `v2/day/event/featured-image`, `v2/day/top-bar`, `v2/day/top-bar/datepicker`, `v2/latest-past/event`, `v2/latest-past/event/date/featured`, `v2/latest-past/event/featured-image`, `v2/list`, `v2/list/event`, `v2/list/event/category`, `v2/list/event/date-tag`, `v2/list/event/date/featured`, `v2/list/nav/next-disabled`, `v2/list/nav/next`, `v2/list/nav/prev-disabled`, `v2/list/nav/prev`, `v2/list/top-bar`, `v2/list/top-bar/datepicker`, `v2/month`, `v2/month/calendar-body`, `v2/month/calendar-body/day`, `v2/month/calendar-body/day/calendar-events/calendar-event`, `v2/month/calendar-body/day/calendar-events/calendar-event/date/featured`, `v2/month/calendar-body/day/calendar-events/calendar-event/title`, `v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/date/featured`, `v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/title`, `v2/month/calendar-body/day/cell-title`, `v2/month/calendar-body/day/date-extras`, `v2/month/calendar-body/day/date`, `v2/month/calendar-body/day/multiday-events/multiday-event`, `v2/month/calendar-body/day/multiday-events/multiday-event/bar/featured`, `v2/month/calendar-body/day/multiday-events/multiday-event/bar/title`, `v2/month/calendar-body/day/multiday-events/multiday-event/hidden/link/featured`, `v2/month/calendar-body/day/multiday-events/multiday-event/hidden/link/title`, `v2/month/calendar-header`, `v2/month/mobile-events/mobile-day`, `v2/month/mobile-events/mobile-day/mobile-event`, `v2/month/mobile-events/mobile-day/mobile-event/date/featured`, `v2/month/mobile-events/mobile-day/mobile-event/featured-image`, `v2/month/mobile-events/mobile-day/mobile-event/title`, `v2/month/top-bar`, `v2/month/top-bar/datepicker`, `v2/widgets/widget-events-list`, `v2/widgets/widget-events-list/event`, `v2/widgets/widget-events-list/event/date/featured`, `v2/widgets/widget-events-qr-code`
* Tweak - Update Month view templates to use a more semantically appropriate table structure. Developers are advised to carefully review any customizations for compatibility before updating. [TEC-5185]
* Accessibility - Changed aria-labels to aria-descriptions for WCAG compliance. [TEC-5524]
* Accessibility - Correct an issue where alert text was not announced by screen readers. [TEC-5184]
* Accessibility - Correct some heading uses that were confusing and/or misapplied. [TEC-5199]
* Accessibility - Correct some images where the alt text conflicted with the linked title. [TEC-5183]
* Accessibility - Improve the keyboard navigation of the Views menu. [TEC-5192]
* Accessibility - Remove redundant aria-label attributes where they duplicate existing visible text. [TEC-5197]
* Accessibility - Remove redundant title attributes on some images and links. [TEC-5194, TEC-5195]
* Accessibility - Updated featured icons in all calendar views to include accessible labels. Reorganized the Month view Feature icons to be more understandable when read by a screen reader. Reworked several icon applications to make them more accessible. [TEC-5190, TEC-5201]
* Language - 59 new strings added, 132 updated, 1 fuzzied, and 1 obsoleted.

### [6.13.2.1] 2025-06-06

* Fix - Fix some hardcoded asset paths. [TEC-5523]
* Fix - Utilize the newer version of our build process to ensure inline svgs are being handled properly. [TCMN-188]
* Security - Fixed an issue where some templates were not sanitized properly.

### [6.13.2] 2025-06-03

* Version - The Events Calendar 6.13.2 is only compatible with Event Tickets 5.24.0 and higher.
* Tweak - Updated Help Hub functionality to follow new standards.
* Language - 8 new strings added, 23 updated, 0 fuzzied, and 0 obsoleted.

### [6.13.1] 2025-05-27

* Fix - Add Domain Path to the plugin header to ensure installed files get read. [TEC-5520]
* Fix - Ensures symbolic links are followed on Assets Group Paths. [TCMN-187]
* Fix - Update aggregator scripts to ensure globals remain global. [TEC-5509]
* Language - 0 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted.

### [6.13.0] 2025-05-20

* Version - The Events Calendar 6.13.0 is only compatible with Events Pro 7.6.0 and higher.
* Version - The Events Calendar 6.13.0 is only compatible with Events Community 5.0.7 and higher.
* Version - The Events Calendar 6.13.0 is only compatible with Event Tickets 5.23.0 and higher.
* Version - The Events Calendar 6.13.0 is only compatible with Event Tickets Plus 6.5.0 and higher.
* Feature - Add a `Block_Trait` to simplify block assets registration and avoid code duplication.
* Fix - Improve Settings UX by preventing unstyled error state when tab object does not exist.
* Fix - Update class steps to use namespaced class names consistently to improve class reusability.
* Fix - In the onboarding API, improve data management by merging new params instead of overwriting existing ones.
* Fix - Standardize asset loading by using a consistent function to load assets.
* Tweak - Alter Telemetry to allow classes to hook in and suppress the modal for specific pages.
* Tweak - Hide Telemetry modal on the onboarding page.
* Tweak - Improve the onboarding wizard by properly storing current tab completion and adding filter to force redirect.
* Tweak - Replace `tribe_asset` with `tec_asset` function for proper asset pathing.
* Tweak - Add `tec_events_onboarding_wizard_force_display` filter to allow bypassing Guided Setup display checks.
* Tweak - Add `tec_events_onboarding_force_redirect_to_guided_setup` filter to bypass checks for redirecting to Guided Setup.
* Tweak - Move Country and Currency lists to Common for better code reuse.
* Tweak - Update asset handling to leverage group paths consistently.
* Language - 2 new strings added, 252 updated, 4 fuzzied, and 38 obsoleted.

### [6.12.0.1] 2025-05-14

* Fix - Prevents fatal if QR library in common has not loaded. [TEC-5497]
* Language - 10 new strings added, 247 updated, 1 fuzzied, and 0 obsoleted.

### [6.12.0] 2025-05-13

* Feature - Add an editor block to display an event QR code [TEC-5404]
* Feature - Add a widget to display a QR code for an event [TEC-5405]
* Feature - Add the [tec_event_qr] shortcode [TEC-5406]
* Feature - Generate QR Code link in the Events Admin Table [TEC-5428]
* Feature - QR Code metabox in Events Edit screen [TEC-5429]
* Feature - Support QR Codes in TEC [TEC-5396]
* Security - Harden backend requests to enforce user capabilities. [SVUL-15]
* Tweak - Added filters: `tec_events_qr_enabled`, `tec_events_qr_valid_screens`, `tec_events_qr_code_supported_post_types`, `tec_events_qr_code_post_types`, `tec_events_qr_code_redirection_type`, `tec_events_qr_code_modal_vars`, `tec_events_qr_code_regenerate`, `tec_events_qr_current_event_url`, `tec_events_qr_upcoming_event_url`, `tec_events_qr_specific_event_url`, `tec_events_qr_redirection_url`, `tec_events_qr_widget_options`, `tec_events_qr_widget_fields`, `tec_events_qr_next_series_event_url`,
* Tweak - Added actions: `tec_events_fully_loaded`
* Tweak - Changed views: `blocks/parts/subscribe-list`, `v2/components/events-bar/views`, `v2/components/events-bar/views/list/item`, `v2/components/messages`, `v2/components/subscribe-links/single-event-list`, `v2/day`, `v2/list`, `v2/month`, `v2/widgets/widget-events-qr-code`
* Accessibility - Add aria-labels to view options and aria-current to selected view. [TEC-5022]
* Accessibility - Add aria-label to view selector button. [TEC-5021]
* Accessibility - Add aria label to Add to calendar button. [TEC-5088]
* Accessibility - Change focus to results after filtering `events/`. [FBAR-332]
* Accessibility - Change wrapper div to a section tag to avoid multiple 'banner' landmarks. [TEC-3424]
* Accessibility - Small tweaks to improve accessibility of user-facing messages. [FBAR-333]
* Accessibility - Tweaked accordions so they will toggle and not submit when using keyboard navigation. [FBAR-343]
* Language - 61 new strings added, 145 updated, 0 fuzzied, and 0 obsoleted.

### [6.11.2.1] 2025-04-28

* Version - The Events Calendar 6.11.2.1 is only compatible with Event Tickets 5.21.1.1 or higher.
* Fix - Amend various callbacks of the External Calendar Embeds feature to not be so strict on the expected arguments, as a result fixing fatal errors when the arguments are not of the expected type. [TEC-5484]
* Security - Added more safety checks to telemetry opt-ins/opt-outs. [TCMN-186]
* Language - 0 new strings added, 186 updated, 0 fuzzied, and 61 obsoleted.

### [6.11.2] 2025-04-09

* Fix - Ensure that Copy and Render for our Legacy Widgets works for all Event related widgets [TEC-5447]
* Fix - Prevent language notice when loading Aggregator cron interval too early. props @peter8nss
* Language - 0 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted.

### [6.11.1] 2025-04-07

* Version - The Events Calendar 6.11.1 is only compatible with Event Tickets 5.20.0 and higher
* Fix - Avoid running unbound queries, avoid too long queries being killed. [ECP-1898]
* Fix - Correct some text-domains copied from common
* Fix - Ensures the ajaxComplete callback is fired after AJAX has actually completed. [FBAR-344]
* Fix - Ensures `delete_custom_tables_data` method is called only for events. [TEC-5445]
* Fix - Ensures `events_per_page` is type casted to int before used. [TEC-5442]
* Fix - Include Label for viewing post type archives. props @mikeritter
* Fix - Makes sure that Custom Tables are loaded after our Common library is loaded. [TEC-5445]
* Fix - Prevent invalid argument supplied for foreach() warning, props to @zosterops-lateralis
* Tweak - Fixed typo in the First Time Setup page.  [TEC-5415]
* Tweak - Improve our widgets to enable copying it in between different instances of the Block and Site editor.
* Tweak - Make sure our settings for showing comments is respected as much as possible. props @zosterops-lateralis
* Tweak - Modify the URL params for Views HTML REST Requests to enable usage of GET requests enabling caching
* Tweak - Modify the visibility of tribe-ea- statuses to prevent them from slowing down WP_Query that are unrelated to Aggregator
* Tweak - Prevent REST API notice from showing in certain cases of false positives.
* Performance - Aggregator query for Authors on the import form has better boundaries props @dilipbheda
* Performance - Avoid duplicate queries by caching model queries results. [ECP-1898]
* Language - 2 new strings added, 192 updated, 2 fuzzied, and 0 obsoleted.

### [6.11.0.1] 2025-04-01

* Fix - Ensures `get_current_screen()` function is only called if it exists, avoiding fatal error if called too early. [TEC-5439]

### [6.11.0] 2025-03-31

* Feature - Added External Calendar Embeds functionality. [TEC-5359]
* Tweak - Add auto-width to Subscribe to Calendar button to accommodate translations. Props to @huubl [TEC-5430]
* Tweak - Adjust CSS to make sure that onboarding wizard form elements are properly aligned on all WordPress versions. [TEC-5402]
* Tweak - Adjusted vertical spacing in the onboarding wizard to better fit the content on the screen. [TEC-5402]
* Tweak - Changed some organizer and venue fields in the onboarding wizard to not be required. [TEC-5408]
* Tweak - Make sure the Setup Guide page shows up only when asked for. [TEC-5411]
* Fix - Add check for single venue and single organizer to the Template_Bootstrap class. Use those checks for SEO titles and enable SEO plugins to overwrite their respective titles. [ECP-1059]
* Fix - Add notice that at least one view is required for Onboarding Wizard display tab. [TEC-5398]
* Fix - Add one time redirect to the Guided Setup page. [TEC-5401]
* Fix - Adjusted logic for when to reset isSaving state for Onboarding Wizard. [TEC-5409]
* Language - 49 new strings added, 158 updated, 0 fuzzied, and 2 obsoleted.

### [6.10.3] 2025-03-25

* Fix - Improved user experience by ensuring Event Tickets installation and activation notices only appear on TEC-related admin pages.
* Language - 0 new strings added, 5 updated, 0 fuzzied, and 0 obsoleted.

### [6.10.2] 2025-03-04

* Feature - Use the filter hook in TCMN to define the pages to show IAN notifications [ET-2294]
* Tweak - Added actions: `tec_events_before_view_html_cache`
* Tweak - Added check that `$_FILES` is set before setting the param on an HTTP request. [TEC-5363]
* Tweak - Added filters: `tec_events_filter_wp_robots_meta_directives`
* Tweak - Added link to Events Calendar Pro in onboarding wizard. [TEC-5397]
* Tweak - Changed views: `v2/month/top-bar/datepicker`, `v2/widgets/widget-events-list/event/date-tag`
* Tweak - Removed filters: `tec_events_seo_robots_meta_content`, `tec_events_no_index_meta`
* Tweak - Update docblocks in the `Tribe__Events__iCal` class.
* Fix - Corrected template override file path for Event List Widget date-tag. [ECP-1725]
* Fix - Fix past events shortcode attribute [TEC-5348]
* Fix - Fix the time zone blocks in the iCal feed to make sure the iCal feed is valid and the calendar can be subscribed to. [TEC-5360]
* Fix - Hide Not-Found notice in Astra Theme archive page [TEC-4853]
* Fix - Hook the noindex directives into a new hook before the View HTML cache check. [TEC-5354]
* Compatibility - Added 404 handling for day view when disabled or accessed outside the range of earliest and latest events, with an exception for the current month when no events exist. [TEC-5356]
* Compatibility - Added 404 handling for month view when disabled or accessed outside the range of earliest and latest events, with an exception for the current month when no events exist. [TEC-5356]
* Compatibility - Switched to using WordPress wp_robots for improved SEO plugin compatibility and to prevent duplicate meta robots tags. [TEC-5355]
* Language - 0 new strings added, 129 updated, 0 fuzzied, and 0 obsoleted.

### [6.10.1.1] 2025-02-12

* Fix - Updated common library to correct issues with notifications around licensing.
* Fix - Add a callback to remove the `tribe_pue_key_notices` once on upgrade to version 6.5.1.1 [TEC-5384]
* Fix - Adjustments were made to prevent a fatal error when tec_pue_checker_init was triggered too early, attempting to call tribe_is_truthy() before it was available. The license check and active plugin monitoring now run on admin_init to ensure proper loading. [TEC-5384]
* Fix - Update the license checker to ignore empty licenses. [TEC-5385]
* Language - 0 new strings added, 0 updated, 0 fuzzied, and 0 obsoleted.

### [6.10.1] 2025-02-10

* Tweak - Added aliases for Venue ORM for `show_map` and `show_map_link`. (props to @m8nmueller) [TEC-5352]
* Tweak - Remove class_exists() and use register_on_action() for Notifications [TEC-5336]
* Fix - Added a check for `$subscribe_links` in `single_event_links` function. [TEC-5357]
* Fix - Added `format_item()` function so venues read from ORM are decorated objects. (props to @m8nmueller) [TEC-5353]
* Fix - Make Eventbrite import available when the Eventbrite Tickets plugin is installed [EBT-149]
* Fix - Replaced deprecated functions with their modern equivalents to maintain compatibility. [EA-476]
* Fix - Support Additional Fields in Events REST API [TEC-5015]
* Fix - Changed the way translations are loaded to work with the latest WordPress language changes.
* Accessibility - Increased pagination button sizes on the events page. [TEC-5176]
* Tweak - Added filters: `tribe_repository_venues_format_item`
* Language - 0 new strings added, 8 updated, 1 fuzzied, and 0 obsoleted.

### [6.10.0] 2025-01-30

* Fix - Update asset, dependencies, customizations to align with WordPress 6.7 and React 18. [TEC-5322]
* Language - 0 new strings added, 44 updated, 0 fuzzied, and 1 obsoleted.

### [6.9.1] 2025-01-22

* Security - Ensure Elementor HTML tags are properly escaped to avoid potential Stored Cross Site Scripting. [SVUL-13]
* Tweak - Moved Action Scheduler loading into Common instead of TEC. [TEC-5345]
* Tweak - Updated Telemetry heading under Settings > Debugging. [TEC-5335]
* Tweak - Re-added filter: `tec_views_v2_subscribe_links_{$slug}_label`
* Tweak - Tweak - Removed duplicate filter: `tec_views_v2_single_subscribe_links_{$slug}_label`
* Tweak - Changed views: `integrations/elementor/widgets/event-calendar-link`, `integrations/elementor/widgets/event-datetime/range-separator`, `v2/components/loader`, `v2/components/messages`
* Fix - Added check to `disable_blocks_on_display` for if `$content` is `null`. [TEC-5343]
* Fix - Ensure Aggregator translations are not loaded before init. [TEC-5341]
* Fix - Fixes edge cases where the nonce_user_logged_out hook was returning a value when the user was logged out, causing the nonce validation to fail. [TEC-5340]
* Fix - Fix the filter name `tec_views_v2_subscribe_links_{$slug}_label` which was accidentally changed in a previous release. [TEC-5342]
* Fix - Re-add logic to add page template options from theme to Display Settings. [TEC-5337]
* Fix - Update Tribe__Events__Aggregator__Errors to ensure we don't load translations before `init`. [TEC-5341]
* Fix - Update uses of unload_textdomain to ensure they allow JIT loading of translations afterwards. [TEC-5341]
* Accessibility - Updated the event search page to handle search results better for screen readers, with alerts noting the results of the search.[TEC-5175]
* Language - 3 new strings added, 84 updated, 0 fuzzied, and 2 obsoleted.

### [6.9.0] 2004-12-17

* Feature - Added new Onboarding Wizard and First Time Setup admin page for new installs. [TEC-5285]
* Fix - When importing events from Google Calendar when using Events Calendar Pro with a custom Google Maps API key, Provinces/States for non-US countries are now saved to the correct field. [ECP-1877]
* Fix - When using "Move to trash events older than", trashed imported events are now ignored. [TEC-5319]
* Fix - Changed `format` method to `format_i18n` to allow for translations of dates in the TEC Elementor Widget. [TEC-5323]
* Fix - Correct template override path to match docblocks for `event-export` directory. [TEC-5326]
* Fix - Correct application of upsell classes in settings page. [n/a]
* Fix - Updated the docblock for the `tribe_get_previous_events_link`, `tribe_get_next_event_link`, and `tribe_get_gridview_link` functions.
* Tweak - Improved documentation for the `tribe_the_next_event_link`, `tribe_the_prev_event_link`, and `tribe_get_events_link` functions.
* Tweak - Update docblocks in the `Tribe__Events__Importer__File_Importer_Events` class. [n/a]
* Tweak - Fix the integration with TEC Tweaks to avoid a fatal error when using the extension. [TEC-5316]
* Language - 87 new strings added, 156 updated, 2 fuzzied, and 0 obsoleted.

### [6.8.3] 2024-12-05

* Feature - In-App Notifications system. [TEC-5165]
* Tweak - Added actions: `tec_ian_icon`
* Language - 0 new strings added, 118 updated, 0 fuzzied, and 1 obsoleted.

### [6.8.2.1] 2024-11-21

* Tweak - Introduced filter `tec_events_rest_api_password_protected_fields` which can be used to control which event fields should be hidden in the REST API for password protected events. [SVUL-8]
* Security - Hide content fields from the archive REST endpoint for password protected events. [SVUL-8]
* Fix - Prevent notices on `_load_textdomain_just_in_time` due to Aggregator and Export links code.

### [6.8.2] 2024-11-19

* Feature - Introduced Help Hub, a centralized support and resource interface for enhanced user guidance and plugin assistance.
* Deprecated - Deprecated the unused update/activation page [TEC-5311]
* Language - 0 new strings added, 0 updated, 0 fuzzied, and 0 obsoleted.

### [6.8.1] 2024-11-04

* Fix - Order of past events in the list view when no future events exist. [TEC-5309]
* Fix - Prevent new Settings pages from over-sanitizing textarea fields, thus removing HTML from before/after in the Events UI. [TEC-5283]
* Fix - Include backwards compatibility for deprecated proprieties in the Settings class used in The Events Calendar and Event Tickets [TEC-5312]

### [6.8.0] 2024-10-30

* Version - The Events Calendar 6.8.0 is only compatible with Events Calendar Pro 7.3.0 and higher.
* Version - The Events Calendar 6.8.0 is only compatible with Events Tickets Plus 6.1.0 or higher.
* Version - The Events Calendar 6.8.0 is only compatible with Event Tickets 5.16.0 or higher.
* Feature - Added integration with new premium Seating product for Event Tickets.

### [6.7.1] 2024-10-21

* Feature - Allow importing custom data when importing Organizers from a CSV file. [TEC-4846]
* Feature - Allow importing custom data when importing Venues from a CSV file. [TEC-5138]
* Fix - Ensure Latest Past Events appear properly in Category views [TEC-4991]
* Fix - Cast theme object to string to avoid a deprecation notice. [TEC-5062]
* Tweak - Removed the 6.0 welcome message. [TEC-5166]
* Tweak - Added filters: `tribe_events_csv_import_organizer_additional_fields`, `tribe_events_csv_import_venue_additional_fields`
* Tweak - Changed views: `v2/latest-past`
* Tweak - Updated docblocks in the `Tribe__Events__Aggregator__Records`, `Tribe__Events__Importer__File_Importer`, and `Tribe__Events__Repositories__Organizer` classes.
* Tweak - Improved documentation for the `tribe_is_event`, `tribe_get_event_link`, `tribe_events_get_event_website_title`, `tribe_get_event_website_link`, `tribe_get_listview_display`, `tribe_get_listview_args`, and `tribe_get_listview_prev_link` functions.
* Language - 3 new strings added, 218 updated, 0 fuzzied, and 32 obsoleted

### [6.7.0] 2024-09-26

* Version - The Events Calendar 6.7.0 is only compatible with Events Calendar Pro 7.1.0 and higher
* Version - The Events Calendar 6.7.0 is only compatible with Events Filterbar 5.5.7 and higher
* Version - The Events Calendar 6.7.0 is only compatible with Events Community 5.0.4 and higher
* Feature - New and improved settings layout and styles. [TEC-5124]
* Fix - Correct translation domains in a few templates. [6.4.0]
* Tweak - Added filters: `tec_settings_gmaps_js_api_start`, `tec_events_settings_display_calendar_display_section`, `tec_general_settings_viewing_section`, `tec_events_aggregator_show_all_settings`, `tec_events_settings_tab_imports_fields`
* Tweak - Removed filters: `tec_events_should_display_events_template_setting`, `tec_events_display_settings_tab_fields`, `tribe_general_settings_tab_fields`
* Tweak - Added actions: `tec_events_settings_tab_display_additional_content`, `tec_events_settings_tab_display_calendar`, `tec_events_settings_tab_display_date_time`, `tec_events_settings_tab_display_maps`, `tec_events_settings_tab_general_debugging`, `tec_events_settings_tab_general_editing`, `tec_events_settings_tab_general_maintenance`, `tec_events_settings_tab_general_viewing`, `tec_settings_tab_addons`, `tec_events_settings_tab_display`, `tec_events_settings_tab_general`, `tec_events_settings_tab_imports`
* Tweak - Changed views: `v2/latest-past/event/venue`
* Language - 6 new strings added, 356 updated, 3 fuzzied, and 29 obsoleted

### [6.6.4.2] 2024-09-17

* Fix - Resolve fatal errors happening when Events search was being used alongside query ordering. [TEC-5155]

### [6.6.4.1] 2024-09-16

* Security - Improve general escaping for ORM queries to prevent legacy Events methods to be used for SQL injections.

### [6.6.4] 2024-09-11

* Security - Improve handling of Date/Time Separator settings to prevent potential XSS vulnerabilities.
* Fix - Add an option to allow for duplicate Venue creation as part of creating/editing Events.
* Fix - Adding small adjustment to WPML integration to allow for location searches on a translated site. (props to @dgwatkins) [ECP-1823]
* Fix - Changed logic within the custom tables query to avoid a database error. (props @datadiver0x0) [ECP-1562]
* Fix - Update the logic that displays the "REST API blocked" banner to reduce false positives. [TEC-5105]
* Tweak - Include methods `tec_events_get_date_time_separator` and `tec_events_get_time_range_separator` and it's respective filters.
* Tweak - Add docblock for make_select_box()
* Tweak - Add docblock for `set_defaults()` in the `Tribe__Events__Importer__Column_Mapper` class.
* Tweak - Add docblocks to the methods in the `Tribe__Events__Importer__Column_Mapper` class.
* Tweak - Add information and missing tags to `tribe_get_listview_args()` docblock.
* Tweak - Add information and missing tags to `tribe_get_listview_dir_link()` docblock.
* Tweak - Add information and missing tags to `tribe_get_listview_link()` docblock.
* Tweak - Add information and missing tags to `tribe_get_listview_past_link()` docblock.
* Tweak - Add information and missing tags to `tribe_get_prev_event_link()`.
* Tweak - Made a string translatable in `settings.php` file. (props to @DAnn2012) [TEC-5142]
* Tweak - Update the docblock of the `tribe_embed_google_map()` method, change a variable name to match current naming conventions, and added a docblock to the `tribe_embed_google_map` filter.
* Tweak - Update the docblock of the `tribe_embed_google_map_link()` method, change a variable name to match current naming conventions, and added a docblock to the `tribe_embed_google_map_link` filter.
* Tweak - Changed views: `silence`, `v2/month/calendar-body/day/calendar-events/calendar-event/date`
* Language - 0 new strings added, 46 updated, 0 fuzzied, and 0 obsoleted

### [6.6.3] 2024-09-09

* Tweak - Add docblock for make_select_box()
* Tweak - Add docblock for `set_defaults()` in the Tribe__Events__Importer__Column_Mapper class.
* Tweak - Add docblocks to the methods in the `Tribe__Events__Importer__Column_Mapper` class.
* Tweak - Add information and missing tags to `tribe_get_listview_args()` docblock.
* Tweak - Add information and missing tags to `tribe_get_listview_dir_link()` docblock.
* Tweak - Add information and missing tags to `tribe_get_listview_link()` docblock.
* Tweak - Add information and missing tags to `tribe_get_listview_past_link()` docblock.
* Tweak - Add information and missing tags to `tribe_get_prev_event_link()`.
* Tweak - Made a string translatable in `settings.php` file. (props to @DAnn2012) [TEC-5142]
* Tweak - Update the docblock of the `tribe_embed_google_map()` method, change a variable name to match current naming conventions, and added a docblock to the `tribe_embed_google_map` filter.
* Tweak - Update the docblock of the `tribe_embed_google_map_link()` method, change a variable name to match current naming conventions, and added a docblock to the `tribe_embed_google_map_link` filter.
* Fix - Add an option to allow for duplicate Venue creation as part of creating/editing Events.
* Fix - Adding small adjustment to WPML integration to allow for location searches on a translated site. (props to @dgwatkins) [ECP-1823]
* Fix - Changed logic within the custom tables query to avoid a database error. (props @datadiver0x0) [ECP-1562]
* Fix - Update the logic that displays the "REST API blocked" banner to reduce false positives. [TEC-5105]

### [6.6.3] 2024-08-28

* Tweak - Add docblock for make_select_box()
* Fix - Add an option to allow for duplicate Venue creation as part of creating/editing Events. [TEC-4941]
* Fix - Character encoding issues on subscribe URLs for Outlook. [TEC-5085, TEC-5094, TEC-5136]
* Fix - Update the logic that displays the "REST API blocked" banner to reduce false positives. [TEC-5105]

### [6.5.1] 2024-06-11

* Feature - Adapt to using the refactored tribe_asset. Remove some unused asset calls. [TCMN-172]
* Fix - Remove automatic capitalization for 'View Calendar' text on Calendar List Widget. [TEC-5146]
* Tweak - Add note to `tribe_create_venue()`, `tribe_create_organizer()`, `tribe_create_event()`, `tribe_update_event()`, `tribe_update_venue()`, `tribe_update_organizer()`, `tribe_delete_organizer()`, and `tribe_delete_venue()` docblocks to indicate future deprecation.
* Tweak - Add docblocks to `src/Tribe/Featured_Events/Permalinks_Helper.php` and `src/Tribe/Featured_Events/Query_Helper.php`.
* Tweak - Changed views: `single-event`
* Language - 2 new strings added, 69 updated, 0 fuzzied, and 0 obsoleted

### [6.5.0.1] 2024-06-04

* Fix - Ensure REST API notice only checks on Events admin pages and once every 48 hours regardless of transients rules. [TEC-5147]
* Security - Ensure the Events REST API respects the individual post access restrictions. [TEC-5148]

### [6.5.0] 2024-05-14

* Version - The Events Calendar 6.5.0 is only compatible with Event Tickets 5.10.0 and higher
* Feature - Moved the Remove End Time settings from our Tweaks extension into the TEC > Settings > Display section. Fixes some compatibility issues with recent updates to the views. Also adds a compatibility layer in case of using an older Tweaks extension. [TEC-4371]
* Fix - When creating a new event the Currency symbol, code and position fields are populated from the general settings options. [TEC-5072]
* Fix - Wrong page titles in List page when using a Classic Theme. [TEC-5074]
* Tweak - Add a warning notice in admin area when the REST API endpoints are not accessible. [TEC-4667]
* Tweak - Add aria-hidden="true" to the event image link so that screen readers ignore it. [TEC-5023]
* Tweak - Add note to `tribe_event_delete()` docblock to indicate future deprecation.
* Tweak - Added actions: `tec_events_elementor_widgets_registered` [TEC-5091]
* Tweak - Added filters: `tec_events_filter_events_template_setting_option`, `tec_events_filter_tribe_get_single_option`, `tec_events_{$slug}_visibility_is_visible`, `tec_events_{$slug}_visibility_is_visible:{$area}`, `tec_events_{$slug}_visibility_is_visible:{$area}:{$post_id}`, `tec_events_display_remove_event_end_time_options`
* Tweak - Removed filters: `tribe_events_register_venue_post_type_labels`
* Tweak - Added actions: `tec_events_elementor_widgets_registered`
* Tweak - Changed views: `single-event/recurring-description`, `v2/list/event/featured-image`
* Security - Replace uses of the retired moment.js with Day.js [TEC-5011]
* Language - 8 new strings added, 190 updated, 0 fuzzied, and 0 obsoleted

### [6.4.0.1] 2024-05-06

* Fix - Prevent the Status widget from potentially running undefined methods. [ECP-1797]
* Tweak - Add action to signal activation of TEC Elementor compatibility. [ECP-1789]
* Tweak - Added actions: `tec_events_elementor_loaded`
* Security - Ensure JSON response of Reflector View class is sanitized, to avoid potential security issues. [SVUL-2]
* Security - Correct a user permissions check.
* Language - 0 new strings added, 27 updated, 0 fuzzied, and 0 obsoleted

### [6.4.0] 2024-04-30

* Feature - Elementor Compatibility. Compatible with Elementor Free 3.21+ and Elementor Pro 3.20+.
* Feature - Added component Elementor widgets for the single event page.
* Feature - Widgets include: Title, Date, Cost, Image, Status, Organizer, Venue, Website, Category, Tags, Subscribe, and Calendar link.
* Feature - Most widgets can be used outside of a single-event post by specifying an event ID or event query parameters.
* Feature - All widgets utilize our PHP templating system, allowing customization of the widget templates.
* Feature - Added a customizable single event template for Elementor Free users utilizing the new widgets.
* Feature - Added a separate customizable single event Theme Builder template for Elementor Pro users utilizing the new widgets.
* Feature - Widgets include mock data for display in template editor.
* Tweak - Added a Calendar Template section in the event display settings page. [ECP-1618]
* Tweak - converted some uses of `date()` to `gmdate()` for display in the date settings section. [ECP-1618]
* Tweak - Added filters: `tec_events_allow_archive_block_template`, `tec_events_allow_single_block_template`, `tec_events_elementor_widget_asset_widgets`, `tec_events_elementor_built_with_elementor`, `tec_events_elementor_registered_{$this->type}`, `tec_events_elementor_event_widget_title`, `tec_events_elementor_event_{$slug}_widget_title`, `tec_events_elementor_event_widget_element_classes`, `tec_events_elementor_event_{$slug}_widget_element_classes`, `tec_events_elementor_event_widget_class`, `tec_events_elementor_event_{$slug}_widget_class`, `tec_events_elementor_event_widget_icon_class`, `tec_events_elementor_event_{$slug}_widget_icon_class`, `tec_events_elementor_widget_event_id`, `tec_events_elementor_widget_{$slug}_event_id`, `tec_events_elementor_widget_template_data`, `tec_events_elementor_widget_{$slug}_template_data`, `tec_events_elementor_event_calendar_link_widget_link_text`, `tribe_get_event_categories`, `tec_events_elementor_event_categories_widget_event_categories_html`, `tec_events_elementor_event_category_widget_header_class`, `tec_events_elementor_event_category_widget_link_wrapper_class`, `tec_events_elementor_event_export_widget_dropdown_class`, `tec_events_elementor_event_export_widget_dropdown_button_class`, `tec_events_elementor_event_export_widget_dropdown_list_class`, `tec_events_elementor_event_export_widget_dropdown_list_item_class`, `tec_events_elementor_event_export_widget_dropdown_link_class`, `tec_events_elementor_event_export_widget_dropdown_content_class`, `tec_events_elementor_event_export_widget_dropdown_icon_class`, `tec_events_elementor_event_export_widget_export_icon_class`, `tec_events_elementor_event_export_widget_dropdown_gcal_class`, `tec_events_elementor_event_export_widget_dropdown_ical_class`, `tec_events_elementor_event_export_widget_dropdown_365_class`, `tec_events_elementor_event_export_widget_dropdown_live_class`, `tec_events_elementor_event_organizer_widget_email_header_text`, `tec_events_elementor_event_organizer_widget_phone_header_text`, `tec_events_elementor_event_organizer_widget_website_header_text`, `tec_events_elementor_event_organizer_header_class`, `tec_events_elementor_event_organizer_name_class`, `tec_events_elementor_event_organizer_name_wrapper_class`, `tec_events_elementor_event_organizer_phone_class`, `tec_events_elementor_event_organizer_phone_wrapper_class`, `tec_events_elementor_event_organizer_phone_header_class`, `tec_events_elementor_event_organizer_email_class`, `tec_events_elementor_event_organizer_email_wrapper_class`, `tec_events_elementor_event_organizer_email_header_class`, `tec_events_elementor_event_organizer_website_class`, `tec_events_elementor_event_organizer_website_wrapper_class`, `tec_events_elementor_event_organizer_website_header_class`, `tec_events_elementor_event_passed_label_text`, `tec_events_elementor_event_tags_separator`, `tec_events_elementor_event_tags_widget_header_text`, `tec_events_elementor_event_tags_header_class`, `tec_events_elementor_event_tags_links_class`, `tec_events_elementor_event_tags_link_class`, `tec_events_elementor_event_venue_widget_header_text`, `tec_events_elementor_event_venue_widget_website_header_text`, `tec_events_elementor_event_venue_widget_phone_header_text`, `tec_events_elementor_event_venue_widget_address_header_text`, `tec_events_elementor_event_venue_header_class`, `tec_events_elementor_event_venue_name_class`, `tec_events_elementor_event_venue_address_class`, `tec_events_elementor_event_venue_phone_class`, `tec_events_elementor_event_venue_website_class`, `tec_events_elementor_event_venue_map_class`, `tec_events_elementor_event_website_widget_header_class`, `tec_events_elementor_event_website_widget_link_class`, `tec_events_elementor_widget_classes`, `tec_events_should_display_events_template_setting`
* Tweak - Removed filters: `tribe_get_venue_website_link_label`
* Tweak - Added actions: `tec_events_elementor_register_widget_assets`, `tec_events_elementor_enqueue_frontend_assets`, `tec_events_elementor_register_editor_styles`, `tec_events_elementor_widget_enqueue_style`, `tec_events_elementor_widget_{$slug}_enqueue_style`
* Tweak - Changed views: `integrations/elementor/templates/blank`, `integrations/elementor/templates/starter`, `integrations/elementor/widgets/base`, `integrations/elementor/widgets/empty`, `integrations/elementor/widgets/event-calendar-link`, `integrations/elementor/widgets/event-categories`, `integrations/elementor/widgets/event-categories/header`, `integrations/elementor/widgets/event-cost`, `integrations/elementor/widgets/event-cost/header`, `integrations/elementor/widgets/event-datetime`, `integrations/elementor/widgets/event-datetime/all-day`, `integrations/elementor/widgets/event-datetime/end-date`, `integrations/elementor/widgets/event-datetime/end-time`, `integrations/elementor/widgets/event-datetime/header`, `integrations/elementor/widgets/event-datetime/range-separator`, `integrations/elementor/widgets/event-datetime/start-date`, `integrations/elementor/widgets/event-datetime/start-time`, `integrations/elementor/widgets/event-datetime/time-separator`, `integrations/elementor/widgets/event-datetime/timezone`, `integrations/elementor/widgets/event-export`, `integrations/elementor/widgets/event-export/button`, `integrations/elementor/widgets/event-export/link`, `integrations/elementor/widgets/event-export/list-item`, `integrations/elementor/widgets/event-image`, `integrations/elementor/widgets/event-navigation`, `integrations/elementor/widgets/event-navigation/next`, `integrations/elementor/widgets/event-navigation/previous`, `integrations/elementor/widgets/event-organizer`, `integrations/elementor/widgets/event-organizer/details`, `integrations/elementor/widgets/event-organizer/details/email`, `integrations/elementor/widgets/event-organizer/details/email/content`, `integrations/elementor/widgets/event-organizer/details/email/header`, `integrations/elementor/widgets/event-organizer/details/phone`, `integrations/elementor/widgets/event-organizer/details/phone/content`, `integrations/elementor/widgets/event-organizer/details/phone/header`, `integrations/elementor/widgets/event-organizer/details/website`, `integrations/elementor/widgets/event-organizer/details/website/content`, `integrations/elementor/widgets/event-organizer/details/website/header`, `integrations/elementor/widgets/event-organizer/header`, `integrations/elementor/widgets/event-organizer/names`, `integrations/elementor/widgets/event-status`, `integrations/elementor/widgets/event-status/passed`, `integrations/elementor/widgets/event-status/status`, `integrations/elementor/widgets/event-tags`, `integrations/elementor/widgets/event-tags/content`, `integrations/elementor/widgets/event-tags/header`, `integrations/elementor/widgets/event-title`, `integrations/elementor/widgets/event-venue`, `integrations/elementor/widgets/event-venue/address`, `integrations/elementor/widgets/event-venue/address/address`, `integrations/elementor/widgets/event-venue/address/header`, `integrations/elementor/widgets/event-venue/address/map_link`, `integrations/elementor/widgets/event-venue/header`, `integrations/elementor/widgets/event-venue/map`, `integrations/elementor/widgets/event-venue/name`, `integrations/elementor/widgets/event-venue/phone`, `integrations/elementor/widgets/event-venue/phone/header`, `integrations/elementor/widgets/event-venue/phone/phone`, `integrations/elementor/widgets/event-venue/single-venue`, `integrations/elementor/widgets/event-venue/website`, `integrations/elementor/widgets/event-venue/website/header`, `integrations/elementor/widgets/event-venue/website/website`, `integrations/elementor/widgets/event-website`, `integrations/elementor/widgets/event-website/header`, `integrations/elementor/widgets/event-website/link`, `integrations/event-tickets/emails/template-parts/body/event/venue/website`
* Language - 201 new strings added, 101 updated, 3 fuzzied, and 0 obsoleted

### [6.3.7] 2024-04-18

* Fix - Corrected the missing Venue Website URL within the Event Tickets Email feature. [ET-2019]
* Tweak - Changed views: `integrations/event-tickets/emails/template-parts/body/event/venue/website`
* Language - 0 new strings added, 0 updated, 0 fuzzied, and 0 obsoleted

### [6.3.6] 2024-04-09

* Fix - Adds timezone offset to the dates in the Outlook subscribe links on event pages. [TEC-4831]
* Fix - Improve updated views CSS overwrites for buttons and view selector. [TEC-5047]
* Fix - Resolves an issue where the global posts were not the correct range or sort order. This now stores the ones from the view repository to be used in the WP title filters. [TEC-4845]
* Fix - Fixes a PHP warning `Undefined array key "venue" in /var/www/html/wp-content/plugins/the-events-calendar/src/Tribe/Linked_Posts.php on line 1007`.
* Tweak - Changed views: `blocks/classic-event-details`, `blocks/event-website`, `v2/components/events-bar/views`, `v2/components/json-ld-data`, `v2/components/subscribe-links/list`, `v2/day/top-bar/datepicker`, `v2/list/top-bar/datepicker`, `v2/month/top-bar/datepicker`
* Language - 0 new strings added, 15 updated, 0 fuzzied, and 0 obsoleted

### [6.3.5] 2024-03-20

* Tweak - Updated version of tribe-common with fixes for ECP.

### [6.3.4] 2024-03-12

* Tweak - When using Event Tickets Wallet Plus the Apple Pass will now display date fields differently based off of Single, Multi, or Series Events. [ETWP-95]
* Tweak - Added filters: `tec_tickets_wallet_plus_apple_wallet_date_format`, `tec_tickets_wallet_plus_apple_wallet_time_format`
* Language - 2 new strings added, 6 updated, 0 fuzzied, and 0 obsoleted

### [6.3.3.1] 2024-02-22

* Fix - On a multisite using WordPress 6.4.3 there was an issue with the subsite options not being properly created during initialization. [TEC-5043]

### [6.3.3] 2024-02-19

* Version - The Events Calendar 6.3.1 is only compatible with Event Tickets 5.8.1 and higher.
* Tweak - Refactored some of the underlying structure for Block Template architecture. [ECP-1620]
* Tweak - Added filters: `tec_events_get_full_site_block_template_services`
* Tweak - Changed views: `blocks/event-links`, `single-event`, `v2/components/data`
* Language - 4 new strings added, 4 updated, 0 fuzzied, and 0 obsoleted

### [6.3.2] 2024-02-06

* Tweak - Share statistical information to Event Tickets plugin when active. [ET-1925]
* Fix - Improve the usage of the shortcodes around Event Details.
* Language - 0 new strings added, 0 updated, 0 fuzzied, and 0 obsoleted

### [6.3.1] 2024-01-24

* Fix - Fix PHP 8.2 deprecation errors `PHP Deprecated:  Creation of dynamic property Tribe__Events__Aggregator__Record__gCal::$image_uploader is deprecated`. [ECP-1603]
* Fix - Make sure that the full country name is used when importing events from Meetup. [EA-469]
* Fix - Our Week view "Next" pagination button would fail to show in some scenarios. This was due to improper tracking of which is the next future occurrence date. [ECP-1535]
* Fix - Resolved an issue where adding multiple venues in block editor would not persist the second venue after the page was reloaded. [ECP-1637]
* Tweak - Added actions: `tec_events_custom_tables_v1_migration_after_dry_run`
* Tweak - Adding some more testing and some clean up around handling and reporting query errors. [TECENG-46]
* Language - 0 new strings added, 115 updated, 0 fuzzied, and 0 obsoleted

### [6.3.0] 2024-01-22

* Version - The Events Calendar 6.3.0 is only compatible with Event Tickets 5.8.0 and higher.
* Feature - Include Series Passes supporting code to enable the creation of Series Passes.
* Tweak - Added the `tec_events_custom_tables_v1_migration_after_dry_run` filter. [ET-1715]
* Language - 0 new strings added, 92 updated, 0 fuzzied, and 0 obsoleted

### [6.2.9] 2023-12-14

* Fix - Resolves an issue where the `tribe-events-calendar-month__day--past` and `tribe-events-calendar-month__day--current` classes were not consistently applied after navigating through different months in the Month View. [TEC-4898]
* Tweak - Define image sizes on the List view featured image to avoid Content Layout Shifting. [TEC-4919]
* Fix - When on category page when there is a locale switched to a language with a translation for the `page` URL param, the paginated page would redirect to a 404. [TEC-4979]
* Tweak - Updated the `tribe_get_venues` function to work with recurring events that have provisional IDs. [ECP-1597]
* Tweak - Added filters: `tec_events_custom_tables_v1_normalize_occurrence_id`
* Tweak - Changed views: `v2/list/event/featured-image`
* Language - 0 new strings added, 2 updated, 0 fuzzied, and 0 obsoleted

### [6.2.8.2] 2023-12-04

* Fix - Ensure correct access rights to JSON-LD data depending on the user role. [TEC-4995]
* Language - 0 new strings added, 130 updated, 0 fuzzied, and 5 obsoleted

### [6.2.8.1] 2023-11-20

* Security - Ensure all password protected posts have their settings respected. [TCMN-167]

### [6.2.8] 2023-11-16

* Version - The Events Calendar 6.2.8 is only compatible with Event Tickets 5.7.0 and higher
* Tweak - Include Event data into for Event Tickets Wallet Plus for both PDF and Apple Wallet passes.
* Language - 0 new strings added, 135 updated, 0 fuzzied, and 11 obsoleted

### [6.2.7] 2023-11-14

* Fix - On the Past Events View, the nonce was incorrectly being generated twice, and one of them would be cached in our HTML transient cache. This was causing a 401 nonce errors to occur when the cached nonce expired. The nonce generation was moved outside the HTML generation that is being cached. [TEC-4936]
* Fix - WordPress 6.3 introduce some changes in filters that regressed a prior fix for authentication and our new nonce structure used in view pagination. One symptom of the issue was losing the authenticated user and failing to display user specific capabilities on event views. [ECP-1601]
* Fix - Resolves issue where a deleted venue still attached to an event would cause an `PHP Warning: Undefined variable $data in /code/wp-content/plugins/the-events-calendar/src/Tribe/REST/V1/Post_Repository.php on line 327` error. [TEC-4954]
* Fix - Resolves an issue with certain versions of WordPress already having the legacy widget block registered causing us to trigger the console error `Block "core/legacy-widget" is already registered.` would occur. Now we check if registered first. [TEC-4764]
* Fix - Resolved several `Deprecated: Creation of dynamic property` warnings on: `\Tribe__Events__Linked_Posts__Chooser_Meta_Box::$singular_name_lowercase` and `\TEC\Events\Custom_Tables\V1\Models\Builder::$query` [BTRIA-2088]
* Tweak - Adjust the content in the admin welcome page to include a link to the TEC Facebook community group. [TEC-4953]
* Tweak - Added filters: `tec_events_get_full_site_block_template_services`, `tec_events_views_v2_get_rest_nonce_html`
* Tweak - Changed views: `blocks/archive-events`, `blocks/single-event`
* Language - 11 new strings added, 119 updated, 0 fuzzied, and 5 obsoleted.

### [6.2.6.1] 2023-11-09

* Version - The Events Calendar 6.2.6.1 is only compatible with Event Tickets 5.6.8.1 and higher
* Fix - Update a common library to prevent possible fatals. [TEC-4978]
* Language - 0 new strings added, 2 updated, 0 fuzzied, and 0 obsoleted

### [6.2.6] 2023-11-08

* Fix - SEO: Ensure that the noindex meta tag properly observes whether events are present on the page or not. [TEC-4976]
* Fix - SEO: Add noindex, nofollow for grid-based views like Month and Week View when they are not set as the home page. [TEC-4976]
* Tweak - Add an X-Robots-Tag to the response headers for ical download links to help prevent search engine crawling. [TEC-4976]
* Tweak - Added filter: `tec_events_ical_header_noindex` to allow preventing the X-Robots-Tag addition. [TEC-4976]
* Tweak - Added filter `tec_events_seo_robots_meta_include` and `tec_events_seo_robots_meta_include_{$view}` to short-circuit the robots meta tag addition. [TEC-4976]
* Tweak - Added filter `tec_events_seo_robots_meta_content` to alter the content attribute of the robots meta tag addition. [TEC-4976]
* Tweak - Added filter `tec_events_seo_robots_meta_allowable_post_types` to allow for the filtering of single post types that can have robots meta tags added.
* Tweak - Deprecated filters `tec_events_add_no_index_meta_tag`, `tribe_events_add_no_index_meta`, and `tec_events_{$view}_add_no_index_meta` in favor of the above new filters.

### [6.2.5] 2023-11-01

* Tweak - Updated hook for showing Event name in the event tickets order report pages. [ET-1810]

### [6.2.4] 2023-10-19

* Fix - AM/PM time formats `g:i A` and `g:i a` are now respected for the French locale. [TEC-4807]

### [6.2.3.2] 2023-10-12

* Fix - Prevent noindex code from adding tags to single event pages. [TEC-4949]
* Fix - Correct a problem that can cause a fatal when plugins are deactivated in a certain order. [TEC-4951]

### [6.2.3.1] 2023-10-09

* Fix - Prevent a fatal caused by get_noindex_events on Events Calendar PRO views if PRO has not been updated. [TEC-4946]
* Language - 0 new strings added, 2 updated, 0 fuzzied, and 0 obsoleted

### [6.2.3] 2023-10-03

* Fix - Ensure the UI can handle an unlimited number of recurrence rules when users create recurring events using the block editor. [ECP-1572]
* Fix - Resolved "Uncaught ReferenceError: lodash is not defined" error by adding `lodash` as a dependency for the Block Editor Assets. [ECP-1575]
* Fix - Resolves an issue around our new nonce structure used in view pagination, losing the authenticated user and failing to display user specific capabilities. [ECP-1581]
* Tweak - Updated focus state for relevant elements to have default outline ensuring improved accessibility and consistent browser behavior. [TEC-4888]
* Tweak - Added filters: `tec_events_add_no_index_meta_tag`, `tec_events_noindex`, `tec_events_{$view}_add_no_index_meta`, `tec_events_no_index_meta`
* Language - 0 new strings added, 183 updated, 0 fuzzied, and 0 obsoleted

### [6.2.2.1] 2023-09-28

* Version - The Events Calendar 6.2.2.1 is only compatible with Event Tickets 5.6.5.1 and higher
* Fix - Fix - Correct issue where Telemetry would register active plugins multiple times. [TEC-4920]

### [6.2.2] 2023-09-13

* Version - The Events Calendar 6.2.2 is only compatible with Event Tickets 5.6.5 and higher
* Fix - When using the Event Tickets email feature the Organizer email and website will no longer be switched. [ET-1843]
* Fix - When subscribing to an event, the organizer name will not encode as many characters, especially spaces. [ET-1778]
* Language - 0 new strings added, 9 updated, 0 fuzzied, and 0 obsoleted

### [6.2.1] 2023-09-05

* Fix - WP Rewrite was being incorrectly initialized in some scenarios due to container DI, and causing some 404s. This was affecting classes that extend the `Tribe__Rewrite`. [TEC-4844]
* Fix - Fixed a bug where `0` and `1` were displayed on the `general` and `display` tabs for Network admins on multisite installations. [TEC-4774]
* Fix - In some cases when multiple Widgets were used on a page, the view results would return the wrong cache, displaying incorrect results. This fixes the inspection of the different view filters being used to determine whether it is cached or not. [ECP-1561]
* Fix - Correct some accessibility issues in the subscribe dropdowns. Props to @alh0319 for calling these out! [TEC-4185]
* Tweak - Enhanced venue and organizer labels by updating aria labels with additional placeholders and revised translator comments, improving internationalization and accessibility. [TEC-4874]
* Tweak - Changed views: `blocks/parts/organizer`, `blocks/parts/subscribe-list`, `modules/meta/organizer`, `modules/meta/venue`, `v2/components/subscribe-links/item`, `v2/components/subscribe-links/list`, `v2/components/subscribe-links/single-event-list`
* Language - 1 new strings added, 22 updated, 0 fuzzied, and 8 obsoleted

### [6.2.0.1] 2023-08-16

* Fix - Ensure we pass the correct number of params to `maybe_get_new_order_from_blocks` [TEC-4889]

### [6.2.0] 2023-08-15

* Tweak - Change styling for Venue Blocks to constrain to a card-like style. [ECP-1540]
* Tweak - Adjust REST endpoints to support multiple venues during event creation and updates. [ECP-1540]
* Tweak - If multiple venues exist on an event, display them in the classic event editor. [ECP-1540]
* Fix - Ensure the block editor includes support for user-defined custom CSS classes. [TEC-4724]
* Fix - Ensure the "Add Organizer" button is visible in the classic editor if organizers have been set. [TEC-4729]
* Fix - Simplify data handling of venues within the block editor. [ECP-1540]
* Fix - When removing a newly created organizer in the block editor before saving the event will now trash the draft organizer. [TEC-3865]
* Tweak - Added filters: `tec_events_rewrite_dynamic_matchers`, `tec_events_views_v2_assets_should_enqueue_single_event_block_editor_styles`, `tec_events_title_taxonomies`, `tec_events_views_v2_view_header_title_element`, `tec_events_views_v2_view_{$view_slug}_header_title_element`, `tec_events_views_v2_view_header_title`, `tec_events_views_v2_view_{$view_slug}_header_title`, `tec_events_views_v2_view_content_title`, `tec_events_views_v2_view_{$view_slug}_content_title`, `tec_get_venue_ids`
* Tweak - Added actions: `tec_events_after_venue_map_fields`
* Tweak - Changed views: `blocks/event-venue.php`, `blocks/parts/map.php`, `blocks/parts/venue.php`, `v2/base.php`, `v2/components/breadcrumbs/linked-breadcrumbs.php`, `v2/components/content-title.php`, 'v2/components/header-title.php`, `v2/components/header.php`, `v2/components/messages.php`, `v2/day.php`, `v2/day/event/venue.php`, `v2/list.php`, `v2/list/event/venue.php`, `v2/month.php`
* Language - 3 new strings added, 72 updated, 1 fuzzied, and 2 obsoleted

### [6.1.4] 2023-08-10

* Version - The minimum supported version of WordPress is now 6.1.0
* Fix - In some scenarios our pagination and various view actions would fail due to 403 errors on the REST endpoints, because of failing nonce checks, likely due to cache. Updating the way we handle nonces to avoid some scenarios the wrong nonce could be cached. [TEC-4814]
* Fix - This issue was regarding our rewrite parsing for the view picker url generation with WPML enabled. It was failing to parse the translated rewrite properly, and leaving unparsed permalinks. [TEC-4758]
* Fix - Ensure we output valid html around <dt> and <dd> elements in an accessible way. [TEC-4812]
* Fix - Ensure the block editor includes support for user-defined custom CSS classes. [TEC-4724]
* Fix - Handle some issues with incorrect application of noindex meta tags. [TEC-4717]
* Fix - Our logic to include `tribe_events` post type on the tag archive page was incorrectly bleeding into other queries happening on the page. This narrows the scope for the `WP_Query` post type overrides and avoids situations where Divi templates were not loading properly. [TEC-4819]
* Fix - Correct some PHP 8.1 deprecations that impact loading of views. [TEC-4871]
* Fix - Prevent TypeError warnings around `admin_footer_text_settings` filter due to type hinting conflicting with other plugins returning null.
* Tweak - Deprecated misspelled `tribe_get_organiser_object_after` filter for one with correct spelling: `tribe_get_organizer_object_after`. Done as part of [TEC-4812]
* Tweak - Remove end colons from some translated strings. Done as part of [TEC-4812]
* Tweak - Fix typo in template displaying stray "w". [TEC-4870]
* Tweak - Removed code pertaining to Event Tickets CT1. [ETP-874]
* Tweak - Added filters: `tec_events_views_v2_get_rest_nonces`, `tribe_events_get_organizer_object_after`
* Tweak - Deprecated filters: `tribe_events_get_organiser_object_after`
* Tweak - Deprecated functions: In `Tribe\Views\V2\Views\Traits\HTML_Cache.php` the `get_view_nonce_fields()`,`get_view_nonce_attributes()`, `get_view_nonce_json_properties()`, `extract_nonces_before_cache()`, `extract_nonces_before_cache()`, `extract_nonces_before_cache()`, and `maybe_generate_nonce()` functions have been deprecated.
* Tweak - Changed views: `blocks/classic-event-details.php`, `blocks/event-category.php`, `blocks/event-datetime.php`, `blocks/event-organizer.php`, `blocks/event-price.php`, `blocks/event-tags.php`, `blocks/event-venue.php`, `blocks/event-website.php`, `blocks/featured-image.php`, `blocks/parts/details.php`, `blocks/parts/organizer.php`, `blocks/parts/subscribe-list.php`, `blocks/parts/subscribe-single.php`, `modules/meta/organizer.php`, `modules/meta/venue.php`, `v2/components/events-bar/search.php`, `v2/day.php`, `v2/list.php`, `v2/month.php`, `v2/widgets/widget-events-list.php`.
* Language - 11 new strings added, 12 updated, 0 fuzzied, and 0 obsoleted.

### [6.1.3] 2023-07-13

* Version - The Events Calendar 6.1.3 is only compatible with Events Community 4.10.10 and higher
* Fix - Performance improvements on Month and Day view when a lot of future and past events were found. [TEC-3089]
* Fix - Ensure we're using the correct download link for the `Export Outlook .ics` file in the single event page. [TEC-4776]
* Fix - Ensure TEC styles can be easily overridden by themes and page builders. [ECP-1503]
* Fix - Avoid the issue where TEC blocks would break when either the `WP Go Maps`, `MapPress Google Maps` and `Leaflet Maps` plugins were active on a site. [TEC-4810]
* Fix - Added some event parsing to ensure only valid events are handled in the iCal file generation. [TEC-4837]
* Fix - Harden some of our CSS to prevent unintended overrides by Elementor global styles. [TEC-4811]
* Fix - Log errors throw in the context of the Custom Tables v1 component. [ET-1486]
* Fix - Adding memoizing into the CT1 models to help reduce trips to fetch the same instance. [ECP-1505]
* Tweak - Refactored CSS for Tickets Emails to better conform to email client CSS standards. [TEC-4849]
* Tweak - Added filters: `tec_events_ical_protected_content_description`
* Tweak - Added actions: `tribe_log`
* Tweak - Changed views: `integrations/event-tickets/emails/template-parts/header/head/tec-styles`
* Security - Various improvements to event creation.
* Language - 1 new strings added, 129 updated, 0 fuzzied, and 0 obsoleted

### [6.1.2.2] 2023-06-23

* Fix - Ensure there is backwards compatibility with Extensions and Pods.

### [6.1.2.1] 2023-06-22

* Fix - Prevent Telemetry from being initialized and triggering a Fatal when the correct conditionals are not met.

### [6.1.2] 2023-06-22

* Version - The Events Calendar 6.1.2 is only compatible with Event Tickets 5.6.1 and higher
* Version - The Events Calendar 6.1.2 is only compatible with Events Filterbar 5.5.0 and higher
* Version - The Events Calendar 6.1.2 is only compatible with Events Community 4.10.8 and higher
* Version - The Events Calendar 6.1.2 is only compatible with Events Community Tickets 4.9.3 and higher
* Version - The Events Calendar 6.1.2 is only compatible with Eventbrite Tickets 4.6.14 and higher
* Version - The Events Calendar 6.1.2 is only compatible with Virtual Events 1.15.1 and higher
* Version - The Events Calendar 6.1.2 is only compatible with Event Automator 1.3.1 and higher
* Fix - Lock our container usage(s) to the new Service_Provider contract in tribe-common. This prevents conflicts and potential fatals with other plugins that use a di52 container.

### [6.1.1] 2023-06-15

* Feature - Include Events data into the Tickets Email for compatibility with Event Tickets. [ET-1552] [ET-1553] [ET-1601]
* Tweak - Added filters: `tribe_general_settings_viewing_section`, `tribe_general_settings_editing_section`, `tribe_general_settings_maintenance_section`, `tribe_general_settings_debugging_section`
* Tweak - Removed filters: `tec_events_integrations_should_load`, `tec_events_integrations_{$type}_should_load`, `tec_events_integrations_{$type}_{$slug}_should_load`, `tribe_events_integrations_should_load_freemius`
* Tweak - Added actions: `tec_telemetry_modal`
* Tweak - Changed views: `integrations/event-tickets/emails/template-parts/body/event/date`, `integrations/event-tickets/emails/template-parts/body/event/image`, `integrations/event-tickets/emails/template-parts/body/event/links`, `integrations/event-tickets/emails/template-parts/body/event/links/gcal`, `integrations/event-tickets/emails/template-parts/body/event/links/ical`, `integrations/event-tickets/emails/template-parts/body/event/venue`, `integrations/event-tickets/emails/template-parts/body/event/venue/address`, `integrations/event-tickets/emails/template-parts/body/event/venue/phone`, `integrations/event-tickets/emails/template-parts/body/event/venue/website`, `integrations/event-tickets/emails/template-parts/header/head/tec-styles`
* Language - 28 new strings added, 132 updated, 0 fuzzied, and 0 obsoleted

### [6.1.0.1] 2023-06-14

* Fix - Prevent fatals when older version of Event Tickets was looking for Freemius code that was removed.

### [6.1.0] 2023-06-14

* Feature - Replace Freemius with Telemetry - an in-house info system. [TEC-4700]
* Feature - Add plugin info to Site Health admin page. [TEC-4701]
* Fix - Elementor and other themes would inadvertently override styles on the tickets button, when the global styles were set. This hardens the common button (rsv/ticket button) styles a bit more. [TEC-4794]
* Fix - Added option to disable pagination on the Month and Week views to address issue of missing events. [TEC-4615]
* Fix - Avoid SQL error when filtering by Series in Custom Tables v1 context. [ET-1486]
* Fix - Fixes database error, caused by the CT1 query parser when attempting rewrite the order by statement. Added logic to reflect on meta query arrays, and not just key/value pairs. [ECP-1495]
* Fix - In block editor there were unnecessary geocode API calls being triggered for Event Venue blocks. Moved logic within stateful conditions, now it no longer runs fetch if the address has not actually changed. [TEC-4741]
* Fix - Prevent administration navigation fatal error with `TypeError: array_search()`. [TEC-4780]
* Fix - Removing our eager schema updates. This was causing a number of `ALTER` statements being run redundantly. No longer utilizes cache/transient for the last run check as it is not dependable. [TEC-4797]
* Fix - This fixes a situation where cache would cause the `post` reference to switch to the initial `post` mid-loop on the admin events list page. This likely could have been happening on other pages as well. [TEC-4690]
* Tweak - Ensure the page titles on the single venue and organizer pages include the respective post titles for improved SEO. [ECP-1173]
* Tweak - Updates title tags on events pages, to be more unique and search specific, taking on formats like "Events from February 2, 2017 - February 3, 2019". [TEC-4692]
* Tweak - Utilize our new container architecture in tribe-common.
* Language - 1 new strings added, 22 updated, 1 fuzzied, and 0 obsoleted

### [6.0.13.1] 2023-05-15

* Fix - In block editor there were unnecessary geocode API calls being triggered for Event Venue blocks. Moved logic within stateful conditions, now it no longer runs fetch if the address has not actually changed. [TEC-4741]
* Language - 0 new strings added, 6 updated, 0 fuzzied, and 0 obsoleted

### [6.0.13] 2023-05-08

* Fix - Correct issue with event subscriptions not passing events past the first 30. [TEC_4584]
* Fix - Ensure Events are displayed correctly on Elementor's `Posts` widget. [TEC-4685]
* Fix - Fix a `Fatal error: Uncaught TypeError: Illegal offset type in isset or empty in …/wp-content/plugins/sitepress-multilingual-cms/classes/url-handling/converter/class-wpml-url-cached-converter.php:46` fatal with our WPML integration when filtering Event permalinks for Event views. [TEC-4770]
* Fix - Fixed an edge case to not inadvertently trash entire Events Pro recurrences. [ECP-1475]
* Fix - For CT1 in markers the occurrence would sometimes not be the same one found as the date field, only one was filtering by post_status. We were only using `provisional_id` for CT1, now we fallback to `post_id`. Now removing options when no occurrences are found, instead of retaining a stale value. [TEC-4768]
* Fix - Pass a NOOP callback function to Google Maps scripts to prevent JS warnings. [TEC-4762]
* Fix - Some button style hardening to prevent some common theme global style bleed, namely from Elementor global styles. [TEC-4677]
* Tweak - Added filter `tec_events_event_cleaner_trash_cron_frequency` to allow customizing the frequency of the trash old event cron. [ECP-1475]
* Tweak - Deprecated some event cleaner functionality. When 6.0 data structure is activated the `Permanently delete events older than` option is disabled, added an adjusted tooltip on the `Move to trash events older than` event setting regarding `EMPTY_TRASH_DAYS`. [TEC-4744]
* Tweak - Ensure the `Subscribe to Calendar` dropdown toggles on and off on click for an improved user experience. [TEC-4388]
* Tweak - Ensure we have the ability to hide the Event Tickets Activation notice using the `defined( 'TRIBE_HIDE_UPSELL' )` constant. [TEC-4767]
* Tweak - Updates to `tribe_events_delete_old_events_sql_args` and `tribe_events_delete_old_events_sql` filters to support Events Pro recurrence cleanup. [ECP-1475]
* Tweak - Added filters: `tribe_events_known_range_stati`, `tec_events_custom_tables_v1_events_only_modifier_before_get_posts`, `tec_events_event_cleaner_trash_cron_frequency`, `tec_events_linked_posts_my_posts_post_status`, `tec_events_linked_posts_all_posts_post_status`, `tribe_events_add_canonical_tag`
* Tweak - Added actions: `tec_events_custom_tables_v1_fully_activated`
* Tweak - Changed views: `blocks/event-tags`, `blocks/parts/details`, `v2/list/event/venue`
* Language - 1 new strings added, 32 updated, 0 fuzzied, and 0 obsoleted

### [6.0.12] 2023-04-10

* Fix - Avoid JS error when using the first compact date display format together with WPML. [TEC-4360]
* Fix - Build secondary Views navigation links correctly when WPML is active. [TEC-4689]
* Fix - Build the link to the Events page from the Permalinks settings page correctly. [TEC-4689]
* Fix - Correctly handle the creation or update of Custom Tables v1 in multisite context. (thanks @jiadil). [TEC-4761]
* Fix - Ensure the link to the Event Tags Archive page is correct when using the Block Editor. [TEC-4716]
* Fix - Ensure the venue country is displayed in the list view when venues are created through the block editor interface. [TEC-4731]
* Fix - Fix issue with events post type bleeding in on custom tag queries, instead of only on tag archive page. [TEC-4694]
* Fix - Fixed a situation where an invalid request header in our pagination would cause some strict security settings to block these AJAX requests. [TEC-4723]
* Fix - Fixes an edge case where running get_posts() twice with a taxonomy query, would result in an extra where statement added limiting results in an unexpected way. [TEC-4695]
* Fix - Fixes situation in block editor where a default organizer would not persist after being saved. [ECP-1061]
* Fix - Make improvements to the canonical tags added to event views to improve compatibility with SEO plugins. [TEC-4693]
* Fix - Resolve the issue of the WP customizer not loading correctly when the Colbri Page Builder plugin is active. [TEC-4735]
* Fix - Updates the Monolog repository to use TEC namespacing via Strauss, to provide more compatibility with other plugins. [TEC-4730]
* Tweak - Added filter: `tec_events_custom_tables_v1_events_only_modifier_before_get_posts` in our 6.0 query modifier, useful to make changes to the query prior to fetching posts for the selected events. [TEC-4695]
* Tweak - Added Filters: `tec_events_linked_posts_my_posts_post_status`, `tec_events_linked_posts_all_posts_post_status` to allow filtering of post status of Linked Posts. [CE-27]
* Tweak - Ensure we only have a single <main> element in the single events page for improved accessibility. [TEC-3415]
* Tweak - Fire the `tec_events_custom_tables_v1_fully_activated` when the Custom Tables v1 implementation is fully loaded. [ET-1495]
* Tweak - Replace the use of `FILTER_SANITIZE_STRING` in favour of `tec_sanitize_string` to improve PHP 8.1 compatibility. [TEC-4666]
* Tweak - Added filters: `tec_events_custom_tables_v1_events_only_modifier_before_get_posts`, `tec_events_linked_posts_my_posts_post_status`, `tec_events_linked_posts_all_posts_post_status`, `tribe_events_add_canonical_tag`
* Tweak - Added actions: `tec_events_custom_tables_v1_fully_activated`
* Tweak - Changed views: `blocks/event-tags`, `blocks/parts/details`, `v2/list/event/venue`
* Language - 0 new strings added, 82 updated, 0 fuzzied, and 0 obsoleted

### [6.0.11] 2023-03-20

* Fix - Add a default Schema eventStatus value for JSON LD output of events. [TEC-4609]
* Fix - Avoid fatal error in `tribe_events_event_classes` when called on events that aren't assigned to any category. [TEC-4709]
* Fix - Avoid PHP errors originating from a missing HTML template when the migration to Custom Tables v1 is not required. [ECP-1472]
* Fix - Correctly display Recurring Event Venue and Organizer details on the front-end and back-end when using WPML. [ECP-1442, ECP-1455]
* Fix - Display Venue correctly in List-like views when using WPML. [ECP-1443]
* Fix - Ensure the date tags for recurring events are displayed correctly in the `Events List` widget. [ECP-1382]
* Fix - Ensure the Subscribe to Calendar Dropdown opens and closes consistently across all themes. [TEC-4388]
* Fix - Failures while saving Events from Blocks Editor while using WPML. [ECP-1429]
* Fix - Fix an issue that stopped the default venue values from populating when submitting a Community Event. [CE-178]
* Fix - Fix the pagination styling on the Aggregator import preview data table. [TEC-4698]
* Fix - Link to the correct Occurrence when using CT1 and WPML. [TEC-4632]
* Fix - Prevent event save processing from being interrupted in cases of partial WPML activation where a language code is missing. [ECP-1442]
* Fix - Prevent fatal on PHP 8+ during generation of the activation report when issues exist.
* Fix - Prevent fatal on PHP 8+ for `tribe_get_event_cat_slugs` with bad typing around `array_filter` [TEC-4725]
* Fix - Prevent PHP 8.0+ fatal around iCal exporting with param not being array [TEC-4726]
* Tweak - Add empty alt tag to featured images across all views when a user doesn't explicitly define one to improve SEO. [ECP-1454]
* Tweak - Ensure all instances of the `tribe_get_events_title` filter have matching signatures. [TEC-3929]
* Tweak - Modified single-event.php to use `tribe_get_formatted_cost` instead of `tribe_get_cost` to display the event cost. [TEC-4699]
* Tweak - Update the datepicker label on list-style views to `Upcoming` when no events are found. [TEC-3960]
* Tweak - Removed actions: `tribe_log`
* Tweak - Changed views: `single-event`, `v2/day/event/featured-image`, `v2/latest-past/event/featured-image`, `v2/list/event/featured-image`, `v2/month/calendar-body/day/calendar-events/calendar-event/featured-image`, `v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/featured-image`, `v2/month/mobile-events/mobile-day/mobile-event/featured-image`, `v2/widgets/widget-events-list/event/date-tag`
* Language - 0 new strings added, 24 updated, 2 fuzzied, and 0 obsoleted

### [6.0.10] 2023-02-22

* Version - The Events Calendar 6.0.10 is only compatible with Events Calendar PRO 6.0.9 and higher
* Tweak - PHP version compatibility bumped to PHP 7.4
* Tweak - Version Composer updated to 2
* Tweak - Version Node updated to 18.13.0
* Tweak - Version NPM update to 8.19.3
* Tweak - Reduce JavaScript bundle sizes for Blocks editor

### [6.0.9] 2023-02-09

* Feature - Add a notice with install functionality for Event Tickets. [TEC-4663]
* Fix - Added safeguard against the `rewrite_rules_array` filter being passed non-array values, more error checking in WPML integration. [TEC-4679]
* Fix - Updating some button styles to be more compatible with global button styles, such as Elementor global styling. [TEC-4653]
* Fix - Ensure custom tables data is correctly updated when duplicating an Event using WPML. [TEC-4651]
* Fix - Ensure the zoom level set under `Events → Settings → Display → Google Maps default zoom level` is applied to the single events page. [TEC-4634]
* Fix - Ensure the code will work correctly when the Events' category taxonomy is unregistered. [TEC-4664]
* Fix - Change the type of the date-related custom tables date fields to VARCHAR to avoid warnings on stricter SQL modes. [TEC-4536]
* Fix - Add logic to our template tags to handle non-string returns from `get_the_terms_list()` [TEC-4664]
* Tweak - Add support for opt-in direct deletion of EA older records using the `tec_event_aggregator_direct_record_deletion` filter or setting the `TEC_EVENT_AGGREGATOR_RECORDS_PURGE_DIRECT_DELETION` constant. [EA-446]
* Tweak - Ensure all Google Map iframes have a title attribute to improve accessibility. [TEC-4243]
* Tweak - Allow filtering the redirected nature of a Views v2 request using the `tec_events_views_v2_redirected` filter. [TEC-4511]
* Tweak - Added filters: `tec_event_aggregator_direct_record_deletion`, `tec_event_aggregator_direct_record_deletion_batch_size`, `tec_events_views_v2_redirected`
* Tweak - Changed views: `modules/map-basic`
* Language - 6 new strings added, 125 updated, 0 fuzzied, and 0 obsoleted

### [6.0.8] 2023-01-26

* Fix - Modifications to custom tables registration to ensure all sites get the new 6.0 table schema, preventing 404 and other related issues. [TEC-4631]
* Fix - Prevent Yoast SEO 19.2 notice due to integration with The Events Calendar [TEC-4662]
* Feature - Add Event Automator to Add-ons page. [TEC-4660]
* Language - 5 new strings added, 171 updated, 1 fuzzied, and 8 obsoleted.

### [6.0.7.1] 2023-01-19

* Fix - Prevent fatal when using The Events Calendar with Event Tickets due to Common library not being updated.

### [6.0.7] 2023-01-18

* Version - The Events Calendar 6.0.7 is only compatible with Events Calendar PRO 6.0.6 and higher
* Fix - Event repository filters, when passing UTC dates on non-UTC event date fields, when using `Condense Event Series` showing tomorrow's event instead of today's. [ECP-1423]
* Fix - Resolve problem with relative dates on REST endpoint for event creation. Dates would potentially cross timezones that would push to an incorrect day due to using the wrong timezone.
* Fix - Prevent Update page from display on minor updates, only for major updates and feature updates. [TEC-4589]
* Fix - Compatibility with Redis Object Cache plugin that would cause Events not be editable in the Blocks Editor. [TEC-4613]
* Fix - Avoid user locale overriding the site locale during rewrite rules generation. [TEC-3733]
* Fix - Correct logic for tribe_is_view functions to account for default view. [TEC-4586]
* Fix - Avoid the issue of events which have venues assigned not being able to be updated successfully on some browsers. [TEC-4596]
* Fix - Handle the case where rewrite rules map to arrays avoiding fatal errors. [TEC-4567]
* Fix - Prevent primary cause of MySQL `Deadlock` errors in 6.0 event migration and added `Deadlock` error catching in our lock/fetch event queue. [TEC-4548]
* Fix - Avoid running slow query for adjacent events when possible. [TEC-4633]
* Fix - Ensure we did not get an error object back when requesting event category. [TEC-4619]
* Fix - Fix the issue of an invalid property error notice being thrown while visiting the Attendee Registration page as an admin. [TEC-4608]
* Fix - Resolve compatibility issue between Yoast SEO and FacetWP. [TEC-4628]
* Fix - Resolve the issue where `tribe_is_upcoming()` and other conditionals were not working as expected. [TEC-4301]
* Tweak - Convert all uses of (view)->get_slug() to (view)::get_view_slug(). [TEC-4586]
* Tweak - Change some labelling of event settings in the admin. [TEC-4626]
* Tweak - Reorganize a few Event settings in the admin. [TEC-4627]
* Tweak - Add canonical tag to the head of all calendar views to prevent Google and other search engines from indexing URLs with custom URL parameters. [TEC-4538]
* Tweak - Added filters: `tribe_events_views_v2_{$view_slug}_view_html_classes`, `tribe_events_views_v2_view_{$view_slug}_template_vars`, `tribe_events_views_v2_view_{$view_slug}_url`, `tribe_events_views_v2_view_{$view_slug}_prev_url`, `tribe_events_views_v2_view_{$view_slug}_next_url`, `tribe_events_views_v2_view_{$view_slug}_link_label_format`, `tribe_events_views_v2_view_{$view_slug}_title`, `tribe_events_views_v2_view_{$view_slug}_messages`, `tribe_events_views_v2_view_{$view_slug}_breadcrumbs`, `tribe_events_views_v2_view_{$view_slug}_display_events_bar`, `tribe_events_views_v2_view_{$view_slug}_show_datepicker_submit`, `tribe_events_views_v2_view_{$view_slug}_public_views`, `tribe_events_views_v2_{$view_slug}_view_container_data`, `tribe_events_views_v2_{$view_slug}_show_latest_past_events_view`, `tribe_events_views_v2_{$view_slug}_events_per_day`, `tribe_events_views_v2_view_{$view_slug}_breakpoint_pointer`, `tribe_events_views_v2_view_{$view_slug}_breakpoints`, `tribe_events_views_v2_view_{$view_slug}_cached_html`, `tribe_events_views_v2_{$view_slug}_widget_repository_args`, `tribe_events_views_v2_{$view_slug}_widget_compatibility_classes`, `tribe_events_views_v2_{$view_slug}_widget_html_classes`, `tec_events_view_{$view_slug}_today_button_label`, `tec_is_view`, `tec_is_{$view_slug}_view`
* Tweak - Removed filters: `tribe_events_views_v2_{$this->get_slug()}_view_html_classes`, `tribe_events_views_v2_view_{$this->slug}_template_vars`, `tribe_events_views_v2_view_{$this->slug}_url`, `tribe_events_views_v2_view_{$this->slug}_prev_url`, `tribe_events_views_v2_view_{$this->slug}_next_url`, `tribe_events_views_v2_view_{$this->slug}_link_label_format`, `tribe_events_views_v2_view_{$slug}_title`, `tribe_events_views_v2_view_{$slug}_messages`, `tribe_events_views_v2_view_{$this->slug}_breadcrumbs`, `tribe_events_views_v2_view_{$this->slug}_display_events_bar`, `tribe_events_views_v2_view_{$this->slug}_show_datepicker_submit`, `tribe_events_views_v2_view_{$this->slug}_public_views`, `tribe_events_views_v2_{$this->get_slug()}_view_container_data`, `tribe_events_views_v2_{$this->get_slug()}_show_latest_past_events_view`, `tec_events_views_v2_{$this->slug}_view_global_repository_args`, `tribe_events_views_v2_{$this->slug}_events_per_day`, `tribe_events_views_v2_view_{$this->slug}_breakpoint_pointer`, `tribe_events_views_v2_view_{$this->slug}_breakpoints`, `tribe_events_views_v2_view_{$this->slug}_cached_html`, `tribe_events_views_v2_{$this->get_slug()}_widget_repository_args`, `tribe_events_views_v2_{$this->get_slug()}_widget_compatibility_classes`, `tribe_events_views_v2_{$this->get_slug()}_widget_html_classes`, `tec_events_view_{$view_slug}_today_button_title`

### [6.0.6.2] 2022-12-16

* Fix - Fix layout issues with Avada, Divi, and similar themes. [TEC-4623]

### [6.0.6.1] 2022-12-14

* Fix - Avoid fatal error in the `tribe_is_events_front_page` when called before global query object is initialized. [TEC-4622]

### [6.0.6] 2022-12-14

* Fix - Resolved a migration state problem in the view not being handled properly when preview is unsupported and a migration error happens simultaneously. [TEC-4482]
* Fix - Prevent a couple scenarios that would cause 404 pages on events. This addresses both an error from UTC offset validation failures and an issue where table renaming improperly created foreign keys that pointed to an invalid constraint target. [TEC-4578]
* Fix - Avoid query filtering issues where the Event post type would be incorrectly added to queries. [TEC-4588]
* Fix - Incorrect results when including Events in the main blog loop. [TEC-4474]
* Fix - Avoid errors when third-party plugins reference or use the `Tribe__Events__Query::pre_get_posts` method. [TEC-4540]
* Fix - Prevent Serializable interface deprecated error in PHP 8.1 when migrating events. [ECP-1319]
* Fix - Ensure the `Previous Events` button when using the `Event View` Elementor widget navigates correctly to the previous page. [FBAR-273]
* Fix - Ensure that when we hit a single-event ical endpoint we get a the correct single event. [TEC-4469]
* Fix - Avoid PHP fatal error on PHP 8.0+ in some settings' pages when setting the front page to the Main Events Page. [TEC-4614]
* Tweak - Add aria label to Google Maps iFrame embed to improve accessibility. [TEC-4404]
* Tweak - Prevent unbound query for previous URL on list based views, improving performance.
* Tweak - Additional views setup no longer run extra Database Query unnecessarily, improving performance.
* Tweak - Improve performance on the Settings page when dealing with a big dataset of events.
* Tweak - Improve performance on the `tribe_events()` and on the Event Views by removing an unnecessary JOIN for hiding of specific upcoming events.
* Tweak - Changed views: `modules/map-basic`
* Language - 1 new strings added, 17 updated, 0 fuzzied, and 0 obsoleted

### [6.0.5] 2022-11-29

* Fix - Fix for scenarios where fatal `Call to a member function get() on null in... the-events-calendar/src/Tribe/Query.php(46)` would occur when `$wp_query` global was not set. [TEC-4566]
* Fix - Add correct text domains to the Organizer block. [TEC-4466]
* Fix - Fix for stuck migrations when duplicate meta exists. [TEC-4547]
* Tweak - Added ability to filter v2 repository args on all View queries. [ECP-1372]
* Tweak - Reorganize the General and Display settings tab content. [TCMN-149]
* Tweak - New headers for the General and Display settings tabs. [TEC-4573]
* Tweak - Add view upsells for ECP on the settings display tab. [TEC-4572]
* Tweak - Add settings info boxes. [TEC-4574]
* Fix - Avoid issues when trying to import some .ics format files with Event Aggregator. [EA-461]
* Deprecation - `Tribe__Events__Editor__Compatibility::$blocks_editor_hidden_field_key`.
* Deprecation - `Tribe__Events__Main::do_addons_api_settings_tab()`, `Tribe__Events__Main::show_upgrade()`,
                `Tribe__Events__Main::do_upgrade_tab()`, `Tribe__Events__Main::general_settings_tab_fields()`,
                `Tribe__Events__Main::display_settings_tab_fields()`, `Tribe__Events__Main::tribe_settings_url()`.
* Tweak - Added filters: `tec_events_custom_tables_v1_query_modifier_applies_to_query`, `tec_events_display_settings_tab_fields`, `tribe_general_settings_tab_fields`
* Language - 118 new strings added, 287 updated, 10 fuzzied, and 88 obsoleted.

### [6.0.4] 2022-11-15

* Version - The Events Calendar 6.0.4 is only compatible with Events Calendar PRO 6.0.3 and higher
* Feature - Include Yoast WordPress SEO OpenGraph integration. [TEC-4558][TEC-4561]
* Fix - Fix for fatal when adding Featured Venue Events widget on Appearance -> Widgets screen. [ECP-1411]
* Fix - Fix for fatal error on Series page in PHP 7.3. [TEC-4549]
* Fix - Prevent error around Free regular expression for JSON-LD on updated views. Props @jonkastonka @saleck @randon [TEC-4570]
* Fix - Avoid fatal error when using PHP version 8.0 or above and the HyperDB plugin. [ECP-1360]
* Fix - Ensure view labels are translated appropriately. [TEC-4485]
* Fix - Errors and warnings in WP.com installations due to empty query results. [TEC-4543]
* Fix - Translation of Event Occurrences URL when using WPML and the Custom Tables V1 implementation. [ECP-1373]
* Fix - More robust type checking in Builder methods. [ECP-1402]
* Fix - Avoid `orderby` related database error in Custom Tables V1 context. [TEC-4555]
* Fix - Prevent error when updating Venue in sites using object cache. [TEC-4348]
* Fix - Prevent date format error when trying to subscribe to calendar in sites using object cache. [TEC-4459]
* Tweak - Clean up the Event Website block to make it more intuitive for users. [TEC-4352]
* Tweak - Update the venue website field to type URL. [TEC-4349]
* Tweak - Do not add date-based ordering to queries when using `none` or `rand` order. [TEC-4555]
* Tweak - Added filters: `tec_events_integrations_should_load`, `tec_events_integrations_{$type}_should_load`, `tec_events_integrations_{$type}_{$slug}_should_load`, `tec_events_integrations_{$integration_type}_{$integration_slug}_events_schema_is_needed`, `tec_events_integrations_{$integration_type}_{$integration_slug}_json_ld_{$type}_data`, `tec_events_views_v2_view_label`, `tec_events_views_v2_{$slug}_view_label`
* Tweak - Removed filters: `tribe_events_views`, `tribe_events_views_v2_manager_view_label_domain`, `tribe_events_views_v2_manager_{$slug}_view_label_domain`, `tribe_events_views_v2_manager_view_label`, `tribe_events_views_v2_manager_{$slug}_view_label`
* Language - 3 new strings added, 144 updated, 0 fuzzied, and 0 obsoleted.

### [6.0.3.1] 2022-11-03

* Fix - Correct issues where early queries can interfere with View template redirects. [TEC-4554]
* Fix - Serialization and unserialization issues related to caching of post models. [TEC-4379]
* Fix - Prevent default WordPress occurrence query caching because we cache it ourselves. [TEC-4379]
* Tweak - Add the `tribe_get_venue_object_after` and `tribe_get_organizer_object_after` filters. [TEC-4379]

### [6.0.3] 2022-10-31

* Fix - Handle repository query filters correctly in custom tables context; fix a REST API issue. [ET-1567]

### [6.0.2] 2022-10-20

* Feature - Add initial integration with Restrict Content Pro. This hides any events on the calendar views that the user is not allowed to view. [ [TEC-4457]]
* Feature - Support the `strict_dates` REST API argument in the `/events` endpoint to control the inclusiveness of the date parameters. [TEC-4493]
* Feature - Support relative date parameters (e.g: `starts_before`, `ends_after` as REST API arguments in the `/events` endpoint to retrieve single day and multi-day events in a single search. [TEC-4493]
* Fix - Prevent problems with WordPress.com Memcache turning Event Single Pages into 404s after the first visit [TEC-4488]
* Fix - Add new function to properly escape event titles in URLs so they are better handled by rewrite rules. Props to @shisho585 for the fix! [TEC-4518]
* Fix - Avoid resetting post data in some Dive theme and plugins. [TEC-4510]
* Fix - Correct a few misnamed custom prop references. [TEC-4445]
* Fix - Correct an issue with event venue when saving in our WPML integration. Props to @dgwatkins for the fix! [TEC-4498]
* Fix - Correctly deprecate the `Tribe__Events__Main::get_closest_event` method. [ECP-1326]
* Fix - Correctly set `found_posts` and `max_num_pages` when redirecting a query to the custom tables. [TEC-4508]
* Fix - Do not run wasteful queries on `switch_blog` in multi-site installations. [TEC-4492]
* Fix - Do not throw errors during migration when notices or errors come from other plugins. [ECP-1318]
* Fix - Ensure `tribe_is_month` and `tribe_is_by_date` work as expected. [TEC-4509]
* Fix - Ensure we handle if By_Day_View gets a null $event_obj->dates. Props to @juliangumenita for the fix! [TEC-4509]
* Fix - Remove strict type hinting from Custom Tables v1 code that would cause fatals in some environments. [ECP-1343]
* Fix - Resolve problems with tribe_get_full_address() which was not properly returning venue address.
* Fix - Restore erroneously removed Events query filters that would result in out-of-order results. [TEC-4470]
* Fix - Revert the code erroneous removed on legacy views removal around the "Show events with the site's other posts" setting.
* Fix - Prevent a potential fatal when WP-CLI isn't present. [TEC-4470]
* Tweak - Move Month View day cell class logic to a standalone function with filters. [TEC-4457]
* Tweak - Add new method: `\Tribe\Events\Views\V2\month_day_classes` [TEC-4457]
* Tweak - Added filter `tec_events_month_day_classes_comparison_date` to filter the date used for class determination comparisons. [TEC-4457]
* Tweak - Added filter `tec_events_month_day_classes` to filter the actual class list before it gets passed to the template. [TEC-4457]
* Tweak - Update the organizer website field to type URL. [TEC-4395]
* Tweak - Add an event property for if the event is currently happening. [TEC-4454]
* Tweak - Create a filterable function `tec_events_get_today_button_label()` for the text on the "Today" button on calendar views. [TEC-4458]
* Tweak - Add a filter for the link title and aria-label so they match the button text more closely. [TEC-4458]
* Tweak - Added filters: `tec_events_today_button_label` and `tec_events_view_{view_slug}_today_button_label` to filter the output of the `tec_events_get_today_button_label` function
                         `tec_events_today_button_title` and `tec_events_{view_slug}_view_today_button_title` to filter the link title and aria-label. [TEC-4458]
* Tweak - Speed up the Custom Tables v1 migration process if a browser window is open on the migration UI. [TEC-4517]
* Language - 11 new strings added, 149 updated, 2 fuzzied, and 2 obsoleted.

### [6.0.1.1] 2022-09-29

* Fix - Prevent Google Calendar duplicated Events from Importing with Aggregator. [TEC-4497]

### [6.0.1] 2022-09-22

* Fix - Prevent network deactivation from overwriting the subsite settings with main site cached settings. [TEC-3738]
* Fix - Correct some translation domains pointing to the wrong plugin. [TEC-4450]
* Fix - Ensure the details in the single event page are accurate for Divi users who set any Divi template under Settings → Events template. [TEC-3814]
* Fix - Add caching to prevent duplicated queries for translated venue/organizer values. props to @dgwatkins for the suggested fix! [TEC-4428]
* Fix - Check the document for `lang` and `rtl` attributes and pass them on to the datepicker so it adapts properly. [TEC-4452]
* Fix - Corrected an issue where the Organizer Block was showing the "Add Another Organizer" button when no organizers were selected. [CE-11]
* Fix - Corrected an issue where the "Edit Venue" and "Edit Organizer" links were displaying with no link. [CE-165]
* Fix - Correct migration error when The Events Calendar PRO is not active. [TEC-4475]
* Fix - Normalize, reformat and rebuild Event date-related meta to fix a number of migration preview failures [ECP-1304]
* Fix - Correct a problem with moving tickets when The Events Calendar PRO is not active. [TEC-4471]
* Fix - Correct an issue with migrating past events that straddle Daylight Savings Time. [ECP-1270]
* Fix - Fix the Community Events recurrence link. [ECP-1215]
* Tweak - Add some helpful knowledgebase article links to the CSV import screen. [TEC-4353]
* Tweak - Ensure the Fast-forward link uses the correct, customizable color as other links. [TEC-3962]
* Tweak - Include Custom Tables Migration in the Support System Information array. [ECP-1316]
* Tweak - Add compatibility for new "Convert to single" option in The Events Calendar PRO. [ECP-1308]
* Language - 5 new strings added, 163 updated, 0 fuzzied, and 0 obsoleted

### [6.0.0.1] 2022-09-07

* Fix - Prevent `E_ERROR` from showing up when calling `tribe_context()->is( 'is_main_query' )` too early in execution. [TEC-4464]

### [6.0.0] 2022-09-06

* Version - The Events Calendar 6.0.0 is only compatible with Events Calendar PRO 6.0.0 and higher
* Feature - Custom tables and optimization of Cache Primers to enable reduced and stabilized number of queries on Event views.
* Feature - Inclusion of Event Occurrences custom table `{$prefix}_tec_occurrences`.
* Feature - Inclusion of Events custom table `{$prefix}_tec_events`.
* Tweak - Legacy views are now fully deprecated and most of the template files and code was removed, please see other changelog items to see modifications.
* Language - 123 new strings added, 296 updated, 0 fuzzied, and 161 obsoleted
* Tweak - Methods marked as deprecated: `Tribe__Events__Main::add_new_organizer`, `Tribe__Events__Main::default_view`, `Tribe__Events__Main::fullAddress`, `Tribe__Events__Main::fullAddressString`, `Tribe__Events__Main::getDateStringShortened`, `Tribe__Events__Main::getPostTypes`, `Tribe__Events__Main::googleCalendarLink`, `Tribe__Events__Main::googleMapLink`, `Tribe__Events__Main::monthNames`, `Tribe__Events__Main::nextMonth`, `Tribe__Events__Main::previousMonth`, `Tribe__Events__Main::setDisplay`
* Tweak - Functions moved to `src/functions/template-tags/deprecated`: `tribe_events_the_header_attributes`, `tribe_get_next_day_date`, `tribe_get_previous_day_date`
* Tweak - Functions/methods refactored:  `tribe_events_is_view_enabled`, `tribe_is_ajax_view_request`, `tribe_meta_event_category_name`
* Tweak - Functions/Methods Removed:  `tribe_get_list_widget_events`, `Tribe__Events__Main::register_list_widget`, `Tribe__Events__Main::init_day_view`, `Tribe__Events__Main::eventQueryVars`, `Tribe__Events__Main::ecpActive`, `Tribe__Events__Main::dateHelper`, `Tribe__Events__Main::dateToTimeStamp`, `Tribe__Events__Main::defaultValueReplaceEnabled`, `Tribe__Events__Main::addHelpAdminMenuItem`, `Tribe__Events__Main::getNotices`, `Tribe__Events__Main::removeNotice`, `Tribe__Events__Main::isNotice`, `Tribe__Events__Main::setNotice`, `Tribe__Events__Main::renderDebug`, `Tribe__Events__Main::debug`, `Tribe__Events__Main::truncate`, `Tribe__Events__Main::saveAllTabsHidden`, `Tribe__Events__Main::doNetworkSettingTab`, `Tribe__Events__Main::addNetworkOptionsPage`, `Tribe__Events__Main::setNetworkOptions`, `Tribe__Events__Main::getNetworkOption`, `Tribe__Events__Main::getNetworkOptions`, `Tribe__Events__Main::setOption`, `Tribe__Events__Main::setOptions`, `Tribe__Events__Main::getOption`, `Tribe__Events__Main::getOptions`, `Tribe__Events__Main::getTagRewriteSlug`, `Tribe__Events__Main::getTaxRewriteSlug`, `Tribe__Events__Main::doHelpTab`, `Tribe__Events__Main::doSettingTabs`, `Tribe__Events__Main::array_insert_before_key`, `Tribe__Events__Main::array_insert_after_key`, `Tribe__Events__Main::add_post_type_to_edit_term_link`, `Tribe__Events__Main::prepare_to_fix_tagcloud_links`, `Tribe__Events__Main::saved_organizers_dropdown`, `Tribe__Events__Main::saved_venues_dropdown`, `Tribe__Events__Main::set_meta_factory_global`, `Tribe__Events__Main::initOptions`, `Tribe__Events__Main::loadTextDomain`, `Tribe__Events__Main::common`, `Tribe__Events__Main::issue_noindex`, `Tribe__Events__Main::displayEventOrganizerDropdown`, `Tribe__Events__Main::displayEventVenueDropdown`, `Tribe__Events__Main::checkAddOnCompatibility`, `Tribe__Events__Main::maybe_delay_activation_if_outdated_common`, `Tribe__Events__Main::is_delayed_activation`, `Tribe__Events__Main::get_event_link`, `Tribe__Events__Main::get_closest_event`, `Tribe__Events__Main::setPostExceptionThrown`, `Tribe__Events__Main::getPostExceptionThrown`, `Tribe__Events__Main::manage_preview_metapost`, `Tribe__Events__Main::setDashicon`, `Tribe__Events__Main::printLocalizedAdmin`, `Tribe__Events__Main::localizeAdmin`, `Tribe__Events__Main::asset_fixes`, `Tribe__Events__Main::add_admin_assets`, `Tribe__Events__Main::loadStyle`, `Tribe__Events__Main::enqueue_wp_admin_menu_style`, `Tribe__Events__Main::get_closest_event_where`, `Tribe__Events__Main::setup_listview_in_bar`, `Tribe__Events__Main::setup_gridview_in_bar`, `Tribe__Events__Main::setup_dayview_in_bar`, `Tribe__Events__Main::setup_date_search_in_bar`, `Tribe__Events__Main::remove_hidden_views`, `Tribe__Events__Main::setup_keyword_search_in_bar`, `Tribe__Events__Main::OrganizerMetaBox`, `Tribe__Events__Main::VenueMetaBox`, `Tribe__Events__Main::EventsChooserBox`, `Tribe__Events__Main::normalize_organizer_submission`, `Tribe__Events__Main::get_i18n_strings_for_domains`, `Tribe__Events__Main::get_i18n_strings`, `Tribe__Events__Main::redirect_past_upcoming_view_urls`, `Tribe__Events__Main::getOrganizerPostTypeArgs`, `Tribe__Events__Main::getVenuePostTypeArgs`, `Tribe__Events__Main::disable_pro`, `Tribe__Events__Main::template_redirect`, `Tribe__Events__Main::handle_submit_bar_redirect`, `Tribe__Events__Main::print_noindex_meta`, `Tribe__Events__Query::init`, `Tribe__Events__Query::parse_query`, `Tribe__Events__Query::pre_get_posts`, `Tribe__Events__Query::default_page_on_front`, `Tribe__Events__Query::multi_type_posts_fields`, `Tribe__Events__Query::posts_join`, `Tribe__Events__Query::posts_fields`, `Tribe__Events__Query::posts_results`, `Tribe__Events__Query::posts_where`, `Tribe__Events__Query::posts_orderby_venue_organizer`, `Tribe__Events__Query::posts_join_venue_organizer`, `Tribe__Events__Query::posts_distinct`, `Tribe__Events__Query::posts_orderby`, `Tribe__Events__Query::set_orderby`, `Tribe__Events__Query::set_order`, `Tribe__Events__Query::getHideFromUpcomingEvents`, `Tribe__Events__Query::getEventCounts`, `Tribe__Events__Query::last_found_events`, `Tribe__Events__Query::postmeta_table`, `Tribe__Events__Query::can_inject_date_field`, `Tribe__Events__Query::should_remove_date_filters`, `Tribe\Events\Views\V2\Widgets\Service_Provider::unregister_list_widget`, `tribe_include_view_list`, `tribe_events_month_has_events_filtered`, `tribe_events_the_month_single_event_classes`, `tribe_events_the_month_day_classes`, `tribe_events_get_current_month_day`, `tribe_events_get_current_week`, `tribe_events_the_month_day`, `tribe_events_have_month_days`, `tribe_show_month`, `tribe_get_dropdown_link_prefix`, `tribe_events_get_filters`, `tribe_events_get_views`, `Tribe__Events__Template__Single_Event::setup_meta`, `Tribe__Events__Template_Factory::asset_package`, `Tribe__Events__Template_Factory::get_asset_factory_instance`, `Tribe__Events__Template_Factory::handle_asset_package_request`, `Tribe__Events__Template_Factory::setup_meta`, `tribe_initialize_view`, `Tribe__Events__Templates::init`, `Tribe__Events__Templates::instantiate_template_class`, `Tribe__Events__Templates::load_ecp_comments_page_template`, `Tribe__Events__Templates::load_ecp_into_page_template`, `Tribe__Events__Templates::maybe_modify_global_post_title`, `Tribe__Events__Templates::maybeSpoofQuery`, `Tribe__Events__Templates::modify_global_post_title`, `Tribe__Events__Templates::restore_global_post_title`, `Tribe__Events__Templates::setup_ecp_template`, `Tribe__Events__Templates::showInLoops`, `Tribe__Events__Templates::spoof_the_post`, `Tribe__Events__Templates::templateChooser`, `Tribe__Events__Templates::theme_body_class`, `Tribe__Events__Templates::add_singular_body_class`, `Tribe__Events__Templates::get_current_page_template`, `Tribe__Events__Templates::needs_compatibility_fix`, `Tribe__Events__Templates::remove_singular_body_class`, `Tribe__Events__Templates::restoreQuery`, `Tribe__Events__Templates::spoof_the_post`, `Tribe__Events__Templates::template_body_class`, `Tribe__Events__Templates::wpHeadFinished`, `event_grid_view`, `get_event_google_map_link`, `event_google_map_link`, `tec_get_event_address`, `tec_event_address`, `tec_address_exists`, `get_event_google_map_embed`, `event_google_map_embed`, `get_jump_to_date_calendar`, `the_event_start_date`, `the_event_end_date`, `the_event_cost`, `the_event_venue`, `the_event_country`, `the_event_address`, `the_event_city`, `the_event_state`, `the_event_province`, `the_event_zip`, `the_event_phone`, `the_event_region`, `the_event_all_day`, `is_new_event_day`, `get_events`, `tribe_event_link`, `events_displaying_past`, `events_displaying_upcoming`, `events_displaying_month`, `events_get_past_link`, `events_get_upcoming_link`, `events_get_next_month_link`, `events_get_previous_month_link`, `events_get_events_link`, `events_get_gridview_link`, `events_get_listview_link`, `events_get_listview_past_link`, `events_get_previous_month_text`, `events_get_current_month_text`, `events_get_next_month_text`, `events_get_displayed_month`, `events_get_this_month_link`, `sp_get_option`, `sp_calendar_grid`, `sp_calendar_mini_grid`, `sp_sort_by_month`, `sp_is_event`, `sp_get_map_link`, `sp_the_map_link`, `sp_get_full_address`, `sp_the_full_address`, `sp_address_exists`, `sp_get_embedded_map`, `sp_the_embedded_map`, `sp_month_year_dropdowns`, `sp_get_start_date`, `sp_get_end_date`, `sp_get_cost`, `sp_has_organizer`, `sp_get_organizer`, `sp_get_organizer_email`, `sp_get_organizer_website`, `sp_get_organizer_link`, `sp_get_organizer_phone`, `sp_has_venue`, `sp_get_venue`, `sp_get_country`, `sp_get_address`, `sp_get_city`, `sp_get_stateprovince`, `sp_get_state`, `sp_get_province`, `sp_get_zip`, `sp_get_phone`, `sp_previous_event_link`, `sp_next_event_link`, `sp_post_id_helper`, `sp_is_new_event_day`, `sp_get_events`, `sp_is_past`, `sp_is_upcoming`, `sp_is_month`, `sp_get_past_link`, `sp_get_upcoming_link`, `sp_get_next_month_link`, `sp_get_previous_month_link`, `sp_get_month_view_date`, `sp_get_single_ical_link`, `sp_get_events_link`, `sp_get_gridview_link`, `sp_get_listview_link`, `sp_get_listview_past_link`, `sp_get_dropdown_link_prefix`, `sp_get_ical_link`, `sp_get_previous_month_text`, `sp_get_current_month_text`, `sp_get_next_month_text`, `sp_get_displayed_month`, `sp_get_this_month_link`, `sp_get_region`, `sp_get_all_day`, `sp_is_multiday`, `sp_events_title`, `sp_meta_event_cats`, `sp_meta_event_category_name`, `sp_get_add_to_gcal_link`, `eventsGetOptionValue`, `events_by_month`, `is_event`, `getEventMeta`, `tribe_events_event_recurring_info_tooltip`, `tribe_the_map_link`, `tribe_the_embedded_map`, `tribe_the_full_address`, `tribe_get_organizer_website`, `tribe_get_venue_permalink`, `tribe_previous_event_link`, `tribe_next_event_link`, `display_day_title`, `display_day`, `tribe_meta_event_cats`, `tribe_get_all_day`, `tribe_is_multiday`, `tribe_calendar_grid`, `tribe_calendar_mini_grid`, `tribe_sort_by_month`, `tribe_month_year_dropdowns`, `tribe_get_this_month_link`, `tribe_get_displayed_month`, `tribe_get_display_day_title`, `tribe_the_display_day`, `tribe_get_display_day`, `tribe_get_object_property_from_array`, `tribe_mini_display_day`, `tribe_event_format_date`, `tribe_event_beginning_of_day`, `tribe_event_end_of_day`, `tribe_events_the_notices`, `tribe_get_the_day_link_date`, `tribe_get_the_day_link_label`, `tribe_the_day_link`, `tribe_get_linked_day`, `tribe_events_disabled_views`, `tribe_events_enabled_views`, `tribe_events_template_data`, `tribe_get_ticket_form`, `tribe_map_cost_array_callback`, `tribe_events_get_days_of_week`, `tribe_is_community_my_events_page`, `tribe_display_current_events_slug`, `tribe_display_current_single_event_slug`, `tribe_display_current_ical_link`, `tribe_is_new_event_day`
* Tweak - Added filters: `tec_events_custom_tables_v1_upgrade_before`, `tec_events_custom_tables_v1_upgrade_after`, `tec_events_custom_tables_v1_should_render_maintenance_modal`, `tec_events_custom_tables_v1_migration_ajax_ui_renderer`, `tec_events_custom_tables_v1_migration_strategy`, `tec_events_custom_tables_v1_delete_meta_keys`, `tec_events_custom_tables_v1_migration_strategy_text_override_$action`, `tec_events_custom_tables_v1_migration_event_report_categories`, `tec_events_custom_tables_v1_migration_get_plugin_state_migration_addendum`, `tec_events_custom_tables_v1_event_data_from_post`, `tec_custom_tables_{$this->table}_model_v1_extensions`, `tec_events_custom_tables_v1_normalize_occurrence_id`, `tec_events_custom_tables_v1_occurrences_generator`, `tec_custom_tables_v1_get_occurrence_match`, `tec_events_custom_tables_v1_enabled`, `tec_events_custom_tables_v1_table_schemas`, `tec_events_custom_tables_v1_field_schemas`, `tec_events_custom_tables_v1_tables_to_drop`, `tec_events_custom_tables_v1_fields_to_drop`, `tec_events_custom_tables_v1_db_transactions_supported`, `tec_events_custom_tables_v1_should_update_custom_tables`, `tec_events_custom_tables_v1_commit_post_updates`, `tec_events_custom_tables_v1_updated_post`, `tec_events_custom_tables_v1_deleted_post`, `tec_events_custom_tables_v1_redirect_post_location`, `tribe_events_known_range_stati`, `tec_events_custom_tables_v1_request_factory_post_id_keys`, `tec_events_custom_tables_v1_custom_tables_query_vars`, `tec_events_custom_tables_v1_occurrence_select_fields`, `tec_events_custom_tables_v1_custom_tables_query_where`, `tec_events_custom_tables_v1_meta_key_redirection_map`, `tec_events_custom_tables_v1_show_series_title`, `tec_events_custom_tables_v1_series_marker_label_classes`, `tribe_events_assets_should_enqueue_admin_update_page_assets`, `tec_events_custom_tables_v1_blocks_editor_event_meta`, `tribe_events_linked_posts_should_render_meta_box`, `tec_events_upgrade_tab_has_content`, `tec_events_prime_cache_post_ids`, `tec_events_get_current_view`, `tribe_get_venue_website_link_target`, `tribe_get_venue_website_link_label`, `tribe_events_settings_default_fields_initializer`
* Tweak - Removed filters: `aggregator_should_load_scripts`, `tribe-events-bar-should-show`, `widget_title`, `tribe_events_`, `tribe_events_widget_jsonld_enabled`, `tec_events_default_view`, `tribe_events_get_{$mode}_event_link`, `tribe_events_get_closest_event`, `tribe_events_get_event_link`, `tribe-events-bar-date-search-default-value`, `tribe_events_bar_date_search_default_value`, `tribe_bar_datepicker_caption`, `tribe_tec_addons`, `tribe_add_on_compatibility_errors`, `tribe_display_event_venue_dropdown_id`, `tribe_display_event_organizer_dropdown_id`, `tribe_events_category_rewrite_slug`, `tribe_events_tag_rewrite_slug`, `the_content`, `tribe_events_suppress_query_filters`, `tribe_query_can_inject_date_field`, `tec_events_query_default_view`, `tribe_events_query_include_start_date_meta`, `tribe_events_query_include_children`, `tribe_events_query_posts_fields`, `tribe_events_query_force_local_tz`, `tribe_events_query_posts_joins`, `tribe_events_query_end_date_column`, `tribe_events_query_posts_orderby`, `tribe_events_query_posts_join_orderby`, `tribe_events_query_posts_join_venue_organizer`, `tribe_events_hide_from_upcoming_ids`, `tribe_events_month_day_limit`, `tribe_enable_recurring_event_queries`, `tribe_events_day_view_title`, `tribe_events_day_timeslot_format`, `tribe_events_ajax_response`, `tribe_upcoming_events_title`, `tribe_past_events_title`, `tribe_events_listview_ajax_get_event_args`, `tribe_events_listview_ajax_event_display`, `tribe_events_month_view_transient_expiration`, `tribe_month_grid_view_title`, `tribe_events_this_month_title`, `tribe_events_month_get_events_in_month`, `tribe_events_month_daily_events`, `tribe_events_month_daily_events_query_args`, `tribe_themes_compatibility_fixes`, `tribe_set_global_post_title`, `tribe_events_current_template_class`, `tribe_event_meta_event_date`, `tribe_event_meta_event_category`, `tribe_event_meta_event_tag`, `tribe_event_meta_event_website`, `tribe_events_display_event_origin`, `tribe_event_meta_event_origin`, `tribe_event_meta_organizer_name`, `tribe_event_meta_organizer_email`, `tribe_event_meta_venue_name`, `tribe_event_meta_venue_address_gmap`, `tribe_event_meta_venue_address`, `tribe_event_meta_venue_map`, `tribe_events_kill_responsive`, `tribe_events_stylesheet_url`, `tribe_importer_url`, `tribe_events_hide_legacy_imports`, `tribe_events_import_type_titles_map`, `tribe_events_import_options_rows`, `tribe_events_import_options_default_selected`, `tribe-import-tabs`, `tribe_import_tabs`, `tribe_events_csv_batch_size`, `tribe-import-available-options`, `tribe_import_available_options`, `tribe-import-setting-`, `tribe_import_setting_`, `tribe_import_default_post_status_non_saved`, `tribe_import_default_post_status`, `tribe_import_possible_stati`, `tribe_import_default_encode_status_non_saved`, `tribe_import_default_encode_status`, `tribe_import_encoding_status`, `tribe_meta_factory_check_exists`, `tribe_meta_factory_get_args`, `tribe_meta_factory_template`, `tribe_get_linked_day`, `tribe_the_day_link`, `tribe_event_link`, `tribe_get_organizer_website`, `tribe_previous_event_link`, `tribe_next_event_link`, `tribe_meta_event_cats`, `tribe_get_all_day`, `tribe_is_multiday`, `tribe_get_ticket_form`, `tribe-events-bar-filters`, `tribe_is_new_event_day`, `tribe_events_get_current_month_day`, `tribe_events_the_month_day_class`, `tribe_events_the_month_single_event_classes`, `tribe_events_month_has_events_filtered`, `tribe_get_dropdown_link_prefix`, `tribe_get_list_widget_events`, `tribe_events_views_v2_is_enabled`, `tribe_events_views_v2_should_smart_activate`, `tribe_events_views_v2_use_period_repository`, `tribe_events_widgets_v2_is_enabled`, `tribe_events_single_view_v2_is_enabled`, `tec_events_views_v1_should_display_deprecated_notice`, `tribe_events_day_view_event_type`, `tribe_default_events_template_classes`, `tribe_events_list_view_event_type`, `tribe_events_list_widget_thumbnail_size`, `tribe_events_list_widget_featured_image_link`
* Tweak - Added actions: `tec_events_custom_tables_v1_error`, `tribe_log`, `tec_events_custom_tables_v1_migration_maintenance_mode`, `tec_events_custom_tables_v1_before_migration_applied`, `tec_events_custom_tables_v1_migration_before_cancel`, `tec_events_custom_tables_v1_migration_after_cancel`, `tec_events_custom_tables_v1_migration_completed`, `tec_events_custom_tables_v1_after_insert_occurrences`, `tec_events_custom_tables_v1_after_save_occurrences`, `tec_events_custom_tables_v1_after_update_occurrences`, `tec_events_custom_tables_v1_pre_drop_tables`, `tec_events_custom_tables_v1_post_drop_tables`, `tec_events_custom_tables_v1_pre_drop_fields`, `tec_events_custom_tables_v1_post_drop_fields`, `tec_events_custom_tables_v1_request_after_insert_event`, `tec_events_custom_tables_v1_request_after_update_event`, `tec_events_custom_tables_v1_update_post_before`, `tec_events_custom_tables_v1_update_post_after`, `tec_events_custom_tables_v1_delete_post`, `tec_events_custom_tables_v1_after_insert_event`, `tec_events_custom_tables_v1_after_update_event`, `tec_events_custom_tables_v1_redirect_classic_editor_event_post`, `tec_events_custom_tables_v1_redirect_rest_event_post`, `tec_events_custom_tables_v1_custom_tables_query_pre_get_posts`, `tec_events_custom_tables_v1_custom_tables_query_results`, `tec_events_custom_tables_v1_{$modifier_class}_done`, `tec_events_views_v2_after_get_events`, `tribe_events_single_meta_details_section_after_datetime`
* Tweak - Removed actions: `tribe-events-bar-enqueue-scripts`, `tribe_events_widget_render`, `tribe_events_before_list_widget`, `tribe_events_list_widget_before_the_title`, `tribe_events_list_widget_after_the_title`, `tribe_events_after_list_widget`, `tribe_events_pre_get_posts`, `tribe_events_set_month_view_events_from_cache`, `tribe_events_calendar_loop_end`, `tribe_tec_template_chooser`, `tribe_events_filter_the_page_title`, `tribe-import-render-tab-`, `tribe_import_render_tab_`, `tribe_events_csv_import_complete`, `tribe_import_options_updated`, `tribe_meta_factory_register`, `tribe_pre_initialize_view`, `tribe_events_before_event_template_data_date_display`, `tribe_events_after_event_template_data_date_display`, `tribe_events_before_show_month`, `tribe_events_after_show_month`, `tribe_events_before_template`, `tribe_events_after_template`, `tribe_events_before_header`, `tribe_events_before_header_nav`, `tribe_events_after_header_nav`, `tribe_events_after_header`, `tribe_events_before_loop`, `tribe_events_after_loop`, `tribe_events_before_footer`, `tribe_events_before_footer_nav`, `tribe_events_after_footer_nav`, `tribe_events_after_footer`, `tribe_events_inside_before_loop`, `tribe_events_inside_after_loop`, `tribe_events_before_the_event_title`, `tribe_events_after_the_event_title`, `tribe_events_before_the_meta`, `tribe_events_inside_cost`, `tribe_events_after_the_meta`, `tribe_events_before_the_content`, `tribe_events_after_the_content`, `tribe_events_before_the_title`, `tribe_events_after_the_title`, `tribe_default_events_template_after_header`, `tribe_default_events_template_before_footer`, `tribe_events_list_before_the_content`, `tribe_events_bar_before_template`, `tribe_events_bar_after_template`, `tribe_events_before_the_grid`, `tribe_events_after_the_grid`, `tribe_events_before_nav`, `tribe_events_after_nav`, `tribe_events_list_widget_before_the_event_image`, `tribe_events_list_widget_after_the_event_image`, `tribe_events_list_widget_before_the_event_title`, `tribe_events_list_widget_after_the_event_title`, `tribe_events_list_widget_before_the_meta`, `tribe_events_list_widget_after_the_meta`
* Tweak - Changed views: `blocks/event-links`, `blocks/event-website`, `blocks/parts/details`, `day`, `day/content`, `day/loop`, `day/nav`, `day/single-event`, `day/single-featured`, `day/title-bar`, `default-template`, `list`, `list/content`, `list/loop`, `list/nav`, `list/single-event`, `list/single-featured`, `list/title-bar`, `modules/address`, `modules/bar`, `modules/meta/details`, `month`, `month/content`, `month/loop-grid`, `month/mobile`, `month/nav`, `month/single-day`, `month/single-event`, `month/title-bar`, `month/tooltip`, `v2/month/calendar-body/day`, `v2/month/calendar-body/day/calendar-events/calendar-event/title`, `v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/title`, `v2/month/mobile-events/mobile-day/mobile-event/title`, `widgets/calendar-widget`, `widgets/list-widget`

### [5.16.4] 2022-08-09

* Fix - Ensure date formats are escaped properly when they contain slashes. [ECP-1136]
* Tweak - Update the calendar print design. [TEC-4425]
* Tweak - Add support for `ticketed` parameter for Event archive REST API calls. [TEC-4439]
* Tweak - Add new methods `filter_url_date_conflicts` and `filter_date_escaping` to filter and properly escape the date formats for some views. [ECP-1136]
* Language - 0 new strings added, 403 updated, 0 fuzzied, and 124 obsoleted.

### [5.16.3.1] 2022-07-21

* Fix - Update Freemius to avoid PHP 8 fatals. [TEC-4330]

### [5.16.3] 2022-07-20

* Fix - Add a theme based CSS class to the HTML body tag when the `Default Page Template` setting is enabled under Events > Settings > Display. [TEC-4391]
* Fix - Avoid some conflicts between the import notice and third-party plugins using jQuery datepicker in the admin. [TEC-4429]
* Tweak - Add edit links to single venue and organizer pages to improve user experience. [ECP-1181]
* Tweak - Add a CSS class i.e. `tribe-events-calendar-month__day--other-month` to past and future month dates in the month view to allow easy targeting similar to what we had in v1. [TEC-4034]
* Tweak - Changed views: `v2/month/calendar-body/day`

### [5.16.2.1] 2022-07-08

* Fix - Don't load Aggregator scripts on post edit pages to prevent datepicker conflicts [TEC-4427]
* Tweak - Added filter: `aggregator_should_load_scripts`

### [5.16.2] 2022-07-06

* Fix - Ensure the `Next` arrow in `List` and `Summary` views navigates to the correct page when the `Main Events Page` is set as the homepage. [TEC-4247]
* Fix - Ensure the `Next` button when using the `Event View` Elementor widget navigates to the next page on the first click. [FBAR-263]
* Fix - Add a height to the subscribe to calendar export SVG icon on the single events page when using the `Skeleton Styles` to prevent it from taking over a huge portion of the page. [TEC-4399]
* Fix - Remove link to Updates page from TEC Settings page. [TEC-4373]
* Fix - Ensure Aggregator CSV imports continue to run when on an admin page. [TEC-4070]
* Fix - Correct hardcoded admin urls used for Event Settings page(s). [ECP-1175]
* Fix - Ensure event widgets don't carry the global search param into their queries. [TEC-4048]
* Fix - Allow sub-site admins to use the updated calendar designs when their plugin access is restricted. [TEC-4382]
* Fix - Remove deprecated usage of `jQuery.attr( 'checked' )`
* Tweak - Add a unique CSS class i.e. `tribe-events-calendar-month__day--past-month` to past month dates in the month view to allow easy targeting. [TEC-3447]
* Tweak - Add a unique CSS class i.e. `tribe-events-calendar-month__day--next-month` to future month dates in the month view to allow easy targeting. [TEC-3819]
* Tweak - Changed views: `v2/month/calendar-body/day`
* Language - 1 new strings added, 113 updated, 0 fuzzied, and 3 obsoleted

### [5.16.1.1] 2022-06-15

* Fix - correct issues with template paths when using FSE. [TEC-4401]

### [5.16.1] 2022-06-09

* Fix - Add rel="noindex" to links that point to empty Month and Day Views so as to not dilute SEO with empty results. [TEC-4354]
* Fix - Clean up some borked CSS in some sections of the Elementor `Event` widget. [ECP-1105]
* Fix - Fix admin links to work with the new admin page structure. [TEC-4380]
* Tweak - Removed filters: `tribe_settings_admin_slug`, `tribe_settings_url`, `tribe_events_enable_month_view_cache`
* Tweak - Changed views: `blocks/event-links`, `blocks/parts/subscribe-list`, `blocks/parts/subscribe-single`,
                         `v2/components/subscribe-links/item`, `v2/components/subscribe-links/single`, `v2/day/nav/next`,
                         `v2/day/nav/prev`, `v2/day/top-bar/nav/next`, `v2/day/top-bar/nav/prev`, `v2/month/mobile-events/nav/next`,
                         `v2/month/mobile-events/nav/prev`, `v2/month/top-bar/nav/next`, `v2/month/top-bar/nav/prev`

### [5.16.0] 2022-05-31

* Feature - Add subscribe links for Outlook 365 and Outlook Live to the event views. [TEC-4168]
* Feature - Add export links for Outlook 365 and Outlook Live to single events. [TEC-4168]
* Feature - Update single event export to use a dropdown template to support more links. [TEC-4176]
* Feature - Add Outlook ics as an option for Subscribe to Calendar that removes the X-WR-CALNAME from the file. Props to Andy Fragen @afragen [TEC-4188]
* Fix - Prevent Redis Cache Pro fatals around date utilization and calculations on Views [TEC-4351]
* Fix - Ensure all expected subscribe links show when using the default page template. [TEC-4313]
* Fix - Put back the event website label for Classic editor. [TEC-4334]
* Fix - Ensure that subscription links include events up to the limit, no matter the view settings. [TEC-4264]
* Fix - On Event tag archives only show events with the tag, change the single event tag links to use the event tag archive, and add a link to event tag archive in the admin tag list. [TEC-4314]
* Fix - Default event category in Global Import Settings to apply on new imports in Event Aggregator. [EA-426]
* Fix - Add rel noindex and nofollow to the legacy iCal export button. [TEC-4354]
* Language - 6 new strings added, 53 updated, 0 fuzzied, and 0 obsoleted

### [5.15.0.1] 2022-05-23

* Fix - Prevent fatal when using Yoast due to missing function `tribe_is_month()` [TEC-4376]
* Fix - Check if function exists for `get_current_screen` to avoid a fatal if not.

### [5.15.0] 2022-05-19

* Version - The Events Calendar 5.15.0 is only compatible with Event Tickets 5.4.0 and higher
* Version - The Events Calendar 5.15.0 is only compatible with Events Calendar PRO 5.14.0 and higher
* Version - The Events Calendar 5.15.0 is only compatible with Events Filterbar    5.3.0 and higher
* Version - The Events Calendar 5.15.0 is only compatible with Events Virtual 1.10.0 and higher
* Version - The Events Calendar 5.15.0 is only compatible with Events Community 4.9.0 and higher
* Version - The Events Calendar 5.15.0 is only compatible with Eventbrite Tickets 4.6.11 and higher
* Feature - Update Events menu to work with the new admin pages structure. [ET-1335]
* Language - 1 new strings added, 395 updated, 2 fuzzied, and 3 obsoleted

### [5.14.2.1] 2022-04-28

* Fix - Correct an issue with linked common release.

### [5.14.2] 2022-04-28

* Feature - Add support to CSV import for the ISO Currency Code field. [TEC-4341]
* Feature - First iteration of changes for Full Site Editor compatibility. [TEC-4262]
* Tweak - Added filters `tribe_merge_identical_organizers_enabled`, `tribe_merge_identical_venues_enabled`, `tribe_merge_identical_organizers_fields`, `tribe_merge_identical_venues_fields`, `tribe_amalgamate_venues_keep_venue`, `tribe_amalgamate_organizers_keep_organizer` for better control of the merge duplicate venues and organizers functionality. [TEC-4225]
* Tweak - Added filter `tribe_events_views_v2_ff_link_next_event` to allow better control of the fast-forward link target. [ECP-957]
* Tweak - Allow filtering of the "next event" query in the fast-forward link. [ECP-957]
* Tweak - Added filters: `tribe_merge_identical_organizers_enabled`, `tribe_merge_identical_venues_enabled`, `tribe_merge_identical_organizers_fields`, `tribe_merge_identical_venues_fields`, `tribe_amalgamate_venues_keep_venue`, `tribe_amalgamate_organizers_keep_organizer`, `tribe_events_views_v2_ff_link_next_event`.
* Tweak - Changed views: `blocks/archive-events`.
* Fix - Correctly calculate Event duration when the Event crosses the daylight saving date and time. [TEC-4336]
* Fix - Don't try to validate "raw" as a date. [TEC-4254]
* Fix - Ensure the Views don't try to do math with strings. [TEC-4322]
* Fix - Enable more than 5 csv entries to be imported when using 8.0.15 to 8.0.17 or 8.1.2 to 8.1.4. [TEC-4312]
* Fix - Ensure Google Calendar links include the event description if it exists. [TEC-4315]
* Language - 3 new strings added, 232 updated, 0 fuzzied, and 0 obsoleted.

### [5.14.1] 2022-03-17

* Tweak - Update the backend block editor UI for a single event to look similar to its frontend version in order to create a true WYSIWYG experience when using the block editor. [TEC-4250]
* Tweak - Added filters: `tribe_events_views_v2_month_ics_start_today`
* Fix - Correct a regex typo that was breaking proper JSON-LD data around event cost. [TEC-4263]
* Fix - Correct Month View ics export so it begins on the current day rather than the 1st. [TEC-4223]
* Fix - Add ISO Currency Code field to admin to set code sent via JSON-LD. TEC was incorrectly sending symbol. [TEC-4212]
* Fix - Ensure that the full styles custom properties require the skeleton style custom properties. [TEC-4308]
* Fix - Ensure that the State/Province field saves for non-US venues. [TEC-4309]
* Fix - Correct duplicated text in wpadminbar Events Menu. [TEC-4310]
* Fix - Load the assets required by the `Event View` Elementor widget in preview mode. [ECP-1065]
* Language - 4 new strings added, 144 updated, 0 fuzzied, and 0 obsoleted.

### [5.14.0.4] 2022-03-01

* Tweak - Update version of Freemius to 2.4.3.

### [5.14.0.3] 2022-02-25

* Fix - Ensure the Venue and Organizer metaboxes load when creating a new post of that type. [TEC-4303]

### [5.14.0.2] 2022-02-22

* Fix - Correct conditional in Filter Bar upsell banner. [TEC-4284]
* Fix - Un-deprecate `tribe_initialize_view()` as it is used in some new views.

### [5.14.0.1] 2022-02-15

* Fix - Prevent parse error due to trailing comma on a method call, PHP 7.1 compatibility required. Props @kzeni

### [5.14.0] 2022-02-15

* Feature - Add a Filter Bar upsell banner to the Filters tab that displays when the Filter Bar plugin isn't active. [TEC-4238]
* Tweak - Correct documentation around the subscribe link filters. Add link slug as array keys for `tec_views_v2_single_subscribe_links` filter. [TEC-4215]
* Tweak - Move and deprecate some methods specific to the Google Calendar link from Main to the new Google_Calendar class. [TEC-4235]
* Tweak - Prevent scripts from loading on all Admin pages, only load on pages needed.
* Tweak - Performance improvements around Block Asset loading and redundancy.
* Tweak - Internal caching of values to reduce `get_option()` call count.
* Tweak - Switch from `sanitize_title_with_dashes` to `sanitize_key` in a couple instances for performance gains.
* Tweak - Remove the `wp.editor.InnerBlocks` Gutenberg component in favor of `wp.blockEditor.InnerBlocks` which was deprecated since version 5.3. [TEC-4178]
* Tweak - Prevent asset loading from repeating calls to plugin URL and path, resulting in some minor performance gains.
* Fix - Update the way we handle Classic Editor compatibility. Specifically around user choice. [TEC-4016]
* Fix - Remove incorrect reference for moment.min.js.map [TEC-4148]
* Fix - Fixed troubleshooting page styles for standalone Event Tickets setup [ET-1382]
* Fix - Remove singleton created from a deprecated class.
* Fix - Ensure that the tec_views_v2_use_subscribe_links filter applies to the single event view. [TEC-4219]
* Fix - Hide the "Export to .ics file" link by default, allow showing it via a filter. Also ensure the link is correct. [TEC-4214]
* Fix - Serve a single event import url for Google Calendar on the single event view. [TEC-4235]
* Fix - Improve theme CSS compatibility on View container by making sure our views take 100% of the width available (props @askwpgirl) [TEC-4257]
* Language - 9 new strings added, 277 updated, 1 fuzzied, and 1 obsoleted

### [5.13.0] 2022-01-31

* Deprecation - All files from Legacy Views will throw deprecated notices, refer to `https://evnt.is/v1-removal` for extra information.
* Deprecation - Template functions `tribe_initialize_view`, `tribe_get_view` and `tribe_show_month` were deprecated, refer to `https://evnt.is/v1-removal` for extra information.

### [5.12.4] 2022-01-19

* Tweak - Minor CSS tweaks to align with the new shortcode based blocks in ECP. [ECP-1016]
* Tweak - Add hook to CSV importer to enable add-on plugins to support their fields during import. [VE-387]
* Tweak - Included new filter `tec_system_information` allowing better control over the Troubleshooting Help page.
* Tweak - Included a Views V2 Status on the Troubleshooting page system info section to help with clarity for support.
* Tweak - Add notice for Themes using Full Site Editor incompatibility with Widgets. [TEC-4233]
* Fix - Prevent Onboarding assets from loading on the admin when not needed.
* Fix - Remove CSS attributes targeting `aria-labels` to prevent inconsistent styling for different languages. [TEC-4227]
* Fix - Resolve sorting problems when using orderby with the Event repository when no other orderby values are specified. [TEC-4232]
* Fix - Prevent unwanted notice on single-event and embed views from legacy views deprecation

### [5.12.3] 2022-01-10

* Version - The Events Calendar 5.12.3 is only compatible with Events Calendar PRO 5.11.2 and higher
* Fix - Ensure the modifications made through the `tribe_events_views_v2_category_title` are respected. [TEC-4110]
* Fix - Correct issue where mobile default view does not load correctly when homepage set to Events Main. [TEC-3826]
* Tweak - Boost SEO for category archive pages by fixing the title tag. [TEC-4110]
* Tweak - Add filter to allow users to choose if the taxonomy should show parent categories [TEC-4110]
* Tweak - Move handling of mobile view to ECP. Add filter to allow overriding default view. [TEC-3826]
* Language - 0 new strings added, 71 updated, 0 fuzzied, and 0 obsoleted

### [5.12.2] 2021-12-20

* Fix - Remove trailing comma that can cause fatals on older versions of PHP. [FBAR-252]
* Fix - Prevent infinite loops in the block editor when including the links block. [TEC-4190]
* Fix - Initial steps to make The Events Calendar compatible with PHP 8.1

### [5.12.1] 2021-12-14

* Feature - Add TEC widget based blocks to the `Event Blocks` custom block category. [TEC-4151]
* Feature - Add Event Status filter options when Filter Bar is active. [FBAR-92]
* Fix - Add a valid rel value to the link tag for TEC REST API support in order to improve HTML 5 and WCAG 2.1 compliance. (props to @gabyrau for the fix!) [TEC-4129]
* Fix - Ensure the date selected when creating a new event from the Event Manager is applied to the block editor. [ECP-954]
* Fix - Properly observe the disabling of JSON-LD output on widget blocks in the block editor. [TEC-4077]
* Fix - Prevent PHP warning in some cases when fetching the date from `tribe_get_display_end_date()`. (props to @huubl for the fix!) [TEC-4161]
* Fix - Close a div in the new subscribe dropdown that was left open. Props to @whoisuncle for bringing this to our attention! [TEC-4166]
* Tweak - Ensure the `Disable the Event Search Bar` setting doesn't get applied on the Event Manager page. [ECP-948]
* Tweak - Ensure the `related events title` and `event titles` within the single event page for the block editor make use the customizer font settings. [TEC-4125]
* Tweak - Update the description text for the "Merge Duplicates" action. Add filters for data sets usd for comparison. [TEC-3018]
* Tweak - Adjust the Subscribe to Calendar dropdown styling to better accommodate themes with sidebars. [TEC-4166]
* Tweak - Add the Event List and Mini-Calendar widgets to the Event Blocks category. [TEC-4151]
* Tweak - Correct some incorrect template paths in docblocks. [TEC-4111]
* Language - 4 new strings added, 159 updated, 0 fuzzied, and 1 obsoleted

### [5.12.0] 2021-12-02

* Feature - Add new subscribe options to the "Export Events" link at the bottom of calendar views and single Event view [TEC-4131]
* Fix - Bypass caching of the event when dealing with the admin event list table. [TEC-4156]
* Fix - Event List Widget will not print the H3 tag related to the title when that is empty. [TEC-4160]
* Tweak - Allow bypassing of the Aggregator logging function by using the `tec_aggregator_records_should_log_error` filter. [TEC-4159]
* Tweak - Removed the `tribe_events_force_filtered_ical_link` filter and the associated js function that recreates the subscribe link on v1 and Single Event views. [TEC-4131]
* Language - 4 new strings added, 52 updated, 0 fuzzied, and 2 obsoleted

### [5.11.0] 2021-11-17

* Feature - Add an `Events List` block that is based on the `Events List` widget to the block editor which users can drag around to any position they want it to appear. [ECP-989]
* Feature - Add event status options of scheduled, canceled, and postponed with the ability to add and display a reason for the latter two. [TEC-3465]
* Feature - Add live preview to the TEC customizer screens. [TEC-4055]
* Fix - When accessing comments there could be situations where an undefined array key was accessed, and in PHP 8 it is a promoted Warning error for undefined array access. [TEC-4093]
* Fix - Resolved `Warning: reset(): Argument #1 ($array) must be passed by reference...` error that was displayed on the Events, Organizers and Venue REST endpoints in PHP v8. [TEC-4097]
* Fix - Ensure that the proper spacing is applied for the venue address in list view. [TEC-4089]
* Tweak - Change some of the block tests to adapt to the new Editor compatibility in common. [TEC-4016]
* Tweak - Update the google calendar export button to open in a new tab on the event single page for both the classic and block editors. [TEC-4084]
* Tweak - Add supplied organizer url to JSON-LD for the event->organizer. Props @cmenon12 for the notification and code! [TEC-4095]
* Tweak - Add a link to the Customizer in the admin menu and in Events->Settings->Display for folks running a FSE theme. [TEC-4126]
* Language - 10 new strings added, 55 updated, 0 fuzzied, and 0 obsoleted

### [5.10.1] 2021-11-04

* Feature - Added Black Friday promo to the General Settings panel. [TCMN-127]
* Tweak - Update Black Friday banner. [TCMN-126]

### [5.10.0] 2021-10-19

* Tweak - Improve the look and feel of the single events page when using the block editor. These changes can be bypassed by defining the following constant to your wp-config.php file: `define( 'TRIBE_EVENTS_SINGLE_VIEW_V2_DISABLED', true );` [TEC-3979]
* Language - 0 new strings added, 1 updated, 0 fuzzied, and 0 obsoleted

### [5.9.2] 2021-10-12

* Fix - Ensure the day view on mobile displays the not found message when no events are present. [TEC-3944]
* Fix - Ensure a map preview is displayed on the venue block in the admin area when using TEC's default Google API Key. [TEC-3042]
* Fix - Add some missing text domains for string translation. [TEC-3908]
* Fix - Correct block use checks around the Classic Editor plugin. [TEC-4099]
* Tweak - Set the appropriate Content-Type for REST responses that return just HTML during view partial requests. [TEC-4087]
* Language - 0 new strings added, 164 updated, 0 fuzzied, and 0 obsoleted

### [5.9.1] 2021-09-14

* Feature - Updated swagger docs generated from swagger 2.0 to openapi 3.0.0
* Fix - Initialize $local_time_zone to ensure we don't have notices displayed in the frontend. [TEC-3791]
* Fix - Ensure the correct timezone label is being displayed on the Classic and Block editors when site-wide timezone is set. [TEC-3791]
* Fix - Ensure that venue state or province are displayed next to the city in list view. [TEC-3332]
* Fix - Ensure the category archive event breadcrumb links to the main events page. [TEC-3330]
* Fix - Ensure that the page title does not encode (em)dashes before passing it on. [TEC-4049]
* Fix - Ensure that the page title does not encode apostrophes before passing it on. [TEC-4058]
* Fix - Ensure that filter_single_event_details_event_website_label() only filters the label for the website field. [ECP-921]
* Tweak - Remove unused template file to avoid confusion.
* Language - 0 new strings added, 13 updated, 0 fuzzied, and 0 obsoleted

### [5.9.0] 2021-08-24

* Fix - Ensure that $eventDisplay is defined before we use it in the default template. [TEC-4060]
* Feature - Alter Customizer to leverage the new exposed CSS custom properties. [TCMN-104]
* Feature - Reduce the CSS load of The Events Calendar Customizer style overrides. [TEC-3011]
* Feature - Allow easier style overrides by users and third-party themes/plugins. [TEC-3011]
* Feature - Add new Font Sections to Customizer -> The Events Calendar -> Global Events. [TEC-3872]
* Feature - Add new font family control to allow The Events Calendar styles to inherit theme fonts. [TEC-3895]
* Feature - Add new font size controls for accessibility and to allow users to more closely match the font sizes of their theme. [TEC-3891]
* Tweak - Support optionally passing start dates to the Event Edit page so targeted event creation can be triggered by The Events Calendar Pro's Event Manager.
* Language - 16 new strings added, 429 updated, 0 fuzzied, and 0 obsoleted

### [5.8.2] 2021-08-17

* Feature - Redesign In-App help and troubleshooting pages. [TEC-3741]
* Fix - Try to ensure that when we do an event search the query post type remains `tribe_events`. [TEC-4012]
* Fix - Ensure the year is displayed in the block editor event single page for events that are occurring in a different year from the current one. [TEC-3740]
* Fix - Fix the issue of the Event Date Time block Timezone dropdown taking up a lot of space. [TEC-4029]
* Fix - Ensure WPML translated event posts show up on translated venue and organizer pages. (props @NicoX13) [TEC-4036]
* Fix - Fix issue of month names not being translatable. This was caused by a missing moment js localization dependency. [ECP-739]
* Fix - Ensure we test the value of tribe_events_get_current_month_day() before using it. [ECP-912]
* Fix - Add a new function to add "Event Blocks" category to the editor for WP >= 5.8. [TEC-4037]
* Tweak - Change label of API Settings tab to "Integrations" and alter helper text. [TEC-4015]
* Language - 2 new strings added, 251 updated, 1 fuzzied, and 18 obsoleted

### [5.8.1] 2021-07-20

* Fix - Ensure that the Block Editor saves cost data when submitted. [TEC-3987]
* Fix - Ensure that when viewing a single event we load the correct template when tribe_context is "confused". [TEC-3975]
* Tweak - Remove some CSS on the single events page that was causing a random border to appear on Avada theme [TEC-3952]
* Tweak - Add CSS class to the event tags label on the event details section on the single event page. [TEC-3951]
* Tweak - Correct the messaging and link for the v1 deprecation notice. [TEC-3958]
* Tweak - Include filter to allow modifications to the Grid query for By Day Views like Month and Week, `tribe_events_views_v2_by_day_view_day_repository`
* Language - 5 new strings added, 26 updated, 2 fuzzied, and 5 obsoleted

### [5.8.0] 2021-07-01

* Version - The Events Calendar 5.8.0 is only compatible with Events Calendar PRO 5.8.0 and higher
* Feature - Add new Events bar section to the Customizer for control of the Events Bar styles. [TEC-3672]
* Fix - Correct instance where the date & time symbols ("@") are not changing color along with the text. [TEC-3883]
* Tweak - Ensure that the Month view date and time default colors match up with the rest [TEC-3709]
* Tweak - Ensure the Customizer Accent Color defaults to "royal blue" (#334aff) [TEC-3884]
* Tweak - Stop doing all the work here and leverage the new tribe-common Theme_Compatibility. [TCMN-106]
* Tweak - Add new hooks to the single event templates to allow more third-party control over content without custom templates. [TEC-3948]
* Tweak - Added filters: `tribe_customizer_should_print_shortcode_customizer_styles`, `tribe_events_views_v2_bootstrap_html`, `tribe_default_events_template_classes`, `tribe_events_single_event_title_classes`, `tribe_events_single_event_title_html_before`, `tribe_events_single_event_title_html_after`, `tribe_events_single_event_title_html`
* Tweak - Removed filters: `tribe_events_views_v2_compatibility_classes`, `tribe_events_views_v2_theme_compatibility_registered`
* Tweak - Added actions: `tribe_default_events_template_after_header`, `tribe_default_events_template_before_footer`
* Tweak - Changed views: `default-template`, `single-event`, `v2/default-template`
* Language - 13 new strings added, 64 updated, 6 fuzzied, and 2 obsoleted

### [5.7.1] 2021-06-23

* Fix - Properly recalculate event cost when creating events via the Block Editor. [TEC-3141]
* Fix - Resolve a compatibility issue with the new single view and the tickets block when using the `twentynineteen` theme. [TEC-3937]
* Fix - Ensure that `view_data` is an array when fetching values from the request. [TEC-3946]
* Fix - Ensure that the events block editor is disabled when "Activate Block Editor for Events" is unchecked. [TEC-3964]
* Tweak - Make custom post types available from the REST API so they can be compatible with the Navigation block. [TEC-3907]
* Tweak - Remove aria-labeled attribute from featured icons. [TEC-3396]
* Language - 0 new strings added, 154 updated, 3 fuzzied, and 0 obsoleted

### [5.7.0] 2021-05-27

* Feature - Add new Month View section to the Customizer for v2 views. [TEC-3836]
* Fix - Apply responsive breakpoints once the page has fully loaded with all JavaScript and Elements on the page [TEC-3797]
* Fix - Resolve conflicts with Gravity Forms plugin that would prevent correct submission of forms data. [ECP-466]
* Fix - Correctly handle start and end of day cutoff in Day View when the server timezone is not the same as the site (thanks @therealgilles). [TEC-3877]
* Fix - Do not remove the `archive` body class from post tag and category pages when using Page as Event Template. [TEC-3846]
* Fix - Correctly translate calendar view in WPML language switcher (thanks @dgwatkins). [TEC-3810]
* Fix - Styles with the default theme `twenty twenty one` in `<buttons>` around the calendar. [TEC-3887]
* Fix - Single event iCalendar export will correctly export only that event information. [TEC-3886]
* Fix - Use the correct date and time in the Day View time separator when Timezone Mode is set to "Manual time zones for each event". [TEC-3877]
* Fix - Correctly integrate with the "Hello Elementor" theme to avoid issues with The Events Calendar and The Events Calendar PRO Views. [ECP-648]
* Fix - Correct typo in style output from Customizer.  Thanks @apmatthews for catching and correcting this!
* Fix - Avoid PHP warnings when linked post types are filtered out (thanks @baden03). [TEC#3533]
* Tweak - Make sure events from latest past events display the featured image correctly. [TEC-3655]
* Tweak - Reduced the usage of the word "onwards" on list-style view date range headings where simpler headings are better suited. [TEC-3831]
* Tweak - Move messages below the calendar grid in the mobile version of Month View. [TEC-3793]
* Tweak - Display a message to let visitors know the selected Month View day has no events in mobile. [TEC-3812]
* Tweak - Add compatibility for the Full Site Editor navigation block. [TEC-3850]
* Tweak - Filter the type of files allowed to upload into the EA Client. [TEC-3882]
* Tweak - Updating lodash to 4.17.21. [TEC-3885]
* Tweak - Prevent to list changes of hash on URL changes like `#content` [TEC-3890]
* Tweak - Update Google Calendar link to use the timezone based on the Timezone Settings from the Calendar [TEC-3143]
* Tweak - Add the `tribe_views_v2_after_setup_loop` filter to modify the loop context set up in the View (v2). [ECP-811]
* Tweak - Add the `tribe_events_views_v2_by_day_view_grid_days` to allow pre-filling Month and Week Views (v2) Events. [ECP-529]
* Tweak - Add the `tribe_events_views_v2_by_day_view_day_results` to allow fine-grained control over Month and Week Views (v2) Event data. [ECP-529]
* Tweak - Added filters: `tribe_customizer_should_print_shortcode_customizer_styles`, `tribe_customizer_should_print_shortcode_customizer_styles`, `tribe_events_views_v2_view_ical_repository_args`, `tribe_events_views_v2_view_{$slug}_asset_origin_object`, `tribe_events_views_v2_by_day_view_grid_days`, `tribe_events_views_v2_by_day_view_day_results`, `tribe_events_views_v2_month_mobile_messages`, `tribe_events_views_v2_view_cached_html`, `tribe_events_views_v2_view_{$this->slug}_cached_html`, `tribe_ical_template_event_ids`, `tribe_get_view_permalink`, `tribe_get_{$slug}_view_permalink`
* Tweak - Added actions: `tribe_views_v2_after_setup_loop`
* Tweak - Changed views: `blocks/classic-event-details`, `blocks/parts/details`, `modules/meta/details`, `v2/components/breakpoints`, `v2/components/messages`, `v2/day/time-separator`, `v2/month`, `v2/month/calendar-body/day`, `v2/month/mobile-events`, `v2/month/mobile-events/mobile-day`, `v2/month/mobile-events/mobile-day/day-marker`
* Language - 27 new strings added, 133 updated, 0 fuzzied, and 0 obsoleted

### [5.6.0] 2021-04-29

* Version - The Events Calendar 5.6.0 is only compatible with Events Calendar PRO 5.6.0 and higher
* Fix - Correct implementation of filters in Views/V2/Hooks.php to avoid fatals. [ECP-761]
* Fix - Ensure when saving on Blocks editor Organizer and Venue IDs don't throw notices for failed deletion. [TEC-3844]
* Fix - Resolve compatibility problem between The Events Calendar and other plugins using Select2. [TEC-3748]
* Fix - Enqueue full styles for v2 event single only when using full styles. [TEC-3848]
* Fix - Modify Select2 to clone the `jQuery.fn.select2` into `jQuery.fn.select2TEC` to avoid conflicting with third-party usage that didn't include the full version of Select2 [TEC-3748]
* Fix - Add filtering hooks to Cache Listener to allow modifications of which options trigger an occurrence. [ECP-826] [ECP-824]
* Fix - Improve escaping for messages when no results were found using search (Thanks Steve Pollak)
* Tweak - Added the ability to filter cached view HTML. Hooks added were: `tribe_events_views_v2_view_cached_html` and `tribe_events_views_v2_view_{$view_slug}_cached_html`. [ECP-770]
* Tweak - Added filters: `tribe_customizer_should_print_shortcode_customizer_styles`, `tribe_events_views_v2_view_ical_repository_args`, `tribe_events_views_v2_view_cached_html`, `tribe_events_views_v2_view_{$this->slug}_cached_html`, `tribe_ical_template_event_ids`
* Tweak - Changed views: `blocks/classic-event-details`, `blocks/parts/details`, `modules/meta/details`, `v2/components/messages`, `v2/month/mobile-events/mobile-day`, `v2/month/mobile-events/mobile-day/day-marker`
* Language - 3 new strings added, 176 updated, 0 fuzzied, and 6 obsoleted

### [5.5.0.1] 2021-04-05

* Fix - Reduce overhead of widget setup on every page load by setting up the widgets only as needed. [TEC-3833]

### [5.5.0] 2021-03-29

* Feature - Add `has_event` and `has_no_events` to the Venue and Organizer ORM so we can filter requests for both by whether they have events or not.
* Fix - Invert quotes to protect against issue with MySQL in `ANSI_QUOTES` mode. [TEC-3785]
* Fix - correct display order of sticky, featured, and "normal" events on Month View. Adds a class for targeting sticky posts for styling. [TEC-3770]
* Fix - Ensure the Events List widget also shows the Time Zone when displaying it is set in the admin. [TEC-3747]
* Fix - Saving on Blocks editor without Organizer is working as expected again [TEC-3788]
* Fix - Fusion Core/Avada Widget implementation of The Events Calendar will no longer throw warnings on the frontend display. [ECP-538]
* Fix - Usage of `tribe_get_events()` for non-existent posts will no longer throw warnings on the Blocks Editor, impacted Community Events Shortcode usage [TEC-3829]
* Tweak - Added rel=noreferrer to Google Map links. [TEC-3795]
* Tweak - Include actions before and after the creation of a view for REST API requests. Hooks added were: `tribe_events_views_v2_before_make_view_for_rest` and `tribe_events_views_v2_after_make_view_for_rest`
* Tweak - Allow specific filtering to add other views into the HTML caching for performance using hook `tribe_events_views_v2_cached_views`.
* Tweak - Include Legacy views deprecation notice [TEC-4809]
* Language - 8 new strings added, 181 updated, 0 fuzzied, and 0 obsoleted

### [5.4.0.2] 2021-03-10

* Fix - Saving organizers properly work on WordPress 5.7 with Blocks Editor [TEC-3788]

### [5.4.0.1] 2021-03-04

* Fix - Prevent fatals happening with PHP 5.6 due to duplicated class for templates [TEC-3799]

### [5.4.0] 2021-02-24

* Version - The Events Calendar 5.4.0 is only compatible with Events Calendar PRO 5.3.0 and higher
* Fix - Compatibility with WordPress 5.7 and jQuery 3.5.X
* Fix - Updated views JavaScript manager is now deferred to the end of the request, to make sure all dependencies are loaded.
* Fix - Navigation for the Views will no longer use current browser URL as previous url, preventing problems on shortcodes.
* Fix - Latest Past view moved to not publicly visible, which was the intended behavior.
* Tweak - Add compatibility container to widgets - to allow for a non-body target for compatibility classes.
* Tweak - Include the `tribe_events_views_v2_view_page_reset_ignored_params` filter to prevent certain params from interfering with pagination resetting. [FBAR-222]
* Tweak - Use filterable attributes for the view more link and text. Add customizer styling for the link. [ECP-568]
* Tweak - Removed `tribe_events_views_v2_widget_admin_form_{$field_type}_input` from the List Widget admin form in favor of using `Tribe__Template::do_entry_point()` [ECP-486]
* Tweak - Moved administration templates for List Widget components to Common. [ECP-486]
* Language - 1 new strings added, 10 updated, 1 fuzzied, and 0 obsoleted

### [5.3.2.1] 2021-02-02

* Fix - Prevent Event Aggregator ASYNC requests from failing to import after 5 Events, Venues, RSVP, Tickets and/or Organizers. [TEC-3769]
* Fix - Update compatibility with PHP 7.4 for ForceUTF8 vendor module. [TEC-3769]

### [5.3.2] 2021-01-28

* Feature - Add customizer support for custom location pins on single events when Views V2 is active. [TEC-3276]
* Fix - Use dynamic label for fast-forward link on the month view. [TEC-3452]
* Fix - Correctly filter `locale` in the `Tribe\Events\I18n` class to avoid errors.
* Fix - Prevent heartbeat warning when null data param is passed on Cron and AJAX requests [TEC-3745]
* Fix - Increase the minimum width of the datetime dropdown when editing an event with the block editor. [TEC-3126]
* Fix - Ordering with an Array when using `Tribe__Repository` now properly ignores the global order passed as the default. [ECP-598]
* Fix - Resolve PHP 8.0 incompatibility with `__wakeup` and `__clone` visibility on Extension class.
* Fix - Prevent `tribe_sort_by_priority` from throwing warnings on `uasort` usage for PHP 8+ compatibility.
* Fix - Update Di52 to include PHP 8+ compatibility.
* Fix - Modify Freemius `class-fs-logger.php` file to prevent PHP 8+ warnings.
* Fix - Correctly handle *nix and Windows server paths that contain falsy values (e.g. `0` or spaces) when building template paths. [TEC-3712]
* Tweak - Increase top padding above date stamp in list view. [TEC-3656]
* Tweak - Reduce bottom margin of the event title in list/day views. [TEC-3656]
* Tweak - Round featured event line corners. [TEC-3656]
* Tweak - Add new filter `tribe_aggregator_build_url_data` to customize the URL delivered to EA server.
* Tweak - Update V2 Customizer admin styles of TEC sections. [TEC-3696]
* Tweak - Added filters: `tribe_aggregator_build_url_data`
* Language - 4 new strings added, 187 updated, 3 fuzzied, and 5 obsoleted

### [5.3.1] 2020-12-15

* Feature - Event Aggregator - Filter Events by Aggregator/Import Record. [EA-130]
* Feature - V2 Customizer - Add background color css overrides. [TEC-3651]
* Feature - V2 Customizer - Add Event Title color css overrides. [TEC-3334]
* Feature - V2 Customizer - Add Event Date & Time color css overrides. [TEC-3675]
* Feature - V2 Customizer - Add controls for Background Color to general and single-event sections. [TEC-3683]
* Feature - V2 Customizer - Add controls for Event Title Color to general section. [TEC-3684]
* Feature - V2 Customizer - Add controls for Event Date & Time Color to general section. [TEC-3685]
* Tweak - Add opaque backgrounds for selected bordered elements. [TEC-3673]
* Tweak - Change Title/Date & Time font color defaults on the Event Single page. [TEC-3682]
* Fix - Fix an issue in csv venue imports where the address would not import.  [TEC-3637]
* Fix - Compatibility for some theme menus that no longer displayed when an event is password protected. [TEC-2968]
* Language - 8 new strings added, 63 updated, 1 fuzzied, and 0 obsoleted

### [5.3.0] 2020-12-02

* Feature - Event Aggregator - Search Box for Scheduled Imports. [TEC-3570]
* Feature - Event Aggregator Batch Pushing for Cron Imports [EA-297]
* Tweak - Add the filter `tribe_aggregator_import_queue_cleaner_time_to_live` to customize the time in seconds to consider an EA record alive. [EA-297]
* Tweak - Add the filter `tribe_aggregator_import_queue_cleaner_stall_limit` to customize the number of seconds for an EA record to be considered stalled. [EA-297]
* Tweak - Add the filter `tribe_events_aggregator_build_url` [EA-297]
* Tweak - Adjust Event Aggregator Client Progress Bar using the Heart Beat API for polling state instead [TEC-3534]
* Tweak - Event Aggregator - Make default limit by number of events instead of by date range. [TEC-3635]
* Tweak - Event Aggregator/Eventbrite Tickets - Remove verbiage regarding 50 event limit on Eventbrite imports.
* Tweak - Add the `tribe_get_organizer_object` function. [TEC-3645]
* Tweak - Change the return value of the `tribe_get_event( $event_id )->organizers` from a collection of Organizer names to a collection of Organizer post objects. [TEC-3645s]
* Tweak - Add the `tribe_get_event( $event_id )->organizer_names` method to return a collection of the Event Organizer names. [TEC-3645]
* Tweak - Ensure widgets don't get Filter Bar classes on their containers. [FBAR-202]
* Tweak - Switch the List View previous/next URL methods to use the slug rather than a hard-coded "list" so the class is more easily extendable. [TEC-3648]
* Tweak - Add an option to trash events after 1 month (thanks @StefanSchroeder).
* Tweak - Add the `tribe_events_views_v2_datepicker_no_conflict` filter (default `false`) to allow loading the Views v2 datepicker in no-conflict mode, when set to `true`, and avoid issues with other plugins that are loading the built-in WordPress `jquery-ui-datepicker` script. [TEC-3581]
* Tweak - Improve WPML integration and URL localization of Views v2. [TEC-3608]
* Fix - Event Aggregator - Fix Eventbrite status filter to not return 'do_not_override' and handle Eventbrite's additional statuses. [TEC-3569]
* Fix - Ensure ECP shortcode today button handles categories gracefully. [ECP-492]
* Fix - Prevent creation of duplicate venues for default address while adding or editing events. [ECP-482]
* Fix - Make sure Month View "View More" link to Day View will preserve the current search criteria. [TEC-3230]
* Fix - Ensure Event Aggregator Cron schedules always have array format and avoid errors on fresh WordPress installations (thanks @mmcachran).
* Fix - Regular expression to sanitize name of columns on the EA client make sure all invalid characters are removed.
* Fix - Use more robust code in the `tribe_is_past_event` template tag to avoid Warnings.
* Fix - Review and improve the Rewrite component to correctly parse and handle localized URLs and accented characters. [TEC-3608]
* Language - 25 new strings added, 775 updated, 1 fuzzied, and 6 obsoleted

### [5.2.1] 2020-10-22

* Tweak - Change Views v2 AJAX request method from GET to POST to avoid issues with too long URLs. [TEC-3283]
* Tweak - Add the `tribe_events_views_v2_endpoint_method` filter to allow controlling the HTTP method Views should use to fetch their content from the back-end endpoint. [TEC-3283]
* Tweak - Add the `tribe_events_views_v2_endpoint_url` filter to allow controlling the URL Views should use to fetch their content from the back-end endpoint. [TEC-3283]
* Fix - Prevent Event Aggregator 15 minute Cron Schedule from being created when not required (props @jetxpert) [EA-317]
* Fix - Add filter to toggle off the event templates hijack. [TEC-3521]
* Fix - Correct url for current month iCal export link. [TEC-3575]
* Fix - Avoid loading the same CSS file twice on the back-end. [TEC-3623]
* Fix - Ensure ECP shortcode prev/next urls handle categories gracefully. [ECP-492]
* Language - 3 new strings added, 200 updated, 0 fuzzied, and 0 obsoleted

### [5.2.0] 2020-09-28

* Fix - Fix the order of the List View when the PRO is set to show only the first instance of a Recurring Event. [ECP-467]
* Fix - Fix a PHP error that would arise when during the translation, by the WPML plugin, of some strings. [TEC-3454, TEC-3578]
* Fix - Fix a compatibility issue with the WPML plugin that would prevent some options from being translated correctly. [TEC-3454]
* Fix - Generation and usage of translated strings that would cause issues with the WPML plugin. [TEC-3454]
* Tweak - Use the `border-small` class for the today button, add new border button styles to customizer. [FBAR-143]
* Tweak - Add missing CSS classes to the Event Categories label on the single event page. [TEC-3478]
* Tweak - Adjust accordion trigger selector to allow multiple space-separated `data-js` attributes. [FBAR-125]
* Tweak - Adjust spacing on header to prevent screen overflow. [FBAR-132]
* Tweak - Adjust aria attributes and add loader text to make ajax loading more accessible. [FBAR-147]
* Tweak - Add the `tribe_events_latest_past_view_display_template` filter to allow controlling the display of templates  in the context of the Latest Past Events View. [FBAR-148]
* Tweak - Allow passing of additional data to the AJAX request by use of container data. [FBAR-162]
* Language - 2 new strings added, 20 updated, 0 fuzzied, and 0 obsoleted

### [5.1.6] 2020-08-24

* Tweak - Move the iCal output coding out of the loop and into its own method.  [VE-150]
* Fix - Fix SQL errors that would show up when creating custom Event queries in theme builders. [TEC-3530]
* Fix - Fix SQL errors that would show up when running custom Event queries in plugins . [TEC-3528]
* Fix - Fix SQL errors that would prevent customers from being able to select tickets assigned to Events in some instances. [TEC-3500]
* Fix - On re-import of the excerpt and event description field enable changes to the existing values. [TEC-3080]
* Fix - On re-import enable excerpt and description to be cleared of their values. [TEC-3080]
* Fix - On re-import only overwrite items that have been mapped. [TEC-2962]
* Tweak - Add filters for venue and organizer import data. [TEC-2962]
* Tweak - Add ability to use default values from settings for venue imports via the `tribe_events_importer_set_default_venue_import_values` filter. [TEC-2962]
* Tweak - Replace placeholders in template docblocks with appropriate links. [TEC-3399]
* Language - 32 new strings added, 75 updated, 0 fuzzied, and 28 obsoleted

### [5.1.5] 2020-07-27

* Tweak - Add filters to link generation for events, venues, and organizers. [EXT-151]
* Tweak - Remove disabled admin notice for Virtual Events and Gutenberg. [TEC-3546]
* Tweak - Modify parameters on `register_rest_route` to include `permission_callback` to prevent notices on WordPress 5.5.
* Fix - Prevent the wrong dates in mobile month view date marker when on leading UTC timezones. [TEC-3549]
* Fix - Fix the display order of Events starting on the same date and time to ensure it's consistent. [TEC-3548]
* Fix - Fix the handling of URL fragments translations in Views to ensure fully localized View URLs work. [TEC-3479]
* Fix - Display promo at the bottom of views when "Show The Events Calender link" is checked. [TEC-3321]
* Fix - Set proper timezone on block editor when creating a new event. [TEC-3543]
* Fix - Prevent PHP error when using V2, the site home page at `Main Events page`, including events in the blog loop, and Pro is active.  [ECP-361]
* Fix - Resolve WordPress REST API authentication errors related to `null` returns. Props to @ahaurat [TEC-3539]
* Language - 0 new strings added, 55 updated, 0 fuzzied, and 6 obsoleted

### [5.1.4] 2020-06-24

* Tweak - Improve fresh install experience by setting the default template to the Events one [TEC-3453]
* Tweak - Create a new method to request an update back to EA imports to mark imports as completed on EA server [TEC-3476]
* Tweak - Add a new filter `tribe_aggregator_service_put_pue_licenses` to enable external sources the option to add additional PUE attached to the request. [TEC-3476]
* Tweak - Prevent latest-past from showing in the front end view selector in new installs [TEC-3450]
* Tweak - On a fresh install set the enabled views to list, month, and day and set the default view to list to stop erroneous error entries [TEC-3451]
* Tweak - Add a new "scheduled" status for the activity reporter of imports from EA [TEC-3475]
* Tweak - Add admin notice for Virtual Events. [TEC-3620]
* Language - 3 new strings added, 246 updated, 1 fuzzied, and 1 obsoleted

### [5.1.3] 2020-06-22

* Tweak - Add new filter `tribe_events_filter_views_v2_plural_events_label` to customize the label in V2 views. [VE-9]
* Fix - Prevent "too few arguments" on the settings page when a url contains percentage signs. [VE-111]
* Fix - Correctly store Event Organizer meta when using the ORM.
* Fix - Linked posts (Organizers and Venues) correctly check if the item selected is brand new or existing when edit link is empty. [TEC-3481]
* Language - 1 new strings added, 112 updated, 0 fuzzied, and 1 obsoleted

### [5.1.2.1] 2020-06-09

* Security - Remove deprecated usage of escapeMarkup in Select2 (props to @miha.jirov for reporting this).

### [5.1.2] 2020-05-27

* Tweak - Prevent undefined errors when using tribe_get_events and forcing a cache refresh.
* Fix - Prevent `E_ERROR` for `Tribe__Events__Meta__Save` construct when dealing with revisions, which some WP Engine customers were seeing.
* Language - 0 new strings added, 49 updated, 0 fuzzied, and 0 obsoleted

### [5.1.1] 2020-05-11

* Feature - Move all the featured event icons to templates. [TEC-3441]
* Feature - Added a helper method `Tribe__Plugins::is_active( 'slug' )` to check if a given plugin is active.
* Feature - Add entry points through filters to be able to add content after the opening html tag or before the closing html tag. [TCMN-65]
* Tweak - Deprecated the `Tribe__Events__Main::get_i18n_strings_for_domains()` and `Tribe__Events__Main::get_i18n_strings()` methods; use the methods with the same name and signature provided by the `tribe( 'tec.18n' )` object [TEC-3404]
* Tweak - Add new filter `tribe_aggregator_manage_record_column_source_html` to customize the source column content HTML used on the Event Aggregator Import "History" tab.
* Tweak - Modify language variables to improve translations readability on Updated Views navigation previous and next buttons. [props @justlevine]
* Tweak - Add new filter `tribe_aggregator_manage_record_column_source_html` to customize the source column content HTML used on the Event Aggregator Import "History" tab.
* Fix - Enqueue Customizer stylesheets properly via `tribe_customizer_inline_stylesheets` in Common. [TEC-3401]
* Fix - Not being able to create events because capabilities were not set on activation or update of the plugin. [TEC-3350]
* Fix - Adjust templates to show time zone in event details when "Show time zone" is checked. [TEC-2979]
* Fix - Correct bad defaults from `Template->attr()` and ensure that the timezone info is correctly hydrated in the case of an unchanged block. [TEC-2964]
* Fix - Show the correct counts on the Event Aggregator Import "History" tab for non-Event content types being imported.
* Fix - Prevent creation of empty venue when removing a Venue inside of the Events using the Classic editor that had a US state selected. [TEC-3416]
* Fix - Event Aggregator imported events when using default status or categories from the Settings Page will now be imported correctly. [TEC-3445]
* Fix - A localization support that would mangle Views URLs when WPML plugin is active alongside Views v2 [TEC-3404]
* Fix - Prevent problems with `func_get_args()` usage around template inclusion for legacy template files [TEC-3104]
* Tweak - Extended support for namespaced classes in the Autoloader.
* Tweak - Make Customizer stylesheet enqueue filterable via `tribe_customizer_inline_stylesheets`. [TEC-3401]
* Tweak - Normalize namespaced prefixes with trailing backslash when registering them in the Autoloader. [VE-14]
* Language - 2 new strings added, 243 updated, 0 fuzzied, and 1 obsoleted

### [5.1.0] 2020-04-23

* Feature - Add a "fast forward" link to Month and Day views when there are no events to show. [TEC-3400]
* Feature - Add `tribe_events_views_v2_use_ff_link` and `tribe_events_views_v2_{$this->slug}_use_ff_link` filters to allow control of the link. [TEC-3400]
* Feature - Add Recent Past Events Views. [TEC-3385]
* Tweak - Improved on meta data handling of for Blocks editor.
* Tweak - Deprecate Select2 3.5.4 in favor of SelectWoo
* Tweak - Load plugin text domain on the new `tribe_load_text_domains` action hook, which fires on `init` instead of on the `plugins_loaded` hook. [TEC-3406]
* Tweak - Add a constant `TRIBE_CACHE_VIEWS` to turn off views HTML caching.
* Fix - Theme navigation warning around `post_date = '0'` no longer happens when using Page template for Updated Views [TEC-3434]
* Fix - Selecting other Page templates from Settings > Display now loads the correct template properly, to display events.
* Fix - Preventing redirects from updated Views V2 to be too broad and end up catching requests from other Plugins, reported by GravityView team on Gravity Forms bug with imports.
* Fix - Prevent PHP errors from happening during bulk activation or deactivation of the plugin [TCMN-53]
* Fix - Correct iCal link on month view for months other than the current one [TEC-3267]
* Fix - Correct a few incorrect and/or typoed text domains [TEC-3390]
* Fix - Ensure we pass search keywords when changing views and in the top-bar nav [TEC-3282]
* Fix - Prevent Blocks editor from throwing browser alert when leaving the page without any changes applied to the edited post.
* Fix - Several strings have been adjusted for consistency and better translatability [TEC-3417]
* Hook - Add the `tribe_events_blocks_editor_is_on` filter; returning a falsy value from this filter will prevent the Blocks Editor to ever be active on Events; else the settings from Events > Settings will apply [TEC-3349]
* Tweak - Add some filters for better control of link targets, standardize the way we create those links [TEC-3402]
* Language - 4 new strings added, 286 updated, 1 fuzzied, and 2 obsoleted

### [5.0.3.1] 2020-03-23

* Fix - Assets class modification to prevent JavaScript and CSS failing to load when `SCRIPT_DEBUG=true` [TCMN-52]

### [5.0.3] 2020-03-23

* Feature - Allow users to set a custom name for new Event Aggregator Imports. [TEC-3286]
* Tweak - Add back missing JSON-LD to Single Events. [TEC-3262]
* Tweak - Minify the Freemius svg assets. [TEC-3215]
* Tweak - Remove "(beta)" label from URL source type of import. [TEC-3289]
* Tweak - Reword the Filter Activation setting's labels for better clarity.  [FBAR-79]
* Fix - Ensure that any values for `liveFilterUpdate` that are not `automatic` or `manual` get converted. [FBAR-83]
* Fix - Breakpoint code compatibility with the latest version of jQuery 3.4.1 [TEC-3251]
* Fix - Remove numbers from listed events in event list widget for Genesis theme. [TEC-2957]
* Fix - Customizer accent color affects featured line and text. [TEC-3277]
* Fix - Resolve conflict between datepicker holding consistent size when navigating and flexibility on small screen sizes. [TEC-3322]
* Fix - Respect EA `post_status` from settings when an event does not have a defined value. [TEC-3255]
* Fix - Save the `post_status` for a scheduled import when using a different value other than `publish`. [TEC-3296]
* Fix - Update events, venues, and organizers to use dynamic labels. [TEC-3280]
* Fix - Resolve an issue in Views v2 that would break URLs when the event single and archive slugs have the same value due to the "Events URL slug" and "Single event URL slug" settings or due to their translations [TEC-3254]
* Fix - Restore correct handling of events RSS feeds; events will show in the RSS feed in ascending start date, starting from the current day and the event publish date will be set to the event start date [TEC-3252]
* Hook - Add filters `tribe_events_liveupdate_automatic_label_text` and `tribe_events_liveupdate_manual_label_text` to allow Filter Bar to include itself in those labels. [TEC-3322]
* Hook - Add the `tribe_views_v2_events_query_controller_active` filter; returning a falsy value from this filter will prevent Views v2 from altering the WordPress query. This filter allows handling situations where Views v2 might interfere with third party plugins (e.g. custom RSS feed implementations) [TEC-3252]
* Tweak - Added filters: `tribe_events_option_convert_live_filters`, `tribe_events_views_v2_messages_need_events_label_keys`
* Tweak - Removed filters: `tribe_events_ical_export_text`
* Tweak - Changed views: `v2/components/events-bar/search/keyword`, `v2/month/calendar-body/day`
* Language - 11 new strings added, 81 updated, 0 fuzzied, and 6 obsoleted

### [5.0.2.1] 2020-02-25

* Fix - Plugin dependency registration with `Plugin_Register` will not prevent loading of all plugins in list if the last item loaded fails. [TCMN-41]

### [5.0.2] 2020-02-19

* Version - The Events Calendar 5.0.2 is only compatible with Filter Bar 4.9.2 and higher
* Version - The Events Calendar 5.0.2 is only compatible with Events Calendar PRO 5.0.2 and higher
* Tweak - Modify Link Color Customizer option for single event links in description, the venue, the organizer, and the website link in classic editor.  [TEC-3219]
* Tweak - Move link color option to General tab in Customizer and remove Text tab.  [TEC-3244]
* Tweak - Freemius Opt-out workflow now present on all occasions [TEC-3171]
* Tweak - Freemius updated to the latest version 2.3.2 [TEC-3171]
* Tweak - Remove the "Default stylesheet - full" option from display settings, for the new views. [TEC-3125]
* Tweak - Change the live refresh option to a radio, adjust conditional checks to accommodate. [TEC-3072]
* Fix - Freemius activation URL send via email works as expected [TEC-3218]
* Fix - Improve compatibility from Updated Views V2 with Beaver Builder plugins [TEC-3248]
* Fix - More robust handling of `hide_from_listings` in REST API v2, thanks @maxm123
* Fix - Make sure the new Views (v2) will correctly print JSON-LD schema information [TEC-3241]
* Language - 4 new strings added, 248 updated, 1 fuzzied, and 3 obsoleted

### [5.0.1] 2020-02-12

* Version - The Events Calendar 5.0.1 is only compatible with Filter Bar 4.9.1 and higher
* Version - The Events Calendar 5.0.1 is only compatible with Events Calendar PRO 5.0.1 and higher
* Feature - Add the "Accent Color" option in the customizer, for the new views. [TEC-3067]
* Fix - Fix venue block title from being indented in Twenty Twenty theme. [TEC-3140]
* Fix - Fix website block label from disappearing when adding event details classic block. [TEC-2971]
* Fix - Fix style overrides for new view shortcodes for Enfold theme. [ECP-315]
* Fix - Fix events bar input class recognition for JS handling in new views. [TEC-3091]
* Fix - Ensure datepicker does not get cut off in small width screens for new views. [TEC-2983]
* Fix - Venue and organizer blocks link to venue and organizer pages if Events Calendar Pro is activated. [ECP-14]
* Fix - Use proper check for map on venue block to apply proper class. [TEC-3020]
* Fix - Remove font family applied to organizer block to allow theme styles to be applied. [TEC-2974]
* Fix - Fix numbers breaking into two lines in datepicker in Twenty Twenty theme. [TEC-2999]
* Fix - Fix tooltips being cut off and hidden in month view. [TEC-3000]
* Fix - Fix event sharing block cutting off text in block editor admin when editing event. [TEC-2972]
* Fix - Fix disappearing price description in block editor admin when editing event. [TEC-2992]
* Fix - Allow venues to be properly removed by clicking the remove venue button in the venue block. [TEC-2965]
* Fix - Ensure map does not display if enable map setting is disabled. [TEC-3013]
* Fix - Fix the datepicker width problem in Google Chrome, for the new views. [TEC-2995]
* Fix - Fix an issue where Venue provinces would be incorrectly populated in iCal exports [TEC-3223]
* Fix - Deleting events after X feature no longer will delete posts with `_EventEndDate` meta [TEC-3233]
* Tweak - Adjust tooltip title styles for Twenty Twenty theme. [TEC-2998]
* Tweak - Remove find events button and related data when events bar is disabled. [TEC-3074]
* Tweak - Ensure datepicker always updates view via live refresh. [TEC-3073]
* Tweak - Adjust customizer labels for sites using the new views [TEC-3066]
* Tweak - Allow start datetime and end datetime to be the same to hide end datetime in frontend when using block editor. [TEC-3009]
* Tweak - Move the "Link Color" option in the customizer, for the new views. [TEC-3067]
* Language - 14 new strings added, 256 updated, 0 fuzzied, and 5 obsoleted

### [5.0.0.2] 2020-02-06

* Fix - Datepicker format now properly defaults to the correct value when Display Settings have not been saved. [TEC-3229]
* Fix - New views mobile breakpoints interactions with Caching plugins resolved. [TEC-3221]

### [5.0.0.1] 2020-01-31

* Fix - Events with timezones that differ from the site timezone now display on the correct date. [TEC-3208]
* Fix - Multi-day events now display on all days that they are supposed to. [TEC-3212]
* Fix - End of day cutoff is now being observed appropriately when creating the day grid stack. [TEC-3210]
* Fix - Fix number of parameters when doing `the_post` action, for the single event view in the new views. [TEC-3214]
* Fix - 404s on permalinks have been resolved by moving the flush permalink action to a later moment of time on activation after all rules have been declared. [TEC-3211]

### [5.0.0] 2020-01-27

* Feature - Created new Month, Day, and List views with all new HTML, CSS, and JavaScript.
* Feature - Add upgrade path for new Month, Day, and List views making it opt-in for any existing users.
* Feature - New templating engine to power the new Views. [See More](https://evnt.is/1aid)
* Feature - Views initialization and instance includes more filters and actions to allow improved extensibility and customization. (See all filters below)
* Feature - Views manager and bootstrapping classes were created to allow more control over where and when views will be initialized. (See filters related to those below)
* Feature - Reduced maintenance burden of customizations by leveraging atomic templates for the new views. (See list of files now available below)
* Feature - CSS uses a Block Element Modifier (BEM) methodology to improve reusability of components. [See More](https://evnt.is/1aib)
* Feature - New Views share one JavaScript Manager, which contains multiple jQuery actions and customization points.
* Feature - View navigation relies on the WP Rest API, improving reliability and caching opportunities.
* Feature - Event permalinks are now more consistent across navigation using `WP_Rewrite` to map params to their matching URL, which improves SEO.
* Feature - Event data filtering used across all new views: `tribe_get_event_before`, `tribe_get_event`, `tribe_get_event_after`, `tribe_events_organizers_fetch_callback`, `tribe_events_venues_fetch_callback`
* Feature - Venue data filtering used across all new views: `tribe_get_venue_object_before`, `tribe_get_venue_object`
* Tweak - Custom Before and After HTML on the Events > Settings page will now prefer event view styling over the Theme's CSS.
* Tweak - Lowered the reliance on the global `$wp_query` to create more consistent output and faster maintenance. [See More](https://evnt.is/1aic)
* Tweak - View overrides for the new views will look within a new folder in your theme to avoid conflicting with old The Events Calendar theme customizations [See More](https://evnt.is/1aia)
* Tweak - Switch to a compact date while on day and month view in mobile [136789]
* Tweak - Remove `tribe_events_getLink` in favor of `tribe_events_get_link` which was a deprecated filter since version 4.3
* Hooks - View template include and render filters and actions: `tribe_template_before_include`, `tribe_template_before_include:{$template_path}`, `tribe_template_after_include`, `tribe_template_after_include:{$template_path}`, `tribe_template_html`, `tribe_template_html:{$template_path}`
* Hooks - View instance filters and actions: `tribe_events_views_v2_view_template`, `tribe_events_views_v2_{$view_slug}_view_template`, `tribe_events_views_v2_view_context`, `tribe_events_views_v2_{$view_slug}_view_context`, `tribe_events_views_v2_view_repository`, `tribe_events_views_v2_{$view_slug}_view_repository`, `tribe_events_views_v2_view_url_query_args`, `tribe_events_views_v2_{$view_slug}_view_url_query_args`, `tribe_events_views_v2_view_html_classes`, `tribe_events_views_v2_{$view_slug}_view_html_classes`, `tribe_events_views_v2_url_query_args`, `tribe_events_views_v2_view_template_vars`, `tribe_events_views_v2_view_{$view_slug}_template_vars`, `tribe_events_views_v2_view_url`, `tribe_events_views_v2_view_{$view_slug}_url`, `tribe_events_views_v2_view_prev_url`, `tribe_events_views_v2_view_{$view_slug}_prev_url`, `tribe_events_views_v2_view_next_url`, `tribe_events_views_v2_view_{$view_slug}_next_url`, `tribe_events_views_v2_view_repository_args`, `tribe_events_views_v2_view_link_label_format`, `tribe_events_views_v2_view_{$view_slug}_link_label_format`, `tribe_events_views_v2_view_title`, `tribe_events_views_v2_view_{$view_slug}_title`, `tribe_events_views_v2_view_messages`, `tribe_events_views_v2_view_{$view_slug}_messages`, `tribe_events_views_v2_view_breadcrumbs`, `tribe_events_views_v2_view_{$view_slug}_breadcrumbs`, `tribe_events_views_v2_view_display_events_bar`, `tribe_events_views_v2_view_{$view_slug}_display_events_bar`, `tribe_events_views_v2_view_ical_data`, `tribe_events_views_v2_view_{$view_slug}_ical_data`, `tribe_events_views_v2_view_show_datepicker_submit`, `tribe_events_views_v2_view_{$view_slug}_show_datepicker_submit`, `tribe_events_views_v2_view_public_views`, `tribe_events_views_v2_view_{$view_slug}_public_views`, `tribe_events_views_v2_view_data`, `tribe_events_views_v2_{$view_slug}_view_data`, `tribe_events_views_v2_{$view_slug}_events_per_day`, `tribe_events_views_v2_month_events_per_day`, `tribe_events_views_v2_month_nav_skip_empty`, `tribe_events_views_v2_view_breakpoints`, `tribe_events_views_v2_view_{$view_slug}_breakpoints`, `tribe_events_views_v2_before_make_view`, `tribe_events_views_v2_after_make_view`, `tribe_events_views_v2_messages_map`, `tribe_events_views_v2_view_messages_before_render`
* Hooks - View REST API HTML request actions and filters: `tribe_events_views_v2_request_arguments`, `tribe_events_views_v2_rest_endpoint_available`, `tribe_events_views_v2_rest_params`, `tribe_events_views_v2_{$view_slug}_rest_params`
* Hooks - Views Bootstrap filters and actions: `tribe_events_views_v2_bootstrap_pre_get_view_html`, `tribe_events_views_v2_bootstrap_should_display_single`, `tribe_events_views_v2_bootstrap_view_slug`, `tribe_events_views_v2_bootstrap_pre_should_load`, `tribe_events_views_v2_should_hijack_page_template`
* Hooks - Views Manager filters and actions: `tribe_events_views`, `tribe_events_views_v2_manager_default_view`, `tribe_events_views_v2_manager_view_label_domain`, `tribe_events_views_v2_manager_{$view_slug}_view_label_domain`, `tribe_events_views_v2_manager_view_label`, `tribe_events_views_v2_manager_{$view_slug}_view_label`
* Hooks - Other views filters and actions: `tribe_events_views_v2_is_enabled`, `tribe_events_views_v2_assets_should_enqueue_frontend`, `tribe_events_views_v2_assets_should_enqueue_full_styles`, `tribe_events_v2_view_title`, `tribe_events_views_v2_should_replace_excerpt_more_link`, `tribe_events_views_v2_view_before_events_html`, `tribe_events_views_v2_view_after_events_html`, `tribe_events_views_v2_month_title`, `tribe_events_views_v2_day_title`, `tribe_events_views_v2_category_title`, `tribe_events_views_v2_theme_compatibility_registered`, `tribe_events_views_v2_stack_spacer`, `tribe_events_views_v2_stack_recycle_spaces`, `tribe_events_views_v2_stack_events`, `tribe_events_views_v2_stack_filter_event`, `tribe_events_views_v2_stack_normalize`
* Templates - Views refactored template files: `v2/base`, `v2/components/after`, `v2/components/before`, `v2/components/breadcrumbs`, `v2/components/breadcrumbs/breadcrumb`, `v2/components/breadcrumbs/linked-breadcrumb`, `v2/components/breakpoints`, `v2/components/data`, `v2/components/events-bar`, `v2/components/events-bar/filters`, `v2/components/events-bar/search-button`, `v2/components/events-bar/search-button/icon`, `v2/components/events-bar/search`, `v2/components/events-bar/search/keyword`, `v2/components/events-bar/search/submit`, `v2/components/events-bar/tabs`, `v2/components/events-bar/views`, `v2/components/events-bar/views/list`, `v2/components/events-bar/views/list/item`, `v2/components/filter-bar`, `v2/components/ical-link`, `v2/components/loader`, `v2/components/messages`, `v2/components/read-more`, `v2/components/top-bar/actions`, `v2/components/top-bar/actions/content`, `v2/components/top-bar/datepicker/submit`, `v2/components/top-bar/nav`, `v2/components/top-bar/nav/next-disabled`, `v2/components/top-bar/nav/next`, `v2/components/top-bar/nav/prev-disabled`, `v2/components/top-bar/nav/prev`, `v2/components/top-bar/today`, `v2/day`, `v2/day/event`, `v2/day/event/cost`, `v2/day/event/date`, `v2/day/event/date/meta`, `v2/day/event/description`, `v2/day/event/featured-image`, `v2/day/event/title`, `v2/day/event/venue`, `v2/day/nav`, `v2/day/nav/next-disabled`, `v2/day/nav/next`, `v2/day/nav/prev-disabled`, `v2/day/nav/prev`, `v2/day/time-separator`, `v2/day/top-bar`, `v2/day/top-bar/datepicker`, `v2/day/type-separator`, `v2/index`, `v2/list`, `v2/list/event`, `v2/list/event/cost`, `v2/list/event/date-tag`, `v2/list/event/date`, `v2/list/event/date/meta`, `v2/list/event/description`, `v2/list/event/featured-image`, `v2/list/event/title`, `v2/list/event/venue`, `v2/list/month-separator`, `v2/list/nav`, `v2/list/nav/next-disabled`, `v2/list/nav/next`, `v2/list/nav/prev-disabled`, `v2/list/nav/prev`, `v2/list/nav/today`, `v2/list/top-bar`, `v2/list/top-bar/datepicker`, `v2/month`, `v2/month/calendar-body`, `v2/month/calendar-body/day`, `v2/month/calendar-body/day/calendar-events`, `v2/month/calendar-body/day/calendar-events/calendar-event`, `v2/month/calendar-body/day/calendar-events/calendar-event/date`, `v2/month/calendar-body/day/calendar-events/calendar-event/date/meta`, `v2/month/calendar-body/day/calendar-events/calendar-event/featured-image`, `v2/month/calendar-body/day/calendar-events/calendar-event/title`, `v2/month/calendar-body/day/calendar-events/calendar-event/tooltip`, `v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/cost`, `v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/date`, `v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/date/meta`, `v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/description`, `v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/featured-image`, `v2/month/calendar-body/day/calendar-events/calendar-event/tooltip/title`, `v2/month/calendar-body/day/more-events`, `v2/month/calendar-body/day/multiday-events`, `v2/month/calendar-body/day/multiday-events/multiday-event-spacer`, `v2/month/calendar-body/day/multiday-events/multiday-event`, `v2/month/calendar-header`, `v2/month/mobile-events`, `v2/month/mobile-events/mobile-day`, `v2/month/mobile-events/mobile-day/day-marker`, `v2/month/mobile-events/mobile-day/mobile-event`, `v2/month/mobile-events/mobile-day/mobile-event/cost`, `v2/month/mobile-events/mobile-day/mobile-event/date`, `v2/month/mobile-events/mobile-day/mobile-event/date/meta`, `v2/month/mobile-events/mobile-day/mobile-event/featured-image`, `v2/month/mobile-events/mobile-day/mobile-event/title`, `v2/month/mobile-events/mobile-day/more-events`, `v2/month/mobile-events/nav`, `v2/month/mobile-events/nav/next-disabled`, `v2/month/mobile-events/nav/next`, `v2/month/mobile-events/nav/prev-disabled`, `v2/month/mobile-events/nav/prev`, `v2/month/mobile-events/nav/today`, `v2/month/top-bar`, `v2/month/top-bar/datepicker`, `v2/not-found`
* Language - 2 new strings added, 169 updated, 1 fuzzied, and 0 obsoleted

### [4.9.14] 2020-01-15

* Feature - Add Repository filter `where_meta_related_by_meta` for getting a post by the meta value an associated post. [133333]
* Tweak - Modifications to the Freemius code initialization to allow better data around plugin uninstalls.
* Tweak - Adjust tooltip title styles for Twenty Twenty theme. [TEC-2998]
* Tweak - Changed views: `blocks/event-venue`
* Fix - Cost field description no longer disappears when editing the block. [TEC-2992]
* Fix - Organizer theme no longer getting overwritten by Blocks editor styles. [TEC-2974]
* Fix - Venue block properly receives the correct HTML class. [TEC-3020]
* Fix - Correct missing block when switching from blocks to classic editor. [131493]

### [4.9.13] 2019-12-10

* Tweak - Allow Event Aggregator date refinements for Eventbrite source.
* Language - 29 new strings added, 201 updated, 0 fuzzied, and 0 obsoleted

### [4.9.12] 2019-11-20

* Fix - Blocks Editor date time saving correctly for WordPress 5.3 compatibility. [137421]
* Tweak - Add the `tribe_get_query_var` function [137262]
* Tweak - Add `tribe_get_the_content()` and `tribe_the_content()` for PHP 7.2 compatibility with WordPress 5.2
* Language - 21 new strings added, 162 updated, 0 fuzzied, and 0 obsoleted

### [4.9.11] 2019-11-12

* Feature - Opt-in to the newly redesigned views
* Fix - Fixed issue where DD/MM/YYYY style dates were not supported during Event Aggregator imports [117691]
* Fix - Resolved issue where non YYYY-MM-DD datepicker formats resulted in unpredictable behavior while navigating views [116086, 126472, 117909]
* Fix - Fixed date issue where the event date was defaulting to current date when editing an event with the block editor [132735]
* Tweak - Added additional datepicker formats for simpler selection [116086, 126472, 117909]
* Tweak - Updated the Repository implementation to handle more complex `orderby` constructs [133303]
* Tweak - Added the `Tribe__Date_Utils::get_week_start_end` method [133303]
* Tweak - added the `tribe_events_suppress_query_filters` filter to allow suppressing `Tribe__Events__Query` filters [134827]
* Language - 5 new strings added, 23 updated, 2 fuzzied, and 13 obsoleted

### [4.9.10] 2019-10-16

* Tweak - added the `tribe_sanitize_deep` function to sanitize and validate input values [134427]
* Tweak - use the `tribe_sanitize_deep` function to sanitize the values returned by the `tribe_get_request_var` function [134427]
* Tweak - Rename "Datepicker Date Format" to "Compact Date Format" [134526]
* Tweak - Adjust Promoter loading order to increase compatibility with plugins that use authentication early in the process [134862]
* Tweak - Add support for Authentication using a Header when using Promoter [133922]
* Language - 2 new strings added, 25 updated, 0 fuzzied, and 1 obsoleted

### [4.9.9] 2019-09-25

* Fix - Set the start date with the current day for the "All" events page for recurring events. Thanks Andy, leapness and others for flagging this! [130350]
* Tweak - Updated Freemius integration code [133148]
* Tweak - Conform iCalendar feed to specifications by not putting quotes around the timezone ID. This fixes some custom parsers [133626]
* Language - 0 new strings added, 16 updated, 0 fuzzied, and 1 obsoleted

### [4.9.8] 2019-09-04

* Tweak - Added the Monolog logging library as alternative logging backend [120785]
* Tweak - Hook Monolog logger on `tribe_log` action [120785]
* Tweak - Add redirection of `tribe( 'logger' )->log()` calls to the Monolog logger using the `tribe_log_use_action_logger` filter [120785]
* Fix - Conform iCalendar feed to specifications by not putting quotes around the timezone. This fixes Outlook compatibility [131791]
* Fix - Additional fields with multiple values using pipes `|` as separators are working properly on importing again. [131510]
* Fix - Fix default view redirection loop on mobile devices. Thanks Ricardo, @cittaslow and others for flagging this! [125567]
* Fix - Handling of featured image setting during Event Aggregator CSV imports [127132]
* Language - 1 new strings added, 10 updated, 0 fuzzied, and 0 obsoleted

### [4.9.7] 2019-08-19

* Tweak - Update Lodash version on Block editor to prevent any possibility of a security issue with the package. From v4.17.11 to v4.17.15 [131421]
* Tweak - Add filter 'tribe_events_js_config' to allow filtering the contents of the Javascript configuration [132567]
* Tweak - Updates to the shortcode Javascript code to allow disabling the URL manipulation behavior [132567]
* Fix - Prevent mascot image to get blown up out of proportions to a larger size on buggy CSS loading. [131910]
* Language - 3 new strings added, 191 updated, 1 fuzzied, and 0 obsoleted

### [4.9.6] 2019-08-07

* Tweak - Update Event Aggregator to include compatibility with new Meetup API requirements - [See more](https://evnt.is/1afb) [125635]
* Language - 5 new strings added, 120 updated, 5 fuzzied, and 10 obsoleted

### [4.9.5] 2019-07-25

* Tweak - Update redirection URLs for Freemius actions [130281]
* Fix - Location filtering for Context class moved out of construct, resolving lots of navigation problems across The Events Calendar [130754]
* Fix - Featured event AJAX and browser navigation working as expected for all use cases. [127272]
* Fix - Shortcode properly handling featured param on AJAX requests. [114002]
* Fix - Remove removing wpautop for Gutenberg blocks to fix spacing when content comes from classic editor. [122801]
* Language - 4 new strings added, 16 updated, 0 fuzzied, and 0 obsoleted

### [4.9.4] 2019-07-03

* Tweak - Add filter `tribe_events_event_insert_args` the arguments in prior to inserting the event and meta fields. [129517]
* Tweak - Add filter `tribe_events_event_update_args` the arguments prior the update of an event and meta fields. [129517]
* Tweak - Add filter `tribe_events_event_prevent_update` to disable the update for an event via the Tribe API [129517]
* Tweak - Add filter `tribe_events_archive_get_args` to filter the arguments used to get the events on the archive page via REST API. [129517]
* Tweak - Add filter `tribe_events_validator_is_event_id` to define if is a valid event_id [129517]
* Tweak - Add action `tribe_rest_before_event_data` executed before the Event data is pulled before deliver the Event via REST API. [129517]
* Tweak - Add `Tribe__Events__Query::last_found_events()` to access the last results via the `Query` object [129517]
* Tweak - Wrap `register_rest_route` calls with `tribe_register_rest_route` to enable filtering on REST registration
* Tweak - Add filter `tribe_ical_feed_vtimezone` to filter the `VTIMEZONE` group [89999]
* Tweak - Include proper documentation of why the plugin has been deactivated and a knowledgebase article about how to downgrade [129726]
* Tweak - When trying to update The Events Calendar with an incompatible version of an Addon that is expired, it will stop the upgrade [129727]
* Tweak - Add filter `tribe_is_classic_editor_plugin_active` to change the output if the classic editor is active or not [121267]
* Tweak - Create a new key if `AUTH_KEY` is not defined or is empty and add a new filter `tribe_promoter_secret_key` to filter the result [127183]
* Tweak - Divide the `tribe-common.js` file to prevent that file from being bloated with external dependencies. [129526]
* Tweak - Make sure `UTC-0` is converted back to `UTC` instead of `UTC-01` [129240]
* Tweak - Add new function `tribe_register_rest_route` Wrapper around `register_rest_route` to filter the arguments when a new REST endpoint is created [129517]
* Tweak - Add new method `Tribe__Cost_Utils::parse_separators` to infer decimal and thousands separators from a value that might have been formatted in a local different from the current one [98061]
* Fix - Save of event meta data when Classic editor plugin and Gutenberg blocks for events are enabled [121267]
* Fix - Moved The Events Calendar specific code from common Context class into The Events Calendar [129241]
* Fix - Fixed issue where multiday events were not returning correct end date in block editor [128033]
* Fix - Resolved issue where deactivation feedback was not hooked properly [128341]
* Fix - Added escaping to the event website URL target attribute [129565]
* Fix - Fix Timezone definitions for `*.ics` file on events [89999]
* Fix - Resolved an issue where non-English decimal and thousands event cost separators could lead to wrong cost values in REST API responses [98061]
* Fix - Prevent Clipboard Javascript from loading all over the place on `/wp-admin/` [129526]
* Fix - PHP 5.6 compatibility for `trait Cache_User` by using WP action `shutdown` instead of `__destruct` on our `WP_Rewrite` [129860]
* Language - 14 new strings added, 222 updated, 1 fuzzied, and 6 obsoleted

### [4.9.3.2] 2019-06-20

* Fix - Prevent issue where older versions of the tribe-common libraries could be bootstrapped [129478]
* Fix - Add Promoter PCSS file so that the proper CSS will be generated on package build [129584]

### [4.9.3.1] 2019-06-07

* Fix - Remove caching of rewrite base slugs which make third-party, Photo and Week work as expected [129035]
* Tweak - Adjust newsletter signup submission destination [129034]

### [4.9.3] 2019-06-06

* Fix - Fixed issue where the previous events link was not present on initial page load of the List View [127477]
* Language - 10 new strings added, 18 updated, 0 fuzzied, and 0 obsoleted

### [4.9.2] 2019-05-16

* Tweak - In the Event Repository class: filter the event creation meta before checking it for coherency
* Tweak - Reduced file size by removing .po files and directing anyone creating or editing local translations to translate.wordpress.org
* Fix - Fix event bar issue where it was required to pick the date in order to search events via keyword or location [126158]
* Fix - Make back-compatibility handling more robust when dealing with classes non-existing in the older plugin versions [127173]

### [4.9.1.1] 2019-05-06

* Fix - Prevent Composer autoloader from throwing Fatal due to nonexistent `setClassMapAuthoritative()` method [126590]

### [4.9.1] 2019-05-02

* Fix - Prevent recurring events all page to throw 404 when events are in the past [126790]
* Fix - Backwards compatibility for `eventDisplay` usage around `list` and `day` only showing upcoming events [126686]
* Fix - List events Widget will display events until their end date has passed [126837]
* Tweak - Add values for the JSON-LD object to avoid Google console errors. Fields added: `offers.availability`, `offers.category`, `offers.priceCurrency`, `offers.validFrom` and `performer` [120193]
* Tweak - Add `tribe_events_cost_unformatted` filter to allow WPML support for WooCommerce Multilingual
* Language - 0 new strings added, 168 updated, 0 fuzzied, and 5 obsoleted

### [4.9.0.3] 2019-04-26

* Fix - Prevent Composer autoloader from throwing Fatal due to nonexistent `setClassMapAuthoritative()` method [126590]

### [4.9.0.2] 2019-04-25

* Fix - Avoid fatals due to Query method not been present by bumping version of Event Tickets required to 4.10.4.2

### [4.9.0.1] 2019-04-25

* Fix - Modifications to `tribe_get_events()` to resolve problems introduced by latest release `4.9.0`
* Fix - Backwards compatibility for `'eventDisplay' => 'upcoming'` on `tribe_get_events()`. Thanks @softwebteam, @mrwweb and @karks88 [126124]
* Fix - Single navigation to next and previous events using the Object Relational Mapping classes [126144]
* Fix - Events displayed correctly on all views, using End date instead of Start Date. Making sure events that are not over still show on upcoming [126259]

### [4.9.0] 2019-04-17

* Feature - Refactor the Database Connection to start using an Object Relational Mapping tool for a better tested codebase
* Feature - Add the `tribe_events()` function as entry-point to the Events ORM and the supporting filter code [116356, 115579]
* Feature - Add the `tribe_venues()` function as entry-point to the Venues ORM and the supporting filter code [116356, 115579]
* Feature - Add the `tribe_organizers()` function as entry-point to the Organizers ORM and the supporting filter code [116356, 115579]
* Feature - Add additional caching to The Events Calendar REST API archives and the Post Repository event/venue/organizer responses [117159]
* Feature - Include Freemius integration on to allow opt-in information collection for 10% of new users
* Tweak - Setting the site of Timezones will trigger queries using UTC to equalize event dates on Views
* Tweak - Add filter to allow deactivating Freemius `tribe_events_integrations_should_load_freemius`
* Tweak - Include a way for third-party to handle Known Range rebuilding of events `tribe_events_rebuild_known_range`
* Tweak - All new granular handling for UTC and Timezone saving on the Classic editor
* Tweak - Add support for the `tribe_suppress_query_filters` query variable to prevent the plugin's own query filters from applying [116356, 115579]
* Tweak - Add the `tribe_events_has_next_args` and `tribe_events_has_previous_args` filters to allow filtering the arguments that check if next/previous archive pages or events are available [123950]
* Fix - Include second param for the `the_title` for Events, Venue and Organizer Rest API endpoints amd prevent warnings. Props to Alex [123317]
* Language - 5 new strings added, 167 updated, 0 fuzzied, and 1 obsoleted

### [4.8.2] 2019-03-04

* Fix - Resolve console warnings around React key usage for Blocks Editor [121198]
* Fix - Improve our `tribe_paged` URL parameter sanitization, preventing themes from printing the variable and causing XSS security issues [123616]
* Fix - Change ordering for Eventbrite Tickets on Event Aggregator, Ascending order by date is now the default [121979]
* Tweak - Day light savings notice will now reset 4 times per year when using any UTC Timezone [123221]
* Tweak - Start date for Event Aggregator is now required on Eventbrite Tickets [121979]
* Language - 3 new strings added, 172 updated, 0 fuzzied, and 1 obsoleted

### [4.8.1] 2019-02-14

* Feature - Introduced new "(do not override)" default post status for Eventbrite imports in Event Aggregator. This preserves events' original statuses from Eventbrite.com upon import (e.g., "draft" events will not be automatically set to "publish" upon import) [112346]
* Fix - Make sure the setting for "Default mobile view" is respected. Thanks to Kathleen, Tim and others for reporting this! [119271]
* Fix - Apply block closer to price block [120108]
* Tweak - Added new filter `tribe_aggregator_new_event_post_status_before_import` to allow for custom handling of an event's post status before EA an import is completed [112648]
* Tweak - Added filters: `tribe_events_admin_js_ajax_url_data`
* Tweak - Unload Image Widget Plus version 1.0.2 or older to Prevent it from creating fatals on The Events Calendar
* Language - 2 new strings added, 150 updated, 1 fuzzied, and 0 obsoleted

### [4.8] 2019-02-04

* Feature - Introduced new "(do not override)" default post status for Eventbrite imports in Event Aggregator. This preserves events' original statuses from Eventbrite.com upon import (e.g., "draft" events will not be automatically set to "publish" upon import) [112346]
* Fix - Make sure the setting for "Default mobile view" is respected. Thanks to Kathleen, Tim and others for reporting this! [119271]
* Fix - Apply block closer to price block [120108]
* Tweak - Added new filter `tribe_aggregator_new_event_post_status_before_import` to allow for custom handling of an event's post status before EA an import is completed [112648]
* Tweak - Added filters: `tribe_events_admin_js_ajax_url_data`
* Tweak - Unload Image Widget Plus version 1.0.2 or older to Prevent it from creating fatals on The Events Calendar
* Language - 2 new strings added, 150 updated, 1 fuzzied, and 0 obsoleted

### [4.8.0.1] 2019-02-07

* Fix - Modify extension dependency checking with new system to determine if it can load [122368]
* Tweak - Prevent most extensions from loading if Event Tickets is on an older version to prevent conflicts [122368]

### [4.8] 2019-02-05

* Feature - Add check and enforce PHP 5.6 as the minimum version [116282]
* Feature - Add system to check plugin versions to inform you to update and prevent site breaking errors [116841]
* Tweak - Added filters: `tribe_not_php_version_names`
* Deprecated - Constants MIN_ET_VERSION and MIN_COMMON_VERSION in Tribe__Events__Main, use $min_et_version property and no replacement for MIN_COMMON_VERSION
* Deprecated - The `is_delayed_activation()`, `maybe_delay_activation_if_outdated_common()`, and `checkAddOnCompatibility()` method has been deprecated in `Tribe__Events__Main` in favor of new Dependency Checking System
* Language - 7 new strings added, 139 updated, 0 fuzzied, and 1 obsoleted

### [4.7.4] 2019-01-21

* Fix - Display the tags block delimiter in the editor [119393]
* Fix - Fixed a number of small layout bugs with the new Twenty Nineteen core theme [119689]
* Fix - Save the "Event Options" when using the block editor [120168]
* Fix - Filter correctly when in Classic Editor page [120137]
* Fix - Give the ability to switch back from all day events in date time block [120266]
* Fix - Properly align the search or create results [120460]
* Fix - iCal export content for events created with the block editor [118679]
* Fix - Moved the "Remove venue" button for a better user experience when removing venues from an event [120267]
* Fix - Date/time block conflicts when clicking to open the block options [119413]
* Fix - Layout bugs with the new Twenty Nineteen core theme [119689]
* Fix - Include UTC dates meta on the event creation from the block editor [120399]
* Tweak - Ensure we don't re-apply `wpautop()` to content that has had it removed [120562]
* Tweak - Added `tribe_events_admin_js_ajax_url_data` filter to make filtering the JS vars of TEC's admin JS easier [116973]
* Tweak - Adjusted content in the admin welcome page that users are brought to upon newly activating The Events Calendar [117795]
* Tweak - Changed views: `blocks/event-tags`
* Language - 3 new strings added, 21 updated, 1 fuzzied, and 5 obsoleted

### [4.7.3] 2018-12-19

* Tweak - Tweak the registration of the Event, Venue, and Organizer post types so they use some new post type labels introduced in WordPress 5.0 like `item_updated`, `item_scheduled`, etc. [119451]
* Fix - Password protected events breaking the month view. Thanks to Lindsay, Simon and others for flagging this out! [117385]
* Fix - Add proper capitalization for Event Price for Blocks Editor [119140]
* Fix - Make sure Datetime Format for Datepickers are respected on the Blocks Editor [117428]
* Fix - Correct text domain and remove old `events-gutenberg` [118656]
* Fix - Properly display recurrence description on Blocks Editor view [119354]
* Fix - Point support links to the correct places [117795]
* Language - 27 new strings added, 106 updated, 0 fuzzied, and 13 obsoleted

### [4.7.2] 2018-12-13

* Feature - Added new action `tribe_events_before_event_template_data_date_display` and `tribe_events_after_event_template_data_date_display`
* Tweak -  Corrected font on time picker components in Event Date Time block [116907]
* Tweak -  Adjusted padding on the Event Date Time block [118697]
* Tweak -  Set default start time to 8:00am and default end time to 5:00pm in Event Date Time block [118112]
* Fix -  Corrected an issue where feature detection of async-process support would fire too many requests [118876]
* Fix - Removed tribe_events_template_data()'s dependency on Events Calendar PRO, which could lead to a fatal error under some conditions [119263]
* Fix - Made the Event Date Time block respect the timezone settings [118682]
* Fix - Removed Price block dashboard gap [118683]
* Fix - Made sure all block editor code for Meta saving is PHP 5.2 compatible
* Fix - Prevented `undefined` from been displayed at the Event Date Time separator fields [119337]
* Fix -  Solved 500 error when trying to update an event [118058]s

### [4.7.1] 2018-12-05

* Feature - Added additional caching to TEC REST API archives and the Post Repository event/venue/organizer responses [117159]
* Feature - Added new `tribe_events_set_month_view_events_from_cache` action to make it easier to listen for when Month View events are retrieved from the Month View cache [116124]
* Fix - Importing CSV files with whitespace at the beginning of the rows won't remove headers and skip columns on Preview [117236]
* Fix - Prevent JavaScript error in Month View when the Date filter is removed from the Tribe Bar (thank you to @tyrann0us on GitHub for submitting this fix!) [116995]
* Fix - Facilitate automated updates for Events Calendar PRO even if it's requirements have not been met

### [4.7.0.1] 2018-11-30

* Fix - Update common library to maximize compatibility with earlier PHP versions (our thanks to @megabit81 for highlighting this problem) [119073]
* Fix - Update common library to ensure better compatibility with addons running inside multisite networks [119044]
* Language - 0 new strings added, 141 updated, 0 fuzzied, and 0 obsoleted

### [4.7] 2018-11-29

* Feature - added new setting to activate the block editor on events for users running the WordPress 5.0 beta.
* Feature - added an Event Date Time block to add and display the event date and time
* Feature - added an Event Price block to add and display the event price and optional event description
* Feature - added an Event Organizer block to add and display an organizer on an event single
* Feature - added an Event Venue block to add and display the event venue information including optional link or map
* Feature - added an Event Website block to add and display an external website link as a button with custom label
* Feature - added an Event Sharing block to display event export options and allow for more customization
* Feature - added an Event Details Classic block to maintain a combined content display as in the classic editor
* Feature - added a Featured Image block to display an event’s featured image in the editor content
* Feature - added a Tags block to display an event’s tags in the editor content
* Feature - added an Event Categories block to display an event’s categories in the editor content
* Feature - added a new Events Blocks section to the block inserter
* Tweak - Added filters: `tribe_blocks_editor_update_classic_content_params`, `tribe_blocks_editor_update_classic_content`, `tribe_events_editor_default_classic_template`, `tribe_events_editor_default_template`, `tribe_events_google_maps_api`, `tribe_events_editor_assets_should_enqueue_frontend`, `tribe_events_single_map_zoom_level`, `tribe_events_single_event_time_formatted`, `tribe_events_single_event_time_title`, `tribe_events_event_block_datetime_use_yearless_format`, `tribe_get_event_website_link_target`, `tribe_events_single_event_time_formatted`, `tribe_events_single_event_time_title`
* Tweak - Added actions: `tribe_blocks_editor_flag_post_classic_editor`, `tribe_events_editor_register_blocks`, `tribe_events_single_event_meta_primary_section_start`, `tribe_events_single_event_meta_primary_section_end`, `tribe_events_single_event_meta_secondary_section_start`, `tribe_events_single_event_meta_secondary_section_end`, `tribe_events_single_meta_details_section_start`, `tribe_events_single_meta_details_section_end`, `tribe_events_single_meta_map_section_start`, `tribe_events_single_meta_map_section_end`, `tribe_events_single_meta_organizer_section_start`, `tribe_events_single_meta_organizer_section_end`, `tribe_events_single_meta_venue_section_start`, `tribe_events_single_meta_venue_section_end`
* Tweak - Changed views: `blocks/classic-event-details`, `blocks/event-category`, `blocks/event-datetime`, `blocks/event-links`, `blocks/event-organizer`, `blocks/event-price`, `blocks/event-tags`, `blocks/event-venue`, `blocks/event-website`, `blocks/featured-image`, `blocks/parts/details`, `blocks/parts/map`, `blocks/parts/organizer`, `blocks/parts/venue`, `silence`, `single-event-blocks`, `single-event`, `single-event/back-link`, `single-event/comments`, `single-event/content`, `single-event/footer`, `single-event/notices`, `single-event/title`
* Language - 11 new strings added, 0 updated, 0 fuzzied, and 30 obsoleted

### [4.6.26.1] 2018-11-21

* Fix - Resolved a compatibility issue with WordPress version 4.7.11 and earlier (our thanks to @placer69 and @earthnutvt for flagging this) [118627]

### [4.6.26] 2018-11-13

* Fix - Fixed the setting-up of strings in the Tribe Bar datepicker to ensure they're translatable into languages other than English [115286]
* Tweak - Improved the legibility of text in Featured Events that are in the Event List widget [116702]
* Tweak - Clarified a number of maps-related settings strings [114865]

### [4.6.25] 2018-10-22

* Fix - List only enabled views on the "Default View" option. Thanks to @wescole, John Meuse and others for reporting! [114807]
* Fix - Handle left-over Facebook scheduled imports and notices [114831]
* Fix - Fixed event navigation when the mini calendar widget was on the event page. Props to Matt and @wescole for flagging this [114359]
* Fix - Ensure columns without headers are handled in CSV imports [114199]
* Tweak - Added notice for the Events Gutenberg extension and eBook download [115543]
* Tweak - Avoid unnecessary HTTP calls in the Settings screens [114013]
* Tweak - Show only applicable refinements for the Eventbrite source types in Event Aggregator imports [107009]
* Tweak - Added `tribe_aggregator_resolve_geolocation` filter to allow for disabling of Geocoding using the EA service [114171]
* Tweak - Added `tribe_aggregator_clean_unsupported` filter to specify whether unsupported origin records should be removed or not

### [4.6.24.1] 2018-10-08

* Fix - Fixed an issue where a fatal error could be generated when trying to save a new Event Aggregator scheduled import [115339]
* Fix - Handle left-over Facebook scheduled imports and notices [114831]
* Tweak - Added the `tribe_aggregator_import_setting_origins` filter to the origins available for default import settings [115704]

### [4.6.24] 2018-10-03

* Fix - Prevent broken and low-resolution Google Maps if user has not provided a Google Maps API key of their own by providing our own fallback API key [114442]
* Fix - Only load widget assets when widget is active on the page [113141]
* Fix - Ensure that venue, organizer, and meta information doesn't show on password-protected events [102643]
* Fix - Correct the Google Maps API link in the Settings help text to point to the correct API page [112322]
* Fix - Restores the event categories and tags creation summary in CSV imports [105888]
* Fix - Updated the Events Gutenberg extension install check to show only when the extension is not active [114577]
* Fix - Stop potential fatal errors from debug logging when running EA import actions from command line [114555]
* Fix - Fixed a bug where it was often not possible to un-check the "Enable JSON-LD" option in the Events List Widget (thanks to @myrunningresource and @craigwilcox for reporting this!) [113541]
* Fix - Ensure that the `tribe-events-bar-should-show` filter functions as expected; if `__return_false` is passed, the Tribe Bar will be totally hidden (thanks @debranettles for reporting this!) [112260]
* Fix - Added checks to prevent JS Type Error in mobile view. Thanks @szenenight, @agrilife and others for flagging this! [113524]
* Tweak - Added the `tribe_events_month_daily_events` filter to the Month view [114041]
* Tweak - Move Google Maps API loading to tribe_assets and only load once on single views when PRO is active, thanks to info2grow first reporting [112221]
* Tweak - Accept 0 as an argument in tribe_get_events() so that `'post_parent' => 0` works, thanks Cy for the detailed report [111518]
* Fix - handle left-over Facebook scheduled imports and notices [114831]
* Tweak - Added new filters for customizing the fallback Google Maps embeds: `tribe_is_using_basic_gmaps_api`, `tribe_get_basic_gmap_embed_url`, and `tribe_get_basic_gmap_embed_url_args` [114442]
* Tweak - Fixed the handling of the global $post variable in some Month View templates to make it easier for themers to customize those templates [113283]
* Tweak - Ensure linked posts are listed alphabetically in metabox dropdowns, as they are in all other admin locations [108120]
* Tweak - Added the `tribe_events_month_daily_events` filter to the Month view [114041]
* Tweak - Move Google Maps API loading to tribe_assets and only load once on single views when PRO is active, thanks to info2grow first reporting [112221]
* Tweak - Accept 0 as an argument in tribe_get_events() so that `'post_parent' => 0` works, thanks Cy for the detailed report [111518]
* Tweak - Added the `tribe_aggregator_record_by_origin` filter to allow new EA origins [114652]
* Tweak - Added the `tribe_aggregator_service_post_import_args` filter to allow new EA origins [114652]
* Tweak - Added the `tribe_aggregator_import_validate_meta_by_origin` filter to allow new EA origins [114652]
* Tweak - Added the `tribe_events_aggregator_refine_keyword_exclusions` filter to allow new EA origins [114652]
* Tweak - Added the `tribe_events_aggregator_refine_location_exclusions` filter to allow new EA origins [114652]
* Tweak - Added the `tribe_aggregator_event_translate_service_data_field_map` filter to allow new EA origins [114652]
* Tweak - Added the `tribe_aggregator_event_translate_service_data_venue_field_map` filter to allow new EA origins [114652]
* Tweak - Added the `tribe_aggregator_event_translate_service_data_organizer_field_map` filter to allow new EA origins [114652]
* Tweak - Added the `tribe_events_status_third_party` action to allow new EA origins [114652]
* Tweak - Added the `tribe_events_aggregator_import_form` action to allow new EA origins [114652]
* Tweak - Added `$origin_show_map_options` parameter to the `tribe_aggregator_fields` filter to allow new EA origins to make use of them [114652]
* Fix - Fixed an issue where a fatal error could be generated when trying to save a new Event Aggregator scheduled import [115339]

### [4.6.23] 2018-09-12

* Fix - Fixed the "Full Styles" mobile view. Thanks Matthew, Laura and others for flagging this! [112301]
* Fix - Modify resource url function to work in mu-plugin directory, thanks to Doug for reporting it  [86104]
* Fix - Remove references to and settings for Facebook importing in Event Aggregator [112432]
* Fix - Ensure Event Aggregator allows for importing events from Eventbrite sites other than Eventbrite.com, including but not limited to Eventbrite.ca, .co.uk, and .co.nz [107821]
* Fix - Allow venue location fields to be intentionally empty on Venue Singular REST API calls [108834]
* Tweak - Add the WordPress Custom Fields Metabox show|hide settings from the Events Calendar Pro [109815]
* Tweak - Allow changing Event Aggregator import process system between the asynchronous and the cron-based one; previously only available as a filter [113418, 113475]
* Tweak - Allow stopping and clearing asynchronous queue processes from the admin UI [113418, 113475]
* Deprecated - `Tribe__Events__Aggregator__Record__Facebook`

### [4.6.22.1] 2018-08-27

* Fix - Allow user to choose venues not created by them. Props to @integrity, @nomadadmin, and many others for reporting this! [113147]

### [4.6.22] 2018-08-22

* Add - Allow filtering events, in REST API requests, by their post ID with `include` [94326]
* Add - Enable future event display to get all events in the future that have not started [70769]
* Add - Allow filtering events, in REST API requests, by their post ID with `include` [94326]
* Add - Enable future event display to get all events in the future that have not started [70769]
* Fix - Prevent subsequent CSV imports from duplicating events in some instances [102745]
* Fix - The "Import events but preserve local changes to event fields" Event Aggregator change authority setting will now behave as expected [87443]
* Fix - Multiple fixes regarding linked post types (e.g. Organizers and custom post types) - props to @natureslens and others for reporting these [105116]:
  * Now correctly saves in their drag-and-drop order
  * Deprecated the functions added in version 4.6.13 that previously attempted to fix ordering logic but was not done in a backwards-compatible way: `get_order_meta_key()` and `tribe_sanitize_organizers()`
  * We no longer rely on a separate postmeta value dedicated to ordering linked posts (e.g. `_EventOrganizerID_Order`), and you may want to remove all such values from your database after re-saving any events that have linked posts and their ordering is important
  * `tribe_get_linked_posts_by_post_type()` now works as expected, no longer returning zero results in error, nor returning all of the post type's posts if there are none linked. The `tribe_events_return_all_linked_posts_if_none` filter was added, as it is necessary for this fix.
  * Editing an existing event no longer loses the linked posts just because they were not part of the submission. Example of the bug in prior versions: If organizers are editable in the wp-admin event edit screen but not on the Community Events "event edit" form (via template override or other custom code), all pre-existing organizers were removed in error.
* Fix - Handle the case where Event Aggregator import queues might get stuck when deleting import records [111856]
* Fix - Only show admin notice when it is a top-level page with the event slug, thanks to MikeNGarrett for the code fix! [111186]
* Fix - Change template_redirect to an action for some legacy view redirects, thanks @barryceelen! [110463]
* Fix - Correctly import and set Organizers for iCal and ICS files Event Aggregator imports [96059]
* Fix - Retain category title in month view and month view shortcode, thanks corthoover for the first report [108258]
* Fix - The "Import events but preserve local changes to event fields" Event Aggregator change authority setting will now behave as expected [87443]
* Fix - Handle the case where Event Aggregator import queues might get stuck when deleting import records [111856]
* Fix - Prevent subsequent CSV imports from duplicating events in some instances [102745]
* Fix - Fix the classic header option not working. Thanks @hanemac, David Luyendyk and others for flagging this! [111672]
* Tweak - Namespace javascript debug function to prevent conflicts causing a function found, thanks to Tom-Mulvey for the fix [110462]
* Tweak - Add venue name to address string for iCal and gCal export, thanks for the coding from @sylviavanos [110464]
* Tweak - Drop the order from the query WPML linked query as it is set later in the method, thanks to @dgwatkins for the PR [110459]
* Tweak - Display JS debug messages only if setting is set or through the `tribe_events_js_debug` filter. Thanks to Rob, @aand and others for flagging this! [82781]

### [4.6.21] 2018-08-01

* Add - Make global $post obj available to tribe_events_get_the_excerpt() with setup_postdata($post) [108043]
* Add - Added WPML metadata improvements for Organizers and Venue. Thanks to David Garcia Watkins and the entire WPML team for their contribution [106798]
* Fix - Ensure no console errors are being displayed if there's no Google Maps API key present. Thanks Greg for flagging this [95312]
* Fix - Fixed an issue where saving Event Aggregator scheduled imports with an empty preview would generate PHP notices [110311]
* Fix - Escape each closing html element in month view tooltip to prevent PHP parser from exposing html, thanks to Karen for a solution [64834]
* Fix - Sending empty 'categories' and 'tags' for the REST API event endpoints when inserting and updating events [109627]
* Fix - Prevent selection of past dates when setting up Scheduled Other URL Imports in Event Aggregator [111227]
* Tweak - Manage plugin assets via `tribe_assets()` [40267]
* Deprecated - Tribe__Events__Asset__Abstract_Asset in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Abstract_Events_Css in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Admin_Menu in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Admin_Ui in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Admin in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Ajax_Calendar in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Ajax_Dayview in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Ajax_List in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Bootstrap_Datepicker in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Calendar_Script in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Chosen in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Datepicker in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Dialog in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Dynamic in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Ecp_Plugins in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Events_Css_Default in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Events_Css_Full in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Events_Css_Skeleton in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Events_Css in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Factory in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Jquery_Placeholder in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Jquery_Resize in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__PHP_Date_Formatter in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Settings in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Smoothness in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Tribe_Events_Bar in favor of using `tribe_asset`
* Deprecated - Tribe__Events__Asset__Tribe_Select2 in favor of using `tribe_asset`

### [4.6.20.1] 2018-07-10

* Fix - Fix an issue where Event Aggregator imports might get blocked at 1% progress [110258]
* Fix - Fix the error displayed when navigating the month view via shortcode. Thanks Lam, @ltcalendar, Disk and others for flagging this! [109589]

### [4.6.20] 2018-07-09

* Feature - Add featured event column support for CLI imports [108027]
* Fix - Display the exact search term in the "no results" notice on the events page [106991]
* Fix - Allow venue and organizer fields to be intentionally empty on Event Singular REST API calls [109482]
* Fix - Added basic checks to prevent saving obviously-invalid event meta values, such as sending `EventStartMinute` of `60` (since it should be 0-59) to `tribe_create_event()`. This prevents falling back to "zero" values (e.g. Unix Epoch) when another value was intended. Thanks to @compton-bob for flagging this via our Help Desk. [109722]
* Fix - Add Privacy Policy guide for The Events Calendar [108454]
* Tweak - Added event ID parameter to `tribe_events_event_classes` filter to make it more useful [64807]
* Tweak - Added the `tribe_aggregator_record_finalized` action to allow developers to act before Event Aggregator imports start [109938]

### [4.6.19] 2018-06-20

* Feature - CSV importer now supports a featured event column [72376]
* Add - Add Eventbrite Icon to Third Party Accounts on the help page [105388]
* Add - Accessibility repair: new title-bar template for loop views included above the filter bar and content containing the page title in a `h1` tag.
* Fix - Accessibility repair: adjust main content container element from `div` to `main`.
* Fix - More robust handling of errors and exceptions during Event Aggregator imports [107929]
* Fix - Ensure that the "Export Events" button is properly displayed in month view when paginating. Thanks to @linpleva, Steven, Will and others for flagging this! [104751]
* Fix - Month view pagination for datepicker formats: YYYY.MM.DD, MM.DD.YYYY, and DD.MM.YYYY. Thanks @netzwerk, @wdburgdorf, @oliverwick and others for notifying us! [105443]
* Fix - Resolved customizer inconsistencies with month/week views and full styles [69758]
* Fix - Check the Events Aggregator license each time the page is accessed [67864]
* Fix - Improve Event Import message responses from Event Aggregator for certain cases where "Unknown service message" would be returned [107606]
* Fix - Make the date picker respect the "Start of the week" Setting. Thanks to @websource, @dsb and others for flagging this! [76320]
* Fix - Correct the "View All" link when using the events month view and plain permalinks. props to Kay and Robert for notifying us [72544]
* Fix - Keep filter bar date when changing from month to list view, with all datepicker formats. Thanks to Caio for reporting this! [83018]
* Fix - Correct the pagination in list view when a keyword is being searched. Thanks to @versi, @akr and Mary for reporting this! [94613]
* Fix - Split linked posts (Organizers and Venues) by ownership, for all users [71349]
* Fix - The connected status for Eventbrite under Third Party Accounts on the Help page [106868]
* Fix - Fixed two PHP 5.2 errors on the Events > Help page [108338]
* Fix - Display the correct Import Settings when Eventbrite Tickets is enabled [106947]
* Tweak - Modify the default values for the CSV settings if there's no EA license [94426]
* Tweak - Added classes to meta output in Single Event meta templates to facilitate customization [62704]
* Tweak - Add the `tribe_aggregator_async_insert_event` filter to allow overriding the Event Aggregator asynchronous event insertion [107929]
* Tweak - Add the `'tribe_aggregator_async_import_event_task` filter to allow overriding the Event Aggregator asynchronous import task [107929]
* Tweak - Added venue google map link to events in Day view [91610]
* Tweak - Renamed the Time zone mode option "Use the local time zones for each event" to "Use manual timezones for each event" (thanks @hikeitbaby for the suggestion) [67148]
* Tweak - Accessibility repair: heading hierarchy improvements throughout.
* Tweak - Accessibility repair: make sure all elements have unique `id` attributes.
* Tweak - Accessibility repair: remove redundant tab stops on feature image links.
* Tweak - Accessibility repair: filter bar view selector adjustments.
* Tweak - Accessibility repair: provide meaningful aria labels for filter bar inputs.
* Tweak - Accessibility repair: hide Google Map embeds from screen readers.
* Tweak - Enable only url imports for Eventbrite when that plugin is not active [107415]
* Tweak - The EB 4.5 migration process to better detect events for migration and insure all fields are migrated [106623]
* Tweak - Add `tribe_events_month_has_events_filtered` function and filter to see if there are events on a certain month, with filters (categories, search) [67607]
* Language - 68 new strings added, 406 updated, 3 fuzzied, and 37 obsoleted

### [4.6.18] 2018-06-04

* Add - Eventbrite to Event Aggregator import origins [61172]
* Add - Priority attribute to Import Setting fields to be able to customize order of fields [61173]
* Add - Default category and change authority for Eventbrite Imports [61173]
* Add - Ability to schedule Eventbrite imports through Event Aggregator [35454]
* Add - Preview for Eventbrite events in the import screen ordered from farthest future event to closest [70130]
* Add - Import Eventbrite events using the Other URL import origin [81825]
* Add - Ability to preview and import multiple Eventbrite events using the Organizer URL [94284]
* Add - Import from Eventbrite Location Search URL, i.e. https://www.eventbrite.com/d/or--portland/events/ [94588]
* Tweak - Move Eventbrite settings from Legacy Import to Settings Import Tab [94388]
* Tweak - Add Eventbrite imports to the Import History Tab [81826]
* Tweak - Remove Legacy Imports UI [81829]

### [4.6.17] 2018-05-29

* Tweak - Add tribe_redirected parameter to enable a visitor to select another view after default mobile redirect, thanks to Marcella for notifying us [102743]
* Fix - Hide any errors generated by servers that don't support `set_time_limit()` (props to @jsww for flagging this!) [64183]
* Fix - Add a warning when the site Timezone is set to UTC [105217]
* Fix - An issue with organizers and venues not being attached to events on Eventbrite import  [106869]
* Language - 4 new strings added, 170 updated, 1 fuzzied, and 0 obsoleted

### [4.6.16] 2018-05-16

* Tweak - Replaced the Aggregator queue processing system to run independently of WP Cron (not for CSV) [105650]
* Fix - Prevents notices for Events Community when handling State and Province fields [106415]

### [4.6.15] 2018-05-09

* Feature - Added wp-cli command to import events from a source with Event Aggregator. See `wp event-aggregator import-from --help` to know more [104426]
* Feature - Added wp-cli command to run scheduled imports with Event Aggregator. See `wp event-aggregator run-import --help` to know more [104426]
* Fix - Ensure that organizers can be deleted when an event has multiple organizers [103715]
* Fix - Fixed a bug where the `[tribe_events]` Month View pagination would fail when no Tribe Bar was visible and plain permalinks were being used [95720]
* Fix - Prevent `url_to_postid` from running when on the main events page to avoid query conflicts [94328]
* Fix - Prevent 404s and malformed URLs that would sometimes arise when navigating to a past-events view from the "All"-events view on a single recurring event [43925]
* Fix - Make the `[tribe_events]` shortcode's output scroll to top when using the List View to match the non-shortcode List View  [81509]
* Fix - Ensure that default venue and address values are used throughout various venue-creation forms [63915]
* Tweak - Honor the return types for `tribe_has_next_event` and `tribe_has_previous_event` when the global query is null
* Language - 28 new strings added, 290 updated, 29 fuzzied, and 7 obsoleted

### [4.6.14.1] 2018-04-18

* Fix - Fixed fatal error that would sometimes arise when The Events Calendar was set to display on the front page

### [4.6.14] 2018-04-18

* Fix - Updated the "front page" logic to store the value in the DB instead of "mocking" the view via JS [100832]
* Fix - Fixed the generation of PHP warnings on retrieval of posts if the "Include events in main blog loop" option is checked (thanks to Colin Carmichael for reporting this problem) [97667]
* Fix - Made the `tribe-ea-record` custom post type (used to store Event Aggregator record information) private [99106]
* Fix - Expanded the size of the time zone input in the admin to allow for better visibility for long names [100363]
* Fix - If the main events page is set to be the site's front page, ensure it shows as "selected" in the Customizer's front page option [100832]
* Fix - Fixed an issue where failed Event Aggregator scheduled imports would re-attempt the import too soon [102489]
* Fix - Ensure the Tribe Bar displays all the available ranges of dates and times [100646]
* Fix - Hid the filters in the Tribe Bar if a unique view is enabled [75114]
* Fix - Fixed some imported-event handling so that events with no time and that aren't all-day events do not display on the front-end [93979]
* Fix - Changed the HTTP status codes of empty event, venue, organizer, category, and tag archives from 404 to 200 and return empty arrays to stick with WP REST API standard [102283]
* Fix - Better "guessing" on column mapping during the import of CSV file (thanks to April in our Help Desk for flagging this problem!) [96162]
* Fix - Add new `tribe_events_linked_post_type_meta_key` filter, required to be set for each custom linked post type, to output custom linked post types in their drag-and-drop order (thanks @natureslens for highlighting the issue) [100733]
* Tweak - Added the `tribe_aggregator_find_matching_organizer` and `tribe_aggregator_find_matching_venue` filters in Events Aggregator to allow the definition of custom Venue and Organizer match criteria [97292]
* Tweak - Display the retry time for a failed Event Aggregator scheduled import in the Scheduled tab [102489]
* Tweak - Add new filter, `tribe_events_import_event_duplicate_matches`, to determine if an event is part of the duplicates matches [77956]
* Tweak - Ensure "secondary" maps, e.g. in the sidebar, have the same full-width behavior as "main" maps [74052]
* Tweak - Restore some missing header navigation elements [99742]
* Tweak - Add notice if an import is missing required columns [67886]
* Tweak - Save time zone and time zone abbreviation fields (if provided) even if date was not changed when saving event through API [102705]

### [4.6.13] 2018-03-28

* Feature - Added facilities allowing users to trash or permanently delete expired events [98826]
* Fix - Corrected the behavior of the previous/next event links rendered on single event pages (props to @jeremyfelt for fixing this) [101757]
* Fix - Save order of organizers as displayed in the admin (thanks to JobInfo and others for report) [79126]
* Tweak - Added Gutenberg compatibility for the Gutenberg Extension plugin
* Tweak - Added new filter `tribe_tickets_venue_action_links_edit_url` to modify the venue edit link for the sales and attendee reports [93923]
* Tweak - Altered day view to start at 00:00:00 and not 00:00:01 [99641]

### [4.6.12] 2018-03-08

* Fix - Resolved an oversight resulting in notice-level errors when the `tribe_event_is_on_date()` function was called incorrectly (props to @sharewisdom for pointing this out) [99117]
* Fix - Resolved errors within the admin environment when the "ticketed" view of events is generated [99266]
* Fix - Improved compatibility with WordPress SEO in relation to the default mobile events view [68716]
* Fix - Resolved Javascript errors in month view which were triggered under some conditions by the presence of password-protected events [99089]
* Fix - Improved logic responsible for identifying which events are expired (in the past) by using timezone-aware comparisons [91168]
* Fix - Corrected the export of upcoming events from single organizer pages (added to support changes in Events Calendar PRO) [70727]
* Tweak - Added safety checks around our use of the global $wp_query object (thanks @archetypalsxe for highlighting this issue!) [100199]
* Tweak - Renamed 'Use Javascript to control date filtering' option to 'Enable live refresh' and improved the associated helper text [98022]
* Tweak - Added caching to reduce the number of HTTP requests being made in relation to Event Aggregator within the admin environment [99486]
* Tweak - Improved performance by reducing the number of queries that run in single event pages (in relation to `tribe_get_prev_event_link()` and `tribe_get_next_event_link()` specifically) [94587]
* Tweak - Added pagination to single organizer and venue pages [97772]
* Tweak - Improved compatibility with the Twenty Seventeen theme (ensuring the calendar is full-width if set to be the site's homepage) [97977]
* Language - 3 new strings added, 161 updated, 1 fuzzied, and 2 obsoleted

### [4.6.11.1] 2018-02-16

* Fix - The render of the venue and organizer templates (thanks to Antonio and others for reporting this in our forums) [99550]
* Fix - Make sure events on calendar are not affected by DST changes [99537]

### [4.6.11] 2018-02-14

* Fix - Ensure parity of CSS styles between the default Month View and the embedded Month Views generated by Events Calendar PRO's [tribe_events] shortcode (thanks @copoloff for reporting this bug!) [92329]
* Fix - If `tribe_ical_feed_calname`  is empty the property `X-WR-CALNAME` is not added to the .ics file [46620]
* Fix - Stopped modifications of the main query if is in a single post to allow custom variables don't affect the page loading when using shortcode (our thanks to Joseph Reckley and others for highlighting this problem) [91787]
* Tweak - Fixed a handful of small CSS bugs in the mobile views of the Twenty Sixteen, Twenty Fifteen, and Twenty Fourteen themes [95693]
* Tweak - Added new hooks (`tribe_events_ical_before`, `tribe_events_ical_events_list_args` and `tribe_events_ical_events_list_query`) to allow further customization of the iCal feed [86227]
* Tweak - Added safeguards to reduce conflicts when lodash and underscore are used on the same site [92205]
* Language - 0 new strings added, 41 updated, 0 fuzzied, and 0 obsoleted

### [4.6.10.1] 2018-01-26

* Fix - Make sure rewrite rule for `/events` is not hardcoded and is based on dynamic option field (thanks to @earnjam and others for flagging this problem) [98463]

### [4.6.10] 2018-01-23

* Fix - Allow The Events Calendar REST API to be disabled using the `tribe_events_rest_api_enabled` filter [97209]
* Fix - Remove the errant `div.tribe-events-single-section` on the single event view when there is no venue [97615]
* Fix - Make sure the date for past events is set to the current date not the end of the day of the current date [71936]
* Fix - Use `featured_color_scheme_custom` if present as mechanism to overwrite the default color scheme for highlight color [96821]
* Fix - Make sure the date for past events is set to the current date not the end of the day of the current date [71936]
* Tweak - Trigger an event `map-created.tribe` when a map is created to allow flexibility on customization [91984]
* Tweak - Add a link to the knowledge base about 'Setting Up Your Google Maps API Key' [89761]
* Tweak - Add `the_title` filter to events called by `tribe_events_template_data` [38237]
* Tweak - Made the "events" and "event" slugs translatable by WPML and other multilingual plugins [95026]
* Tweak - Introduced the `tribe_events_query_force_local_tz` filter to allow for forcing non-UTC event start and end times in Tribe__Events__Query [92948]
* Tweak - Prevent empty or otherwise-invalid values for various date-format options in the Display settings [94725]
* Tweak - Brought day number headers in the Month View into compliance with WCAG 2.0 accessibility standards when using the "Tribe Events" stylesheet [68411]
* Tweak - Improved the alignment of the event cost on the single-event view (props to @canberraclimbersassociation for reporting this bug) [97208]
* Tweak - Added some more context to the labeling of the "Number of events per page" option (thanks to Todd H. for highlighting this label) [73659]
* Tweak - Improve performance on Event Admin List Count by removing JOIN and use cached results [63567]
* Tweak - Made the "/page/" component of some views' URL string translatable [40976]
* Tweak - Button "Merge Duplicates" is always visible from now on [75208]
* Tweak - Allow queries to explicitly include or exclude events that are nominally hidden from event listings [91254]

### [4.6.9] 2018-01-10

* Feature - Add new utility functions tribe_is_events_home and tribe_is_events_front_page similar to native WP is_home and is_front_page [42195]
* Fix - Avoid issues when importing multiple organizers that specify images [96354]
* Fix - Make sure latitude and longitude information from iCal feeds is used if available [96363]
* Fix - Fixed an issue that prevented EA from importing images attached to Facebook events [96393]
* Fix - Remove the duplicate filter call that was running twice for `tribe_rest_venue_data` [96090]
* Tweak - Added new `tribe_aggregator_import_event_image`, `tribe_aggregator_import_venue_image` and `tribe_aggregator_import_organizer_image` filter so that users can control whether, during EA imports, images should be attached to post or not [96393]
* Tweak - Made it possible to translate the iCal feed's description field (props @gafderks) [96677]
* Tweak - Improved escaping of map IDs (props LucaPipolo) [96772]
* Tweak - Added new REST API endpoint that allows looking up organizers by slug instead of ID at the path `organizers/by-slug/{slug}/`, it has the same functionality as the endpoint `organizers/{ID}` [96088]
* Tweak - Added new REST API endpoint that allows looking up venues by slug instead of ID at the path `venues/by-slug/{slug}/`, it has the same functionality as the endpoint `venues/{ID}` [96088]
* Tweak - Added `slug` to the REST API responses for organizer and venue data [96088]
* Tweak - Added `slug` to the REST API parameters allowed to use when inserting or updating an organizer or event [96088]
* Tweak - Added action: `tribe_events_venue_save` [96069]
* Tweak - Added action: `tribe_events_organizer_save` [96069]
* Tweak - Added filter: `tribe_events_rest_venue_prepare_postarr` [96069]
* Tweak - Added filter: `tribe_events_rest_organizer_prepare_postarr` [96069]
* Tweak - Old `tribe_rest_venue_data` filter was passing the venue and the event two the second parameter because of the duplication. Now it has the second parameter as $venue, third parameter as $event if event ID was provided [96090]
* Language - 5 new strings added, 30 updated, 0 fuzzied, and 0 obsoleted

### [4.6.8] 2017-12-18

* Fix - Preserve filter bar checkbox selections when changing views [66749]
* Fix - Fix radio filters so they are only included as values when switching views when checked [72954]
* Fix - Ensure the correct properties are set for list widget queries, to avoid problems when running alongside Events Calendar PRO (props @KZeni) [94105]
* Fix - Fixed some layout issues with the "Buy Now" button and stock labels on mobile list views [81115]
* Fix - Fixed issue where left- or right-aligned images at the bottom of event descriptions would overlap event meta on single-event pages [71134]
* Fix - Fixed issue where Google Maps Link would display in some situations even when there is no address information for which to generate a link. [94909]
* Fix - Corrected reference to a Select2 asset (our thanks to @pyxis630 for flagging this problem and props to @andrasguseo for the fix) [95348]
* Fix - Ensure that when start and end dates are passed to the REST API, all events within the date range are correctly retrieved (thanks @braffenberg and others for highlighting this issue!) [90005]
* Tweak - Added Google Maps API key to all Google Maps URLs when the key is available, allowing maps to load more reliably on some hosting environments (props to @sfdfortnight, @thor, and many others for reporting this!) [62910]
* Tweak - Adjusted CSS to improve the display of venue URLs/phone numbers (especially when Events Calendar PRO is also active) (our thanks to Mathew on the forums for flagging this issue) [69127]
* Tweak - Added new REST API endpoint that allows looking up events by slug instead of ID at the path `events/by-slug/{slug}/`, it has the same functionality as the endpoint `events/{ID}` [92825]
* Tweak - Added `slug` to the REST API responses for event data [92825]
* Tweak - Added `slug` to the REST API parameters allowed to use when inserting or updating an event [92825]
* Tweak - Added new `tribe_events_rest_use_inclusive_start_end_dates` filter so that users can make the REST API return events from a more literal date range [90005]
* Language - 3 new strings added, 68 updated, 0 fuzzied, and 0 obsoleted

### [4.6.7] 2017-12-07

* Fix - Fixed an issue where EA imports might not correctly create venues for iCalendar imports (thanks @starweb and others for highlighting this issue) [94323]
* Fix - Fixed an issue where Month View wouldn't render correctly in X Theme with the "Events template" option set to "Default Page Template" [92554]
* Fix - Fixed a WPML incompatibility issue where language could be switched to the wrong one (thanks @dgwatkins) [94732]
* Tweak - Added the `tribe_events_x_theme_force_full_content()` filter to let users disable X Theme compatibility code [92554]
* Language - 0 new strings added, 2 updated, 0 fuzzied, and 0 obsoleted

### [4.6.6] 2017-11-21

* Feature - Added Template class which adds a few layers of filtering to any template file included
* Tweak - Added clear warnings and errors to prevent and limit the import of iCalendar sources missing required fields [93600]
* Tweak - Included `tribe_callback_return` for static returns for Hooks
* Tweak - Improved Aggregator notices including error data on the responses [87326]
* Language - 4 new strings added, 79 updated, 0 fuzzied, and 0 obsoleted

### [4.6.5] 2017-11-16

* Fix - Improved legacy URL redirect logic to prevent unwanted redirects (our thanks to wesleyanhq and Adam Schwartz for highlighting this issue) [86942]
* Fix - Modified tribe_get_template_part() to remove potential for multiple templates to be rendered in a single call [46630]
* Fix - Fixed an issue where Event Aggregator scheduled imports might remain stuck in pending status [90501, 92614, 91754]
* Fix - Removed code which was automatically populating various address fields with default values when creating a new venue from within the event editor [44732]
* Fix - Resolved some issues with the "Show Map" and "Show Map Link" options in CSV files not being reliably respected on import (props @joappf and many others for highlighting this issue) [82784]
* Fix - Added opportunities to override edit linked post links [89015]
* Fix - Fixed a bug where only some parts of event featured images were clickable in List Views (thanks @mattemkadia for highlighting this issue) [81392]
* Fix - Fixed the broken 'Learn more' URL received after an unsuccessful "Other URL" import preview [92890]
* Fix - Fixed issue in list view navigation with backwards previous/next classes (thanks @secondtoughest) [36230]
* Fix - Fixed an issue where venues and organizers would not be correctly assigned to events in CSV imports with import statuses other than "Publish" [79680]
* Tweak - Remove net import scheduled notes for on demand imports [79079]
* Tweak - Allow for non-Latin characters to be used as the Events URL slug and the Single Event URL slug (thanks @daviddweb for originally reporting this) [61880]
* Tweak - Remove net import scheduled notes for on demand imports [79079]
* Tweak - Fixed some layout issues that would emerge with "Events URL Slug" option when "Plain" permalinks were enabled [92314]
* Tweak - Tweaked some language in Event Aggregator's metabox on individual edit-event screens to reduce confusion around the impact of the Update Authority on CSV imports [77957]
* Tweak - Fix PHP 7.1 compatibility with Event Aggregator (props @BJP NEALE) [90002]
* Tweak - Added new filter: `tribe_events_force_filtered_ical_link`. This makes the "Export Events" URL more easily modifiable (thanks to @tdudley07 for highlighting this issue) [43908]
* Tweak - Made the "End of Day Cutoff" option better accommodate 24-hour and other time formats (thanks @festivalgeneral for bringing this issue to our attention!) [78621]
* Tweak - Made the options presented by the timezone selector filterable (via the newly added `tribe_events_timezone_choice` hook - our thanks to National University's Marketing Department for this idea) [92909]
* Tweak - Improved integration with Twenty Seventeen - main events page now uses full height header when set to front page (thanks @uncovery for pointing this out) [89767]
* Tweak - Ensured REST API taxonomy endpoints are only registered in WordPress versions 4.7 and higher (thanks @dnaber-de for reporting this) [93227]
* Language - 1 new strings added, 132 updated, 0 fuzzied, and 1 obsoleted

### [4.6.4] 2017-11-09

* Tweak - Timepicker is now part of Tribe Common, it was removed from The Events Calendar
* Tweak - Required changes to make the plugin compatible with version 4.6 of Event Tickets
* Language - 10 new strings added, 167 updated, 0 fuzzied, and 2 obsoleted

### [4.6.3] 2017-11-02

* Fix - Prevent JS error when adding a Pro widget in the WP Customizer screen [72127]
* Fix - Fixed issue where the value of an event's "Show Google Maps Link" option would not properly affect the displaying of the link on List View (props: @etechnologie) [75547]
* Fix - Added some more specification to our jquery-ui-datepicker CSS to limit conflicts with other plugins and themes [90577]
* Fix - Improve shortcode pagination/view change url so it is reusable (props: @der.chef and others) [70021]
* Fix - Ensure the `tribe_json_ld_{type}_object` filter is available to make modifications of event, venue and organizer JSON LD data possible (thanks to Mathew for flagging this problem) [89801]
* Fix - Improved JSON LD output for events by outputting the correct UTC offset where required (our thanks to Nina and many others for flagging this issue) [78233]
* Tweak - Fixed some display issues for the event schedule details (props @mia-caro)
* Tweak - Improved the clarity of and amount of context for some linked post labels to make translation of those labels a little easier and more nuanced (props @hnacc and others) [88589]
* Tweak - Changed the order in which the list view "next events" link is assembled for better translatability (with thanks to @alelouya for highlighting this problem) [72097]
* Tweak - Adjusted linked posts selector HTML to improve compatibility with Batcache [92049]
* Tweak - Improved datepicker handling so an end date on or later than the start date can always be selected [89825]
* Language - 0 new strings added, 7 updated, 0 fuzzied, and 0 obsoleted

### [4.6.2] 2017-10-18

* Fix - Restored functionality to the "currency position" options in Events Settings, and in the per-event cost settings (props @schola and many others!) [89918]
* Fix - Fixed issue in Month view with multi-month events not appearing on subsequent months (thanks @shinno.kei & @schittly for helping isolate this) [89747]
* Fix - Made some changes to prevent Month View caching from breaking WPML support when in Month View (props: @mpike and many others!) [82286]
* Fix - Fixed start/end times being displayed in incorrect timezone in structured data (thanks @mtncreative & @esosa) [42125]
* Fix - Fixed an issue that would cause a 404 error if the selected default view was not enabled (thanks @pruneau) [45612]
* Fix - Improved translatability by adding missing textdomains for a number of strings (props @pedro-mendonca) [91071]
* Fix - Removed unneeded escaping to ensure the organizer link displays as expected (pros @f4w-pwharton) [91074]
* Tweak - Improvements to the readme.txt file surrounding plugin requirements (thanks @ramiy) [90285]
* Tweak - Improve site identification in multisite installations using Event Aggregator to avoid throttling issues [90489]
* Tweak - Avoid notice level errors when a non-existent category archive is requested (our thanks to Charles Simmons for highlighting this) [90697]
* Tweak - Added a new filter `tribe_events_ical_single_event_links` to make customizing the iCal and gCal export links on single-event views easier [90705]

### [4.6.1] 2017-10-04

* Fix - Fixed "Next Events" and "Previous Events" navigation links in list views, which would sometimes make a category-filtered list view lose its category filter as a user navigated through pages of future or past events (props @forumhelpdesk and @atomicdust for reporting this!) [72013]
* Fix - Fixed some layout issues with the Tribe Bar datepicker that would arise when using a Twenty Sixteen or Twenty Fifteen child them (thanks to @stefanrueegger for reporting this) [46471]
* Fix - Prevented modification of event titles within the loop when using TRIBE_MODIFY_GLOBAL_TITLE [89273]
* Fix - Fixed issue when exporting all-day multi-day events via iCal where the end date was one day early (Thank you @fairmont for reporting this!) [87775]
* Fix - Fixed issues with the jQuery Timepicker vendor script conflicting with other plugins' similar scripts (props: @hcny et al.) [74644]
* Fix - Fixed an issue that would prevent Event Aggregator scheduled imports from running [88395]
* Fix - Fixed the "Start Time" and "End Time" timepicker fields in the event-creation screen to make it impossible to have an end date/time that comes before the start date/time [72686]
* Tweak - Remove unnecessary parameters from some remove_action calls in the plugin (thanks to @JPry on GitHub for submitting this fix!) [88867]
* Tweak - Adjusted the EA cron start time so that it never gets created in the past [88965]
* Tweak - Improved options format in the Event Aggregator settings [88970]
* Tweak - Added a filter to CSV importer for altering the delimiter, escaping, and enclosing characters [70570]
* Tweak - Adjusted the `tribe_update_venue()` template tag so it no longer creates some unnecessary meta fields involving post_title, post_content, etc. (thanks @oheinrich for bringing this to our attention) [66968]
* Tweak - Improved the performance of The Events Calendar REST API tweaking some queries [89743]
* Tweak - Add support for a `found_posts` argument in `tribe_get_events`, `tribe_get_venues` and `tribe_get_organizers` functions to return the number of posts found matching the current query arguments [89743]
* Deprecated - Deprecated the `tribe-events-bar-date-search-default-value` filter; use `tribe_events_bar_date_search_default_value` instead [67482]
* Language - Improvements to aid translatability of text throughout plugin (props: @ramiy) [88982]
* Language - 7 new strings added, 180 updated, 4 fuzzied, and 3 obsoleted

### [4.6] 2017-09-25

* Feature - Added full CRUD REST support for Events, Organizers, Venues, Event Categories, and Tags
* Tweak - Updated Bootstrap Datepicker to v1.7.0
* Tweak - Added latitude/longitude to REST responses when available on venues
* Tweak - Added JSON-LD data to REST responses when available
* Tweak - Replaced deprecated first parameter of `tribe_get_organizers()` with a parameter that, when specified with a truthy value, returns only organizers with upcoming events attached to them
* Tweak - Added linked post filters: `tribe_{$this->post_type}_has_events_excluded_post_stati`, `tribe_events_tribe_organizer_create`, `tribe_events_tribe_organizer_update`, `tribe_event_venue_duplicate_post_fields`, `tribe_event_organizer_duplicate_custom_fields`
* Tweak - Added action: `tribe_events_organizer_created`
* Tweak - Added REST filters: `tribe_rest_organizer_default_only_with_upcoming`, `tribe_rest_venue_default_only_with_upcoming`, `tribe_events_rest_term_allow_delete`
* Tweak - Added duplicate-detection filters: `tribe_duplicate_post_strategies`, `tribe_duplicate_post_strategy`, `tribe_duplicate_post_{$strategy}_strategy`
* Language - 152 new strings added, 217 updated, 6 fuzzied, and 1 obsoleted

### [4.5.13] 2017-09-20

* Feature - Add link to the featured image in the Events List widget. New filter introduced to control this: `tribe_events_list_widget_featured_image_link` (props to @cabadaj007 for the feature request) [84807]
* Feature - Remove 'France, Metropolitan' option from country list to prevent issues with Google Maps API (thanks @varesanodotfr for pointing this out) [78023]
* Feature - Ignored Events will restore previous status instead of setting to 'publish' [82213]
* Fix - Patched jQuery Resize vendor library to avoid JavaScript conflicts (props to @britner for the original report) [71994]
* Fix - Fixed a typo in the Event List widget options [71081]
* Fix - Addressed some PHP notices that would sometimes emerge in tag-filtered post lists in the wp-admin (thanks to @wfsec28 and others in the forums for reporting this!) [45274]
* Fix - When "Full Styles" or "Tribe Events Styles" are used, prevent duplicate featured images from showing up in the Twenty Seventeen theme (props to @want2what and others in the forums for reporting this) [80955]
* Fix - Fixed the issue that would prevent the start date and date range parameters from being taken into account when using 'Other URL' source in Event Aggregator
* Fix - Aggregator will no longer update comments while inactive [78890]
* Fix - Avoid issues when REST API archive request parameters are not in the original order (thanks @Nslaver for reporting this and providing a fix) [88748]
* Tweak - Aggregator prevents duplicated records with the same params from being created [68833]
* Tweak - Aggregator will now allow for some minor shifts in schedule execution time to help distribute requests to EA Service [86628]
* Tweak - Improve text in the Event Aggregator settings [77452]
* Tweak - Add actions before and after posts are inserted or updated by Event Aggregator to allow custom functions to kick in (`tribe_aggregator_before_insert_posts` and `tribe_aggregator_after_insert_posts`) [87530]
* Tweak - Allow users to import CSV with numerically-named categories by using a flag (currently `%n`) (thanks @Shamsi for reporting) [78340]
* Tweak - Allow date range and events count limits to be set on each type of import (except for 'Other URL') in Event Aggregator [79975]

### [4.5.12.3] 2017-09-19

* Fix - Display events on Month View correctly for WordPress version 4.8.2 and up (props @realcrozetva for reporting this) [88952]

### [4.5.12.2] 2017-09-08

* Fix - Fixed an issue where manually running Scheduled Imports would always result in a failed import [87321]

### [4.5.12.1] 2017-09-07

* Fix - Fixed an issue where events imported via Event Aggregator from an iCal-like source would be duplicated in place of being updated [87654]

### [4.5.12] 2017-09-06

* Fix - Fixed an issue where, with certain date formats chosen in the Events display settings, the "Next Month" link navigation wasn't working (props to @tttammi and others for reporting this issue!) [86937]
* Fix - Fixed a typo in REST API Swagger documentation that mentioned "organizer" when it should have stated "venue".
* Fix - Fixed issues with Event Aggregator queueing system where events might be duplicated or incorrectly updated [79975]
* Fix - Prevent notice when the Aggregator Record title is an array [82149]
* Fix - Allows Aggregator Google Map settings to extend the Global Setting by default (props to queerio for reporting this!) [67639]
* Fix - Prevent Warnings when throwing WordPress admin notices from Aggregator daily usage limit (props to cigarplanner for reporting this!) [83187]
* Fix - Resolved problem where Aggregator wouldn't allow you to remove filtering terms for Records [76949]
* Fix - Allow any datepicker format to be used on Aggregator filtering Events (props to matthewseymour for reporting this!) [77819]
* Fix - Added check to see if log directory is readable before listing logs within it (thank you @rodrigochallengeday-org and @richmondmom for reporting this) [86091]
* Tweak - Datatables Head and Foot checkboxes will not select all items, only the current page [77395]
* Tweak - Included tooltip for Aggregator "Hide & Ignore" button for events [67890]
* Tweak - Added all the Aggregator Origins to the Admin Bar [68693]
* Tweak - Added filters: `tribe_get_state_options`
* Tweak - Added template tags: `maybe_format_from_datepicker()`
* Tweak - Added the `tribe_rest_single_event_data` filter to the single event REST API endpoint to allow filtering the returned data (thanks @mwender) [88748]
* Language - 2 new strings added, 90 updated, 0 fuzzied, and 1 obsoleted

### [4.5.11] 2017-08-24

* Fix - Avoid Event Aggregator previews or scheduled imports being marked as failures [84259]
* Fix - Fixed start and end date limit parsing for events archive in the REST API code [78375]
* Fix - Fixed issue with `tribe_events_get_the_excerpt()` returning a read more link that sometimes pointed to the current page [70473]
* Fix - Fixed Post ID not being sent to the_title filter for Organizers and Venues (props Anna L.) [85206]
* Fix - Fixed issue where Month View tooltips would often go off-screen in some smaller viewport sizes [65136]
* Fix - Fixed an issue that would sometimes render Event Aggregator options invalid even with a valid license [78469]
* Fix - Fixed an issue where the mobile.php template file would often fail to include an event's featured image [74291]
* Fix - Resolved issue where invalid linked post IDs prevent proper updates on linked posts (props to Mathew L. and a few others for highlighting this issue) [71802]
* Fix - Do not hijack the blog when the main events page is configured to appear on the site's homepage (our thanks to Jason and others for flagging this problem) [72094]
* Fix - Remove extra trailing double-quotes at the end of the timepicker data-format attributes [85603]
* Fix - Fixed an issues where Event Aggregator scheduled imports could not run other than manually [81639]
* Tweak - Prevent stray commas from showing up for some event venues in the List View [72289]
* Tweak - Prevent stray commas from showing up for some event venues in the Day View [85429]
* Tweak - Modify certain event queries to widen the window of opportunity for query caching (props @garretjohnson) [84841]
* Tweak - Improve Event Aggregator message regarding Facebook token expiration [70376]
* Tweak - Support importing from URLs (Event Aggregator) where the protocol hasn't been specified by defaulting to HTTP [76466]
* Tweak - Removed WP API adjustments [85996]
* Tweak - Added filter: `tribe_aggregator_meta_source` to filter the Event Aggregator import source
* Tweak - Added filter: `tribe_events_linked_post_meta_values_{$current_linked_post_meta_key}` for filtering the array of values retrieved for a specific linked post meta field
* Tweak - Updated views: `src/views/day/single-event.php` and `src/views/list/single-event.php`
* Compatibility - Minimum supported version of WordPress is now 4.5
* Language - Improvements to various strings to improve ease of translation (props to @ramiy)
* Language - 5 new strings added, 56 updated, 1 fuzzied, and 3 obsoleted [the-events-calendar]

### [4.5.10.1] 2017-08-16

* Fix - Updates common library to resolve a range of issues preventing frontend assets from loading and breaking parts of our user interface [85017]

### [4.5.10] 2017-08-09

* Fix - Avoid duplicate events when importing from some iCal, Google Calendar and Facebook feeds in Event Aggregator (our thanks to Jason Sears, controlyours and many other users for highlighting these issues) [67038]
* Fix - Fixed bug that caused scheduled imports to get stuck in a perpetual state of failure when receiving error messages from the Event Aggregator service (our thanks to Antonio Jose and others for flagging this problem) [83767]
* Fix - Resolved issue where errors from the Event Aggregator service were not properly logging/visible on the History tab [83767]
* Tweak - Made linked post fields' auto-save features more stringently check for empty values to prevent the plugin from trying to "save" empty values (our thanks to Jean-Marie for highlighting this problem) [80282]
* Tweak - Moved the organizer e-mail address field label a bit to better accommodate Community Events [80426]
* Tweak - Added filter to tribe_get_display_end_date()'s return value [77730]
* Tweak - Avoid notice-level errors while processing queues within Event Aggregator (our thanks to David Sharpe and others for reporting this) [84020]
* Tweak - Improve compatibility and avoid Javascript errors when running alongside Twenty Seventeen [70853]
* Compatibility - Minimum supported version of WordPress is now 4.4
* Language - 1 new strings added, 119 updated, 0 fuzzied, and 0 obsoleted

### [4.5.9] 2017-07-26

* Fix - Send Aggregator callback URL with correct Scheme [83364]
* Fix - Scheduled Aggregator cron for inserting will re-enqueue to complete scheduled imports [83382]
* Fix - Avoid overwriting Venues and Organizers when importing FB events with similarly named Venues and Organizers [75370]
* Fix - Improve handling of large and/or slow Google Calendar and iCal feeds [79975]
* Tweak - Added period "." separator to datepicker formats. [65282]
* Tweak - Added tribe_events_month_get_events_in_month filter to allow overriding of events used in month templates. [83317]

### [4.5.8.1] 2017-07-21

* Fix - Fixed an issue where failed EA Imports would hang for a long time before failing [83344]

### [4.5.8] 2017-07-13

* Fix - Remove permalink logic for recurring events (Events Calendar PRO will implement instead) [74153]
* Fix - Avoid type error when setting up one-time imports for Facebook URLs (our thanks to @J for flagging this!) [78664]
* Fix - Add a safety check in isOrganizer() function (our thanks to Kevin for flagging this!) [81645]
* Fix - Avoid EA Client hanging when no events are found while attempting an import from a Facebook source [82713]
* Fix - Improve compatibility of The Events Calendar when operating with WPML from within a subdirectory (props: @dgwatkins) [81998]

### [4.5.7] 2017-06-28

* Fix - Restore support for translated events category slugs when WPML is active [73478]
* Fix - Improve handling of shortcodes within event view excerpts (props: @awbauer) [81226]
* Fix - Improve compatibility with WPML in relation to event permalinks specifically (props: @dgwatkins) [81224]
* Fix - Improved handling of Venue fields that allows for better form validation in Community Events [76297]
* Tweak - Better detection and reporting of communication failures with the Event Aggregator server
* Tweak - Textual corrections (with thanks to @garrett-eclipse for highlighting many of these) [77196]
* Tweak - New filter added ("tribe_events_linked_posts_dropdown_enable_creation") to facilitate more control over linked posts [80487]
* Tweak - Improve performance of theme compatibility code [71974]
* Tweak - Don't show Event Aggregator system status in Help tab if there's no Event Aggregator license in place [68506]

### [4.5.6] 2017-06-22

* Tweak - Improved how Cost field looks and it's consistency across views [71092 & 71094]
* Fix - Resolved issue where the Meta Chunker attempted to inappropriately chunk meta for post post_types [80857]
* Tweak - Added actions: `tribe_events_inside_cost`
* Tweak - Changed views: `day/single-event`, `day/single-featured`, `list/single-event`, `list/single-featured`
* Language - 1 new strings added, 15 updated, 1 fuzzied, and 1 obsoleted [the-events-calendar]
* Language - 0 new strings added, 0 updated, 1 fuzzied, and 0 obsoleted [tribe-common]

### [4.5.5] 2017-06-14

* Fix - Removed extra double quotes in organizer link output [71133]
* Fix - Make the list and day view styles match more closely [63599]
* Fix - Better sanitization on CSV imports (thanks to Valentinos Chouris from NCC Group for reporting this) [80311]
* Fix - Prevent tabs from being incorrectly escaped in iCal output (props: KZeni) [80452]
* Fix - Fixed inconsistent font styling of Tribe Bar form labels. [27252]
* Tweak - Removed unused Javascript (jQuery UI Dialog) to help avoid warnings (our thanks to @gama6889 for flagging this) [80766]
* Tweak - Added new filter hooks 'tribe_events_register_event_type_args' and 'tribe_events_register_event_cat_type_args' [80658]

### [4.5.4] 2017-06-06

* Tweak - Minor tweaks to the CSS for linked post types (Organizer/Venues)
* Fix - Prevent drag and drop icon showing when singular linked post type is been displayed
* Fix - Resolved issue where scheduled imports sometimes failed to execute [79587]
* Fix - Better sanitization of data (Props to Valentinos Chouris for reporting this) [80310]
* Language - 2 new strings added, 156 updated, 0 fuzzied, and 4 obsoleted [the-events-calendar]
* Language - 4 new strings added, 20 updated, 1 fuzzied, and 0 obsoleted [tribe-common]

### [4.5.3] 2017-06-01

* Fix - Made it easier to translate the update confirmation message (our thanks to safu9 for highlighting this) [79729]
* Fix - Fixed compatibility issue with WPML which caused organizers and venues to disappear on translated events [67581]
* Fix - Fixed bug where venues and organizers would be duplicated when their associated event is previewed. [64088]
* Tweak - Other fixes to the plugin verbiage (with thanks to @garrett-eclipse and others)

### [4.5.2.1] 2017-05-19

* Fix - Prevent fatal errors occurring in PHP 5.5 and earlier [79208]

### [4.5.2] 2017-05-17

* Fix - Correct REST API reference URL (our thanks to Lindsey for flagging this) [78658]
* Fix - Improve Event Aggregator integration to avoid situations where imports continually restart but do not complete [77988]
* Tweak - Make the inclusion or exclusion of the year (within the event schedule string) filterable [78070]
* Tweak - Adjustments to help avoid false positive security alerts being generated in relation to our customizer integration [78355]

### [4.5.1] 2017-05-04

* Fix - Prevented errors on EA import screen that happened in exotic circumstance. Thanks @kathryn for reporting this! [75787]
* Fix - Made EA preserve custom dates after reimporting a Facebook Event when option is set. [75787]
* Fix - Enhance month view caching to minimize impact of JSON-LD generation [74656]
* Tweak - Styling/layout improvements within the Event Aggregator screen [77895]

### [4.5.0.2] 2017-05-01

* Fix - Ensure compatibility with WordPress version 4.4 and earlier

### [4.5.0.1] 2017-05-01

* Fix - Resolving issue where some premium plugins were falsely claiming they were out of date

### [4.5] 2017-05-01

* Feature - Event Aggregator now allows users to import from other sites with The Events Calendar [68139]
* Feature - Include a Events REST API endpoint for read operations [70711]
* Feature - Include granular Scheduling for Events Aggregator
* Tweak - Update Authority for modified fields now will include Organizer, Venues and Taxonomy changes [71152]
* Tweak - Clean up direct calls to get events and use wrapper `tribe_get_events()` which has a hook for customizing
* Tweak - Remove including Event Tickets for backwards compatibility as a vendor library [71908]
* Tweak - Create a global ID to increase consistency on all of the imported items with Event Aggregator [75218]
* Fix - Prevent Aggregator to run on Empty Queues thus generating fatals (props to @Donald for the report here) [75377]
* Fix - Categories and Tags are no longer cleared when importing with Event Aggregator (thank you @Nicolas for the report) [74264]
* Fix - Increase consistency on Column Mapping for CSV imports [76476]
* Tweak - Added filters for REST API: `tribe_events_rest_url_prefix`, `tribe_rest_url`, `tribe_events_rest_use_builtin`, `tribe_rest_events_archive_data`, `tribe_rest_event_max_per_page`, `tribe_rest_event_data`, `tribe_rest_venue_data`, `tribe_rest_organizer_data`, `tribe_rest_event_categories_data`, `tribe_rest_event_tags_data`, `tribe_rest_event_taxonomy_term_data`, `tribe_rest_event_featured_image`, `tribe_events_rest_api_enabled`
* Tweak - Added filters for REST API Documentation: `tribe_rest_swagger_cost_details_documentation`, `tribe_rest_swagger_date_details_documentation`, `tribe_rest_swagger_image_details_documentation`, `tribe_rest_swagger_image_size_documentation`, `tribe_rest_swagger_term_documentation`, `tribe_rest_swagger_event_documentation`, `tribe_rest_swagger_organizer_documentation`, `tribe_rest_swagger_venue_documentation`, `tribe_rest_swagger_documentation`
* Tweak - Added filters for Modified fields tracking: `tribe_tracker_post_types`, `tribe_tracker_excluded_meta_keys`, `tribe_tracker_enabled`, `tribe_tracker_enabled_for_terms`, `tribe_tracker_taxonomies`
* Tweak - Added filters for Event Aggregator: `tribe_aggregator_localized_data`, `tribe_aggregator_service_messages`, `tribe_aggregator_url_import_range_options`, `tribe_aggregator_url_import_range_cap`, `tribe_aggregator_url_import_range_start`, `tribe_aggregator_url_import_range_end`
* Tweak - Removed filters for Event Aggregator: `tribe_aggregator_track_modified_fields`
* Tweak - Added actions for Initialization: `tribe_events_bound_implementations`
* Tweak - Removed methods for `Tribe__Events__Main`: `track_event_post_field_changes`, `maybe_load_tickets_framework`
* Tweak - Removed methods for `Tribe__Events__Aggregator__Service`: `has_service_message`

### [4.4.5] 2017-03-23

* Fix - Local changes to events should be preserved in accordance with the Event Import Authority setting (thanks to @bryan for reporting this one) [72876]
* Fix - Correct the value for days of the week abbreviation (thanks @mmmmartin03 for the report) [75379]
* Tweak - Enable the month view cache by default on new installations [74867]
* Tweak - External links to Google maps changed from http to https (nice find by @bjf2000 - reported via the .org support page) [74930]
* Tweak - Links to WordPress.org changed from http to https (ultimately this is also credited to @bjf2000's find. Thanks!) [72273]

### [4.4.4] 2017-03-08

* Fix - Avoid unnecessarily removing a callback from an action while inside the same action (improves PolyLang compatibility - props @Chouby) [73122]
* Fix - Resolving issue where sites that overrode the wp-admin path would fail to successfully perform a Facebook OAuth with Event Aggregator [74687]
* Tweak - Improve template loading for easier customization by developers and better support of the template hierarchy (props @QWp6t) [72842]

### [4.4.3] 2017-02-22

* Fix - Resolved issue where iCal exports on month view were exporting more events than intended (thanks to @s2ldesign for reporting in our forums) [72133]
* Fix - Resolved meta width issue for maps when Pro is active (gracias a @ANTONIO JOSE por el reporte del error)  [69844, 72272]
* Fix - Resolved issue where featured images were not being imported via Event Aggregator Facebook imports (cheers to @Cody for the initial bug report) [72764]
* Fix - Resolved issue where translated 'all' slugs were not respected (thank you @Marianne for your report in the forums) [71996]
* Tweak - Translation improvements and fixes (@Katja - thanks! ) [70068]
* Tweak - Allow "-1" when specifying the "Month view events per day" setting [70497]

### [4.4.2] 2017-02-09

* Fix - Ensure the global and source-specific Google Map settings for imports are respected [67228]
* Fix - Prevent PHP 5.2 Strict mode from throwing notices due to usage of `is_a` [72812]
* Fix - Ensure the events list widget's show/hide if there are upcoming events setting is respected [72965]
* Tweak - Add filters for template tag functions related to dates: `tribe_get_start_time`, `tribe_get_end_time`, `tribe_get_start_date` and `tribe_get_end_date` [67759]

### [4.4.1.1] 2017-01-26

* Fix - Resolved fatal caused when rendering themes that override tribe styles

### [4.4.1] 2017-01-26

* Fix - Resolve the Fatals related to undefined methods and Memory exhaustion [71958, 71912]
* Fix - iCal export for Single events working again [71916]
* Tweak - Changes the Search label to prevent duplicate words (props @oheinrich) [72149]
* Tweak - Add theme version to `tribe-event.css` (props @berler) [71973]
* Fix - Resolve JavaScript error when jQuery was been de-registered [71369]
* Fix - Prevent Fatals when Importing Images on Event Aggregator [70576]
* Fix - Prevent Third Party notes to be escaped, anchor link working again [71872]
* Fix - Google Maps now are using HTTPS instead of HTTP (props @cliffordp)
* Fix - Prevent Fatals on Event Aggregator Cron, due to Activity logging failure [71904]
* Fix - Elminate some cases of problem with Facebook manual import on Event Aggregator [69137]
* Fix - WPML integration smaller incompatibilities [70520, 70522]

### [4.4.0.1] 2017-01-09

* Fix - Adds safety check to ensure a smooth activation process when earlier versions of Tribe Common are active

### [4.4] 2017-01-09

* Feature - Add dynamic helper text to single event editor to display the events date and time [66484]
* Feature - Add support for featured events [65898]
* Feature - Add support for placing the main events archive on the site homepage [38757]
* Feature - Add support for the theme customizer [67489]
* Feature - Make it possible to adjust map pins via the theme customizer [65889]
* Feature - Support for Event Aggregator in a multisite network context added [61427]
* Fix - Add a link to The Events Calendar Help page in the Network Administration screen of multisite installations [68665]
* Fix - Multisite license editing and displaying consistency [68662]
* Tweak - Adjusted styles and added actions for featured events in the List Widget [65923]
* Tweak - Organizers and Venues are now with a better and cleaner interface [68430]
* Tweak - Eliminate duplicate meta data for organizer posts [25084]
* Tweak - Improved the start/end date user interface [66486, 66487, 66550]
* Tweak - iCal export now includes all events - up to a reasonable limit - rather than just those in the current view [65037]
* Tweak - Adjustments made to the default week view color scheme [69756]
* Tweak - Add AJAX and improve consistency of the venue and organizer UI [38129]

### [4.3.5] 2016-12-20

* Tweak - Updated the template override instructions in a number of templates [68229]
* Tweak - Improve behavior of tribe_get_events_title() in respect of single events [46313]
* Tweak - Event Aggregator will only load on the Administration, prevent bigger loads for Front-End users [70812]
* Tweak - Allow better filtering for Organizers and Venue Meta fields (Props: @Chouby from Polylang) [70894]
* Fix - Prevent JavaScript Notices related to Bumpdown [69886]
* Fix - Assets URL on Windows Servers are fully operational again [68377]
* Fix - JavaScript and CSS files will respect HTTPS on all pages [69561]
* Fix - Fixed comment count and visibility issues due to Event Aggregator records [68297]
* Fix - Fixed PHP notices and warnings raised when importing .ics files [69960]
* Fix - Only show link to Venues if Pro is active in List View [69887]
* Fix - Fixed and issue that would make Event Aggregator importing notices remain stuck in the Import screen [70614]
* Fix - Avoid error screen when saving licenses on multisite installations [68599]
* Fix - Fix calendar view links in WPML language switcher [67134]

### [4.3.4.2] 2016-12-13

* Fix - Correct an oversight leading to breakages of the /all/ events archive for Events Calendar PRO users [70662]

### [4.3.4.1] 2016-12-09

* Fix - Updates Tribe Common to remove some stray characters that were impacting page layouts (props: @Aetles) [70536]

### [4.3.4] 2016-12-08

* Tweak - Tribe Common now is loaded only once across our plugin suite, improves performance in some cases [65755]
* Fix - Featured Images for Event Aggregator imports are working as expected again. [69465]
* Fix - Google Calendar and iCalendar files are now updating their respective events [68684]
* Fix - On demand Event Aggregator records will update events correctly [69542]

### [4.3.3] 2016-11-16

* Feature - Added Tribe Extension class and loader, to make small addons easier to build [68188]
* Fix - Ordering on Month view is working as expected again [69123]
* Fix - Enable ampersand character in mobile month view titles (thanks @kate for the report of this) [45409]
* Fix - Prevent notices for Event Aggregator License checking [67981]
* Fix - Mismatched text domains are resolved, important for translations (props to @Hans) [68462]
* Fix - Sticky on Month View is working as expected again [68902]
* Fix - Prevent HTTPS websites from pointing to Assets in HTTP [68372]
* Fix - On `WP_Query` we will no-longer overwrite custom `post__not_in` params [42143]

### [4.3.2] 2016-11-02

* Fix - Fixes an issue where the text in the Location search field was URL encoded when using the back or forward button for navigation. [61742]
* Fix - Aggregator Errors will not show more than once daily as comments (Thanks @Jacob for your report on the forums) [68094]
* Fix - Event Aggregator ICS default configuration now are been Selected Correctly [67885]
* Fix - Shortcode Month view now will display tooltips correctly [68094]
* Fix - Avoid loading the select2 JavaScript library twice when Advanced Custom Fields is activated (props to @ryan for the initial report [43605]
* Fix - Avoid errors and notices on calendar page when X theme and WPML plugins are active (thanks @ingrid for reporting this one) [64400]

### [4.3.1.1] 2016-10-20

* Fix - Corrected a packaging issue from the 4.3.1 release [67936]

### [4.3.1] 2016-10-20

* Tweak - Implement the pruning of Event Aggregator history records after 7 days, filterable by tribe_aggregator_record_retention [68283]
* Tweak - Event Aggregator will now verify that the license key has uses remaining before creating a history record [68286]
* Tweak - Improve `tribe_create_event` documentation (Props to Keith) [44871]
* Fix - Resolved an issue where scheduled Event Aggregator imports marked as "On Demand" were being run by cron [68284]
* Fix - Resolved a bug where empty meta fields were being inserted into Event Aggregator record post meta [68290]
* Fix - Resolved a bug where Venue and Organizers urls were been generated incorrectly (Thanks @Matt) [68168]
* Fix - Pagination links on Month view are updating correctly [67977]
* Fix - Resolved the support for translated event category archive slug that could lead to broken links on the front-end while using WPML (Props to Wilco in the support Forums) [62018]
* Fix - Resolved a bug where searching for past events in the List view would always yield no results (Thanks for the report @Davide) [61863]
* Fix - Resolved an issue where long file names would break plugin updates on some Windows installations (pros to @Alan [62552]
* Fix - Resolved an issue where the `/all` link on recurring events on non English websites could be broken (reported by @lumiest - thanks!) [68062]
* Fix - Pagination links on Month view are updating correctly [67977]

### [4.3.0.1] 2016-10-14

* Fix - Preventing legacy Facebook events from being duplicated

### [4.3] 2016-10-13

* Feature - Added Event Aggregator to enable service-based event imports from iCal feeds, Facebook, and Meetup
* Feature - Revamped the CSV import screens to work within the new Event Aggregator pages
* Tweak - Adjusted some view logic to support the new Event Views shortcode in Pro [44800]
* Tweak - Added a button to copy the system infomation on the help tab [43709]
* Tweak - Added an option for users to opt into automatic system infomation so our support system can grab the system information found on the help tab automatically [31645]
* Tweak - Use an earlier hook for iCal feed generation (props @jlambe) [64141]
* Tweak - Revise and simplify integration with Event Tickets attendee screen [61992]
* Tweak - Added context to a set of strings to make translation easier (props @pedro-mendonca) [64586]
* Tweak - Deprecated various disused functions and classes relating to the Meta Factory [39905]
* Fix - Cease using GLOB_BRACE for including deprecated files due to limited server support [63172]
* Fix - Avoid problems that can occur when hooking and unhooking actions (props @Chouby) [63474]
* Fix - Resolves an issue where we were duplicating a core WordPress hook but with a different set of parameters (props @Chouby) [66455]
* Fix - Correct the datetime formatting issues within the iCal feed (props @henryk) [65968]
* Deprecated - `Tribe__Events__Main::initOptions()` has been deprecated with no replacement
* Deprecated - `Tribe__Events__Main::set_meta_factory_global()` has been deprecated in favor of using the `Tribe__Events__Meta_Factory` class
* Deprecated - The `setup_meta()` method in both the `Tribe__Events__Template__Single_Event` and `Tribe__Events__Template_Factory` classes has been deprecated
* Deprecated - The `the_title()`, `event_date()`, `event_category()`, `event_tag()`, `event_website()`, `event_origin()`, `organizer_name()`, `organizer_email()`, `venue_name()`, `venue_address()`, and `venue_map()` methods have been deprecated in the `Tribe__Events__Advanced_Functions__Register_Meta` class
* Deprecated - The `register()`, `check_exists()`, and `get_args()` methods have been deprecated in the `Tribe__Events__Meta_Factory` class

### [4.2.7] 2016-09-15

* Tweak - Additional support for plugin extensions

### [4.2.6] 2016-08-31

* Add - tribe_is_event_past() conditional to detect if event end time is past current time (Reported by @Jonathan in our support forums - thanks Jonathan.)

### [4.2.5] 2016-08-17

* Fix - Fixed inconsistent template filtering logic for single event template [62525]
* Tweak - Restored preview for published events [64874]

### [4.2.4] 2016-08-03

* Tweak - Changed "Event Add-Ons" to load faster [64286]
* Fix - Fixed default venue setting [64628]
* Fix - Fixed default venue state and province settings [64629]

### [4.2.3] 2016-07-20

* Fix - In month view, be sure to unhook JSON-LD output when calling unhook function
* Fix - Incorrect JSON-LD event start and end times (thank you @jjbte for reporting on .org forums)
* Fix - Show Google Map and Link checkbox so they show when editing an event (Reported originally by Michael of @NailedIT in the .org forum)
* Fix - Use Community Events Venue Edit Link when on Community Events Forms instead of Admin (also as a result of the report abve from @NailedIT. Thanks again.)

### [4.2.2] 2016-07-06

* Fix - Small CSS Issue on Welcome Page
* Fix - Month view on mobile device width doesn't have links to prev/next months
* Fix - Reimport of updated CSV removes featured image (Bug #46149)
* Fix - Fixed the issue that would make multiple organizers details disappear when trying to submit invalid event data using Community
* Fix - Add a check to avoid being unable to switch view when Filter Bar plugin is active and at least one field is set to auto-complete mode
* Fix - Only add the events custom post type to the tag archive queries and not custom queries with tags [45635]
* Fix - When using the filter tribe_events_excerpt_allow_shortcode shortcodes will be maybe be processed in event excerpts in the list views [42289]

### [4.2.1.1] 2016-06-28

* Fix - Ensure translations load as expected with all supported versions of WordPress (thanks to @JacobALund for originally reporting this on .org forums)

### [4.2.1] 2016-06-22

* Tweak - Adjust the caching rules for Month View for faster loading
* Fix - Replace a bad return type to avoid unnecessary notices in the error log
* Fix - Add missing styles for correctly hide screen reader text
* Fix - Fixes `tribe_get_event_link()` which wasn't working when passing second parameter as `true'
* Tweak - Reduce the ginormous font size of Month View titles in skeleton styles
* Fix - Add styling to adjust List View description to full width
* Fix - Miscellaneous tweaks to improve the Month and Day views
* Fix - Fix a shorthand array that was causing errors in PHP 5.2 and 5.3 when importing events

### [4.2] 2016-06-08

* Feature - Added Google Maps API key field in the Settings tab to avoid map timeouts and errors on larger sites (Thanks to Yan for reporting this!)
* Feature - Added support for featured image, multiple organizers, excerpt and more custom fields in the .csv file import function for events (Thank you to Graphic Designer for posting on UserVoice!)
* Feature - Added support for featured image, description, map details and more custom fields in the .csv file import function for venues
* Feature - Added support for featured image and description in the .csv file import function for organizers (Thank you to Rebecca for posting on UserVoice!)
* Feature - Added an oEmbed template for events
* Feature - Improve performance of a query used to determine if there are free/uncosted events (Thank you @fabianmarz for the pull request!)
* Feature - Added support for attaching custom post types to events
* Tweak - Improved filtering of the `tribe_event_featured_image()` function (Cheers to @fabianmarz!)
* Tweak - Add an encoding class for the CSV importer to prevent non utf8 characters from preventing imports (Thanks to screenrage for the report!)
* Tweak - Improved our JSON-LD output to ensure consistency (Props to @garrettjohnson and Lars!)
* Tweak - Language files in the `wp-content/languages/plugins` path will be loaded before attempting to load internal language files (Thank you to user aafhhl for bringing this to our attention!)
* Tweak - Switch to HTTPS for the "Powered by The Events Calendar" link (Thank you Cynthia for reporting this!)
* Tweak - Switch to using HTTPS by default for interactions with Google Maps API
* Tweak - Improved filterability of calendar excerpts by introducing the new `tribe_events_get_the_excerpt` filter hook
* Tweak - Improved filtering of organizer details when importing by CSV (Props to @Geir for bringing this up!)
* Tweak - Adjustments for single event view in Twenty Fifteen theme
* Tweak - Improved performance of query used to test for events without any cost
* Tweak - Added missing semicolon to a laquo (Props to mwender on GitHub for the fix!)
* Tweak - Improve the "stickiness" of CSV import column mappings (Thank you @jamesgol!)
* Tweak - Consistency of JSON-LD markup improved (Cheers to @garrettjohnson for the help!)
* Tweak - Avoid notice-level errors when working with WP CLI on a site where The Events Calendar is also active (Thanks to @sun)
* Tweak - Corrected the spelling of timezone in the CSV Importer's event field
* Tweak - Updated venue and organizer templates to use the new architecture for attaching custom post types to events
* Tweak - Move plugin CSS to PostCSS
* Tweak - Category default view is now set to `default` in place of hardcoding the current default view in the category base rewrite rule [31907]
* Deprecated - `Tribe__Events__PUE__Checker`, `Tribe__Events__PUE__Plugin_Info`, and `Tribe__Events__PUE__Utility` classes are deprecated and are replaced by `Tribe__PUE__Checker`, `Tribe__PUE__Plugin_Info`, and `Tribe__PUE__Utility` classes
* Fixed - Changed the use of `have_posts()` in the maybe iCal links for the main views that could cause an infinite loop
* Accessibility - Focus styles added for search fields
* Accessibility - Add ARIA labels for Month/Day/List sub nav
* Accessibility - Add ARIA label for events footer sub nav heading

### [4.1.4] 2016-05-19

* Fix - Improve accuracy of list view pagination after switching from month view
* Tweak - Give the multi-organizer form 'sticky' properties so values persist even if the submission is initially rejected
* Tweak - Resolved minor CSS issues in the welcome page

### [4.1.3] 2016-04-28

* Fix - Month View single days are now ordered as follows: sticky events, ongoing multi-day events, all day events, then start time. In other words, all events should be ordered as you'd expect when viewing events in Month View.
* Fix - Updated the compatibility of CSV importer with WordPress 4.5 due to a change in the `post_status` filter. This will help prevent some of the errors you may have seen when importing events using a CSV file.
* Tweak - Added new event names for AJAX success to the List, Month, and Day views to help The Events Calendar's compatibility with our other premium plugins.

### [4.1.2] 2016-04-11

* Tweak - Removed an unneeded hook that attempted to add a query argument to event tag links
* Fix - Resolved an issue where events marked as "sticky" would not display as such in Month View
* Fix - Dashes, hyphens, or whatever you like to call them in the events archive slug no longer breaks the URL
* Fix - The notice that pops up when a conflicting "events" page exists can now be dismissed

### [4.1.1.1] 2016-04-07

* Security - Tightened up security with post type link filtering (props to Nadal Soler for reporting this issue!)
* Security - Tightened up security around tribe bar submissions (props to Paul Mynarsky for reporting this issue!)

### [4.1.1] 2016-03-30

* Fix - Resolved bug where array notices were output on single event pages when venues were not set (props to zaxiscreative for reporting this issue!)
* Fix - Resolved issue where the Month View in mobile sizes retained the long day-of-week names when the abbreviations should have been used (props to Lucy for the bug report!)
* Fix - Fixed bug where a "0" was added to the default Venue name when creating a new event
* Fix - Fixed notice that caused Ajax requests to fail (props to cgrymala on WP.org for reporting this!)
* Fix - Removed quotes from around TZID-specified timezones in iCal feeds which causes problems with some parsers (props to factory44 for reporting the issue that lead to this fix)
* Fix - Resolved various capitalization issues with German translations (props to oheinrich in our forums for pointing out this issue!)

### [4.1.0.1] 2016-03-17

* Fix - Resolved multiple issues with the German `de_DE` language file that caused a number of site-breaking issues

### [4.1] 2016-03-15

* Feature - Added a tribe_get_venue_website_url() function for fetching Venue website URLs (props to fervorcreative in our forums for this request!)
* Performance - Lazy-load venue and organizer selector data
* Tweak - Allow iCal filenames to be filtered via a new filter: tribe_events_ical_feed_filename
* Tweak - Added a hook to allow single day queries in month view to be filtered: tribe_events_month_daily_events_query_args
* Tweak - Improved the logic around rebuilding known date ranges
* Tweak - Always show the "Merge Duplicates" button for venues and organizers in the Events General Settings page
* Tweak - Allow the "same slug" notice to be dismissed and fix some text in that message
* Tweak - Ignore alpha/beta/rc suffixes on version numbers when checking template versions
* Tweak - Add a filter for month view daily events query: tribe_events_month_daily_events_query_args
* Tweak - Added a more flexible cost range parsing function
* Tweak - Obfuscate license keys Events > Help > System Information
* Fix - Fixed a fatal that sometimes occurred when refreshing the import CSV page
* Fix - Fixed issue where some characters were not escaped appropriately for month and year formats
* Fix - Added missing tribe-loading@2x.gif
* Fix - Fixed a warning produced by passing a DateTime() object into start_date or end_date args of tribe_get_events (props to iamhexcoder for the pull request!)
* Fix - Fixed bug where events in month view were not always sorted in chronological order
* Fix - Fixed the System Info URL in Events > Help
* Fix - Resolved issue where the default country would be "Array" if no default country is set
* Fix - Fixed bug where ajaxurl was sometimes undefined

### [4.0.7] 2016-03-02

* Fix - Resolve display issues on templates with Jetpack and a few themes
* Fix - Mobile breakpoints on month view working with custom breakpoints
* Fix - Reordering Venue and Organizer metadata no longer breaks titles
* Fix - Prevented notices from happening when using `the_title` filter
* Fix - iCal links now will respect categories on the first page
* Fix - Prevent third-party bugs with SEO plugins when inserting events programmatically
* Fix - Organizer information is showing up again correctly
* Fix - Modified the add-on license validation method to better explain what is happening
* Fix - Description on mobile views now have the correct class attribute on HTML
* Fix - Added missing semicolon on the list navigation for "&laquo"

### [4.0.6] 2016-02-17

* Tweak - Adjust injection of event data into the_content from priority 10 to 9 for better 3rd-party plugin compatibility
* Tweak - Change mobile month view selector to load event details below the calendar for better theme compatibility
* Tweak - Better handling of edge cases on the post_excerpt for List View
* Tweak - Removal of generic CSS classes like `.updated` and `.published`
* Fix - Prevent Notices from appearing when using `tribe_get_organizer()`
* Fix - Make HTML Single Event Pages valid
* Fix - Numeric named categories URLs are now fully working
* Fix - Event Title now Accepts HTML on Tooltips
* Fix - Licenses Tab now will work with `DISALLOW_FILE_MODS` (Props to Sun for spotting and fixing this)

### [4.0.5] 2016-01-15

* Security - Security fix with Venues and Organizers (props to grantdayjames for reporting this!)

### [4.0.4] 2015-12-23

* Tweak - Including the latest embedded Event Tickets release for backward compatibility

### [4.0.3] 2015-12-22

* Tweak - Adjust single-event.php template to allow the "Time" title and content to be filterable (Props to Sitecrafting for highlighting this issue!)
* Fix - Resolved issue with an overly escaped Event Category edit URL that prevented editing categories (Thanks to Ian for the first report of this issue!)
* Fix - Fixed issue where clicking on columns on the Events listed in the Admin Dashboard were ALWAYS sorted by Event start/end date before sorting by the column selected (Cheers to Corrado for bringing this to our attention!)

### [4.0.2] 2015-12-16

* Tweak - Adding better support for non-numeric cost values on events (Props to Mirja for highlighting this!)
* Tweak - Avoid notice level errors when advanced events list widget settings are saved (Thank you Johan for reporting the issue!)
* Tweak - Improve messaging in the same-slug warning message (Thanks to Simon for bringing this to our attention!)
* Tweak - Hook to Event Tickets to inject event dates into ticket emails
* Tweak - Adding better support for default venues (Props to Karly for noting this!)
* Tweak - Improve handling of internationalized slugs (Cheers to Oliver for the help!)
* Fix - Ensure the past events list displays the correct events when accessed via ajax (Thank you Jesse for highlighting this!)
* Fix - Support ordering by venue/organizer within event queries (Thank you Doug for bringing this to our attention!)
* Fix - Fixed issue where events with the same date/time would sometimes be excluded from single-event navigation (Cheers to JeremyEnglert for the tip!)
* Fix - Resolved issue where events set with the explicit cost of 0 were not showing as "Free" (Thank you terrizsolo for reporting this!)
* Fix - Fixed bug where the datepicker in Twenty Sixteen was really ugly
* Fix - Fixed bug where using Quick Edit on events caused the table columns in the event list to become jumbled on save (Props to A K for the report!)
* Fix - Resolved bug where category links sometimes included event category 1 (Thank you Anthony for the original report of this problem!)
* Fix - Fixed a settings page URL (Props to Kristy for the heads up!)

### [4.0.1] 2015-12-10

* Tweak - Add a warning message for major updates
* Tweak - For SEO reasons, use an h1 for the title rather than an h2 (props to @wpexplorer for this fix)
* Tweak - Target the calendar view grid in JS using a simpler selector
* Fix - Resolved WP 4.4 related fatal on the Nav Menu page that prevented the admin footer from rendering/enqueuing JS
* Fix - Resolved bug where visiting /events/upcoming could sometimes result in an infinite redirect loop
* Fix - Removed `wp_trim_excerpt` and use only it's powers, fixing the excerpt problem
* Fix - Fixed bug where the mobile calendar view did not display the date for the date being viewed
* Fix - Fixed bug where the admin toolbar's Events > Import > CSV did not link to the CSV importer page
* Fix - Fixed issue where the events list in the admin dashboard were not ordered in an intuitive manner
* Fix - Resolved bug where sorting by event category or tag resulted in an error
* Fix - Fixed bug where full event content text was displayed where excerpts should have been displayed
* Fix - Resolved issue where events imported via CSV were excluded from single event navigation
* Fix - Fixed bug where /events/list would sometimes 404 on a new install
* Fix - Resolved bug where multiday all-day events displayed the end date as one day later than it should be when the End of Day Cut-off was set to something other than 12am
* Fix - Timezone handling fixed within generated iCal feeds

### [4.0] 2015-12-02

* Security - A TON of escaping was added to our codebase thanks to the efforts of the always-helpful Andy Fragen (@afragen)
* Feature - Moved the Ticket framework code into its own plugin (event-tickets)
* Feature - The event cost now supports more international formats with the addition of the tribe_events_cost_separators filter (Thank you remokrol for bringing this to our attention!)
* Feature - Added support for the twentysixteen theme
* Feature - Created a new Add-Ons tab in Settings so that TEC add-ons can have a consolidated settings tab
* Feature - Improve the date formats UI by providing example output for each selected format
* Tweak - Restructured TEC's core settings code for reusability with other standalone plugins like Event Tickets
* Tweak - Deprecate old JS event names in favor of a new JS event naming standard. Example: deprecated tribe_ev_runAjax in favor of run-ajax.tribe
* Tweak - Consolidated import pages for TEC and add-ons
* Tweak - When suggesting a UTF-8 compatibility CSV formatting tool, point to one that still exists
* Tweak - Added the ability to filter attendees CSV items via tribe_events_tickets_attendees_csv_items (Props to @bostondv on GitHub for this patch!)
* Tweak - Updated all excerpt output to use tribe_events_get_the_excerpt() to ensure a consistent display of excerpt content (Cheers to Joseph to pointing this out!)
* Tweak - Add support for wp_get_document_title in response to the WordPress 4.4 deprecation of wp_title
* Tweak - Check post creation permissions before letting users create venues and organizers from the event meta box
* Tweak - Only display data separators between fields that have data when rendering organizers (Thank you Bud for highlighting this issue!)
* Tweak - When a user cannot create organizers, prevent the auto-selection of organizers when editing an event
* Tweak - Remove microformat CSS classes from templates and replace with namespaced content-relevant CSS classes
* Tweak - Changed the "updated" CSS class to "tribe-updated" so that it is properly namespaced (Thank you vijayrajesh!)
* Tweak - The Plugin Update Checker will now auto-save valid plugin keys (Thanks to Denon for originally bringing this up!)
* Tweak - Cleaned up the output of JSON-LD data. Filterable via the new tribe_google_data_markup_json filter
* Tweak - Drop the use of the generic CSS class "placeholder" in favor of "tribe-event-placeholder" (Thanks to Marc on the forums!)
* Tweak - Adjusted the CSS padding on Admin Menu items for Events
* Tweak - Various codesniffer fixes
* Tweak - tribe_get_venue_link() no longer echoes if you ask it to return an <a> element
* Tweak - Error messages for empty Venue names
* Tweak - Improve our responsiveness for the widget mini calendar, allowing smaller sidebars.
* Tweak - No longer retrieve empty costs when fetching all costs for all events
* Tweak - Change the priority of bootstrapping the-events-calendar to ensure it occurs before any of the TEC addons in the event some addons are upgraded to v4.0 later than TEC
* Tweak - Adjust the logic used for adding a noindex/follow tag to event views
* Tweak - No longer hiding default address fields when default venues are selected when Pro is active
* Fix - Resolved issue where the iCal feed did not provide an appropriately formatted timezone in some cases (Cheers to Matt for the report!)
* Fix - Added support for translating some previously untranslatable strings (Props to tititou36, media325, and Stef!)
* Fix - Prevented duplicate CSS IDs on the mini calendars (Cheers to Corrado for the help!)
* Fix - Fixed bug causing tribe_get_single_ical_link() and tribe_get_ical_link() to use the same URL when it shouldn't (Props to Ben Byrne @drywall on Twitter for the heads up!)
* Fix - Fixed issue where the "Add another organizer" text wasn't using the correct singular label (Thank you MIKE for the report!)
* Fix - Various CSS fixes for twenty(ten-fifteen)
* Fix - Improved our handling of `get_current_screen()` across the plugin, avoiding notices and warnings (Thank you Mike for the help!)
* Fix - Fixed bug where accessing object properties on a non object errored out when saving event meta (props to @dalethedeveloper on GitHub for this fix!)
* Fix - Fixed bug where organizer ID meta attached sometimes included a blank record. That blank record is no longer returned in tribe_get_organizer_ids()
* Fix - Fixed error message returned when tabbing away from a blank event name meta box so that it properly indicates that an event name is required (Our thanks to @tapan29bd for this fix!)
* Fix - Resolved issue where Timezone event start/end date property name strings were malformed which guaranteed a a call to get_post_meta for Timezone date strings
* Fix - Fixed CSS issue where the month view calendar could sometimes extend beyond the edge of the page when Skeleton Styles were enabled
* Fix - Fixed a problem where iCal data was generated with incorrect dates in the case of some all days events (thanks to Matt for highlighting this)
* Fix - Resolved a problem causing the previous month view to appear when it should not
* Fix - Fixed issue in mobile month view where date was missing from heading
* Fix - Resolved issue that caused /events/ to 404 if it was visited on a new install before hitting "Save" on the Events > Settings > Display page
* Deprecated - The Tribe__Events__Main::defaultValueReplaceEnabled() method is being deprecated in favor of tribe_get_option('defaultValueReplace'). Schedules for removal in v4.5
* Deprecated - The tribe_event_link() has been deprecated in favor of tribe_get_event_link(). Scheduled for removal in 5.0
* Deprecated - The third parameter of tribe_get_organizer_link() (the $echo parameter) has been deprecated and is scheduled for removal in 5.0
* Deprecated - Tribe__Events__Abstract_Deactivation in favor of Tribe__Abstract_Deactivation
* Deprecated - Tribe__Events__Admin__Helpers in favor of Tribe__Admin__Helpers
* Deprecated - Tribe__Events__App_Shop in favor of Tribe__App_Shop
* Deprecated - Tribe__Events__Autoloader in favor of Tribe__Autoloader
* Deprecated - Tribe__Events__Cache in favor of Tribe__Cache
* Deprecated - Tribe__Events__Cache_Listener in favor of Tribe__Cache_Listener
* Deprecated - Tribe__Events__Changelog_Reader in favor of Tribe__Changelog_Reader
* Deprecated - Tribe__Events__Credits in favor of Tribe__Credits
* Deprecated - Tribe__Events__Date_Utils in favor of Tribe__Date_Utils
* Deprecated - Tribe__Events__Field in favor of Tribe__Field
* Deprecated - Tribe__Events__Settings in favor of Tribe__Settings
* Deprecated - Tribe__Events__Settings_Tab in favor of Tribe__Settings_Tab
* Deprecated - Tribe__Events__Support in favor of Tribe__Support
* Deprecated - Tribe__Events__Template_Part_Cache in favor of Tribe__Template_Part_Cache
* Deprecated - Tribe__Events__Tickets__Attendees_Table in favor of Tribe__Tickets__Attendees_Table in the event-tickets plugin
* Deprecated - Tribe__Events__Tickets__Metabox in favor of Tribe__Tickets__Metabox in the event-tickets plugin
* Deprecated - Tribe__Events__Tickets__Ticket_Object in favor of Tribe__Tickets__Ticket_Object in the event-tickets plugin
* Deprecated - Tribe__Events__Tickets__Tickets in favor of Tribe__Tickets__Tickets in the event-tickets plugin
* Deprecated - Tribe__Events__Tickets__Tickets_Pro in favor of Tribe__Tickets__Tickets_Handler in the event-tickets plugin
* Deprecated - Tribe__Events__Validate in favor of Tribe__Validate
* Deprecated - Tribe__Events__View_Helpers in favor of Tribe__View_Helpers
* Deprecated - Tribe__Events__Main::OPTIONNAME in favor of Tribe__Main::OPTIONNAME
* Deprecated - Tribe__Events__Main::OPTIONNAMENETWORK in favor of Tribe__Main::OPTIONNAMENETWORK
* Deprecated - Tribe__Events__Main::addHelpAdminMenuItem() in favor of Tribe__Settings_Manager::add_help_admin_menu_item()
* Deprecated - Tribe__Events__Main::addNetworkOptionsPage() in favor of Tribe__Settings_Manager::add_network_options_page()
* Deprecated - Tribe__Events__Main::array_insert_after_key() in favor of Tribe__Main::array_insert_after_key()
* Deprecated - Tribe__Events__Main::array_insert_before_key() in favor of Tribe__Main::array_insert_before_key()
* Deprecated - Tribe__Events__Main::debug() in favor of Tribe__Debug::debug()
* Deprecated - Tribe__Events__Main::defaultValueReplaceEnabled() in favor of tribe_get_option( 'defaultValueReplace' )
* Deprecated - Tribe__Events__Main::doHelpTab() in favor of Tribe__Settings_Manager::do_help_tab()
* Deprecated - Tribe__Events__Main::doNetworkSettingTab() in favor of Tribe__Settings_Manager::do_network_settings_tab()
* Deprecated - Tribe__Events__Main::doSettingTabs() in favor of Tribe__Settings_Manager::do_setting_tabs()
* Deprecated - Tribe__Events__Main::do_licenses_tab() in favor of Tribe__Settings_Manager::do_licenses_tab()
* Deprecated - Tribe__Events__Main::getNetworkOption() in favor of Tribe__Settings_Manager::get_network_option()
* Deprecated - Tribe__Events__Main::getNetworkOptions() in favor of Tribe__Settings_Manager::get_network_options()
* Deprecated - Tribe__Events__Main::getNotices() in favor of Tribe__Notices::get()
* Deprecated - Tribe__Events__Main::getOption() in favor of Tribe__Settings_Manager::get_option()
* Deprecated - Tribe__Events__Main::getOptions() in favor of Tribe__Settings_Manager::get_options()
* Deprecated - Tribe__Events__Main::have_addons() in favor of Tribe__Settings_Manager::have_addons()
* Deprecated - Tribe__Events__Main::isNotice() in favor of Tribe__Notices::is_notice()
* Deprecated - Tribe__Events__Main::pluginDir in favor of Tribe__Events__Main::plugin_dir
* Deprecated - Tribe__Events__Main::pluginName in favor of Tribe__Events__Main::plugin_name
* Deprecated - Tribe__Events__Main::pluginPath in favor of Tribe__Events__Main::plugin_path
* Deprecated - Tribe__Events__Main::pluginUrl in favor of Tribe__Events__Main::plugin_url
* Deprecated - Tribe__Events__Main::removeNotice() in favor of Tribe__Notices::remove_notice()
* Deprecated - Tribe__Events__Main::renderDebug() in favor of Tribe__Debug::render()
* Deprecated - Tribe__Events__Main::saveAllTabsHidden() in favor of Tribe__Settings_Manager::save_all_tabs_hidden()
* Deprecated - Tribe__Events__Main::setNetworkOptions() in favor of Tribe__Settings_Manager::set_network_options()
* Deprecated - Tribe__Events__Main::setNotice() in favor of Tribe__Notices::set_notice()
* Deprecated - Tribe__Events__Main::truncate() in favor of tribe_events_get_the_excerpt()
* Deprecated - tribe_event_beginning_of_day() in favor of tribe_beginning_of_day()
* Deprecated - tribe_event_end_of_day() in favor of tribe_end_of_day()
* Deprecated - tribe_event_format_date() in favor of tribe_format_date()
* Deprecated - tribe_events_the_notices() in favor of tribe_the_notices()

> [!IMPORTANT]
> ### 3.x and previous
>
> For release notes from the 3.x and older lifecycles, see our [full historical release notes](https://theeventscalendar.com/category/products/release-notes/).
