<?php

/**
 * Fires when the plugin is uninstalled.
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Check if Keep Data and Settings on Uninstall option is activated. If activated, do not erase data and settings
$keep_data_setting = boolval( get_option( 'smuac_keepdata_setting', 1 ) );

// If "keep data" option is NOT activated
if ( ! $keep_data_setting ) {

	// List all options
	$optionlist = array( 'smuac_plugin_status_setting', 'smuac_quotename_setting', 'smuac_quoteemail_setting', 'smuac_quotephone_setting', 'smuac_quotemessage_setting', 'smuac_quote_button_cart_setting', 'smuac_integrate_quotes_discussions_setting', 'smuac_guest_access_restriction_setting', 'smuac_hidden_has_priority_setting', 'smuac_registration_options_dropdown_setting', 'smuac_registration_at_checkout_setting', 'smuac_approval_required_all_users_setting', 'smuac_validate_vat_button_checkout_setting', 'smuac_replace_selector_text_setting', 'smuac_bundles_product_image_setting', 'smuac_enable_discussions_setting', 'smuac_enable_quoterequests_setting', 'smuac_enable_bundles_setting', 'smuac_enable_shopping_lists_setting', 'smuac_enable_bulk_order_form_setting', 'smuac_enable_multiaccounts_setting', 'smuac_enable_product_visibility_setting', 'smuac_hide_prices_guests_text_setting', 'smuac_hide_b2b_site_text_setting', 'smuac_hidden_price_dynamic_rule_text_setting', 'smuac_shopping_lists_language_setting', 'smuac_keepdata_setting', 'smuac_multisite_separate_b2bb2c_setting', 'smuac_search_by_sku_setting', 'smuac_search_product_description_setting', 'smuac_search_each_variation_setting', 'smuac_show_accounting_subtotals_setting', 'smuac_force_permalinks_flushing_setting', 'smuac_force_permalinks_setting', 'smuac_replace_product_selector_setting', 'smuac_hide_users_dynamic_rules_setting', 'smuac_product_visibility_cache_setting', 'smuac_vat_exemption_different_country_setting' );

	// Delete all options
	foreach ( $optionlist as $option_name ) {
		delete_option( $option_name );
	}
}
