<?php
/*
/**
 * Plugin Name:       Subaccounts & Multi-User Accounts
 * Plugin URI:        https://woocommerce.com/products/subaccounts-multiuser-accounts
 * Description:       Subaccounts & Multi-User Accounts enables powerful, distributed, multi-user access to buyer accounts.
 * Version:           1.2.5
 * Author:            WebWizards
 * Author URI:        webwizards.dev
 * Developer:         WebWizards
 * Developer URI:     https://webwizards.dev
 * Text Domain:       smuac
 * Domain Path:       /languages
 *
 * Woo: 7882898:9e743f0e65c5b27d3182c5d2bdc5ce1b
 * WC requires at least: 3.0.0
 * WC tested up to: 8.0.0
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'SMUAC_DIR', plugin_dir_path( __FILE__ ) );

function smuac_activate() {
	require_once SMUAC_DIR . 'includes/class-smuac-activator.php';
	Smuac_Activator::activate();
}
register_activation_hook( __FILE__, 'smuac_activate' );

require SMUAC_DIR . 'includes/class-smuac.php';

// Load plugin language
add_action( 'init', 'smuac_load_language' );
function smuac_load_language() {
	load_plugin_textdomain( 'smuac', false, basename( dirname( __FILE__ ) ) . '/languages' );
}

// Begins execution of the plugin.
function smuac_run() {
	 $plugin = new Smuac();
}

smuac_run();

add_action(
	'before_woocommerce_init',
	function() {
		if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	}
);
