/**
 *
 * JavaScript file that handles public side JS
 */
(function($){

	"use strict";

	$( document ).ready(
		function() {

			/* Multiaccounts START */
			// On clicking 'New Multiaccount'
			$( '.smuac_multiaccounts_container_top_button' ).on(
				'click',
				function(){
					// Hide multiaccounts, show new multiaccount
					$( '.smuac_multiaccounts_new_account_container' ).css( 'display','block' );
					$( '.smuac_multiaccounts_account_container' ).css( 'display','none' );
					$( '.smuac_multiaccounts_container_top_button' ).css( 'display','none' );
				}
			);
			// On clicking 'Close X', reverse
			$( '.smuac_multiaccounts_new_account_container_top_close' ).on(
				'click',
				function(){
					$( '.smuac_multiaccounts_new_account_container' ).css( 'display','none' );
					$( '.smuac_multiaccounts_account_container' ).css( 'display','block' );
					$( '.smuac_multiaccounts_container_top_button' ).css( 'display','inline-flex' );
				}
			);

			// On clicking "Create new multiaccount"
			$( '.smuac_multiaccounts_new_account_container_content_bottom_button' ).on(
				'click',
				function(){
					// clear displayed validation errors
					$( '.smuac_multiaccounts_new_account_container_content_bottom_validation_errors' ).html( '' );
					let validationErrors = '';
					// get username and email and password

					let username = 123;
					if (parseInt( smuac_display_settings.disable_username_subaccounts ) === 0) {
						username = $( 'input[name="smuac_multiaccounts_new_account_username"]' ).val().trim();
					}

					let email    = $( 'input[name="smuac_multiaccounts_new_account_email_address"]' ).val().trim();
					let password = $( 'input[name="smuac_multiaccounts_new_account_password"]' ).val().trim();

					// check against regex
					if (parseInt( smuac_display_settings.disable_username_subaccounts ) === 0) {
						if (/^(?!.*[_.]$)(?=.{8,30}$)(?![_.])(?!.*[_.]{2})[a-zA-Z0-9._-]+$/.test( username ) === false) {
							validationErrors += smuac_display_settings.newMultiaccountUsernameError;
						}
					}
					if (/^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/.test( email ) === false) {
						validationErrors += smuac_display_settings.newMultiaccountEmailError;
					}
					if (/^(?=.*[A-Za-z])(?=.*[\d]).{8,}$/.test( password ) === false) {
						validationErrors += smuac_display_settings.newMultiaccountPasswordError;
					}

					if (validationErrors !== '') {
						// show errors
						$( '.smuac_multiaccounts_new_account_container_content_bottom_validation_errors' ).html( validationErrors );
					} else {
						// proceed with AJAX account registration request

						// get all other data
						let name     = $( 'input[name="smuac_multiaccounts_new_account_name"]' ).val().trim();
						let jobTitle = $( 'input[name="smuac_multiaccounts_new_account_job_title"]' ).val().trim();
						let phone    = $( 'input[name="smuac_multiaccounts_new_account_phone_number"]' ).val().trim();

						// checkboxes are true or false
						let checkboxBuy             = $( 'input[name="smuac_multiaccounts_new_account_container_content_element_checkbox_buy"]' ).prop( 'checked' );
						let checkboxViewOrders      = $( 'input[name="smuac_multiaccounts_new_account_container_content_element_checkbox_view_orders"]' ).prop( 'checked' );
						let checkboxViewBundles     = $( 'input[name="smuac_multiaccounts_new_account_container_content_element_checkbox_view_bundles"]' ).prop( 'checked' );
						let checkboxViewDiscussions = $( 'input[name="smuac_multiaccounts_new_account_container_content_element_checkbox_view_discussions"]' ).prop( 'checked' );
						let checkboxViewLists       = $( 'input[name="smuac_multiaccounts_new_account_container_content_element_checkbox_view_lists"]' ).prop( 'checked' );

						// send AJAX account creation request
						var datavar = {
							action: 'smuac_create_multiaccount',
							security: smuac_display_settings.security,
							username: username,
							password: password,
							name: name,
							jobTitle: jobTitle,
							email: email,
							phone: phone,
							permissionBuy: checkboxBuy,
							permissionViewOrders: checkboxViewOrders,
							permissionViewBundles: checkboxViewBundles,
							permissionViewDiscussions: checkboxViewDiscussions,
							permissionViewLists: checkboxViewLists,
						};

						$.post(
							smuac_display_settings.ajaxurl,
							datavar,
							function(response){
								if (response === 'error') {
									$( '.smuac_multiaccounts_new_account_container_content_bottom_validation_errors' ).html( smuac_display_settings.newMultiaccountAccountError );
								} else if (response === 'error_maximum_multiaccounts') {
									$( '.smuac_multiaccounts_new_account_container_content_bottom_validation_errors' ).html( smuac_display_settings.newMultiaccountMaximumMultiaccountsError );
								} else {
									// go to multiaccounts endpoint
									window.location = smuac_display_settings.multiaccountsurl;
								}
							}
						);
					}
				}
			);

			// On clicking "Update multiaccount"
			$( '.smuac_multiaccounts_edit_account_container_content_bottom_button' ).on(
				'click',
				function(){
					// get details and permissions
					let multiaccountId = $( '.smuac_multiaccounts_edit_account_container_content_bottom_button' ).val().trim();
					let name           = $( 'input[name="smuac_multiaccounts_new_account_name"]' ).val().trim();
					let jobTitle       = $( 'input[name="smuac_multiaccounts_new_account_job_title"]' ).val().trim();
					let phone          = $( 'input[name="smuac_multiaccounts_new_account_phone_number"]' ).val().trim();

					// checkboxes are true or false
					let checkboxBuy             = $( 'input[name="smuac_multiaccounts_new_account_container_content_element_checkbox_buy"]' ).prop( 'checked' );
					let checkboxViewOrders      = $( 'input[name="smuac_multiaccounts_new_account_container_content_element_checkbox_view_orders"]' ).prop( 'checked' );
					let checkboxViewBundles     = $( 'input[name="smuac_multiaccounts_new_account_container_content_element_checkbox_view_bundles"]' ).prop( 'checked' );
					let checkboxViewDiscussions = $( 'input[name="smuac_multiaccounts_new_account_container_content_element_checkbox_view_discussions"]' ).prop( 'checked' );
					let checkboxViewLists       = $( 'input[name="smuac_multiaccounts_new_account_container_content_element_checkbox_view_lists"]' ).prop( 'checked' );

					// send AJAX account creation request
					var datavar = {
						action: 'smuac_update_multiaccount',
						security: smuac_display_settings.security,
						multiaccountId: multiaccountId,
						name: name,
						jobTitle: jobTitle,
						phone: phone,
						permissionBuy: checkboxBuy,
						permissionViewOrders: checkboxViewOrders,
						permissionViewBundles: checkboxViewBundles,
						permissionViewDiscussions: checkboxViewDiscussions,
						permissionViewLists: checkboxViewLists,
					};

					$.post(
						smuac_display_settings.ajaxurl,
						datavar,
						function(response){
							// go to multiaccounts endpoint
							window.location = smuac_display_settings.multiaccountsurl;
						}
					);
				}
			);

			// on clicking close inside multiaccount edit
			$( '.smuac_multiaccounts_edit_account_container_top_close' ).on(
				'click',
				function(){
					// go to multiaccounts endpoint
					window.location = smuac_display_settings.multiaccountsurl;
				}
			);

			// on clicking delete user, run same function as reject user
			$( '.smuac_multiaccounts_edit_account_container_content_bottom_button_delete' ).on(
				'click',
				function(){
					if (confirm( smuac_display_settings.are_you_sure_delete )) {
						var datavar = {
							action: 'smuacrejectuser',
							security: smuac_display_settings.security,
							user: $( '.smuac_multiaccounts_edit_account_container_content_bottom_button' ).val().trim(),
							ismultiaccount: 'yes',
						};

						$.post(
							smuac_display_settings.ajaxurl,
							datavar,
							function(response){
								// go to multiaccounts endpoint
								window.location = smuac_display_settings.multiaccountsurl;
							}
						);
					}
				}
			);

			/* Multiaccounts END */

			/* Bulk order form START */
			// On clicking "new line", prepend newline to button container
			$( '.smuac_bulkorder_form_container_newline_button' ).on(
				'click',
				function(){
					// add line
					$( '.smuac_bulkorder_form_container_newline_container' ).before(
						'<div class="smuac_bulkorder_form_container_content_line">' +
						'<input type="text" class="smuac_bulkorder_form_container_content_line_product" >' +
						'<input type="number" min="0" class="smuac_bulkorder_form_container_content_line_qty">' +
						'<div class="smuac_bulkorder_form_container_content_line_subtotal">' +
							smuac_display_settings.currency_symbol + '0' +
						'</div>' +
						'<div class="smuac_bulkorder_form_container_content_line_livesearch">' +
						'</div>' +
						'</div>'
					);
				}
			);

			// on click 'save list' in bulk order form
			$( '.smuac_bulkorder_form_container_bottom_save_button' ).on(
				'click',
				function(){
					let title = window.prompt( smuac_display_settings.save_list_name, "" );

					if (title !== '' && title !== null) {

						let productString = '';
						// loop through all bulk order form lines
						document.querySelectorAll( '.smuac_bulkorder_form_container_content_line_product' ).forEach(
							function(textinput) {
								var classList = $( textinput ).attr( 'class' ).split( /\s+/ );
								$.each(
									classList,
									function(index, item) {
										// foreach line if it has selected class, get selected product ID
										if (item.includes( 'smuac_selected_product_id_' )) {
											let productID = item.split( '_' )[4];
											let quantity  = $( textinput ).parent().find( '.smuac_bulkorder_form_container_content_line_qty' ).val();
											if (quantity > 0) {
												// set product
												productString += productID + ':' + quantity + '|';
											}
										}
									}
								);
							}
						);
						// if not empty, send
						if (productString !== '') {
							var datavar = {
								action: 'smuac_bulkorder_save_list',
								security: smuac_display_settings.security,
								productstring: productString,
								title: title,
							};

							$.post(
								smuac_display_settings.ajaxurl,
								datavar,
								function(response){
									// list has been saved
									alert( smuac_display_settings.list_saved );
								}
							);
						}
					}
				}
			);

			$( 'body' ).on(
				'input',
				'.smuac_bulkorder_form_container_content_line_product',
				function(){

					let parent      = $( this ).parent();
					let inputValue  = $( this ).val();
					let searchbyval = $( '#smuac_bulkorder_searchby_select' ).val();
					if (typeof(searchbyval) === "undefined") {
						searchbyval = 'productname';
					}
					parent.find( '.smuac_bulkorder_form_container_content_line_livesearch' ).html( '<img class="smuac_loader_img" src="' + smuac_display_settings.loaderurl + '">' );
					parent.find( '.smuac_bulkorder_form_container_content_line_livesearch' ).css( 'display','block' );
					if (inputValue.length > 0) { // min x chars
						// run search AJAX function
						var datavar = {
							action: 'smuac_ajax_search',
							security: smuac_display_settings.security,
							searchValue: inputValue,
							searchby: searchbyval,
							dataType: 'json'
						};

						$.post(
							smuac_display_settings.ajaxurl,
							datavar,
							function(response){

								let display = '';
								let results = response;
								if (parseInt( results ) !== 1234) { // 1234 Integer for Empty
									let resultsObject = JSON.parse( results );
									Object.keys( resultsObject ).forEach(
										function (index) {
											if (index.includes( 'SMUACPRICE' )) {
												prices[index] = resultsObject[index];
											} else if (index.includes( 'SMUACIMAGE' )) {
												images[index] = resultsObject[index];
											} else {
												let img = index + 'SMUACIMAGE';
												if (resultsObject[img] !== 'no') {
													display += '<div class="smuac_livesearch_product_result productid_' + index + '">' + resultsObject[index] + '<img class="smuac_livesearch_image" src="' + resultsObject[img] + '"></div>';
												} else {
													display += '<div class="smuac_livesearch_product_result productid_' + index + '">' + resultsObject[index] + '</div>';
												}
											}
										}
									);
								} else {
									display = smuac_display_settings.no_products_found;
								}

								parent.find( '.smuac_bulkorder_form_container_content_line_livesearch' ).html( display );
							}
						);
					} else {
						parent.find( '.smuac_bulkorder_form_container_content_line_livesearch' ).css( 'display','none' );
					}
				}
			);

			var prices = Object;
			var images = Object;

			// on clicking on search result, set result in field
			$( 'body' ).on(
				'click',
				'.smuac_livesearch_product_result',
				function(){
					let title     = $( this ).text();
					let parent    = $( this ).parent().parent();
					var classList = $( this ).attr( 'class' ).split( /\s+/ );
					$.each(
						classList,
						function(index, item) {
							if (item.includes( 'productid' )) {

								let productID = item.split( '_' )[1];
								// set input disabled
								parent.find( '.smuac_bulkorder_form_container_content_line_product' ).val( title );
								parent.find( '.smuac_bulkorder_form_container_content_line_product' ).css( 'color', smuac_display_settings.colorsetting );
								parent.find( '.smuac_bulkorder_form_container_content_line_product' ).css( 'font-weight', 'bold' );
								parent.find( '.smuac_bulkorder_form_container_content_line_product' ).addClass( 'smuac_selected_product_id_' + productID );
								parent.find( '.smuac_bulkorder_form_container_content_line_product' ).after( '<button class="smuac_bulkorder_clear">' + smuac_display_settings.clearx + '</button>' );
								setTimeout(
									function(){
										parent.find( '.smuac_bulkorder_form_container_content_line_product' ).prop( 'disabled', true );
										parent.find( '.smuac_bulkorder_form_container_content_line_livesearch' ).css( 'display','none' );
									},
									125
								);

							}
						}
					);
					calculateBulkOrderTotals();
				}
			);

			$( 'body' ).on(
				'click',
				'.smuac_bulkorder_clear',
				function(){
					let parent = $( this ).parent();
					let line   = parent.find( '.smuac_bulkorder_form_container_content_line_product' );
					let qty    = parent.find( '.smuac_bulkorder_form_container_content_line_qty' );
					line.prop( 'disabled', false );
					line.removeAttr( "style" );
					line.val( '' );
					qty.val( '' );
					var classList = line.attr( 'class' ).split( /\s+/ );
					$.each(
						classList,
						function(index, item) {
							if (item.includes( 'smuac_selected_product_id_' )) {
								line.removeClass( item );
							}
						}
					);

					calculateBulkOrderTotals();
					$( this ).remove();

				}
			);

			// on click add to cart
			$( '.smuac_bulkorder_form_container_bottom_add_button' ).on(
				'click',
				function(){

					let productString = '';
					// loop through all bulk order form lines
					document.querySelectorAll( '.smuac_bulkorder_form_container_content_line_product' ).forEach(
						function(textinput) {
							var classList = $( textinput ).attr( 'class' ).split( /\s+/ );
							$.each(
								classList,
								function(index, item) {
									// foreach line if it has selected class, get selected product ID
									if (item.includes( 'smuac_selected_product_id_' )) {
										let productID = item.split( '_' )[4];
										let quantity  = $( textinput ).parent().find( '.smuac_bulkorder_form_container_content_line_qty' ).val();
										if (quantity > 0) {
											// set product
											productString += productID + ':' + quantity + '|';
										}
									}
								}
							);
						}
					);
					// if not empty, send
					if (productString !== '') {
						var datavar = {
							action: 'smuac_bulkorder_add_cart',
							security: smuac_display_settings.security,
							productstring: productString,
						};

						$.post(
							smuac_display_settings.ajaxurl,
							datavar,
							function(response){
								window.location = smuac_display_settings.carturl;
							}
						);
					}
				}
			);

			// on product or quantity change, calculate totals
			$( 'body' ).on(
				'input',
				'.smuac_bulkorder_form_container_content_line_qty',
				function(){
					calculateBulkOrderTotals();
				}
			);

			function calculateBulkOrderTotals(){
				let total = 0;
				// loop through all bulk order form lines
				document.querySelectorAll( '.smuac_bulkorder_form_container_content_line_product' ).forEach(
					function(textinput) {
						var classList = $( textinput ).attr( 'class' ).split( /\s+/ );
						$.each(
							classList,
							function(index, item) {
								// foreach line if it has selected class, get selected product ID
								if (item.includes( 'smuac_selected_product_id_' )) {
									let productID = item.split( '_' )[4];
									let quantity  = $( textinput ).parent().find( '.smuac_bulkorder_form_container_content_line_qty' ).val();
									if (quantity > 0) {
										let index = productID + 'SMUACPRICE';
										let price = parseFloat( prices[index] );

										let subtotal = price * quantity;
										subtotal     = parseFloat( subtotal.toFixed( 2 ) );
										setTimeout(
											function(){
												if (parseInt( smuac_display_settings.accountingsubtotals ) === 1) {
													// get price html via WC PRICE
													var datavar = {
														action: 'smuac_accountingsubtotals',
														security: smuac_display_settings.security,
														pricesent: subtotal,
													};

													$.post(
														smuac_display_settings.ajaxurl,
														datavar,
														function(response){
															$( textinput ).parent().find( '.smuac_bulkorder_form_container_content_line_subtotal' ).html( response );
														}
													);

												} else {
													$( textinput ).parent().find( '.smuac_bulkorder_form_container_content_line_subtotal' ).text( smuac_display_settings.currency_symbol + subtotal );
												}
											},
											100
										);
										total = total + subtotal;
										total = parseFloat( total.toFixed( 2 ) );
									} else {
										$( textinput ).parent().find( '.smuac_bulkorder_form_container_content_line_subtotal' ).text( smuac_display_settings.currency_symbol + 0 );
									}
								} else {
									$( textinput ).parent().find( '.smuac_bulkorder_form_container_content_line_subtotal' ).text( smuac_display_settings.currency_symbol + 0 );
								}
							}
						);

					}
				);

				if (parseInt( smuac_display_settings.accountingsubtotals ) === 1) {
					// get price html via WC PRICE
					var datavar = {
						action: 'smuac_accountingsubtotals',
						security: smuac_display_settings.security,
						pricesent: total,
					};

					$.post(
						smuac_display_settings.ajaxurl,
						datavar,
						function(response){
							$( '.smuac_bulkorder_form_container_bottom_total' ).html( response );
						}
					);

				} else {
					$( '.smuac_bulkorder_form_container_bottom_total' ).text( smuac_display_settings.currency_symbol + total );
				}

			}

			/* Bulk order form END */

			/* Shopping Lists START */

			// shopping lists data table
			$( '#smuac_shopping_lists_table' ).dataTable(
				{
					"language": {
						"url": smuac_display_settings.datatables_folder + smuac_display_settings.shopping_lists_language_option + '.json'
					}
				}
			);

			// on click 'trash' in shopping list
			$( '.smuac_bulkorder_form_container_bottom_delete_button' ).on(
				'click',
				function(){
					if (confirm( smuac_display_settings.are_you_sure_delete_list )) {
						let listId = $( this ).val();

						var datavar = {
							action: 'smuac_shopping_list_delete',
							security: smuac_display_settings.security,
							listid: listId
						};

						$.post(
							smuac_display_settings.ajaxurl,
							datavar,
							function(response){
								window.location = smuac_display_settings.purchaselistsurl;
							}
						);
					}
				}
			);

			// on click 'update' in shopping list
			$( '.smuac_bulkorder_form_container_bottom_update_button' ).on(
				'click',
				function(){
					let listId = $( this ).val();

					let productString = '';
					// loop through all bulk order form lines
					document.querySelectorAll( '.smuac_bulkorder_form_container_content_line_product' ).forEach(
						function(textinput) {
							var classList = $( textinput ).attr( 'class' ).split( /\s+/ );
							$.each(
								classList,
								function(index, item) {
									// foreach line if it has selected class, get selected product ID
									if (item.includes( 'smuac_selected_product_id_' )) {
										let productID = item.split( '_' )[4];
										let quantity  = $( textinput ).parent().find( '.smuac_bulkorder_form_container_content_line_qty' ).val();
										if (quantity > 0) {
											// set product
											productString += productID + ':' + quantity + '|';
										}
									}
								}
							);
						}
					);
					// if not empty, send
					if (productString !== '') {
						var datavar = {
							action: 'smuac_shopping_list_update',
							security: smuac_display_settings.security,
							productstring: productString,
							listid: listId
						};

						$.post(
							smuac_display_settings.ajaxurl,
							datavar,
							function(response){
								window.location = smuac_display_settings.purchaselistsurl;
							}
						);
					}
				}
			);

			// if this is a shopping list
			let isPurchaseList = $( '#smuac_shopping_list_page' ).val();
			if (isPurchaseList !== undefined) {
				// add "selected" style to list items
				$( '.smuac_bulkorder_form_container_content_line_product' ).css( 'color', smuac_display_settings.colorsetting );
				$( '.smuac_bulkorder_form_container_content_line_product' ).css( 'font-weight', 'bold' );
				// get pricing details that will allow to calculate subtotals
				document.querySelectorAll( '.smuac_bulkorder_form_container_content_line_product' ).forEach(
					function(textinput) {
						let inputValue = $( textinput ).val();
						var datavar    = {
							action: 'smuac_ajax_search',
							security: smuac_display_settings.security,
							searchValue: inputValue,
							searchType: 'purchaseListLoading',
							dataType: 'json'
						};

						$.post(
							smuac_display_settings.ajaxurl,
							datavar,
							function(response){
								let results = response;
								if (results !== '"empty"') {
									let resultsObject = JSON.parse( results );
									Object.keys( resultsObject ).forEach(
										function (index) {
											if (index.includes( 'SMUACPRICE' )) {
												prices[index] = resultsObject[index];
											}
										}
									);
								}
							}
						);
					}
				);

			}

			$( 'body' ).on(
				'click',
				'.smuac_add_cart_to_shopping_list_button',
				function(){

					let title = window.prompt( smuac_display_settings.save_list_name, "" );
					if (title !== '' && title !== null) {

						var datavar = {
							action: 'smuac_save_cart_to_shopping_list',
							security: smuac_display_settings.security,
							title: title,
							dataType: 'json'
						};

						$.post(
							smuac_display_settings.ajaxurl,
							datavar,
							function(response){
								$( '.smuac_add_cart_to_shopping_list_button' ).text( smuac_display_settings.list_saved );
								$( '.smuac_add_cart_to_shopping_list_button' ).prop( 'disabled', true );
							}
						);
					}
				}
			);

			/* Shopping Lists END */

		}
	);

})( jQuery );
