<?php

class Smuac {


	public function __construct() {

		// Handle Ajax Requests
		if ( wp_doing_ajax() ) {
			// interferes in the product page for some reason with variation loading

			add_action(
				'plugins_loaded',
				function () {

					/*
					Groups */
					// Set up product/category user/user group visibility rules
					if ( 1 === intval( get_option( 'smuac_enable_product_visibility_setting', 0 ) ) ) {
						if ( 0 === intval( get_option( 'smuac_disable_visibility_setting', 0 ) ) ) {
							// if user is not admin or shop manager
							if ( ! current_user_can( 'manage_woocommerce' ) ) {
								// if caching is enabled
								if ( intval( get_option( 'smuac_product_visibility_cache_setting', 1 ) ) === 1 ) {
									add_action( 'pre_get_posts', array( $this, 'smuac_product_categories_visibility_rules' ) );
								}
							}
						}
					}

					// Add Fixed Price Rule to AJAX product searches
					// Check if plugin status is B2B OR plugin status is Hybrid and user is B2B user.
					if ( isset( $_COOKIE['smuac_userid'] ) ) {
						$cookieuserid = sanitize_text_field( $_COOKIE['smuac_userid'] );
					} else {
						$cookieuserid = '999999999999';
					}
					if ( 'b2b' === get_option( 'smuac_plugin_status_setting', 'b2b' ) || ( 'hybrid' === get_option( 'smuac_plugin_status_setting', 'b2b' ) && ( 'yes' === get_user_meta( get_current_user_id(), 'smuac_b2buser', true ) || 'yes' === get_user_meta( $cookieuserid, 'smuac_b2buser', true ) ) ) ) {
						if ( 0 === intval( get_option( 'smuac_disable_dynamic_rule_fixedprice_setting', 0 ) ) ) {
							// check the number of rules saved in the database
							if ( 'yes' === get_option( 'smuac_have_fixed_price_rules', 'yes' ) ) {
								// check if the user's ID or group is part of the list.
								$list = get_option( 'smuac_have_fixed_price_rules_list', 'yes' );
								if ( 'yes' === $this->smuac_user_is_in_list( $list ) ) {
									add_filter( 'woocommerce_product_get_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_fixed_price' ), 9999, 2 );
									add_filter( 'woocommerce_product_get_regular_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_fixed_price' ), 9999, 2 );
									// Variations
									add_filter( 'woocommerce_product_variation_get_regular_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_fixed_price' ), 9999, 2 );
									add_filter( 'woocommerce_product_variation_get_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_fixed_price' ), 9999, 2 );
									add_filter( 'woocommerce_variation_prices_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_fixed_price' ), 9999, 2 );
									add_filter( 'woocommerce_variation_prices_regular_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_fixed_price' ), 9999, 2 );
								}
							}
						}
					}

					// Add Discount rule to AJAX product searches
					if ( 'b2b' === get_option( 'smuac_plugin_status_setting', 'b2b' ) || ( 'hybrid' === get_option( 'smuac_plugin_status_setting', 'b2b' ) && ( 'yes' === get_user_meta( get_current_user_id(), 'smuac_b2buser', true ) ) ) ) {
						if ( 0 === intval( get_option( 'smuac_disable_dynamic_rule_discount_sale_setting', 0 ) ) ) {
							if ( 'yes' === get_option( 'smuac_have_discount_everywhere_rules', 'yes' ) ) {
								// check if the user's ID or group is part of the list.
								$list = get_option( 'smuac_have_discount_everywhere_rules_list', 'yes' );
								if ( 'yes' === $this->smuac_user_is_in_list( $list ) ) {
									add_filter( 'woocommerce_product_get_regular_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_discount_regular_price' ), 9999, 2 );
									add_filter( 'woocommerce_product_variation_get_regular_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_discount_regular_price' ), 9999, 2 );
									// Generate "sale price" dynamically
									add_filter( 'woocommerce_product_get_sale_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_discount_sale_price' ), 9999, 2 );
									add_filter( 'woocommerce_product_variation_get_sale_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_discount_sale_price' ), 9999, 2 );
									add_filter( 'woocommerce_variation_prices_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_discount_sale_price' ), 9999, 2 );
									add_filter( 'woocommerce_variation_prices_sale_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_discount_sale_price' ), 9999, 2 );
									add_filter( 'woocommerce_get_variation_prices_hash', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_discount_sale_price_variation_hash' ), 99, 1 );

									// Displayed formatted regular price + sale price
									add_filter( 'woocommerce_get_price_html', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_discount_display_dynamic_price' ), 9999, 2 );
									// Set sale price in Cart
									add_action( 'woocommerce_before_calculate_totals', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_discount_display_dynamic_price_in_cart' ), 9999, 1 );
									// Function to make this work for MiniCart as well
									add_filter( 'woocommerce_cart_item_price', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_discount_display_dynamic_price_in_cart_item' ), 9999, 3 );

									// Change "Sale!" badge text
									add_filter( 'woocommerce_sale_flash', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_discount_display_dynamic_sale_badge' ), 9999, 3 );
								}
							}
						}
					}

					if ( 0 === intval( get_option( 'smuac_disable_dynamic_rule_hiddenprice_setting', 0 ) ) ) {
						if ( 'yes' === get_option( 'smuac_have_hidden_price_rules', 'yes' ) ) {
							// check if the user's ID or group is part of the list.
							$list = get_option( 'smuac_have_hidden_price_rules_list', 'yes' );
							if ( 'yes' === $this->smuac_user_is_in_list( $list ) ) {
								// Add product purchasable filter, so that it works with Bulk Order Form checks
								add_filter( 'woocommerce_get_price_html', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_hidden_price' ), 99999, 2 );
								add_filter( 'woocommerce_variation_price_html', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_hidden_price' ), 99999, 2 );
								// Dynamic rule Hidden price - disable purchasable
								add_filter( 'woocommerce_is_purchasable', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_hidden_price_disable_purchasable' ), 10, 2 );
								add_filter( 'woocommerce_variation_is_purchasable', array( 'Smuac_Dynamic_Rules', 'smuac_dynamic_rule_hidden_price_disable_purchasable' ), 10, 2 );
							}
						}
					}

					// Add tiered pricing to AJAX as well
					/* Set Tiered Pricing via Fixed Price Dynamic Rule */
					add_filter( 'woocommerce_product_get_price', array( $this, 'smuac_tiered_pricing_fixed_price' ), 999, 2 );
					add_filter( 'woocommerce_product_get_regular_price', array( $this, 'smuac_tiered_pricing_fixed_price' ), 999, 2 );
					// Variations
					add_filter( 'woocommerce_product_variation_get_regular_price', array( $this, 'smuac_tiered_pricing_fixed_price' ), 999, 2 );
					add_filter( 'woocommerce_product_variation_get_price', array( $this, 'smuac_tiered_pricing_fixed_price' ), 999, 2 );
					add_filter( 'woocommerce_variation_prices_price', array( $this, 'smuac_tiered_pricing_fixed_price' ), 999, 2 );
					add_filter( 'woocommerce_variation_prices_regular_price', array( $this, 'smuac_tiered_pricing_fixed_price' ), 999, 2 );

					// Pricing and Discounts in the Product Page: Add to AJAX
					/* Set Individual Product Pricing (via product tab) */
					add_filter( 'woocommerce_product_get_price', array( $this, 'smuac_individual_pricing_fixed_price' ), 999, 2 );
					add_filter( 'woocommerce_product_get_regular_price', array( $this, 'smuac_individual_pricing_fixed_price' ), 999, 2 );
					// Variations
					add_filter( 'woocommerce_product_variation_get_regular_price', array( $this, 'smuac_individual_pricing_fixed_price' ), 999, 2 );
					add_filter( 'woocommerce_product_variation_get_price', array( $this, 'smuac_individual_pricing_fixed_price' ), 999, 2 );
					add_filter( 'woocommerce_variation_prices_price', array( $this, 'smuac_individual_pricing_fixed_price' ), 999, 2 );
					add_filter( 'woocommerce_variation_prices_regular_price', array( $this, 'smuac_individual_pricing_fixed_price' ), 999, 2 );
					// Set sale price as well
					add_filter( 'woocommerce_product_get_sale_price', array( $this, 'smuac_individual_pricing_discount_sale_price' ), 999, 2 );
					add_filter( 'woocommerce_product_variation_get_sale_price', array( $this, 'smuac_individual_pricing_discount_sale_price' ), 999, 2 );
					add_filter( 'woocommerce_variation_prices_price', array( $this, 'smuac_individual_pricing_discount_sale_price' ), 999, 2 );
					add_filter( 'woocommerce_variation_prices_sale_price', array( $this, 'smuac_individual_pricing_discount_sale_price' ), 999, 2 );
					// display html
					// Displayed formatted regular price + sale price
					add_filter( 'woocommerce_get_price_html', array( $this, 'smuac_individual_pricing_discount_display_dynamic_price' ), 999, 2 );
					// Set sale price in Cart
					add_action( 'woocommerce_before_calculate_totals', array( $this, 'smuac_individual_pricing_discount_display_dynamic_price_in_cart' ), 999, 1 );
					// Function to make this work for MiniCart as well
					add_filter( 'woocommerce_cart_item_price', array( $this, 'smuac_individual_pricing_discount_display_dynamic_price_in_cart_item' ), 999, 3 );

				}
			);

			// Discussions
			add_action( 'wp_ajax_smuacdiscussionmessage', array( $this, 'smuacdiscussionmessage' ) );
			add_action( 'wp_ajax_nopriv_smuacdiscussionmessage', array( $this, 'smuacdiscussionmessage' ) );
			add_action( 'wp_ajax_smuacsendinquiry', array( $this, 'smuacsendinquiry' ) );
			add_action( 'wp_ajax_nopriv_smuacsendinquiry', array( $this, 'smuacsendinquiry' ) );
			// Request custom quote from cart
			add_action( 'wp_ajax_smuacrequestquotecart', array( $this, 'smuacrequestquotecart' ) );
			add_action( 'wp_ajax_nopriv_smuacrequestquotecart', array( $this, 'smuacrequestquotecart' ) );
			// Add bundle to cart
			add_action( 'wp_ajax_smuacaddbundle', array( $this, 'smuacaddbundle' ) );
			add_action( 'wp_ajax_nopriv_smuacaddbundle', array( $this, 'smuacaddbundle' ) );
			// Approve and Reject users
			add_action( 'wp_ajax_smuacapproveuser', array( $this, 'smuacapproveuser' ) );
			add_action( 'wp_ajax_nopriv_smuacapproveuser', array( $this, 'smuacapproveuser' ) );
			add_action( 'wp_ajax_smuacrejectuser', array( $this, 'smuacrejectuser' ) );
			add_action( 'wp_ajax_nopriv_smuacrejectuser', array( $this, 'smuacrejectuser' ) );
			// Download file (e.g. registration files, company license etc)
			add_action( 'wp_ajax_smuachandledownloadrequest', array( $this, 'smuachandledownloadrequest' ) );
			// Multiaccounts
			add_action( 'wp_ajax_nopriv_smuac_create_multiaccount', array( $this, 'smuac_create_multiaccount' ) );
			add_action( 'wp_ajax_smuac_create_multiaccount', array( $this, 'smuac_create_multiaccount' ) );
			add_action( 'wp_ajax_nopriv_smuac_update_multiaccount', array( $this, 'smuac_update_multiaccount' ) );
			add_action( 'wp_ajax_smuac_update_multiaccount', array( $this, 'smuac_update_multiaccount' ) );
			// Bulk order
			add_action( 'wp_ajax_nopriv_smuac_ajax_search', array( $this, 'smuac_ajax_search' ) );
			add_action( 'wp_ajax_smuac_ajax_search', array( $this, 'smuac_ajax_search' ) );

			add_action( 'wp_ajax_nopriv_smuac_accountingsubtotals', array( $this, 'smuac_accountingsubtotals' ) );
			add_action( 'wp_ajax_smuac_accountingsubtotals', array( $this, 'smuac_accountingsubtotals' ) );

			add_action( 'wp_ajax_nopriv_smuac_ajax_get_price', array( $this, 'smuac_ajax_get_price' ) );
			add_action( 'wp_ajax_smuac_ajax_get_price', array( $this, 'smuac_ajax_get_price' ) );
			add_action( 'wp_ajax_nopriv_smuac_bulkorder_add_cart', array( $this, 'smuac_bulkorder_add_cart' ) );
			add_action( 'wp_ajax_smuac_bulkorder_add_cart', array( $this, 'smuac_bulkorder_add_cart' ) );
			add_action( 'wp_ajax_nopriv_smuac_bulkorder_save_list', array( $this, 'smuac_bulkorder_save_list' ) );
			add_action( 'wp_ajax_smuac_bulkorder_save_list', array( $this, 'smuac_bulkorder_save_list' ) );
			// Shopping lists
			add_action( 'wp_ajax_nopriv_smuac_shopping_list_update', array( $this, 'smuac_shopping_list_update' ) );
			add_action( 'wp_ajax_smuac_shopping_list_update', array( $this, 'smuac_shopping_list_update' ) );
			add_action( 'wp_ajax_nopriv_smuac_shopping_list_delete', array( $this, 'smuac_shopping_list_delete' ) );
			add_action( 'wp_ajax_smuac_shopping_list_delete', array( $this, 'smuac_shopping_list_delete' ) );
			add_action( 'wp_ajax_nopriv_smuac_save_cart_to_shopping_list', array( $this, 'smuac_save_cart_to_shopping_list' ) );
			add_action( 'wp_ajax_smuac_save_cart_to_shopping_list', array( $this, 'smuac_save_cart_to_shopping_list' ) );
			// Dismiss "activate woocommerce" admin notice permanently
			add_action( 'wp_ajax_smuac_dismiss_activate_woocommerce_admin_notice', array( $this, 'smuac_dismiss_activate_woocommerce_admin_notice' ) );
			// Dismiss onboarding admin notice permanently
			add_action( 'wp_ajax_smuac_dismiss_onboarding_admin_notice', array( $this, 'smuac_dismiss_onboarding_admin_notice' ) );
			// Save Special group settings (b2c and guests) in groups
			add_action( 'wp_ajax_nopriv_smuac_b2c_special_group_save_settings', array( $this, 'smuac_b2c_special_group_save_settings' ) );
			add_action( 'wp_ajax_smuac_b2c_special_group_save_settings', array( $this, 'smuac_b2c_special_group_save_settings' ) );
			add_action( 'wp_ajax_nopriv_smuac_logged_out_special_group_save_settings', array( $this, 'smuac_logged_out_special_group_save_settings' ) );
			add_action( 'wp_ajax_smuac_logged_out_special_group_save_settings', array( $this, 'smuac_logged_out_special_group_save_settings' ) );
			// Tools
			add_action( 'wp_ajax_nopriv_smuacbulksetusers', array( $this, 'smuacbulksetusers' ) );
			add_action( 'wp_ajax_smuacbulksetusers', array( $this, 'smuacbulksetusers' ) );
			add_action( 'wp_ajax_nopriv_smuacbulksetcategory', array( $this, 'smuacbulksetcategory' ) );
			add_action( 'wp_ajax_smuacbulksetcategory', array( $this, 'smuacbulksetcategory' ) );
			// Backend Update User Data
			add_action( 'wp_ajax_nopriv_smuacupdateuserdata', array( $this, 'smuacupdateuserdata' ) );
			add_action( 'wp_ajax_smuacupdateuserdata', array( $this, 'smuacupdateuserdata' ) );
			// Validate VAT for checkout registration
			add_action( 'wp_ajax_nopriv_smuacvalidatevat', array( $this, 'smuacvalidatevat' ) );
			add_action( 'wp_ajax_smuacvalidatevat', array( $this, 'smuacvalidatevat' ) );
			// Check delivery country for VAT Validation
			add_action( 'wp_ajax_nopriv_smuaccheckdeliverycountryvat', array( $this, 'smuaccheckdeliverycountryvat' ) );
			add_action( 'wp_ajax_smuaccheckdeliverycountryvat', array( $this, 'smuaccheckdeliverycountryvat' ) );
			// AJAX Search Image
			add_action( 'wp_ajax_nopriv_smuac_ajax_search_image', array( $this, 'smuac_ajax_search_image' ) );
			add_action( 'wp_ajax_smuac_ajax_search_image', array( $this, 'smuac_ajax_search_image' ) );

			add_action( 'wp_ajax_nopriv_smuacbulksetmultiaccounts', array( $this, 'smuacbulksetmultiaccounts' ) );
			add_action( 'wp_ajax_smuacbulksetmultiaccounts', array( $this, 'smuacbulksetmultiaccounts' ) );
			add_action( 'wp_ajax_nopriv_smuacbulksetmultiaccountsregular', array( $this, 'smuacbulksetmultiaccountsregular' ) );
			add_action( 'wp_ajax_smuacbulksetmultiaccountsregular', array( $this, 'smuacbulksetmultiaccountsregular' ) );
		}

		// Run Admin/Public code
		if ( is_admin() ) {
			require_once SMUAC_DIR . '/admin/class-smuac-admin.php';
			$admin = new Smuac_Admin();
		} elseif ( ! $this->smuac_is_login_page() ) {
			require_once SMUAC_DIR . '/public/class-smuac-public.php';
			$public = new Smuac_Public();
		}
	}

	public function smuacbulksetmultiaccountsregular() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['option_first'] ) ) {
			$option_first = trim( sanitize_text_field( $_POST['option_first'] ) );
		}

		$multiaccount_ids = explode( ',', $option_first );

		foreach ( $multiaccount_ids as $multiaccount_id ) {
			$multiaccount_id_trimmed = trim( $multiaccount_id );
			update_user_meta( $multiaccount_id_trimmed, 'smuac_account_type', 'regular' );
			$parent_id = get_user_meta( $multiaccount_id_trimmed, 'smuac_account_parent', true );

			// remove from list of multiaccounts
			$current_multiaccounts_list = get_user_meta( $parent_id, 'smuac_multiaccounts_list', true );
			$current_multiaccounts_list = str_replace( ',' . $multiaccount_id_trimmed, '', $current_multiaccounts_list );

			update_user_meta( $parent_id, 'smuac_multiaccounts_list', $current_multiaccounts_list );

		}

		echo 'success';
		exit();
	}

	public function smuacbulksetmultiaccounts() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['option_first'] ) ) {
			$option_first = trim( sanitize_text_field( $_POST['option_first'] ) );
		}

		if ( isset( $_POST['option_second'] ) ) {
			$option_second = trim( sanitize_text_field( $_POST['option_second'] ) );
		}

		$multiaccount_ids = explode( ',', $option_first );
		$parent_id        = trim( $option_second );

		foreach ( $multiaccount_ids as $multiaccount_id ) {
			$multiaccount_id_trimmed = trim( $multiaccount_id );
			update_user_meta( $multiaccount_id_trimmed, 'smuac_account_type', 'multiaccount' );
			update_user_meta( $multiaccount_id_trimmed, 'smuac_account_parent', $parent_id );

			$current_multiaccounts_list = get_user_meta( $parent_id, 'smuac_multiaccounts_list', true );
			update_user_meta( $parent_id, 'smuac_multiaccounts_list', $current_multiaccounts_list . ',' . $multiaccount_id_trimmed );

			// enable all permissions for multiaccount
			update_user_meta( $multiaccount_id_trimmed, 'smuac_account_permission_buy', 1 );
			update_user_meta( $multiaccount_id_trimmed, 'smuac_account_permission_view_orders', 1 );
			update_user_meta( $multiaccount_id_trimmed, 'smuac_account_permission_view_offers', 1 );
			update_user_meta( $multiaccount_id_trimmed, 'smuac_account_permission_view_conversations', 1 );
			update_user_meta( $multiaccount_id_trimmed, 'smuac_account_permission_view_lists', 1 );
		}

		echo 'success';
		exit();
	}


	public function smuac_user_is_in_list( $list ) {
		// get user data
		$user_data_current_user_id = get_current_user_id();
		if ( 0 === intval( $user_data_current_user_id ) ) {
			// check cookies
			if ( isset( $_COOKIE['smuac_userid'] ) ) {
				$user_data_current_user_id = sanitize_text_field( $_COOKIE['smuac_userid'] );
			}
		}
		$user_data_current_user_b2b   = get_user_meta( $user_data_current_user_id, 'smuac_b2buser', true );
		$user_data_current_user_group = get_user_meta( $user_data_current_user_id, 'smuac_customergroup', true );
		// checks based on user id, b2b status and group, if it's part of an applicable rules list
		$is_in_list = 'no';
		$list_array = explode( ',', $list );
		if ( 0 !== intval( $user_data_current_user_id ) ) {
			if ( in_array( 'everyone_registered', $list_array ) ) {
				return 'yes';
			}
			if ( 'yes' === $user_data_current_user_b2b ) {
				// user is b2b
				if ( in_array( 'everyone_registered_b2b', $list_array ) ) {
					return 'yes';
				}
				if ( in_array( 'group_' . $user_data_current_user_group, $list_array ) ) {
					return 'yes';
				}
			} else {
				// user is b2c
				if ( in_array( 'everyone_registered_b2c', $list_array ) ) {
					return 'yes';
				}
			}
			if ( in_array( 'user_' . $user_data_current_user_id, $list_array ) ) {
				return 'yes';
			}
		} elseif ( 0 === intval( $user_data_current_user_id ) ) {
			if ( in_array( 'user_0', $list_array ) ) {
				return 'yes';
			}
		}

		return $is_in_list;
	}

	// Add email classes to the list of email classes that WooCommerce loads
	public function smuac_add_email_classes( $email_classes ) {

		$email_classes['Smuac_New_Quote_Email'] = include SMUAC_DIR . '/includes/emails/class-smuac-new-quote-email.php';

		$email_classes['Smuac_New_Customer_Email'] = include SMUAC_DIR . '/includes/emails/class-smuac-new-customer-email.php';

		$email_classes['Smuac_New_Message_Email'] = include SMUAC_DIR . '/includes/emails/class-smuac-new-message-email.php';

		$email_classes['Smuac_New_Customer_Requires_Approval_Email'] = include SMUAC_DIR . '/includes/emails/class-smuac-new-customer-requires-approval-email.php';

		$email_classes['Smuac_Your_Account_Approved_Email'] = include SMUAC_DIR . '/includes/emails/class-smuac-your-account-approved-email.php';

		return $email_classes;
	}

	// Add email actions
	public function smuac_add_email_actions( $actions ) {
		$actions[] = 'smuac_account_approved_finish';
		$actions[] = 'smuac_new_message';
		$actions[] = 'smuac_new_quote';
		return $actions;
	}

	// Add invoice payment gateway
	public function smuac_add_invoice_gateway( $methods ) {
		if ( ! class_exists( 'B2BWhs_Invoice_Gateway' ) ) {
			include_once 'class-smuac-invoice-gateway.php';
			$methods[] = 'B2BWhs_Invoice_Gateway';
		}
		return $methods;
	}

	// Helps prevent public code from running on login / register pages, where is_admin() returns false
	public function smuac_is_login_page() {
		if ( isset( $GLOBALS['pagenow'] ) ) {
			return in_array( $GLOBALS['pagenow'], array( 'wp-login.php', 'wp-register.php', 'admin.php' ), true );
		}
	}

	public function smuac_ajax_search_image() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['searchValue'] ) ) {
			$searched_term = sanitize_text_field( $_POST['searchValue'] );
			$str           = wp_get_attachment_image_src( get_post_thumbnail_id( $searched_term ) );
			if ( $str && ( count( $str ) > 0 ) ) {
				// return image url
				echo( esc_url( $str[0] ) );
			}
		}

		exit();
	}

	// Update discussion with user message meta
	public function smuacdiscussionmessage() {

		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		// If nonce verification didn't fail, run further
		if ( isset( $_POST['message'] ) ) {
			$message = sanitize_textarea_field( $_POST['message'] );
		} else {
			$message = '';
		}
		if ( isset( $_POST['discussionid'] ) ) {
			$discussionid = sanitize_text_field( $_POST['discussionid'] );
		} else {
			$discussionid = 0;
		}

		$currentuser    = wp_get_current_user()->user_login;
		$discussionuser = get_post_meta( $discussionid, 'smuac_discussion_user', true );

		// Check message not empty
		if ( null !== $message && '' !== trim( $message ) ) {
			// Check user permission against Discussion user meta. Check multiaccounts as well
			$current_user_id    = get_current_user_id();
			$multiaccounts_list = get_user_meta( $current_user_id, 'smuac_multiaccounts_list', true );
			$multiaccounts_list = explode( ',', $multiaccounts_list );
			$multiaccounts_list = array_filter( $multiaccounts_list );
			array_push( $multiaccounts_list, $current_user_id );

			$multiaccounts_list = apply_filters( 'smuac_discussion_permission_list', $multiaccounts_list, $discussionid, $current_user_id, $discussionuser );

			// if current account is multiaccount AND has permission to view all account discussions, add parent account+all multiaccounts lists
			$account_type = get_user_meta( $current_user_id, 'smuac_account_type', true );
			if ( 'multiaccount' === $account_type ) {
				$permission_view_all_discussions = filter_var( get_user_meta( $current_user_id, 'smuac_account_permission_view_discussions', true ), FILTER_VALIDATE_BOOLEAN );
				if ( true === $permission_view_all_discussions ) {
					// has permission
					$parent_account            = get_user_meta( $current_user_id, 'smuac_account_parent', true );
					$parent_multiaccounts_list = explode( ',', get_user_meta( $parent_account, 'smuac_multiaccounts_list', true ) );
					$parent_multiaccounts_list = array_filter( $parent_multiaccounts_list ); // filter blank, null, etc.
					array_push( $parent_multiaccounts_list, $parent_account ); // add parent itself to form complete parent accounts list

					$multiaccounts_list = array_merge( $multiaccounts_list, $parent_multiaccounts_list );
				}
			}

			foreach ( $multiaccounts_list as $user ) {
				$multiaccounts_list[ $user ] = get_user_by( 'id', $user )->user_login;
			}

			if ( in_array( $discussionuser, $multiaccounts_list ) ) {
				$nr_messages        = get_post_meta( $discussionid, 'smuac_discussion_messages_number', true );
				$current_message_nr = $nr_messages + 1;
				update_post_meta( $discussionid, 'smuac_discussion_message_' . $current_message_nr, $message );
				update_post_meta( $discussionid, 'smuac_discussion_messages_number', $current_message_nr );
				update_post_meta( $discussionid, 'smuac_discussion_message_' . $current_message_nr . '_author', $currentuser );
				update_post_meta( $discussionid, 'smuac_discussion_message_' . $current_message_nr . '_time', time() );

				// if status is new, change to open
				$status = get_post_meta( $discussionid, 'smuac_discussion_status', true );
				if ( 'new' === $status ) {
					update_post_meta( $discussionid, 'smuac_discussion_status', 'open' );
				}

				// send email notification. Check if it has been 10 minutes since the previous message
				$previous_message_time = intval( get_post_meta( $discussionid, 'smuac_discussion_message_' . $nr_messages . '_time', true ) );

				if ( ( time() - $previous_message_time ) > 600 ) {
					$recipient = get_option( 'admin_email' );

					$recipient = apply_filters( 'smuac_recipient_new_message', $recipient, $discussionid );

					do_action( 'smuac_new_message', $recipient, $message, $current_user_id, $discussionid );
				}
			}
		}
	}


	// Create new discussion by user
	public function smuacsendinquiry() {

		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		// If nonce verification didn't fail, run further
		if ( isset( $_POST['message'] ) ) {
			$message = sanitize_textarea_field( $_POST['message'] );
		} else {
			$message = '';
		}
		if ( isset( $_POST['title'] ) ) {
			$title = sanitize_text_field( $_POST['title'] );
		} else {
			$title = '';
		}
		if ( isset( $_POST['type'] ) ) {
			$type = sanitize_text_field( $_POST['type'] );
		} else {
			$type = '';
		}

		$currentuser  = wp_get_current_user()->user_login;
		$discussionid = '';

		// Check message not empty
		if ( null !== $message && '' !== trim( $message ) ) {
			// Insert post
			$args         = array(
				'post_title'  => $title,
				'post_type'   => 'smuac_discussion',
				'post_status' => 'publish',
			);
			$discussionid = wp_insert_post( $args );

			update_post_meta( $discussionid, 'smuac_discussion_user', $currentuser );
			update_post_meta( $discussionid, 'smuac_discussion_status', 'new' );
			update_post_meta( $discussionid, 'smuac_discussion_type', $type );
			update_post_meta( $discussionid, 'smuac_discussion_message_1', $message );
			update_post_meta( $discussionid, 'smuac_discussion_messages_number', 1 );
			update_post_meta( $discussionid, 'smuac_discussion_message_1_author', $currentuser );
			update_post_meta( $discussionid, 'smuac_discussion_message_1_time', time() );

			$recipient = get_option( 'admin_email' );
			$recipient = apply_filters( 'smuac_recipient_new_message', $recipient, $discussionid );

			// send email notification
			do_action( 'smuac_new_message', $recipient, $message, get_current_user_id(), $discussionid );
		}

		// return discussion id URL
		echo esc_url( add_query_arg( 'id', $discussionid, wc_get_account_endpoint_url( 'discussion' ) ) );
		exit();
	}

	public function smuacrequestquotecart() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}
		// If nonce verification didn't fail, run further

		// If user is logged out, or integration with discussions is disabled, send it simply as email
		if ( ! is_user_logged_in() || ( 1 !== intval( get_option( 'smuac_integrate_quotes_discussions_setting', 1 ) ) ) || ( 'hybrid' === get_option( 'smuac_plugin_status_setting', 'b2b' ) && 'yes' !== get_user_meta( get_current_user_id(), 'smuac_b2buser', true ) ) ) {
			$messagecart = '';

			if ( isset( $_POST['name'] ) ) {
				$name         = sanitize_text_field( $_POST['name'] );
				$messagecart .= esc_html__( 'Name: ', 'smuac' ) . $name . ' <br />';
			}
			if ( isset( $_POST['email'] ) ) {
				$email        = sanitize_text_field( $_POST['email'] );
				$messagecart .= esc_html__( 'Email: ', 'smuac' ) . $email . ' <br />';
			}
			if ( isset( $_POST['phone'] ) ) {
				$phone        = sanitize_text_field( $_POST['phone'] );
				$messagecart .= esc_html__( 'Phone: ', 'smuac' ) . $phone . ' <br />';
			}
			if ( isset( $_POST['message'] ) ) {
				$message      = sanitize_textarea_field( $_POST['message'] );
				$messagecart .= esc_html__( 'Message: ', 'smuac' ) . $message . ' <br />';
			}

			$messagecart .= '<br />' . esc_html__( 'Requested items:', 'smuac' ) . ' <br />';
			// Add cart details and quantities at the beginning of the message
			$items = WC()->cart->get_cart();
			foreach ( $items as $item => $values ) {
				$_product     = wc_get_product( $values['data']->get_id() );
				$messagecart .= '<b>' . $_product->get_name() . '</b>  <br> ' . esc_html__( 'Quantity: ', 'smuac' ) . $values['quantity'] . '<br>';
			}

			// send email notification
			$recipient = get_option( 'admin_email' );

			do_action( 'smuac_new_quote', $recipient, $messagecart );

			// empty cart
			WC()->cart->empty_cart();
			echo esc_url( get_permalink( woocommerce_get_page_id( 'shop' ) ) );
			exit();
		} else {
			$messagecart = '';

			// send quote as discussion
			if ( isset( $_POST['name'] ) ) {
				$name         = sanitize_text_field( $_POST['name'] );
				$messagecart .= esc_html__( 'Name: ', 'smuac' ) . $name . ' <br />';
			}
			if ( isset( $_POST['email'] ) ) {
				$email        = sanitize_text_field( $_POST['email'] );
				$messagecart .= esc_html__( 'Email: ', 'smuac' ) . $email . ' <br />';
			}
			if ( isset( $_POST['phone'] ) ) {
				$phone        = sanitize_text_field( $_POST['phone'] );
				$messagecart .= esc_html__( 'Phone: ', 'smuac' ) . $phone . ' <br />';
			}
			if ( isset( $_POST['message'] ) ) {
				$message      = sanitize_textarea_field( $_POST['message'] );
				$messagecart .= esc_html__( 'Message: ', 'smuac' ) . $message . ' <br />';
			}

			$messagecart .= '<br />' . esc_html__( 'Requested items:', 'smuac' ) . ' <br />';
			// Add cart details and quantities at the beginning of the message
			$items = WC()->cart->get_cart();
			foreach ( $items as $item => $values ) {
				$_product     = wc_get_product( $values['data']->get_id() );
				$messagecart .= '<b>' . $_product->get_name() . '</b>  <br> ' . esc_html__( 'Quantity: ', 'smuac' ) . $values['quantity'] . '<br>';
			}
			$message = $messagecart . '<br />';

			if ( isset( $_POST['title'] ) ) {
				$title = sanitize_text_field( $_POST['title'] );
			}
			if ( isset( $_POST['type'] ) ) {
				$type = sanitize_text_field( $_POST['type'] );
			}
			$currentuser  = wp_get_current_user()->user_login;
			$discussionid = '';

			// Insert post
			$args         = array(
				'post_title'  => $title,
				'post_type'   => 'smuac_discussion',
				'post_status' => 'publish',
			);
			$discussionid = wp_insert_post( $args );

			update_post_meta( $discussionid, 'smuac_discussion_user', $currentuser );
			update_post_meta( $discussionid, 'smuac_discussion_status', 'new' );
			update_post_meta( $discussionid, 'smuac_discussion_type', $type );
			update_post_meta( $discussionid, 'smuac_discussion_message_1', $message );
			update_post_meta( $discussionid, 'smuac_discussion_messages_number', 1 );
			update_post_meta( $discussionid, 'smuac_discussion_message_1_author', $currentuser );
			update_post_meta( $discussionid, 'smuac_discussion_message_1_time', time() );

			// send email notification
			$recipient = get_option( 'admin_email' );
			$recipient = apply_filters( 'smuac_recipient_new_message_quote', $recipient, $discussionid );

			do_action( 'smuac_new_message', $recipient, $message, 'Quoteemail:1', $discussionid );

			// empty cart
			WC()->cart->empty_cart();

			// return discussion id URL
			echo esc_url( add_query_arg( 'id', $discussionid, wc_get_account_endpoint_url( 'discussion' ) ) );
			exit();
		}
	}

	public function smuacaddbundle() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}
		// If nonce verification didn't fail, run further

		if ( isset( $_POST['bundle'] ) ) {
			$bundle_id = sanitize_text_field( $_POST['bundle'] );
		}

		// Run permission check on bundle
		$user                 = wp_get_current_user()->user_login;
		$currentusergroupidnr = get_user_meta( get_current_user_id(), 'smuac_customergroup', true );

		// If permission check is true
		if ( 1 === intval( get_post_meta( $bundle_id, 'smuac_user_' . $user, true ) ) || 1 === intval( get_post_meta( $bundle_id, 'smuac_group_' . $currentusergroupidnr, true ) ) ) {
			// Add bundle to cart
			$bundle_details                           = get_post_meta( apply_filters( 'wpml_object_id', $bundle_id, 'post', true ), 'smuac_bundle_details', true );
			$products                                 = explode( '|', $bundle_details );
			$cart_item_data['smuac_bundle_id']        = $bundle_id;
			$cart_item_data['smuac_bundle_name']      = get_the_title( apply_filters( 'wpml_object_id', $bundle_id, 'post', true ) );
			$cart_item_data['smuac_numberofproducts'] = count( $products );
			$i                                        = 1;
			foreach ( $products as $product ) {
				$details = explode( ';', $product );

				// if item is in the form product_id, change title
				$isproductid = explode( '_', $details[0] );
				if ( 'product' === $isproductid[0] ) {
					// it is a product+id, get product title
					$newproduct = wc_get_product( $isproductid[1] );
					$details[0] = $newproduct->get_name();
				}

				$cart_item_data[ 'smuac_product_' . $i . '_name' ]     = $details[0];
				$cart_item_data[ 'smuac_product_' . $i . '_quantity' ] = $details[1];
				$cart_item_data[ 'smuac_product_' . $i . '_price' ]    = $details[2];
				$i++;
			}

			$cart_item_data = apply_filters( 'smuac_before_add_bundle_to_cart', $cart_item_data );

			// Create B2B bundle product if it doesn't exist
			$bundle_id = intval( get_option( 'smuac_bundle_product_id_setting', 0 ) );
			if ( ! get_post_status( $bundle_id ) ) {
				$bundle     = array(
					'post_title'  => 'Bundle',
					'post_status' => 'custombundle',
					'post_type'   => 'product',
					'post_author' => 1,
				);
				$product_id = wp_insert_post( $bundle );
				// Set product hidden:
				$terms = array( 'exclude-from-catalog', 'exclude-from-search' );
				wp_set_object_terms( $product_id, $terms, 'product_visibility' );
				wp_set_object_terms( $product_id, 'simple', 'product_type' );
				update_post_meta( $product_id, '_visibility', 'hidden' );
				update_post_meta( $product_id, '_stock_status', 'instock' );
				update_post_meta( $product_id, '_regular_price', '' );
				update_post_meta( $product_id, '_sale_price', '' );
				update_post_meta( $product_id, '_purchase_note', '' );
				update_post_meta( $product_id, '_sku', 'SKU11' );
				update_post_meta( $product_id, '_product_attributes', array() );
				update_post_meta( $product_id, '_sale_price_dates_from', '' );
				update_post_meta( $product_id, '_sale_price_dates_to', '' );
				update_post_meta( $product_id, '_price', '1' );
				update_post_meta( $product_id, '_sold_individually', '' );

				// set option to product id
				update_option( 'smuac_bundle_product_id_setting', $product_id );
				$bundle_id = intval( get_option( 'smuac_bundle_product_id_setting', 0 ) );
			}

			$bundle_id = apply_filters( 'smuac_bundle_id_before_add_bundle_to_cart', $bundle_id, $cart_item_data['smuac_bundle_id'] );

			WC()->cart->add_to_cart( $bundle_id, 1, 0, array(), $cart_item_data );
		}

		echo 'success';
		exit();
	}

	public function smuaccheckdeliverycountryvat() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}
		// If nonce verification didn't fail, run further

		// Apply VAT Rules
		Smuac_Dynamic_Rules::smuac_dynamic_rule_tax_exemption();
		echo 'success';
		exit();
	}

	public function smuacvalidatevat() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}
		// If nonce verification didn't fail, run further

		$vat_number_inputted = '';
		if ( isset( $_POST['vat'] ) ) {
			$vat_number_inputted = sanitize_text_field( $_POST['vat'] );
		}

		$vat_number_inputted = strtoupper( str_replace( array( '.', ' ' ), '', $vat_number_inputted ) );

		$country_inputted = '';
		if ( isset( $_POST['country'] ) ) {
			$country_inputted = sanitize_text_field( $_POST['country'] );
		}

		// validate number
		$error_details     = '';
		$validation        = new stdClass();
		$validation->valid = 1;
		// check vat
		try {
			$client       = new SoapClient( 'http://ec.europa.eu/taxation_customs/vies/checkVatService.wsdl' );
			$country_code = substr( $vat_number_inputted, 0, 2 ); // take first 2 chars
			$vat_number   = substr( $vat_number_inputted, 2 ); // remove first 2 chars

			$validation    = $client->checkVat(
				array(
					'countryCode' => $country_code,
					'vatNumber'   => $vat_number,
				)
			);
			$error_details = '';

			// check country is same as VAT country
			if ( trim( strtolower( $country_inputted ) ) !== trim( strtolower( $country_code ) ) ) {
				// check exception Greece (GR) has EL VAT code
				if ( ( 'gr' === trim( strtolower( $country_inputted ) ) ) && ( 'el' === trim( strtolower( $country_code ) ) ) ) {
					// if indeed the VAT number is EL and country is GR, do nothing
					$vat_validation = 1;
				} else {
					$validation->valid = 0;
				}
			}
		} catch ( Exception $e ) {
			$error = $e->getMessage();

			$error_array = array(
				'INVALID_INPUT'       => esc_html__( 'CountryCode is invalid or the VAT number is empty', 'smuac' ),
				'SERVICE_UNAVAILABLE' => esc_html__( 'VIES VAT Service is unavailable. Try again later.', 'smuac' ),
				'MS_UNAVAILABLE'      => esc_html__( 'VIES VAT Member State Service is unavailable.', 'smuac' ),
				'TIMEOUT'             => esc_html__( 'Service timeout. Try again later', 'smuac' ),
				'SERVER_BUSY'         => esc_html__( 'VAT Server is too busy. Try again later.', 'smuac' ),
			);

			if ( array_key_exists( $error, $error_array ) ) {
				$error_details .= $error_array[ $error ];
			}
			$validation->valid = 0;
		}

		if ( 1 === intval( $validation->valid ) ) {
			echo 'valid';
		} else {
			echo 'invalid';
		}

		exit();
	}

	public function smuacapproveuser() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}
		// If nonce verification didn't fail, run further

		if ( isset( $_POST['user'] ) ) {
			$user_id = sanitize_text_field( $_POST['user'] );
		}
		if ( isset( $_POST['chosen_group'] ) ) {
			$group = sanitize_text_field( $_POST['chosen_group'] );
		}

		// approve account
		update_user_meta( $user_id, 'smuac_account_approved', 'yes' );
		// place user in customer group
		update_user_meta( $user_id, 'smuac_customergroup', $group );
		// add role
		$user_obj = new WP_User( $user_id );
		$user_obj->add_role( 'smuac_role_' . $group );
		// set user as b2b enabled
		update_user_meta( $user_id, 'smuac_b2buser', 'yes' );

		// create action hook to send "account approved" email
		$email_address = sanitize_text_field( get_user_by( 'id', $user_id )->user_email );
		do_action( 'smuac_account_approved_finish', $email_address );

		echo 'success';
		exit();
	}

	public function smuacrejectuser() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		// If nonce verification didn't fail, run further
		if ( isset( $_POST['user'] ) ) {
			$user_id = sanitize_text_field( $_POST['user'] );
		}

		// check if this function is being run by delete multiaccount in the frontend
		if ( isset( $_POST['ismultiaccount'] ) ) {
			$current_user = get_current_user_id();
			// remove multiaccount from user meta
			$multiaccounts_number = get_user_meta( $current_user, 'smuac_multiaccounts_number', true );
			$multiaccounts_number--;
			update_user_meta( $current_user, 'smuac_multiaccounts_number', sanitize_text_field( $multiaccounts_number ) );

			$multiaccounts_list = get_user_meta( $current_user, 'smuac_multiaccounts_list', true );
			$multiaccounts_list = str_replace( ',' . $user_id, '', $multiaccounts_list );
			update_user_meta( $current_user, 'smuac_multiaccounts_list', sanitize_text_field( $multiaccounts_list ) );

			// assign orders to parent
			$args   = array(
				'customer_id' => $user_id,
			);
			$orders = wc_get_orders( $args );
			foreach ( $orders as $order ) {
				$order_id       = $order->get_id();
				$parent_user_id = get_user_meta( $user_id, 'smuac_account_parent', true );

				$order->set_customer_id( $parent_user_id );
				$order->save();
			}
		}

		// delete account
		wp_delete_user( $user_id );

		echo 'success';
		exit();
	}

	// Handles AJAX Download requests, enabling the download of user attachment during registration
	public function smuachandledownloadrequest() {

		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_REQUEST['attachment'] ) ) {
			$requested_file = sanitize_text_field( $_REQUEST['attachment'] );
		}
		// If nonce verification didn't fail, run further
		$file = wp_get_attachment_url( $requested_file );

		if ( ! $file ) {
			return;
		}

		// clean the fileurl
		$file_url = stripslashes( trim( $file ) );
		// get filename
		$file_name = basename( $file );

		header( 'Expires: 0' );
		header( 'Cache-Control: no-cache, no-store, must-revalidate' );
		header( 'Cache-Control: pre-check=0, post-check=0, max-age=0', false );
		header( 'Pragma: no-cache' );
		header( "Content-Disposition:attachment; filename={$file_name}" );
		header( 'Content-Type: application/force-download' );

		readfile( "{$file_url}" );
		exit();
	}

	public function smuac_create_multiaccount() {

		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		$parent_user_id              = get_current_user_id();
		$multiaccounts_maximum_limit = 500;

		// Test multiaccounts number
		$current_multiaccounts_number = get_user_meta( $parent_user_id, 'smuac_multiaccounts_number', true );
		if ( null === $current_multiaccounts_number ) {
			$current_multiaccounts_number = 0;
		}

		if ( intval( $current_multiaccounts_number ) < $multiaccounts_maximum_limit ) {
			// proceed
			if ( isset( $_POST['username'] ) ) {
				$username = sanitize_text_field( $_POST['username'] );
			}
			if ( isset( $_POST['password'] ) ) {
				$password = sanitize_text_field( $_POST['password'] );
			}
			if ( isset( $_POST['name'] ) ) {
				$name = sanitize_text_field( $_POST['name'] );
			}
			if ( isset( $_POST['jobTitle'] ) ) {
				$job_title = sanitize_text_field( $_POST['jobTitle'] );
			}
			if ( isset( $_POST['phone'] ) ) {
				$phone = sanitize_text_field( $_POST['phone'] );
			}
			if ( isset( $_POST['email'] ) ) {
				$email = sanitize_text_field( $_POST['email'] );
			}
			if ( isset( $_POST['permissionBuy'] ) ) {
				$permission_buy = sanitize_text_field( $_POST['permissionBuy'] );
			}
			if ( isset( $_POST['permissionViewOrders'] ) ) {
				$permission_view_orders = sanitize_text_field( $_POST['permissionViewOrders'] );
			}
			if ( isset( $_POST['permissionViewBundles'] ) ) {
				$permission_view_bundles = sanitize_text_field( $_POST['permissionViewBundles'] );
			}
			if ( isset( $_POST['permissionViewDiscussions'] ) ) {
				$permission_view_discussions = sanitize_text_field( $_POST['permissionViewDiscussions'] );
			}
			if ( isset( $_POST['permissionViewLists'] ) ) {
				$permission_view_lists = sanitize_text_field( $_POST['permissionViewLists'] );
			}

			if ( apply_filters( 'b2bking_disable_username_subaccounts', 1 ) === 0 ) {
				$user_id = wc_create_new_customer( $email, $username, $password );
			} else {
				$user_id = wc_create_new_customer( $email, $email, $password );
			}

			if ( ! ( is_wp_error( $user_id ) ) ) {
				// no errors, proceed
				// set user meta
				update_user_meta( $user_id, 'smuac_account_type', 'multiaccount' );
				update_user_meta( $user_id, 'smuac_account_parent', $parent_user_id );
				update_user_meta( $user_id, 'smuac_account_name', $name );
				update_user_meta( $user_id, 'smuac_account_phone', $phone );
				update_user_meta( $user_id, 'smuac_account_job_title', $job_title );
				update_user_meta( $user_id, 'smuac_account_permission_buy', $permission_buy ); // true or false
				update_user_meta( $user_id, 'smuac_account_permission_view_orders', $permission_view_orders ); // true or false
				update_user_meta( $user_id, 'smuac_account_permission_view_bundles', $permission_view_orders ); // true or false
				update_user_meta( $user_id, 'smuac_account_permission_view_discussions', $permission_view_orders ); // true or false
				update_user_meta( $user_id, 'smuac_account_permission_view_lists', $permission_view_lists ); // true or false

				// set parent multiaccount details meta
				$current_multiaccounts_number++;
				update_user_meta( $parent_user_id, 'smuac_multiaccounts_number', $current_multiaccounts_number );

				$current_multiaccounts_list = get_user_meta( $parent_user_id, 'smuac_multiaccounts_list', true );
				$current_multiaccounts_list = $current_multiaccounts_list . ',' . $user_id;
				update_user_meta( $parent_user_id, 'smuac_multiaccounts_list', $current_multiaccounts_list );

				$userobj = new WP_User( $user_id );
				$userobj->set_role( 'customer' );

				do_action( 'smuac_after_multiaccount_created', $user_id );

				echo esc_html( $user_id );
			} else {
				echo 'error';
			}
		} else {
			echo 'error_maximum_multiaccounts';
		}

		exit();
	}

	public function smuac_update_multiaccount() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['multiaccountId'] ) ) {
			$multiaccount_id = sanitize_text_field( $_POST['multiaccountId'] );
		}
		if ( isset( $_POST['name'] ) ) {
			$name = sanitize_text_field( $_POST['name'] );
		}
		if ( isset( $_POST['jobTitle'] ) ) {
			$job_title = sanitize_text_field( $_POST['jobTitle'] );
		}
		if ( isset( $_POST['phone'] ) ) {
			$phone = sanitize_text_field( $_POST['phone'] );
		}
		if ( isset( $_POST['permissionBuy'] ) ) {
			$permission_buy = sanitize_text_field( $_POST['permissionBuy'] );
		}
		if ( isset( $_POST['permissionViewOrders'] ) ) {
			$permission_view_orders = sanitize_text_field( $_POST['permissionViewOrders'] );
		}
		if ( isset( $_POST['permissionViewBundles'] ) ) {
			$permission_view_bundles = sanitize_text_field( $_POST['permissionViewBundles'] );
		}
		if ( isset( $_POST['permissionViewDiscussions'] ) ) {
			$permission_view_discussions = sanitize_text_field( $_POST['permissionViewDiscussions'] );
		}
		if ( isset( $_POST['permissionViewLists'] ) ) {
			$permission_view_lists = sanitize_text_field( $_POST['permissionViewLists'] );
		}

		// set user meta
		update_user_meta( $multiaccount_id, 'smuac_account_name', $name );
		update_user_meta( $multiaccount_id, 'smuac_account_phone', $phone );
		update_user_meta( $multiaccount_id, 'smuac_account_job_title', $job_title );
		update_user_meta( $multiaccount_id, 'smuac_account_permission_buy', $permission_buy ); // true or false
		update_user_meta( $multiaccount_id, 'smuac_account_permission_view_orders', $permission_view_orders ); // true or false
		update_user_meta( $multiaccount_id, 'smuac_account_permission_view_bundles', $permission_view_bundles ); // true or false
		update_user_meta( $multiaccount_id, 'smuac_account_permission_view_discussions', $permission_view_discussions ); // true or false
		update_user_meta( $multiaccount_id, 'smuac_account_permission_view_lists', $permission_view_lists ); // true or false

		echo esc_html( $multiaccount_id );
		exit();
	}

	public function smuac_accountingsubtotals() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['pricesent'] ) ) {
			$pricevalue = sanitize_text_field( $_POST['pricesent'] );
		}

		echo wp_kses( wc_price( floatval( $pricevalue ) ), array() );

		exit();
	}

	public function smuac_ajax_search() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}
		if ( isset( $_POST['searchby'] ) ) {
			$searchby = sanitize_text_field( $_POST['searchby'] );
		} else {
			$searchby = 'productname';
		}
		if ( isset( $_POST['searchValue'] ) ) {
			$searched_term = sanitize_text_field( $_POST['searchValue'] );
		}
		if ( isset( $_POST['searchType'] ) ) {
			$search_type = sanitize_text_field( $_POST['searchType'] );
			if ( 'purchaseListLoading' === $search_type ) {
				$searched_term = substr( $searched_term, 0, 7 );
			}
		}

		$search_each_variation = get_option( 'smuac_search_each_variation_setting', 1 );
		$search_what           = 'product';
		if ( 1 === intval( $search_each_variation ) ) {
			$search_what = array( 'product', 'product_variation' );
		}

		if ( 'productname' === $searchby ) {
			$queryAllparams = array(
				'no_found_rows'  => true,
				'post_status'    => 'publish',
				'posts_per_page' => -1,
				'post_type'      => $search_what,
				'meta_query'     => array(
					'relation' => 'AND',
					array(
						'key'     => '_price',
						'value'   => '',
						'compare' => '!=',
					),
					array(
						'key'     => '_price',
						'compare' => 'EXISTS',
					),
				),
				'fields'         => 'ids',
				's'              => $searched_term,
			);

			$queryAll  = new WP_Query( $queryAllparams );
			$allTheIDs = $queryAll->posts;
		} elseif ( 'sku' === $searchby ) {
			// search by SKU
			$querySKUparams = array(
				'no_found_rows'  => true,
				'post_status'    => 'publish',
				'posts_per_page' => -1,
				'post_type'      => $search_what,
				'meta_query'     => array(
					'relation' => 'AND',
					array(
						'key'     => '_price',
						'value'   => '',
						'compare' => '!=',
					),
					array(
						'key'     => '_price',
						'compare' => 'EXISTS',
					),
					array(
						'key'     => '_sku',
						'value'   => $searched_term,
						'compare' => 'LIKE',
					),
					array(
						'key'     => '_stock_status',
						'value'   => 'outofstock',
						'compare' => '!=',
					),
				),
				'fields'         => 'ids',
			);

			$querySKU  = new WP_Query( $querySKUparams );
			$allTheIDs = $querySKU->posts;
		}

		require_once SMUAC_DIR . 'public/class-smuac-helper.php';
		$helper = new Smuac_Helper();

		$results = array();
		$i       = 8; // show maximum 8 search results
		foreach ( $allTheIDs as $product_id ) {
			if ( $i > 0 ) {
				$product = wc_get_product( $product_id );

				if ( $product->is_purchasable() && $product->is_in_stock() ) {
					if ( $product->is_type( 'variable' ) ) {
						$children_ids = $product->get_children();
						foreach ( $children_ids as $variation_id ) {
							$productvariation = new WC_Product_Variation( $variation_id );
							// make sure variation does not have empty/unset attributes
							$attributes = $productvariation->get_attributes();
							if ( $productvariation->is_in_stock() && ! in_array( '', $attributes ) ) {
								if ( $productvariation->is_on_sale() ) {
									$product_price = $productvariation->get_sale_price();
								} else {
									$product_price = $productvariation->get_price();
								}
								$product_price = round( floatval( $helper->smuac_wc_get_price_to_display( $productvariation, array( 'price' => $product_price ) ) ), 2 );
								$product_title = $productvariation->get_formatted_name();

								$product_image = wp_get_attachment_image_src( get_post_thumbnail_id( $variation_id ) );
								if ( false === $product_image ) {
									$product_image = 'no';
									// try to find parent image
									$parent_image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ) );
									if ( false !== $parent_image ) {
										$product_image = $parent_image[0];
									}
								} else {
									$product_image = $product_image[0];
								}

								$results[ $variation_id ]                = $product_title;
								$results[ $variation_id . 'SMUACPRICE' ] = $product_price;
								$results[ $variation_id . 'SMUACIMAGE' ] = $product_image;
							}
						}
					} else {
						$stop = 'no';
						if ( 1 === intval( $search_each_variation ) ) {
							if ( is_a( $product, 'WC_Product_Variation' ) ) {
								$attributes = $product->get_attributes();
								if ( in_array( '', $attributes ) ) {
									$stop = 'yes';
								}
							}
						}

						if ( 'no' === $stop ) {
							if ( $product->is_on_sale() ) {
								$product_price = $product->get_sale_price();
							} else {
								$product_price = $product->get_price();
							}

							$product_price = round( floatval( $helper->smuac_wc_get_price_to_display( $product, array( 'price' => $product_price ) ) ), 2 );
							$product_title = $product->get_formatted_name();

							$product_image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ) );
							if ( false === $product_image ) {
								$product_image = 'no';
							} else {
								$product_image = $product_image[0];
							}

							$results[ $product_id ]                = $product_title;
							$results[ $product_id . 'SMUACPRICE' ] = $product_price;
							$results[ $product_id . 'SMUACIMAGE' ] = $product_image;
						}
					}
					$i--;
				}
			}
		}

		if ( empty( $results ) ) {
			$results = 1234;
			echo esc_html( $results );
		} else {
			echo json_encode( $results );
		}

		exit();
	}

	public function smuac_ajax_get_price() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['productid'] ) ) {
			$product_id = sanitize_text_field( $_POST['productid'] );
		}
		$product_price = wc_get_product( $product_id )->get_price();

		echo esc_html( intval( $product_price ) );
		exit();
	}

	public function smuac_bulkorder_add_cart() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['productstring'] ) ) {
			$productstring = sanitize_text_field( $_POST['productstring'] );
		}
		$products_array = explode( '|', $productstring );
		foreach ( $products_array as $product ) {
			$product_id  = explode( ':', $product )[0];
			$product_qty = explode( ':', $product )[1];
			WC()->cart->add_to_cart( $product_id, $product_qty );
		}

		echo 'success';
		exit();
	}

	public function smuac_bulkorder_save_list() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['productstring'] ) ) {
			$productstring = sanitize_text_field( $_POST['productstring'] );
		}
		if ( isset( $_POST['title'] ) ) {
			$title = sanitize_text_field( $_POST['title'] );
		}

		$shopping_list    = array(
			'post_title'  => $title,
			'post_status' => 'publish',
			'post_type'   => 'smuac_list',
			'post_author' => get_current_user_id(),
		);
		$shopping_list_id = wp_insert_post( $shopping_list );
		update_post_meta( $shopping_list_id, 'smuac_shopping_list_details', $productstring );

		echo esc_html( $shopping_list_id );
		exit();
	}

	public function smuac_shopping_list_update() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['productstring'] ) ) {
			$productstring = sanitize_text_field( $_POST['productstring'] );
		}
		if ( isset( $_POST['listid'] ) ) {
			$list_id = sanitize_text_field( $_POST['listid'] );
		}

		update_post_meta( $list_id, 'smuac_shopping_list_details', $productstring );

		echo esc_html( $list_id );
		exit();
	}

	public function smuac_shopping_list_delete() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['listid'] ) ) {
			$list_id = sanitize_text_field( $_POST['listid'] );
		}
		wp_delete_post( $list_id );

		echo 'success';
		exit();
	}

	public function smuac_save_cart_to_shopping_list() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		$productstring = '';
		$items         = WC()->cart->get_cart();
		foreach ( $items as $item => $values ) {
			$product_id     = $values['data']->get_id();
			$product_qty    = $values['quantity'];
			$productstring .= $product_id . ':' . $product_qty . '|';
		}

		// if cart not empty, save as list
		if ( '' !== $productstring ) {
			if ( isset( $_POST['title'] ) ) {
				$title = sanitize_text_field( $_POST['title'] );
			}
			$shopping_list    = array(
				'post_title'  => $title,
				'post_status' => 'publish',
				'post_type'   => 'smuac_list',
				'post_author' => get_current_user_id(),
			);
			$shopping_list_id = wp_insert_post( $shopping_list );

			update_post_meta( $shopping_list_id, 'smuac_shopping_list_details', $productstring );
		}

		echo 'success';
		exit();
	}

	public function smuac_send_feedback() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['message'] ) ) {
			$message = sanitize_text_field( $_POST['message'] );
		}
		if ( isset( $_POST['email'] ) ) {
			$email = sanitize_text_field( $_POST['email'] );
		}

		wp_mail( 'contact@webwizards.dev', esc_html__( 'New feedback message', 'smuac' ), $message . ' ' . esc_html__( 'Message was sent by:', 'smuac' ) . $email );

		echo 'success';
		exit();
	}

	public function smuacupdateuserdata() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['userid'] ) ) {
			$user_id = sanitize_text_field( $_POST['userid'] );
		}
		if ( isset( $_POST['field_strings'] ) ) {
			$fields_string = sanitize_text_field( $_POST['field_strings'] );
		}
		$fields_array = explode( ',', $fields_string );
		foreach ( $fields_array as $field_id ) {
			if ( null !== $field_id && ! empty( $field_id ) ) {
				// first check if field is VAT, then update user meta if field not empty
				$billing_connection = get_post_meta( $field_id, 'smuac_custom_field_billing_connection', true );
				if ( 'billing_vat' !== $billing_connection ) {
					// proceed normally,this is not VAT
					if ( isset( $_POST[ 'field_' . $field_id ] ) ) {
						update_user_meta( $user_id, 'smuac_custom_field_' . $field_id, sanitize_text_field( $_POST[ 'field_' . $field_id ] ) );
					}
				} else {
					// check if VIES is enabled
					$vies_enabled = get_post_meta( $field_id, 'smuac_custom_field_VAT_VIES_validation', true );

					if ( 1 === intval( $vies_enabled ) ) {
						// run VIES check on the data
						if ( isset( $_POST[ 'field_' . $field_id ] ) ) {
							$vatnumber = sanitize_text_field( $_POST[ 'field_' . $field_id ] );
						}
						$vatnumber = strtoupper( str_replace( array( '.', ' ' ), '', $vatnumber ) );

						$client       = new SoapClient( 'http://ec.europa.eu/taxation_customs/vies/checkVatService.wsdl' );
						$country_code = substr( $vatnumber, 0, 2 ); // take first 2 chars
						$vat_number   = substr( $vatnumber, 2 ); // remove first 2 chars

						$validation        = new \stdClass();
						$validation->valid = false;

						// check vat
						try {
							$validation = $client->checkVat(
								array(
									'countryCode' => $country_code,
									'vatNumber'   => $vat_number,
								)
							);
						} catch ( Exception $e ) {
							$error             = $e->getMessage();
							$validation->valid = 0;
						}

						if ( 1 === intval( $validation->valid ) ) {
							// update data
							update_user_meta( $user_id, 'smuac_custom_field_' . $field_id, $vatnumber );
							// also set validated vat
							update_user_meta( $user_id, 'smuac_user_vat_status', 'validated_vat' );
						} else {
							echo 'vatfailed';
						}
					}
				}
			}
		}

		echo 'success';
		exit();
	}

	public function smuac_dismiss_activate_woocommerce_admin_notice() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_notice_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		update_user_meta( get_current_user_id(), 'smuac_dismiss_activate_woocommerce_notice', 1 );

		echo 'success';
		exit();
	}

	public function smuac_dismiss_onboarding_admin_notice() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_notice_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		update_user_meta( get_current_user_id(), 'smuac_dismiss_onboarding_notice', 1 );

		echo 'success';
		exit();
	}

	public function smuac_b2c_special_group_save_settings() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}
		// get all shipping methods
		$shipping_methods = WC()->shipping->get_shipping_methods();
		foreach ( $shipping_methods as $shipping_method ) {
			if ( isset( $_POST[ 'smuac_b2c_users_shipping_method_' . $shipping_method->id ] ) ) {
				$user_setting = sanitize_text_field( $_POST[ 'smuac_b2c_users_shipping_method_' . $shipping_method->id ] );
			}
			if ( 1 === intval( $user_setting ) ) {
				update_option( 'smuac_b2c_users_shipping_method_' . $shipping_method->id, 1 );
			} elseif ( 0 === intval( $user_setting ) ) {
				update_option( 'smuac_b2c_users_shipping_method_' . $shipping_method->id, 0 );
			}
		}

		$payment_methods = WC()->payment_gateways->payment_gateways();

		foreach ( $payment_methods as $payment_method ) {
			if ( isset( $_POST[ 'smuac_b2c_users_payment_method_' . $payment_method->id ] ) ) {
				$user_setting = sanitize_text_field( $_POST[ 'smuac_b2c_users_payment_method_' . $payment_method->id ] );
			}
			if ( 1 === intval( $user_setting ) ) {
				update_option( 'smuac_b2c_users_payment_method_' . $payment_method->id, 1 );
			} elseif ( 0 === intval( $user_setting ) ) {
				update_option( 'smuac_b2c_users_payment_method_' . $payment_method->id, 0 );
			}
		}

		echo 'success';
		exit();
	}

	public function smuac_logged_out_special_group_save_settings() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}
		// get all shipping methods
		$shipping_methods = WC()->shipping->get_shipping_methods();
		foreach ( $shipping_methods as $shipping_method ) {
			if ( isset( $_POST[ 'smuac_logged_out_users_shipping_method_' . $shipping_method->id ] ) ) {
				$user_setting = sanitize_text_field( $_POST[ 'smuac_logged_out_users_shipping_method_' . $shipping_method->id ] );
			}
			if ( 1 === intval( $user_setting ) ) {
				update_option( 'smuac_logged_out_users_shipping_method_' . $shipping_method->id, 1 );
			} elseif ( 0 === intval( $user_setting ) ) {
				update_option( 'smuac_logged_out_users_shipping_method_' . $shipping_method->id, 0 );
			}
		}

		$payment_methods = WC()->payment_gateways->payment_gateways();

		foreach ( $payment_methods as $payment_method ) {
			if ( isset( $_POST[ 'smuac_logged_out_users_payment_method_' . $payment_method->id ] ) ) {
				$user_setting = sanitize_text_field( $_POST[ 'smuac_logged_out_users_payment_method_' . $payment_method->id ] );
			}
			if ( 1 === intval( $user_setting ) ) {
				update_option( 'smuac_logged_out_users_payment_method_' . $payment_method->id, 1 );
			} elseif ( 0 === intval( $user_setting ) ) {
				update_option( 'smuac_logged_out_users_payment_method_' . $payment_method->id, 0 );
			}
		}

		echo 'success';
		exit();
	}

	public function smuacbulksetusers() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['chosen_group'] ) ) {
			$group = sanitize_text_field( $_POST['chosen_group'] );
		}

		// get users
		$users = get_users(
			array(
				'fields' => 'ids',
			)
		);

		if ( ! empty( $users ) ) {
			// loop trough each author
			foreach ( $users as $user ) {
				// move all users to the group
				if ( 'b2cuser' === $group ) {
					update_user_meta( $user, 'smuac_customergroup', 'no' );
					update_user_meta( $user, 'smuac_b2buser', 'no' );
				} else {
					update_user_meta( $user, 'smuac_customergroup', $group );
					update_user_meta( $user, 'smuac_b2buser', 'yes' );
				}
			}
		}

		echo 'success';
		exit();
	}

	public function smuacbulksetcategory() {
		// Check security nonce.
		if ( ! check_ajax_referer( 'smuac_security_nonce', 'security' ) ) {
			wp_send_json_error( 'Invalid security token sent.' );
			wp_die();
		}

		if ( isset( $_POST['chosen_option'] ) ) {
			$option = sanitize_text_field( $_POST['chosen_option'] );
		}

		// get categories
		$terms = get_terms(
			array(
				'fields'      => 'ids',
				'post_status' => 'publish',
				'numberposts' => -1,
			)
		);

		$groups = get_posts(
			array(
				'post_type'   => 'smuac_group',
				'post_status' => 'publish',
				'numberposts' => -1,
				'fields'      => 'ids',
			)
		);

		if ( ! empty( $terms ) ) {
			// loop trough each term
			foreach ( $terms as $term ) {
				// move all users to the group
				if ( 'visibleallgroups' === $option ) {
					update_term_meta( $term, 'smuac_group_b2c', 1 );
					update_term_meta( $term, 'smuac_group_0', 1 );
					foreach ( $groups as $group ) {
						update_term_meta( $term, 'smuac_group_' . $group, 1 );
					}
				} elseif ( 'notvisibleallgroups' === $option ) {
					update_term_meta( $term, 'smuac_group_b2c', 0 );
					update_term_meta( $term, 'smuac_group_0', 0 );
					foreach ( $groups as $group ) {
						update_term_meta( $term, 'smuac_group_' . $group, 0 );
					}
				}
			}
		}

		echo 'success';
		exit();
	}

	// copied from Public
	// Hide prices to guest users
	public function smuac_hide_prices_guest_users( $price, $product ) {
		// if user is guest, OR multisite B2B/B2C separation is enabled and user should be treated as guest
		if ( ! is_user_logged_in() || ( 1 === intval( get_option( 'smuac_multisite_separate_b2bb2c_setting', 0 ) ) && 'yes' !== get_user_meta( get_current_user_id(), 'smuac_b2buser', true ) ) ) {
			return get_option( 'smuac_hide_prices_guests_text_setting', esc_html__( 'Login to view prices', 'smuac' ) );
		} else {
			return $price;
		}
	}

	public function smuac_disable_purchasable_guest_users( $purchasable ) {
		// if user is guest, or multisite b2b/b2b separation is enabled and user should be treated as guest
		if ( ! is_user_logged_in() || ( 1 === intval( get_option( 'smuac_multisite_separate_b2bb2c_setting', 0 ) ) && 'yes' !== get_user_meta( get_current_user_id(), 'smuac_b2buser', true ) ) ) {
			return false;
		} else {
			return $purchasable;
		}
	}

	// Tiered pricing for AJAX
	public function smuac_tiered_pricing_fixed_price( $price, $product ) {

		if ( is_user_logged_in() ) {
			$user_id      = get_current_user_id();
			$account_type = get_user_meta( $user_id, 'smuac_account_type', true );
			if ( 'multiaccount' === $account_type ) {
				// for all intents and purposes set current user as the multiaccount parent
				$parent_user_id = get_user_meta( $user_id, 'smuac_account_parent', true );
				$user_id        = $parent_user_id;
			}

			// check transient to see if the current price has been set already via another function
			if ( get_transient( 'smuac_user_' . $user_id . '_product_' . $product->get_id() . '_custom_set_price' ) === $price ) {
				return $price;
			}

			$is_b2b_user          = get_the_author_meta( 'smuac_b2buser', $user_id );
			$currentusergroupidnr = get_the_author_meta( 'smuac_customergroup', $user_id );
			if ( 'yes' === $is_b2b_user ) {
				// Search price tiers
				$price_tiers = get_post_meta( $product->get_id(), 'smuac_product_pricetiers_group_' . $currentusergroupidnr, true );

				// if no tiers, get regular
				if ( empty( $price_tiers ) ) {
					$price_tiers = get_post_meta( $product->get_id(), 'smuac_product_pricetiers_group_b2c', true );
				}

				if ( ! empty( $price_tiers ) ) {
					// if there are price tiers, check product quantity in cart and set price accordingly

					// find product quantity in cart
					$product_id = $product->get_id();
					$quantity   = 0;
					foreach ( WC()->cart->get_cart() as $cart_item ) {
						if ( $product_id === $cart_item['product_id'] || $product_id === $cart_item['variation_id'] ) {
							$quantity = $cart_item['quantity'];
							break;
						}
					}

					if ( 0 !== $quantity ) {
						$price_tiers      = explode( ';', $price_tiers );
						$quantities_array = array();
						$prices_array     = array();
						// first eliminate all quantities larger than the quantity in cart
						foreach ( $price_tiers as $tier ) {
							$tier_values = explode( ':', $tier );
							if ( $tier_values[0] <= $quantity && ! empty( $tier_values[0] ) ) {
								array_push( $quantities_array, $tier_values[0] );
								$prices_array[ $tier_values[0] ] = $tier_values[1];
							}
						}

						// if any number remains
						if ( 0 !== count( $quantities_array ) ) {
							// get the largest number
							$largest = max( $quantities_array );
							// clear cache mostly for variable products
							WC_Cache_Helper::get_transient_version( 'product', true );

							// if regular table exists, but group table does not exist
							// apply tiered pricing only if the user's group price is not already smaller than tier price
							if ( empty( get_post_meta( $product->get_id(), 'smuac_product_pricetiers_group_' . $currentusergroupidnr, true ) ) ) {
								if ( floatval( $price ) > floatval( $prices_array[ $largest ] ) ) {
									return $prices_array[ $largest ];
								} else {
									// return regular price
									return $price;
								}
							} else {
								return $prices_array[ $largest ];
							}
						} else {
								return $price;
						}
					} else {
							return $price;
					}
				} else {
					return $price;
				}
			} else {
				return $price;
			}
		} else {
			return $price;
		}
	}

	// Individual product pricing functions for AJAX below
	public function smuac_individual_pricing_fixed_price( $price, $product ) {

		if ( is_user_logged_in() ) {
			$user_id      = get_current_user_id();
			$account_type = get_user_meta( $user_id, 'smuac_account_type', true );
			if ( 'multiaccount' === $account_type ) {
				// for all intents and purposes set current user as the multiaccount parent
				$parent_user_id = get_user_meta( $user_id, 'smuac_account_parent', true );
				$user_id        = $parent_user_id;
			}

			// check transient to see if the current price has been set already via another function
			if ( get_transient( 'smuac_user_' . $user_id . '_product_' . $product->get_id() . '_custom_set_price' ) === $price ) {
				return $price;
			}

			$is_b2b_user          = get_the_author_meta( 'smuac_b2buser', $user_id );
			$currentusergroupidnr = get_the_author_meta( 'smuac_customergroup', $user_id );
			if ( 'yes' === $is_b2b_user ) {
				// Search if there is a specific price set for the user's group
				$b2b_price = get_post_meta( $product->get_id(), 'smuac_regular_product_price_group_' . $currentusergroupidnr, true );
				if ( ! empty( $b2b_price ) ) {
					// ADD WOOCS COMPATIBILITY
					if ( class_exists( 'WOOCS' ) ) {
						global $WOOCS;
						$currrent = $WOOCS->current_currency;
						if ( $currrent != $WOOCS->default_currency ) {
							$currencies = $WOOCS->get_currencies();
							$rate       = $currencies[ $currrent ]['rate'];
							$b2b_price  = $b2b_price / ( $rate );
						}
					}

					return $b2b_price;
				} else {
					return $price;
				}
			} else {
				return $price;
			}
		} else {
			return $price;
		}
	}

	public function smuac_individual_pricing_discount_sale_price( $sale_price, $product ) {

		if ( is_user_logged_in() ) {
			$user_id      = get_current_user_id();
			$account_type = get_user_meta( $user_id, 'smuac_account_type', true );
			if ( 'multiaccount' === $account_type ) {
				// for all intents and purposes set current user as the multiaccount parent
				$parent_user_id = get_user_meta( $user_id, 'smuac_account_parent', true );
				$user_id        = $parent_user_id;
			}

			$is_b2b_user          = get_the_author_meta( 'smuac_b2buser', $user_id );
			$currentusergroupidnr = get_the_author_meta( 'smuac_customergroup', $user_id );
			if ( 'yes' === $is_b2b_user ) {
				// Search if there is a specific price set for the user's group
				$b2b_price = get_post_meta( $product->get_id(), 'smuac_sale_product_price_group_' . $currentusergroupidnr, true );
				if ( ! empty( $b2b_price ) ) {
					// ADD WOOCS COMPATIBILITY
					if ( class_exists( 'WOOCS' ) ) {
						global $WOOCS;
						$currrent = $WOOCS->current_currency;
						if ( $currrent != $WOOCS->default_currency ) {
							$currencies = $WOOCS->get_currencies();
							$rate       = $currencies[ $currrent ]['rate'];
							$b2b_price  = $b2b_price / ( $rate );
						}
					}

					return $b2b_price;
				} else {
					return $sale_price;
				}
			} else {
				return $sale_price;
			}
		} else {
			return $sale_price;
		}
	}

	public function smuac_individual_pricing_discount_display_dynamic_price( $price_html, $product ) {
		if ( $product->is_type( 'variable' ) && ! class_exists( 'WOOCS' ) ) { // add WOOCS compatibility
			return $price_html;
		}

		if ( is_user_logged_in() ) {
			$user_id      = get_current_user_id();
			$account_type = get_user_meta( $user_id, 'smuac_account_type', true );
			if ( 'multiaccount' === $account_type ) {
				// for all intents and purposes set current user as the multiaccount parent
				$parent_user_id = get_user_meta( $user_id, 'smuac_account_parent', true );
				$user_id        = $parent_user_id;
			}

			$is_b2b_user          = get_the_author_meta( 'smuac_b2buser', $user_id );
			$currentusergroupidnr = get_the_author_meta( 'smuac_customergroup', $user_id );
			if ( 'yes' === $is_b2b_user ) {
				// Search if there is a specific price set for the user's group
				$b2b_price = get_post_meta( $product->get_id(), 'smuac_sale_product_price_group_' . $currentusergroupidnr, true );
				if ( ! empty( $b2b_price ) ) {
					if ( $product->is_type( 'variable' ) && class_exists( 'WOOCS' ) ) { // add WOOCS compatibility
						global $WOOCS;
						$currrent = $WOOCS->current_currency;
						if ( $currrent != $WOOCS->default_currency ) {
							$currencies = $WOOCS->get_currencies();
							$rate       = $currencies[ $currrent ]['rate'];

							// apply WOOCS rate to price_html
							$min_price  = $product->get_variation_price( 'min' ) / ( $rate );
							$max_price  = $product->get_variation_price( 'max' ) / ( $rate );
							$price_html = wc_format_price_range( $min_price, $max_price );
						}
					} else {
						$price_html = wc_format_sale_price( wc_get_price_to_display( $product, array( 'price' => $product->get_regular_price() ) ), wc_get_price_to_display( $product, array( 'price' => $product->get_sale_price() ) ) ) . $product->get_price_suffix();
					}
				}
			}
		}

		return $price_html;
	}

	public function smuac_individual_pricing_discount_display_dynamic_price_in_cart( $cart ) {
		if ( is_admin() && ! defined( 'DOING_AJAX' ) ) {
			return;
		}

		if ( did_action( 'woocommerce_before_calculate_totals' ) >= 2 ) {
			return;
		}

		// Get current user
		$user_id      = get_current_user_id();
		$account_type = get_user_meta( $user_id, 'smuac_account_type', true );
		if ( 'multiaccount' === $account_type ) {
			// for all intents and purposes set current user as the multiaccount parent
			$parent_user_id = get_user_meta( $user_id, 'smuac_account_parent', true );
			$user_id        = $parent_user_id;
		}

		$is_b2b_user          = get_the_author_meta( 'smuac_b2buser', $user_id );
		$currentusergroupidnr = get_the_author_meta( 'smuac_customergroup', $user_id );
		if ( 'yes' === $is_b2b_user ) {
			// Iterate through each cart item
			foreach ( $cart->get_cart() as $cart_item ) {
				// Search if there is a specific price set for the user's group
				if ( isset( $cart_item['variation_id'] ) && 0 !== intval( $cart_item['variation_id'] ) ) {
					$b2b_price      = get_post_meta( $cart_item['variation_id'], 'smuac_sale_product_price_group_' . $currentusergroupidnr, true );
					$product_id_set = $cart_item['variation_id'];
				} else {
					$b2b_price      = get_post_meta( $cart_item['product_id'], 'smuac_sale_product_price_group_' . $currentusergroupidnr, true );
					$product_id_set = $cart_item['product_id'];
				}

				if ( ! empty( $b2b_price ) ) {
					$cart_item['data']->set_price( $b2b_price );
					set_transient( 'smuac_user_' . $user_id . '_product_' . $product_id_set . '_custom_set_price', $b2b_price );
				}
			}
		}
	}

	public function smuac_individual_pricing_discount_display_dynamic_price_in_cart_item( $price, $cart_item, $cart_item_key ) {

		// Get current user
		$user_id      = get_current_user_id();
		$account_type = get_user_meta( $user_id, 'smuac_account_type', true );
		if ( 'multiaccount' === $account_type ) {
			// for all intents and purposes set current user as the multiaccount parent
			$parent_user_id = get_user_meta( $user_id, 'smuac_account_parent', true );
			$user_id        = $parent_user_id;
		}

		$is_b2b_user          = get_the_author_meta( 'smuac_b2buser', $user_id );
		$currentusergroupidnr = get_the_author_meta( 'smuac_customergroup', $user_id );
		if ( 'yes' === $is_b2b_user ) {
			if ( isset( $cart_item['variation_id'] ) && 0 !== intval( $cart_item['variation_id'] ) ) {
				$b2b_price      = get_post_meta( $cart_item['variation_id'], 'smuac_sale_product_price_group_' . $currentusergroupidnr, true );
				$product_id_set = $cart_item['variation_id'];
			} else {
				$b2b_price      = get_post_meta( $cart_item['product_id'], 'smuac_sale_product_price_group_' . $currentusergroupidnr, true );
				$product_id_set = $cart_item['product_id'];
			}

			if ( ! empty( $b2b_price ) ) {
				require_once SMUAC_DIR . 'public/class-smuac-helper.php';
				$helper = new Smuac_Helper();

				$discount_price = $helper->smuac_wc_get_price_to_display( wc_get_product( $product_id_set ), array( 'price' => $cart_item['data']->get_sale_price() ) ); // get sale price

				if ( null !== $discount_price && '' !== $discount_price ) {
					$price = wc_price( $discount_price, 4 );
				}
			}
		}
		return $price;
	}

	// Visibility rules, copied from public
	public function smuac_product_categories_visibility_rules( $q ) {

		if ( 1 === intval( get_option( 'smuac_enable_product_visibility_setting', 0 ) ) ) {
			$allTheIDs = get_transient( 'smuac_user_' . get_current_user_id() . '_ajax_visibility' );

			if ( $allTheIDs ) {
				if ( ! empty( $allTheIDs ) ) {
					$q->set( 'post__in', $allTheIDs );
				}
			}
		}
	}

	public function get_visibility_set_transient() {
		if ( ! get_transient( 'smuac_user_' . get_current_user_id() . '_ajax_visibility' ) ) {
			if ( 1 === intval( get_option( 'smuac_enable_product_visibility_setting', 0 ) ) ) {
				$user_is_b2b = get_user_meta( get_current_user_id(), 'smuac_b2buser', true );

				// if user logged in and is b2b
				if ( is_user_logged_in() && ( 'yes' === $user_is_b2b ) ) {
					// Get current user's data: group, id, login, etc
					$currentuserid = get_current_user_id();
					$account_type  = get_user_meta( $currentuserid, 'smuac_account_type', true );
					if ( 'multiaccount' === $account_type ) {
						// for all intents and purposes set current user as the multiaccount parent
						$parent_user_id = get_user_meta( $currentuserid, 'smuac_account_parent', true );
						$currentuserid  = $parent_user_id;
					}
					$currentuser          = get_user_by( 'id', $currentuserid );
					$currentuserlogin     = $currentuser->user_login;
					$currentusergroupidnr = get_the_author_meta( 'smuac_customergroup', $currentuserid );
					// if user is b2c
				} elseif ( is_user_logged_in() && ( 'yes' !== $user_is_b2b ) ) {
					$currentuserlogin     = 'b2c';
					$currentusergroupidnr = 'b2c';
				} else {
					$currentuserlogin     = 0;
					$currentusergroupidnr = 0;
				}
				/*
				*
				*   There are 2 separate queries that need to be made:
				*   1. Query of all Categories visible to the USER AND all Categories visible to the USER'S GROUP
				*   2. Query of all Products set to Manual visibility mode, visible to the user or the user's group
				*
				*/

				// Build Visible Categories for the 1st Query
				$visiblecategories = array();
				$hiddencategories  = array();

				$terms = get_terms(
					array(
						'taxonomy'   => 'product_cat',
						'fields'     => 'ids',
						'hide_empty' => false,
					)
				);

				foreach ( $terms as $term ) {
					/*
					* If category is visible to GROUP OR category is visible to USER
					* Push category into visible categories array
					*/

					// first check group
					$group_meta = get_term_meta( $term, 'smuac_group_' . $currentusergroupidnr, true );
					if ( 1 === intval( $group_meta ) ) {
						array_push( $visiblecategories, $term );
						// else check user
					} else {
						$userlistcommas = get_term_meta( $term, 'smuac_category_users_textarea', true );
						$userarray      = explode( ',', $userlistcommas );
						foreach ( $userarray as $user ) {
							if ( trim( $user ) === $currentuserlogin ) {
								array_push( $visiblecategories, $term );
								break;
							}
						}
						// has reached this point, therefore category is not visible
						array_push( $hiddencategories, $term );
					}
				}

				$product_category_visibility_array = array(
					'taxonomy' => 'product_cat',
					'field'    => 'term_id',
					'terms'    => $visiblecategories,
					'operator' => 'IN',
				);

				// if user has enabled "hidden has priority", override setting
				if ( 1 === intval( get_option( 'smuac_hidden_has_priority_setting', 0 ) ) ) {
					$product_category_visibility_array = array(
						'taxonomy' => 'product_cat',
						'field'    => 'term_id',
						'terms'    => $hiddencategories,
						'operator' => 'NOT IN',
					);
				}

				/*
				 Get all items that do not have manual visibility set up */
				// get all products ids
				$items_not_manual_visibility_array = get_transient( 'smuac_not_manual_visibility_array' );
				if ( ! $items_not_manual_visibility_array ) {
					$all_prods    = new WP_Query(
						array(
							'posts_per_page' => -1,
							'post_type'      => 'product',
							'fields'         => 'ids',
						)
					);
					$all_prod_ids = $all_prods->posts;

					// get all products with manual visibility ids
					$all_prods_manual    = new WP_Query(
						array(
							'posts_per_page' => -1,
							'post_type'      => 'product',
							'fields'         => 'ids',
							'meta_query'     => array(
								'relation' => 'AND',
								array(
									'key'   => 'smuac_product_visibility_override',
									'value' => 'manual',
								),
							),
						)
					);
					$all_prod_manual_ids = $all_prods_manual->posts;
					// get the difference
					$items_not_manual_visibility_array = array_diff( $all_prod_ids, $all_prod_manual_ids );
					set_transient( 'smuac_not_manual_visibility_array', $items_not_manual_visibility_array );
				}

				// Build first query
				$queryAparams = array(
					'posts_per_page' => -1,
					'post_type'      => 'product',
					'fields'         => 'ids',
					'tax_query'      => array(
						$product_category_visibility_array,
					),
					'post__in'       => $items_not_manual_visibility_array,
				);

				// Build 2nd query: all manual visibility products with USER OR USER GROUP visibility
				$queryBparams = array(
					'posts_per_page' => -1,
					'post_type'      => 'product',
					'fields'         => 'ids',
					'meta_query'     => array(
						'relation' => 'AND',
						array(
							'relation' => 'OR',
							array(
								'key'   => 'smuac_group_' . $currentusergroupidnr,
								'value' => '1',
							),
							array(
								'key'   => 'smuac_user_' . $currentuserlogin,
								'value' => '1',
							),
						),
						array(
							'key'   => 'smuac_product_visibility_override',
							'value' => 'manual',
						),
					),
				);

				$queryA = new WP_Query( $queryAparams );
				$queryB = new WP_Query( $queryBparams );

				// Merge the 2 queries in an IDs array
				$allTheIDs = array_merge( $queryA->posts, $queryB->posts );
				set_transient( 'smuac_user_' . get_current_user_id() . '_ajax_visibility', $allTheIDs );
			}
		}
	}
}
