<?php


class Smuac_Activator {


	public static function activate() {

		// prevent option update issues due to caching
		wp_cache_delete( 'alloptions', 'options' );

		// Trigger post types and endpoints functions
		require_once SMUAC_DIR . 'admin/class-smuac-admin.php';
		require_once SMUAC_DIR . 'public/class-smuac-public.php';
		$adminobj  = new Smuac_Admin();
		$publicobj = new Smuac_Public();
		$publicobj->smuac_custom_endpoints();

		// Flush rewrite rules
		flush_rewrite_rules();

		// Set admin notice state to enabled ('activate woocommerce' notice)
		update_user_meta( get_current_user_id(), 'smuac_dismiss_activate_woocommerce_notice', 0 );

	}
}
