<?php

/**
 *
 * PHP File that handles Settings management
 */
class Smuac_Settings {


	public function register_all_settings() {

		// Set plugin status (Disabled, B2B & B2C, or B2B)
		add_settings_section( 'smuac_shop_type_settings_section', '', '', 'smuac' );
		register_setting(
			'smuac',
			'smuac_plugin_status_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_plugin_status_setting', 'b2b' ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_plugin_status_setting', esc_html__( 'Shop Type', 'smuac' ), array( $this, 'smuac_plugin_status_setting_content' ), 'smuac', 'smuac_shop_type_settings_section' );

		/* Quote Settings */

		add_settings_section( 'smuac_quotesettings_text_section', '', '', 'smuac' );

		register_setting(
			'smuac',
			'smuac_quotename_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_quotename_setting', 1 ) : $input;
				},
			)
		);
		register_setting(
			'smuac',
			'smuac_quoteemail_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_quoteemail_setting', 1 ) : $input;
				},
			)
		);
		register_setting(
			'smuac',
			'smuac_quotephone_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_quotephone_setting', 0 ) : $input;
				},
			)
		);
		register_setting(
			'smuac',
			'smuac_quotemessage_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_quotemessage_setting', 1 ) : $input;
				},
			)
		);

		add_settings_field( 'smuac_quotename_setting', esc_html__( 'Quote Fields', 'smuac' ), array( $this, 'smuac_quotename_setting_content' ), 'smuac', 'smuac_quotesettings_text_section' );

		// Request a Custom Quote Button
		register_setting(
			'smuac',
			'smuac_quote_button_cart_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_quote_button_cart_setting', 'enableb2b' ) : $input;
				},
			)
		);
		add_settings_section( 'smuac_quotebutton_settings_section', '', '', 'smuac' );
		add_settings_field( 'smuac_quote_button_cart_setting', esc_html__( '"Request a Quote" in Cart', 'smuac' ), array( $this, 'smuac_quote_button_cart_setting_content' ), 'smuac', 'smuac_quotebutton_settings_section' );

		// Integrate Quotes with Discussions
		register_setting(
			'smuac',
			'smuac_integrate_quotes_discussions_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_integrate_quotes_discussions_setting', 1 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_integrate_quotes_discussions_setting', esc_html__( 'Integrate with Discussions', 'smuac' ), array( $this, 'smuac_integrate_quotes_discussions_setting_content' ), 'smuac', 'smuac_quotesettings_text_section' );

		/* Access restriction */

		// Set guest access restriction (none, hide prices, hide website, replace with request quote)
		register_setting(
			'smuac',
			'smuac_guest_access_restriction_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_guest_access_restriction_setting', 'hide_prices' ) : $input;
				},
			)
		);
		add_settings_section( 'smuac_access_restriction_settings_section', '', '', 'smuac' );
		add_settings_field( 'smuac_guest_access_restriction_setting', esc_html__( 'Guest User Access', 'smuac' ), array( $this, 'smuac_access_restriction_setting_content' ), 'smuac', 'smuac_access_restriction_settings_section' );

		add_settings_section( 'smuac_access_restriction_category_settings_section', '', '', 'smuac' );
		// Enable rules for non b2b users
		register_setting(
			'smuac',
			'smuac_hidden_has_priority_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_hidden_has_priority_setting', 0 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_hidden_has_priority_setting', esc_html__( 'Hidden Has Priority', 'smuac' ), array( $this, 'smuac_hidden_has_priority_setting_content' ), 'smuac', 'smuac_access_restriction_category_settings_section' );

		/* Registration Settings */
		add_settings_section( 'smuac_registration_settings_section', '', '', 'smuac' );
		add_settings_section( 'smuac_registration_settings_section_advanced', '', '', 'smuac' );

		// Registration Option Dropdown enable (enabled by default)
		register_setting(
			'smuac',
			'smuac_registration_options_dropdown_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_registration_options_dropdown_setting', 1 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_registration_options_dropdown_setting', esc_html__( 'Extend Normal Registration', 'smuac' ), array( $this, 'smuac_registration_options_dropdown_setting_content' ), 'smuac', 'smuac_registration_settings_section' );

		// Enable custom registration in checkout
		register_setting(
			'smuac',
			'smuac_registration_at_checkout_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_registration_at_checkout_setting', 0 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_registration_at_checkout_setting', esc_html__( 'Extend Checkout Registration', 'smuac' ), array( $this, 'smuac_registration_at_checkout_setting_content' ), 'smuac', 'smuac_registration_settings_section_advanced' );

		// Require approval for all users' registration
		register_setting(
			'smuac',
			'smuac_approval_required_all_users_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_approval_required_all_users_setting', 0 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_approval_required_all_users_setting', esc_html__( 'Manual Approval for All', 'smuac' ), array( $this, 'smuac_approval_required_all_users_setting_content' ), 'smuac', 'smuac_registration_settings_section_advanced' );

		// Enable Validate VAT button at checkout
		register_setting(
			'smuac',
			'smuac_validate_vat_button_checkout_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_validate_vat_button_checkout_setting', 0 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_validate_vat_button_checkout_setting', esc_html__( 'Validate VAT at Checkout', 'smuac' ), array( $this, 'smuac_validate_vat_button_checkout_setting_content' ), 'smuac', 'smuac_othersettings_vat_section' );

		/* Bundles Settings */
		add_settings_section( 'smuac_bundles_settings_section', '', '', 'smuac' );
		// Show product selector in Bundles
		register_setting(
			'smuac',
			'smuac_replace_selector_text_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_replace_selector_text_setting', 0 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_replace_selector_text_setting', esc_html__( 'Replace Products With Text', 'smuac' ), array( $this, 'smuac_replace_selector_text_setting_content' ), 'smuac', 'smuac_bundles_settings_section' );
		// Show product selector in Bundles
		register_setting(
			'smuac',
			'smuac_bundles_product_image_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_bundles_product_image_setting', 1 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_bundles_product_image_setting', esc_html__( 'Show Product Image', 'smuac' ), array( $this, 'smuac_bundles_product_image_setting_content' ), 'smuac', 'smuac_bundles_settings_section' );

		/* Enable Features */

		add_settings_section( 'smuac_enable_features_settings_section', '', '', 'smuac' );
		add_settings_field( 'smuac_enabled_modules_setting', esc_html__( 'Active Modules', 'smuac' ), array( $this, 'smuac_enabled_modules_setting_content' ), 'smuac', 'smuac_enable_features_settings_section' );

		register_setting(
			'smuac',
			'smuac_enable_shopping_lists_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_enable_shopping_lists_setting', 1 ) : $input;
				},
			)
		);
		register_setting(
			'smuac',
			'smuac_enable_multiaccounts_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_enable_multiaccounts_setting', 1 ) : $input;
				},
			)
		);

		/* Language Settings */

		add_settings_section( 'smuac_languagesettings_text_section', '', '', 'smuac' );

		// Hide prices to guests text
		register_setting(
			'smuac',
			'smuac_hide_prices_guests_text_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_hide_prices_guests_text_setting', esc_html__( 'Login to view prices', 'smuac' ) ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_hide_prices_guests_text_setting', esc_html__( 'Hide prices text', 'smuac' ), array( $this, 'smuac_hide_prices_guests_text_setting_content' ), 'smuac', 'smuac_languagesettings_text_section' );

		// Hide b2b site entirely text
		register_setting(
			'smuac',
			'smuac_hide_b2b_site_text_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_hide_b2b_site_text_setting', esc_html__( 'Please login to access the B2B Portal.', 'smuac' ) ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_hide_b2b_site_text_setting', esc_html__( 'Hide shop & products text', 'smuac' ), array( $this, 'smuac_hide_b2b_site_text_setting_content' ), 'smuac', 'smuac_languagesettings_text_section' );

		// Hidden price dynamic rule text
		register_setting(
			'smuac',
			'smuac_hidden_price_dynamic_rule_text_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_hidden_price_dynamic_rule_text_setting', esc_html__( 'Price is unavailable', 'smuac' ) ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_hidden_price_dynamic_rule_text_setting', esc_html__( 'Hidden price dynamic rule text', 'smuac' ), array( $this, 'smuac_hidden_price_dynamic_rule_text_setting_content' ), 'smuac', 'smuac_languagesettings_text_section' );

		add_settings_section( 'smuac_languagesettings_purchaselists_section', '', '', 'smuac' );

		// Shopping Lists Language
		register_setting(
			'smuac',
			'smuac_shopping_lists_language_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_shopping_lists_language_setting', 'English' ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_shopping_lists_language_setting', esc_html__( 'Language', 'smuac' ), array( $this, 'smuac_shopping_lists_language_setting_content' ), 'smuac', 'smuac_languagesettings_purchaselists_section' );

		/* Other Settings */

		add_settings_section( 'smuac_othersettings_section', '', '', 'smuac' );

		// Keep data on uninstall
		register_setting(
			'smuac',
			'smuac_keepdata_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_keepdata_setting', 1 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_keepdata_setting', esc_html__( 'Keep data on uninstall:', 'smuac' ), array( $this, 'smuac_keepdata_setting_content' ), 'smuac', 'smuac_othersettings_section' );

		// Color and Design
		add_settings_section( 'smuac_othersettings_colordesign_section', '', '', 'smuac' );
		register_setting(
			'smuac',
			'smuac_color_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_color_setting', '#94678b' ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_color_setting', esc_html__( 'Frontend Color', 'smuac' ), array( $this, 'smuac_color_setting_content' ), 'smuac', 'smuac_othersettings_colordesign_section' );

		register_setting(
			'smuac',
			'smuac_colorhover_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_colorhover_setting', '#904d82' ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_colorhover_setting', esc_html__( 'Frontend Hover Color', 'smuac' ), array( $this, 'smuac_colorhover_setting_content' ), 'smuac', 'smuac_othersettings_colordesign_section' );

		add_settings_section( 'smuac_othersettings_multisite_section', '', '', 'smuac' );

		// Multisite setting
		register_setting(
			'smuac',
			'smuac_multisite_separate_b2bb2c_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_multisite_separate_b2bb2c_setting', 0 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_multisite_separate_b2bb2c_setting', esc_html__( 'B2B & B2C Multisite', 'smuac' ), array( $this, 'smuac_multisite_separate_b2bb2c_setting_content' ), 'smuac', 'smuac_othersettings_multisite_section' );

		add_settings_section( 'smuac_othersettings_bulkorderform_section', '', '', 'smuac' );
		// Search by SKU setting
		register_setting(
			'smuac',
			'smuac_search_by_sku_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_search_by_sku_setting', 1 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_search_by_sku_setting', esc_html__( 'Search by SKU', 'smuac' ), array( $this, 'smuac_search_by_sku_setting_content' ), 'smuac', 'smuac_othersettings_bulkorderform_section' );

		// Search by Description setting
		register_setting(
			'smuac',
			'smuac_search_product_description_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_search_product_description_setting', 0 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_search_product_description_setting', esc_html__( 'Search Product Description', 'smuac' ), array( $this, 'smuac_search_product_description_setting_content' ), 'smuac', 'smuac_othersettings_bulkorderform_section' );

		// Search each individual variation setting
		register_setting(
			'smuac',
			'smuac_search_each_variation_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_search_each_variation_setting', 1 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_search_each_variation_setting', esc_html__( 'Search Each Variation', 'smuac' ), array( $this, 'smuac_search_each_variation_setting_content' ), 'smuac', 'smuac_othersettings_bulkorderform_section' );

		// Show accounting subtotals
		register_setting(
			'smuac',
			'smuac_show_accounting_subtotals_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_show_accounting_subtotals_setting', 0 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_show_accounting_subtotals_setting', esc_html__( 'Show Accounting Subtotals', 'smuac' ), array( $this, 'smuac_show_accounting_subtotals_setting_content' ), 'smuac', 'smuac_othersettings_bulkorderform_section' );

		// Force permalinks to show
		register_setting(
			'smuac',
			'smuac_force_permalinks_flushing_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_force_permalinks_flushing_setting', 0 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_force_permalinks_flushing_setting', esc_html__( 'Force Permalinks Rewrite', 'smuac' ), array( $this, 'smuac_force_permalinks_flushing_setting_content' ), 'smuac', 'smuac_othersettings_permalinks_section' );

		add_settings_section( 'smuac_othersettings_permalinks_section', '', '', 'smuac' );

		add_settings_section( 'smuac_othersettings_largestores_section', '', '', 'smuac' );

		register_setting(
			'smuac',
			'smuac_replace_product_selector_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_replace_product_selector_setting', 0 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_replace_product_selector_setting', esc_html__( 'Replace Selector with Text Box', 'smuac' ), array( $this, 'smuac_replace_product_selector_setting_content' ), 'smuac', 'smuac_othersettings_largestores_section' );

		register_setting(
			'smuac',
			'smuac_hide_users_dynamic_rules_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_hide_users_dynamic_rules_setting', 0 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_hide_users_dynamic_rules_setting', esc_html__( 'Hide Individual Users', 'smuac' ), array( $this, 'smuac_hide_users_dynamic_rules_setting_content' ), 'smuac', 'smuac_othersettings_largestores_section' );

		add_settings_section( 'smuac_othersettings_pvisibility_section', '', '', 'smuac' );
		// Search by SKU setting
		register_setting(
			'smuac',
			'smuac_product_visibility_cache_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_product_visibility_cache_setting', 1 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_product_visibility_cache_setting', esc_html__( 'Cache Product Visibility', 'smuac' ), array( $this, 'smuac_product_visibility_cache_setting_content' ), 'smuac', 'smuac_othersettings_pvisibility_section' );

		add_settings_section( 'smuac_othersettings_vat_section', '', '', 'smuac' );
		// Search by SKU setting
		register_setting(
			'smuac',
			'smuac_vat_exemption_different_country_setting',
			array(
				'sanitize_callback' => function ( $input ) {
					return null === $input ? get_option( 'smuac_vat_exemption_different_country_setting', 0 ) : $input;
				},
			)
		);
		add_settings_field( 'smuac_vat_exemption_different_country_setting', esc_html__( 'VAT Exemption Requires Different Delivery Country', 'smuac' ), array( $this, 'smuac_vat_exemption_different_country_setting_content' ), 'smuac', 'smuac_othersettings_vat_section' );

		do_action( 'smuac_register_settings' );
	}

	public function smuac_plugin_status_setting_content() {
		?>
		<fieldset>
			<label><input type="radio" tabindex="0" class="hidden" name="smuac_plugin_status_setting" value="b2b" <?php checked( 'b2b', get_option( 'smuac_plugin_status_setting', 'b2b' ), true ); ?>"> <?php esc_html_e( 'B2B Shop', 'smuac' ); ?></label><br />
			<label><input type="radio" tabindex="0" class="hidden" name="smuac_plugin_status_setting" value="hybrid" <?php checked( 'hybrid', get_option( 'smuac_plugin_status_setting', 'b2b' ), true ); ?>"> <?php esc_html_e( 'B2B & B2C Shop', 'smuac' ); ?></label><br />
			<p class="description"><?php esc_html_e( 'In a B2B shop, all customers are business users. In a B2B & B2C shop, there are both business and individual customers.', 'smuac' ); ?></p>
		</fieldset>
		<?php
	}

	public function smuac_access_restriction_setting_content() {
		?>
		<fieldset>
			<label><input type="radio" tabindex="0" class="hidden" name="smuac_guest_access_restriction_setting" value="none" <?php checked( 'none', get_option( 'smuac_guest_access_restriction_setting', 'hide_prices' ), true ); ?>"> <?php esc_html_e( 'Normal', 'smuac' ); ?></label><br />
			<label><input type="radio" tabindex="0" class="hidden" name="smuac_guest_access_restriction_setting" value="hide_prices" <?php checked( 'hide_prices', get_option( 'smuac_guest_access_restriction_setting', 'hide_prices' ), true ); ?>"> <?php esc_html_e( 'Hide prices', 'smuac' ); ?></label><br />
			<label><input type="radio" tabindex="0" class="hidden" name="smuac_guest_access_restriction_setting" value="hide_website" <?php checked( 'hide_website', get_option( 'smuac_guest_access_restriction_setting', 'hide_prices' ), true ); ?>"> <?php esc_html_e( 'Hide shop & products', 'smuac' ); ?></label><br />
			<label><input type="radio" tabindex="0" class="hidden" name="smuac_guest_access_restriction_setting" value="hide_website_completely" <?php checked( 'hide_website_completely', get_option( 'smuac_guest_access_restriction_setting', 'hide_prices' ), true ); ?>"> <?php esc_html_e( 'Hide website & force login', 'smuac' ); ?></label><br />
			<label><input type="radio" tabindex="0" class="hidden" name="smuac_guest_access_restriction_setting" value="replace_prices_quote" <?php checked( 'replace_prices_quote', get_option( 'smuac_guest_access_restriction_setting', 'hide_prices' ), true ); ?>"> <?php esc_html_e( 'Request quotes instead of price', 'smuac' ); ?></label><br />

			<p class="description"><?php esc_html_e( 'This setting controls what guest / logged out users see when accessing the shop. To control this in more detail, use rules.', 'smuac' ); ?></p>
		</fieldset>
		<?php
	}

	public function smuac_quote_button_cart_setting_content() {
		?>
		<fieldset>
			<label><input type="radio" tabindex="0" class="hidden" name="smuac_quote_button_cart_setting" value="disabled" <?php checked( 'disabled', get_option( 'smuac_quote_button_cart_setting', 'enableb2b' ), true ); ?>"> <?php esc_html_e( 'Disabled', 'smuac' ); ?></label><br />
			<label><input type="radio" tabindex="0" class="hidden" name="smuac_quote_button_cart_setting" value="enableb2c" <?php checked( 'enableb2c', get_option( 'smuac_quote_button_cart_setting', 'enableb2b' ), true ); ?>"> <?php esc_html_e( 'Enabled for B2C users', 'smuac' ); ?></label><br />
			<label><input type="radio" tabindex="0" class="hidden" name="smuac_quote_button_cart_setting" value="enableb2b" <?php checked( 'enableb2b', get_option( 'smuac_quote_button_cart_setting', 'enableb2b' ), true ); ?>"> <?php esc_html_e( 'Enabled for B2B users', 'smuac' ); ?></label><br />
			<label><input type="radio" tabindex="0" class="hidden" name="smuac_quote_button_cart_setting" value="enableall" <?php checked( 'enableall', get_option( 'smuac_quote_button_cart_setting', 'enableb2b' ), true ); ?>"> <?php esc_html_e( 'Enabled for ALL users', 'smuac' ); ?></label><br />

			<p class="description"><?php esc_html_e( 'Control which users can access the "Request a Custom Quote" button in the cart page.', 'smuac' ); ?></p>
		</fieldset>
		<?php
	}

	public function smuac_quotename_setting_content() {
		?>
		<fieldset>
			<label><input type="hidden" name="smuac_quotename_setting" value="0"><input type="checkbox" name="smuac_quotename_setting" value="1" <?php checked( 1, get_option( 'smuac_quotename_setting', 1 ), true ); ?>"> <?php esc_html_e( 'Name', 'smuac' ); ?></label><br />
			<label><input type="hidden" name="smuac_quoteemail_setting" value="0"><input type="checkbox"  name="smuac_quoteemail_setting" value="1" <?php checked( 1, get_option( 'smuac_quoteemail_setting', 1 ), true ); ?>"> <?php esc_html_e( 'Email Address', 'smuac' ); ?></label><br />
			<label><input type="hidden" name="smuac_quotephone_setting" value="0"><input type="checkbox"  name="smuac_quotephone_setting" value="1" <?php checked( 1, get_option( 'smuac_quotephone_setting', 0 ), true ); ?>"> <?php esc_html_e( 'Phone Number', 'smuac' ); ?></label><br />
			<label><input type="hidden" name="smuac_quotemessage_setting" value="0"><input type="checkbox"  name="smuac_quotemessage_setting" value="1" <?php checked( 1, get_option( 'smuac_quotemessage_setting', 1 ), true ); ?>"> <?php esc_html_e( 'Message', 'smuac' ); ?></label><br />
			
			<p class="description"><?php esc_html_e( 'Enable the fields you want in the front-end quote request form.', 'smuac' ); ?></p>
		</fieldset>
		<?php
	}

	public function smuac_enabled_modules_setting_content() {
		?>
		<fieldset>
			<label><input type="hidden" name="smuac_enable_shopping_lists_setting" value="0"><input type="checkbox"  name="smuac_enable_shopping_lists_setting" value="1" <?php checked( 1, get_option( 'smuac_enable_shopping_lists_setting', 1 ), true ); ?>"> <?php esc_html_e( 'Shopping Lists', 'smuac' ); ?></label><br />
			<label><input type="hidden" name="smuac_enable_multiaccounts_setting" value="0"><input type="checkbox"  name="smuac_enable_multiaccounts_setting" value="1" <?php checked( 1, get_option( 'smuac_enable_multiaccounts_setting', 1 ), true ); ?>"> <?php esc_html_e( 'Multiaccounts', 'smuac' ); ?></label><br />
	
			<p class="description"><?php esc_html_e( 'Enable or disable the features you need, based on shop requirements. These items are available in users\' "My Account" panel.', 'smuac' ); ?></p>
		</fieldset>
		<?php
	}

	public function smuac_vat_exemption_different_country_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_vat_exemption_different_country_setting" value="0">
		  <input type="checkbox" name="smuac_vat_exemption_different_country_setting" value="1" ' . checked( 1, get_option( 'smuac_vat_exemption_different_country_setting', 0 ), false ) . '">
		  <label>' . esc_html__( 'Within EU, require delivery country to be different than shop country for VAT exemption.', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_product_visibility_cache_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_product_visibility_cache_setting" value="0">
		  <input type="checkbox" name="smuac_product_visibility_cache_setting" value="1" ' . checked( 1, get_option( 'smuac_product_visibility_cache_setting', 1 ), false ) . '">
		  <label>' . esc_html__( 'Enable visibility cache. Some scenarios such as product translation may require disabling this option.', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_replace_product_selector_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_replace_product_selector_setting" value="0">
		  <input type="checkbox" name="smuac_replace_product_selector_setting" value="1" ' . checked( 1, get_option( 'smuac_replace_product_selector_setting', 0 ), false ) . '">
		  <label>' . esc_html__( 'For large numbers of products, this prevents crashes.', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_hide_users_dynamic_rules_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_hide_users_dynamic_rules_setting" value="0">
		  <input type="checkbox" name="smuac_hide_users_dynamic_rules_setting" value="1" ' . checked( 1, get_option( 'smuac_hide_users_dynamic_rules_setting', 0 ), false ) . '">
		  <label>' . esc_html__( 'For large numbers of users, this prevents crashes.', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_hidden_has_priority_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_hidden_has_priority_setting" value="0">
		  <input type="checkbox" name="smuac_hidden_has_priority_setting" value="1" ' . checked( 1, get_option( 'smuac_hidden_has_priority_setting', 0 ), false ) . '">
		  <label>' . esc_html__( 'Hide products when they belong to at least 1 hidden category.', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_force_permalinks_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_force_permalinks_setting" value="0">
		  <input type="checkbox" name="smuac_force_permalinks_setting" value="1" ' . checked( 1, get_option( 'smuac_force_permalinks_setting', 0 ), false ) . '">
		  <label>' . esc_html__( 'Different My Account URL structure. May solve 404 issues and improve loading speed.', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_force_permalinks_flushing_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_force_permalinks_flushing_setting" value="0">
		  <input type="checkbox" name="smuac_force_permalinks_flushing_setting" value="1" ' . checked( 1, get_option( 'smuac_force_permalinks_flushing_setting', 0 ), false ) . '">
		  <label>' . esc_html__( 'Can solve 404 issues in the My Account page.', 'smuac' ) . '</label>
		</div>
		';
	}



	/* Bundle Settings */


	public function smuac_replace_selector_text_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		  <input type="hidden" name="smuac_replace_selector_text_setting" value="0">
		  <input type="checkbox" name="smuac_replace_selector_text_setting" value="1" ' . checked( 1, get_option( 'smuac_replace_selector_text_setting', 0 ), false ) . '">
		  <label>' . esc_html__( 'Replace product selector with custom text', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_bundles_product_image_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_bundles_product_image_setting" value="0">
		  <input type="checkbox" name="smuac_bundles_product_image_setting" value="1" ' . checked( 1, get_option( 'smuac_bundles_product_image_setting', 1 ), false ) . '">
		  <label>' . esc_html__( 'Show product images in My Account->Bundles in the frontend', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_registration_options_dropdown_setting_content() {
		?>
		<fieldset>
			<label><input type="hidden" name="smuac_registration_options_dropdown_setting" value="0"><input type="checkbox" name="smuac_registration_options_dropdown_setting" value="1" <?php checked( 1, get_option( 'smuac_registration_options_dropdown_setting', 1 ), true ); ?>"> <?php esc_html_e( 'Add B2B options and fields to normal registration (e.g. My Account registration)', 'smuac' ); ?></label><br />
		</fieldset>

		<?php
	}

	public function smuac_integrate_quotes_discussions_setting_content() {
		?>
		<fieldset>
			<label><input type="hidden" name="smuac_integrate_quotes_discussions_setting" value="0"><input type="checkbox" name="smuac_integrate_quotes_discussions_setting" value="1" <?php checked( 1, get_option( 'smuac_integrate_quotes_discussions_setting', 1 ), true ); ?>"> <?php esc_html_e( 'Quote requests start discussions', 'smuac' ); ?></label><br />
					
			<p class="description"><?php esc_html_e( 'Enabling this setting creates a new discussion when quote requests are sent by logged in users. Disabling it simply sends the quote as an email.', 'smuac' ); ?></p>
		</fieldset>
		<?php
	}

	public function smuac_approval_required_all_users_setting_content() {
		?>
		<fieldset>
			<label><input type="hidden" name="smuac_approval_required_all_users_setting" value="0"><input type="checkbox" name="smuac_approval_required_all_users_setting" value="1" <?php checked( 1, get_option( 'smuac_approval_required_all_users_setting', 0 ), true ); ?>"> <?php esc_html_e( 'Manually approve all new registrations.', 'smuac' ); ?></label><br />
					
			<p class="description"><?php esc_html_e( 'This setting affects all new registrations. To control this in more detail, you can disable this option and set approval for each individual role.', 'smuac' ); ?></p>
		</fieldset>
		<?php
	}

	public function smuac_registration_at_checkout_setting_content() {
		?>
		<fieldset>
			<label><input type="hidden" name="smuac_registration_at_checkout_setting" value="0"><input type="checkbox" name="smuac_registration_at_checkout_setting" value="1" <?php checked( 1, get_option( 'smuac_registration_at_checkout_setting', 0 ), true ); ?>"> <?php esc_html_e( 'Add B2B options and fields to checkout registration', 'smuac' ); ?></label><br />
			<p class="description"><?php esc_html_e( 'This option is only for websites that allow registration at checkout.', 'smuac' ); ?></p>
		</fieldset>
		<?php
	}

	public function smuac_validate_vat_button_checkout_setting_content() {
		echo '
		<fieldset>
		<input type="hidden" name="smuac_validate_vat_button_checkout_setting" value="0">
		  <input type="checkbox" name="smuac_validate_vat_button_checkout_setting" value="1" ' . checked( 1, get_option( 'smuac_validate_vat_button_checkout_setting', 0 ), false ) . '">
		  <label>' . esc_html__( 'If VAT Number is provided during checkout / checkout registration, this button validates and applies VAT exemptions.', 'smuac' ) . '</label>
		  <p class="description">' . esc_html__( 'This settings add a "Validate VAT" button at checkout, so guests can also be exempt from tax.', 'smuac' ) . '</p>
		</fieldset>
		';
	}

	public function smuac_keepdata_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_keepdata_setting" value="0">
		  <input type="checkbox" name="smuac_keepdata_setting" value="1" ' . checked( 1, get_option( 'smuac_keepdata_setting', 1 ), false ) . '">
		  <label>' . esc_html__( 'Keep settings and data after uninstall', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_multisite_separate_b2bb2c_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_multisite_separate_b2bb2c_setting" value="0">
		  <input type="checkbox" name="smuac_multisite_separate_b2bb2c_setting" value="1" ' . checked( 1, get_option( 'smuac_multisite_separate_b2bb2c_setting', 0 ), false ) . '">
		  <label>' . esc_html__( 'If you have a multisite and separate B2B and B2C sites, this option will treat B2C users as guests when visiting the B2B site and lock them out.', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_search_by_sku_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_search_by_sku_setting" value="0">
		  <input type="checkbox" name="smuac_search_by_sku_setting" value="1" ' . checked( 1, get_option( 'smuac_search_by_sku_setting', 1 ), false ) . '">
		  <label>' . esc_html__( 'Enable search by SKU in the Bulk Order Form', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_search_product_description_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_search_product_description_setting" value="0">
		  <input type="checkbox" name="smuac_search_product_description_setting" value="1" ' . checked( 1, get_option( 'smuac_search_product_description_setting', 0 ), false ) . '">
		  <label>' . esc_html__( 'Also search product descriptions (slower)', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_search_each_variation_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_search_each_variation_setting" value="0">
		  <input type="checkbox" name="smuac_search_each_variation_setting" value="1" ' . checked( 1, get_option( 'smuac_search_each_variation_setting', 1 ), false ) . '">
		  <label>' . esc_html__( 'Enable individual SKU/name search for each variation (slower)', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_show_accounting_subtotals_setting_content() {
		echo '
		<div class="ui toggle checkbox">
		<input type="hidden" name="smuac_show_accounting_subtotals_setting" value="0">
		  <input type="checkbox" name="smuac_show_accounting_subtotals_setting" value="1" ' . checked( 1, get_option( 'smuac_show_accounting_subtotals_setting', 0 ), false ) . '">
		  <label>' . esc_html__( 'Accurate price display based on store settings (slower)', 'smuac' ) . '</label>
		</div>
		';
	}

	public function smuac_hide_prices_guests_text_setting_content() {
		echo '<input type="text" name="smuac_hide_prices_guests_text_setting" value="' . esc_attr( get_option( 'smuac_hide_prices_guests_text_setting', esc_html__( 'Login to view prices', 'smuac' ) ) ) . '">
			<p class="description">' . esc_html__( 'What guests see when "Hide prices" is enabled.', 'smuac' ) . '</p>';
	}

	public function smuac_hide_b2b_site_text_setting_content() {
		echo '<input type="text" name="smuac_hide_b2b_site_text_setting" value="' . esc_attr( get_option( 'smuac_hide_b2b_site_text_setting', esc_html__( 'Please login to access the B2B Portal.', 'smuac' ) ) ) . '">
				<p class="description">' . esc_html__( 'What guests see when "Hide Shop & Products" is enabled.', 'smuac' ) . '</p>';
	}

	public function smuac_hidden_price_dynamic_rule_text_setting_content() {
		echo '<input type="text" name="smuac_hidden_price_dynamic_rule_text_setting" value="' . esc_attr( get_option( 'smuac_hidden_price_dynamic_rule_text_setting', esc_html__( 'Price is unavailable', 'smuac' ) ) ) . '">
				<p class="description">' . esc_html__( 'What users see when "Hidden Price" dynamic rules apply.', 'smuac' ) . '</p>';
	}

	public function smuac_color_setting_content() {
		?>
		<input name="smuac_color_setting" type="color" value="<?php echo esc_attr( get_option( 'smuac_color_setting', '#94678b' ) ); ?>">
		<?php
	}

	public function smuac_colorhover_setting_content() {
		?>
		<input name="smuac_colorhover_setting" type="color" value="<?php echo esc_attr( get_option( 'smuac_colorhover_setting', '#904d82' ) ); ?>">
		<?php
	}


	public function smuac_shopping_lists_language_setting_content() {
		?>
		<select name="smuac_shopping_lists_language_setting">
			<option value="English" <?php selected( 'English', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'English', 'smuac' ); ?></option>
			<option value="Afrikaans" <?php selected( 'Afrikaans', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Afrikaans', 'smuac' ); ?></option>
			<option value="Albanian" <?php selected( 'Albanian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Albanian', 'smuac' ); ?></option>
			<option value="Arabic" <?php selected( 'Arabic', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Arabic', 'smuac' ); ?></option>
			<option value="Armenian" <?php selected( 'Armenian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Armenian', 'smuac' ); ?></option>
			<option value="Azerbaijan" <?php selected( 'Azerbaijan', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Azerbaijan', 'smuac' ); ?></option>
			<option value="Bangla" <?php selected( 'Bangla', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Bangla', 'smuac' ); ?></option>
			<option value="Basque" <?php selected( 'Basque', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Basque', 'smuac' ); ?></option>
			<option value="Belarusian" <?php selected( 'Belarusian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Belarusian', 'smuac' ); ?></option>
			<option value="Bulgarian" <?php selected( 'Bulgarian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Bulgarian', 'smuac' ); ?></option>
			<option value="Catalan" <?php selected( 'Catalan', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Catalan', 'smuac' ); ?></option>
			<option value="Chinese" <?php selected( 'Chinese', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Chinese', 'smuac' ); ?></option>
			<option value="Chinese Traditional" <?php selected( 'Chinese Traditional', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Chinese Traditional', 'smuac' ); ?></option>
			<option value="Croatian" <?php selected( 'Croatian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Croatian', 'smuac' ); ?></option>
			<option value="Czech" <?php selected( 'Czech', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Czech', 'smuac' ); ?></option>
			<option value="Danish" <?php selected( 'Danish', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Danish', 'smuac' ); ?></option>
			<option value="Dutch" <?php selected( 'Dutch', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Dutch', 'smuac' ); ?></option>
			<option value="Estonian" <?php selected( 'Estonian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Estonian', 'smuac' ); ?></option>
			<option value="Filipino" <?php selected( 'Filipino', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Filipino', 'smuac' ); ?></option>
			<option value="Finnish" <?php selected( 'Finnish', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Finnish', 'smuac' ); ?></option>
			<option value="French" <?php selected( 'French', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'French', 'smuac' ); ?></option>
			<option value="Galician" <?php selected( 'Galician', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Galician', 'smuac' ); ?></option>
			<option value="Georgian" <?php selected( 'Georgian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Georgian', 'smuac' ); ?></option>
			<option value="German" <?php selected( 'German', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'German', 'smuac' ); ?></option>
			<option value="Greek" <?php selected( 'Greek', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Greek', 'smuac' ); ?></option>
			<option value="Hebrew" <?php selected( 'Hebrew', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Hebrew', 'smuac' ); ?></option>
			<option value="Hindi" <?php selected( 'Hindi', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Hindi', 'smuac' ); ?></option>
			<option value="Hungarian" <?php selected( 'Hungarian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Hungarian', 'smuac' ); ?></option>
			<option value="Icelandic" <?php selected( 'Icelandic', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Icelandic', 'smuac' ); ?></option>
			<option value="Indonesian" <?php selected( 'Indonesian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Indonesian', 'smuac' ); ?></option>
			<option value="Italian" <?php selected( 'Italian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Italian', 'smuac' ); ?></option>
			<option value="Japanese" <?php selected( 'Japanese', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Japanese', 'smuac' ); ?></option>
			<option value="Kazakh" <?php selected( 'Kazakh', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Kazakh', 'smuac' ); ?></option>
			<option value="Korean" <?php selected( 'Korean', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Korean', 'smuac' ); ?></option>
			<option value="Kyrgyz" <?php selected( 'Kyrgyz', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Kyrgyz', 'smuac' ); ?></option>
			<option value="Latvian" <?php selected( 'Latvian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Latvian', 'smuac' ); ?></option>
			<option value="Lithuanian" <?php selected( 'Lithuanian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Lithuanian', 'smuac' ); ?></option>
			<option value="Macedonian" <?php selected( 'Macedonian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Macedonian', 'smuac' ); ?></option>
			<option value="Malay" <?php selected( 'Malay', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Malay', 'smuac' ); ?></option>
			<option value="Mongolian" <?php selected( 'Mongolian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Mongolian', 'smuac' ); ?></option>
			<option value="Nepali" <?php selected( 'Nepali', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Nepali', 'smuac' ); ?></option>
			<option value="Norwegian" <?php selected( 'Norwegian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Norwegian', 'smuac' ); ?></option>
			<option value="Polish" <?php selected( 'Polish', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Polish', 'smuac' ); ?></option>
			<option value="Portuguese" <?php selected( 'Portuguese', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Portuguese', 'smuac' ); ?></option>
			<option value="Romanian" <?php selected( 'Romanian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Romanian', 'smuac' ); ?></option>
			<option value="Russian" <?php selected( 'Russian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Russian', 'smuac' ); ?></option>
			<option value="Serbia" <?php selected( 'Serbia', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Serbia', 'smuac' ); ?></option>
			<option value="Slovak" <?php selected( 'Slovak', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Slovak', 'smuac' ); ?></option>
			<option value="Slovenian" <?php selected( 'Slovenian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Slovenian', 'smuac' ); ?></option>
			<option value="Spanish" <?php selected( 'Spanish', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Spanish', 'smuac' ); ?></option>
			<option value="Swedish" <?php selected( 'Swedish', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Swedish', 'smuac' ); ?></option>
			<option value="Thai" <?php selected( 'Thai', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Thai', 'smuac' ); ?></option>
			<option value="Turkish" <?php selected( 'Turkish', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Turkish', 'smuac' ); ?></option>
			<option value="Ukrainian" <?php selected( 'Ukrainian', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Ukrainian', 'smuac' ); ?></option>
			<option value="Uzbek" <?php selected( 'Uzbek', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Uzbek', 'smuac' ); ?></option>
			<option value="Vietnamese" <?php selected( 'Vietnamese', get_option( 'smuac_shopping_lists_language_setting', 'English' ), true ); ?>><?php esc_html_e( 'Vietnamese', 'smuac' ); ?></option>
		</select>
		<?php
	}



	public function render_settings_page_content() {
		?>

			<div class="wrap">
			  
				<h2><?php esc_html_e( 'Subaccounts & Multi-User Accounts ', 'smuac' ); ?></h2>
				<?php settings_errors(); ?>
				  
				<?php
				if ( isset( $_GET['tab'] ) ) {
					$active_tab = sanitize_text_field( $_GET['tab'] );
				} else {
					$active_tab = 'mainsettings';
				}
				?>
				  
				<h2 class="nav-tab-wrapper">
					<a href="?page=smuac&tab=mainsettings" class="nav-tab <?php echo 'mainsettings' === $active_tab ? 'nav-tab-active' : ''; ?>"><?php esc_html_e( 'Settings', 'smuac' ); ?></a>
				</h2>

				<form id="smuac_admin_form" method="POST" action="options.php">
					<?php settings_fields( 'smuac' ); ?>

					<div id="smuac_admin_wrapper" >
		 
						<!-- Admin Menu Tabs Content--> 
						<div id="smuac_tabs_wrapper">

							<!-- Main Settings Tab--> 
							<?php
							if ( 'mainsettings' === $active_tab ) {
								?>
									<h3>
										<?php esc_html_e( 'Enable / Disable Modules', 'smuac' ); ?>
									</h3>
									<table class="form-table">
										<?php do_settings_fields( 'smuac', 'smuac_enable_features_settings_section' ); ?>
									</table>
									<br />
									<h3 class="ui block header">
										<i class="list alternate icon"></i>
										<?php esc_html_e( 'Shopping Lists Language', 'smuac' ); ?>
									</h3>
									<table class="form-table">
										<?php do_settings_fields( 'smuac', 'smuac_languagesettings_purchaselists_section' ); ?>
									</table>
									<h3>
										<?php esc_html_e( 'Color & Design', 'smuac' ); ?>
									</h3>
									<table class="form-table">
										<?php do_settings_fields( 'smuac', 'smuac_othersettings_colordesign_section' ); ?>
									</table>
									<h3>
										<?php esc_html_e( 'URLs & Permalinks', 'smuac' ); ?>
									</h3>
									<table class="form-table">
										<?php do_settings_fields( 'smuac', 'smuac_othersettings_permalinks_section' ); ?>
									</table>
									<h3>
										<?php esc_html_e( 'User Editor', 'smuac' ); ?>
									</h3>
									<table class="form-table">
										<tbody>
											<tr>
												<th scope="row"><?php esc_html_e( 'Set Users as Subaccounts', 'smuac' ); ?></th>
												<td>
													<div id="smuac_tools_setusermultiaccounts">
														<div class="smuac_user_settings_container_column_title_multiaccounts">
															<i class="user plus icon smuac_multiaccountplusicon"></i>

														</div>
														<input class="smuac_set_user_multiaccounts_input" type="text" placeholder="<?php esc_html_e( 'Enter user ids (e.g. 12,15,19)', 'smuac' ); ?>" id="smuac_set_user_multiaccounts_first" >
														<input class="smuac_set_user_multiaccounts_input" type="text" placeholder="<?php esc_html_e( 'Enter parent account id (e.g. 23)', 'smuac' ); ?>" id="smuac_set_user_multiaccounts_second" >
														
														  <div id="smuac_set_accounts_as_multiaccounts" class="ui teal button">
															  <i class="user plus icon"></i> 
															<?php esc_html_e( 'Set accounts as subaccounts of parent', 'smuac' ); ?>
														  </div>
														
													</div>
												</td>
											</tr><tr>
													<th scope="row"><?php esc_html_e( 'Turn Subaccounts into Regular Accounts:', 'smuac' ); ?></th>
													<td>
														<div class="smuac_user_settings_container_column_title_multiaccounts">
																  <i class="user outline icon smuac_multiaccountplusicon"></i>

															  </div>
															  <input class="smuac_set_user_multiaccounts_input" type="text" placeholder="<?php esc_html_e( 'Enter user ids (e.g. 12,15,19)', 'smuac' ); ?>" id="smuac_set_multiaccounts_regular_input" >
														
																<div id="smuac_set_multiaccounts_regular_button" class="ui teal button">
																	<i class="user outline icon"></i> 
																<?php esc_html_e( 'Set accounts', 'smuac' ); ?>
																</div>
													</td>

																			
											</tr> 


										</tbody>
									</table>
									<h3>
										<?php esc_html_e( 'Uninstall', 'smuac' ); ?>
									</h3>
									<table class="form-table">
										<?php do_settings_fields( 'smuac', 'smuac_othersettings_section' ); ?>
									</table>

								<?php

							}
							?>
						</div>
					</div>

					<br>
					<input type="submit" name="submit" id="smuac-admin-submit" class="ui primary button" value="Save Settings">
				</form>
			</div>

			<?php
	}
}
