/**
 *
 * JavaScript file that has global action in the admin menu
 */
(function($){

	"use strict";

	$( document ).ready(
		function() {

			// Initialize Color Picker
			$( 'input[name=smuac_color_setting], input[name=smuac_colorhover_setting]' ).wpColorPicker();

			// Tools
			// On clicking set accounts as multiaccounts
			$( '#smuac_set_accounts_as_multiaccounts' ).on(
				'click',
				function(){
					if (confirm( smuac.are_you_sure_set_multiaccounts )) {
						var datavar = {
							action: 'smuacbulksetmultiaccounts',
							security: smuac.security,
							option_first: $( '#smuac_set_user_multiaccounts_first' ).val(),
							option_second: $( '#smuac_set_user_multiaccounts_second' ).val(),
						};

						$.post(
							ajaxurl,
							datavar,
							function(response){
								alert( smuac.multiaccounts_have_been_set );
								location.reload();
							}
						);
					}
				}
			);
			// On clicking set accounts as regular accounts
			$( '#smuac_set_multiaccounts_regular_button' ).on(
				'click',
				function(){
					if (confirm( smuac.are_you_sure_set_multiaccounts_regular )) {
						var datavar = {
							action: 'smuacbulksetmultiaccountsregular',
							security: smuac.security,
							option_first: $( '#smuac_set_multiaccounts_regular_input' ).val(),
						};

						$.post(
							ajaxurl,
							datavar,
							function(response){
								alert( smuac.multiaccounts_have_been_set );
								location.reload();
							}
						);
					}
				}
			);

		}
	);

})( jQuery );
