<?php
/*************************************************************************************************************
file ssp-update.php is a part of Simple Live Press and contains proprietary code - simplesocialpress.com
*************************************************************************************************************/


/************************************
* the code below is just a standard
* options page. Substitute with 
* your own.
*************************************/

function edd_sspress_license_menu() {
	
    add_submenu_page( 'ssp-settings', 'Simple Social Press', 'License', 'manage_options', 'ssp-license', 'edd_sspress_license_page'); 
}
add_action('admin_menu', 'edd_sspress_license_menu');

function edd_sspress_license_page() {
	$license_key 	= get_option( 'edd_sspress_license_key' );
    $status 	= get_option( 'sspress_ls' );
    
    
	$check_expiry = array(
			'edd_action' 	=> 'check_license',
			'license' 	=> $license_key,
			'item_name' => urlencode( SSPRESS_ITEM_NAME ),
			'url' 	=> get_site_url()
		);
			$response = wp_remote_post( SSPRESS_STORE_URL, array( 'timeout' => 60, 'body' => $check_expiry ) );
            $update_data = json_decode( wp_remote_retrieve_body( $response ) );
			if (isset($update_data->expires)) {
                $expiry = $update_data->expires; 
                if ($expiry !== 'lifetime')
					$expiry = date('M d, Y', strtotime( $expiry));
                else 
                    $expiry = 'never (lifetime)';
            }
			if (isset($update_data->license_limit))
                $license_limit = $update_data->license_limit; 
			if (isset($update_data->activations_left))
                $activations_left = $update_data->activations_left;
		    if (isset($update_data->license))
                $license = $update_data->license;

	?>
	<div class="wrap">
		<h2><?php _e('Simple Social Press License Activator'); ?></h2>
		<form method="post" action="options.php">
		
			<?php settings_fields('edd_sspress_license'); ?>
			
			<table class="form-table">
				<tbody>
					<tr valign="top">	
						<th scope="row" valign="top">
							<?php _e('License Key'); ?>
						</th>
							<td>
								<?php if( $status !== false && $license == 'valid' ) { ?>
							<input id="edd_sspress_license_key" name="edd_sspress_license_key" type="text" class="regular-text" disabled value="<?php esc_attr_e( $license_key ); ?>" />
								<?php }else if ($license == 'expired'){ ?>
							<input id="edd_sspress_license_key" name="edd_sspress_license_key" type="text" class="regular-text" value="<?php esc_attr_e( $license_key ); ?>" />
								<?php }else{ ?>
							<input id="edd_sspress_license_key" name="edd_sspress_license_key" type="text" class="regular-text" value="<?php esc_attr_e( $license_key ); ?>" />
								<?php } ?>
							<label class="description" for="edd_sspress_license_key"><?php _e('Enter your license key'); ?></label>
								<br>
								<?php if( $status !== false && $license == 'valid' ) { ?>
									<span style="color:green;"><i><?php _e('License key is active. Expires ' . $expiry . '. You have ' . $activations_left . '/' . $license_limit . ' activations left.'); ?></i></span>
								<?php }else if ($license == 'expired'){ ?>
									<span style="color:red;"><i><?php _e('License key expired on '.$expiry); ?> <a href="https://simplepodcastpress.com/checkout/?edd_license_key=<?php echo $license_key;?>&download_id=8252" target="_blank">Click here to renew it. </a></i></span>
								<?php }else { ?>
									<span style="color:red;"><i><?php _e('Inactive or invalid license.'); ?></i></span>
								<?php } ?>
						</td>
					</tr>
					<?php if( false !== $license ) { ?>
						<tr valign="top">	
							<th scope="row" valign="top">
								<?php _e('Activate License'); ?>
							</th>
							<td>
								<?php if( $status !== false && $license == 'valid' ) { ?>
									<?php wp_nonce_field( 'edd_sspress_nonce', 'edd_sspress_nonce' ); ?>
										<input type="submit" class="button-secondary" name="ssp_edd_license_deactivate" value="<?php _e('Deactivate License'); ?>"/>
								<?php } else {
									wp_nonce_field( 'edd_sspress_nonce', 'edd_sspress_nonce' ); ?>
										 <input type="submit" class="button-secondary" name="ssp_edd_license_activate" value="<?php _e('Activate License'); ?>"/>
								<?php } ?>
							</td>
						</tr>
					<?php } ?>
				</tbody>
			</table>	
		
		</form>
	<?php
}

function edd_sspress_register_option() {
	// creates our settings in the options table
	register_setting('edd_sspress_license', 'edd_sspress_license_key', 'edd_sspress_sanitize_license' );
}
add_action('admin_init', 'edd_sspress_register_option');

function edd_sspress_sanitize_license( $new ) {
	$old = get_option( 'edd_sspress_license_key' );
	if( $old && $old != $new ) {
		delete_option( 'sspress_ls' ); // new license has been entered, so must reactivate
	}
	return $new;
}



/************************************
* this illustrates how to activate 
* a license key
*************************************/

function edd_sspress_activate_license() {
// listen for our activate button to be clicked
	if( isset( $_POST['ssp_edd_license_activate'] ) ) {

		// run a quick security check 
	 	if( ! check_admin_referer( 'edd_sspress_nonce', 'edd_sspress_nonce' ) )
			return; // get out if we didn't click the Activate button
		
		 $license_post = $_POST['edd_sspress_license_key']; 

		
		 update_option( 'edd_sspress_license_key', $license_post );
		// retrieve the license from the database
		$license = trim( get_option( 'edd_sspress_license_key' ) );
			

		// data to send in our API request
		$api_params = array( 
			'edd_action'=> 'activate_license', 
			'license' 	=> $license, 
			'item_name' => urlencode( SSPRESS_ITEM_NAME ), // the name of our product in EDD
			'url'       => urlencode(home_url())
		);
		
		
		//update_option ('lic_check_response_fail', TRUE);

		// Call the custom API.
		$response = wp_remote_get( add_query_arg( $api_params, esc_url_raw(SSPRESS_STORE_URL) ), array( 'timeout' => 15, 'sslverify' => false ) );
		update_option ('lic_check_response_fail', $response);

		// make sure the response came back okay
		if ( is_wp_error( $response ) ) {
			return false;
		}

		// decode the license data
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		// $license_data->license will be either "valid" or "invalid"
		update_option( 'sspress_ls', $license_data->license );

	}
	
	/*

	// listen for our activate button to be clicked
	if( isset( $_POST['ssp_edd_license_activate'] ) ) {

		// run a quick security check 
	 	if( ! check_admin_referer( 'edd_sspress_nonce', 'edd_sspress_nonce' ) )
			return; // get out if we didn't click the Activate button
		
	


		// retrieve the license from the database
		$license = trim( get_option( 'edd_sspress_license_key' ) );
			

		// data to send in our API request
		$api_params = array( 
			'edd_action'=> 'activate_license', 
			'license' 	=> $license, 
			'item_name' => urlencode( SSPRESS_ITEM_NAME ), // the name of our product in EDD
			'url'       => urlencode(home_url())
		);
		

		
		//update_option ('lic_check_response_fail', TRUE);

		// Call the custom API.
		$response = wp_remote_get( add_query_arg( $api_params, esc_url_raw(SSPRESS_STORE_URL) ), array( 'timeout' => 15, 'sslverify' => false ) );
		update_option ('lic_check_response_fail', $response);

		// make sure the response came back okay
		if ( is_wp_error( $response ) ) {
			return false;
		}

		// decode the license data
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		
		// $license_data->license will be either "valid" or "invalid"
		update_option( 'sspress_ls', $license_data->license );

	}
*/
}
add_action('admin_init', 'edd_sspress_activate_license');


/***********************************************
* Illustrates how to deactivate a license key.
* This will decrease the site count
***********************************************/

function edd_sspress_deactivate_license() {

	// listen for our activate button to be clicked
	if( isset( $_POST['ssp_edd_license_deactivate'] ) ) {

		// run a quick security check 
	 	if( ! check_admin_referer( 'edd_sspress_nonce', 'edd_sspress_nonce' ) ) 	
			return; // get out if we didn't click the Activate button

		// retrieve the license from the database
		$license = trim( get_option( 'edd_sspress_license_key' ) );
			

		// data to send in our API request
		$api_params = array( 
			'edd_action'=> 'deactivate_license', 
			'license' 	=> $license, 
			'item_name' => urlencode( SSPRESS_ITEM_NAME ), // the name of our product in EDD
			'url'       => urlencode(home_url())
		);
		

		// Call the custom API.
		$response = wp_remote_get( add_query_arg( $api_params, esc_url_raw(SSPRESS_STORE_URL) ), array( 'timeout' => 15, 'sslverify' => false ) );

		// make sure the response came back okay
		if ( is_wp_error( $response ) )
			return false;

		// decode the license data
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		
		// $license_data->license will be either "deactivated" or "failed"
		if( $license_data->license == 'deactivated' )
			delete_option( 'sspress_ls' );

	}
}
add_action('admin_init', 'edd_sspress_deactivate_license');


/************************************
* this illustrates how to check if 
* a license key is still valid
* the updater does this for you,
* so this is only needed if you
* want to do something custom
*************************************/

function edd_sspress_check_license() {

	

	global $wp_version;

	$license = trim( get_option( 'edd_sspress_license_key' ) );
		
	$api_params = array( 
		'edd_action' => 'check_license', 
		'license' => $license, 
		'item_name' => urlencode( SSPRESS_ITEM_NAME ),
		'url'       => urlencode(home_url())
		
	);

 

	// Call the custom API.
	$response = wp_remote_get( add_query_arg( $api_params, esc_url_raw(SSPRESS_STORE_URL) ), array( 'timeout' => 15, 'sslverify' => false ) );


	if ( is_wp_error( $response ) )
		return false;

	$license_data = json_decode( wp_remote_retrieve_body( $response ) );

	if( $license_data->license == 'valid' ) {
		echo 'valid'; exit;
		// this license is still valid
	} else {
		echo 'invalid'; exit;
		// this license is no longer valid
	}

}