<?php
//delete_option( 'ssp_settings' );
/*************************************************************************************************************
file sbp.php is a part of Simple Social Press and contains proprietary code - simplesocialpress.com
*************************************************************************************************************/
class wp_simplesocialpress{

function  __construct(){
			
            global $sbp_db_version;
            $sbp_db_version = "1.2";
            global $sbpress_current_version;
            $sbpress_current_version = SSPRESS_PLUGIN_VERSION;
     
            // Live
            define( 'SSPFAI', '1718153538427977');
            define ('SSPFAS', '0a354af13b45f0423bd5c28a374d0c51');
            define ('SSPFAIS', '1718153538427977|53120f0b8b835c43abb2694724b4cd0f');
            define ('FB_API_VER', 'v6.0');
            define ('SSP_CHANNEL', 'fb');
            define( 'SSPRESS_PLUGIN_URL', plugins_url() . '/simple-social-press');
    
            define('SRT_STATE_SUBNUMBER', 0);
            define('SRT_STATE_TIME',      1);
            define('SRT_STATE_TEXT',      2);
            define('SRT_STATE_BLANK',     3);
			
            @ini_set('max_execution_time', 300);
            //define('WP_MEMORY_LIMIT', '64M');
            if(!session_id()) {
                //session_start();
                session_start(['read_and_close' => true ]);
            }

                        
            //$disable_url_shortner = get_option('sbp_disable_url_shortner');
            
            if ( is_admin() ) {    
            
                  add_action('admin_menu',array($this,'sbp_admin_menu'));
                  add_action("wp_ajax_save_ssp_settings", array( $this, "sbp_save_blab_settings" ));
                  add_action( 'admin_enqueue_scripts', array( $this, 'register_sbp_admin_scripts' ) );
                  // Actions to take when plugin is updated
                  add_action( 'admin_init', array( $this, 'sbp_plugin_update'), 1 );
                  
                     
                  add_action('auto-draft_to_publish', array($this,'sbp_preserve_draft_date'), 10, 1);
                  add_action('draft_to_publish', array($this,'sbp_preserve_draft_date'), 10, 1);
                  add_action('draft_to_private', array($this,'sbp_preserve_draft_date'), 10, 1);
                  add_action('draft_to_pending', array($this,'sbp_preserve_draft_date'), 10, 1);
                  

			      //add_action('transition_post_status', array($this,'sbp_preserve_draft_date_save'), 10, 3);
                
                
                  //add_action('wp_dashboard_setup', array($this,'reviews_dashboard_widgets'));
                  //add_action( 'publish_post', array($this, 'manual_sbp_action'), 10, 1 ); 
			      //add_action( 'save_post', array($this, 'manual_sbp_action'), 1, 1 ); 
                
                  // Add button plugin to TinyMCE
				  add_action('init', array($this, 'tinymce_button'),1);
				  add_filter( 'content_save_pre' , array($this, 'ssp_shortcode_save') , 10, 1);

				  //Add Custom Simple Social Press MetaBoxes
                  add_action( "add_meta_boxes", array( $this, "ssp_metaboxes" ) );
                  add_action( 'save_post',  array( $this, "ssp_metabox_save" ) );


				  add_filter( 'option_default_post_format', array($this, 'ssp_default_post_format'));
            }
              
            else {

                  // Add shortcode support in widgets
                  //add_filter('widget_text', 'do_shortcode', 11);
                  
                  // Force player on home page
                  $sp_settings = get_option('ssp_settings');     
                  $sbp_force_player_home = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_force_player_home']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_force_player_home'] : '';
                  
                  if ($sbp_force_player_home)
                        add_filter('the_excerpt', array($this,'sbp_the_content'));
                  
                  
                  // set priority to 9 so it won't conflict with other plugins
                  add_filter('the_content', array($this, 'sbp_the_content'));
                  add_action( "wp_head", array( $this, "sbp_open_graph" ),10,1 );

            }
            

            // Set cron
            add_action('simplesocialpress_fetch',array($this,'sbp_generate_post_with_cron'));
                
            if( !wp_next_scheduled( 'simplesocialpress_fetch' ) ) {
			        wp_schedule_event( time() + 60, 'hourly', 'simplesocialpress_fetch' ); 
			      }

            add_action('simplesocialpress_comments',array($this,'generate_comments_from_sbp_table'));
			    
            if( !wp_next_scheduled( 'simplesocialpress_comments' ) ) {
			        wp_schedule_event( time(), 'daily', 'simplesocialpress_comments' ); 
            }
            
            add_action('simplesocialpress_token_expire_cron',array($this,'simplesocialpress_token_expire_cron_fn'));
			    
            if( !wp_next_scheduled( 'simplesocialpress_token_expire_cron' ) ) {
			        wp_schedule_event( time(), 'daily', 'simplesocialpress_token_expire_cron' ); 
			      }
            require_once("incl/custom-fields-gutenberg/ssp-custom-fields-display.php");         
            require_once( "updater/ssp-update.php" );
            //require_once("draftnotify/draft-notify.php");
			//require_once("widget/sbp-widget.php");
      require_once ("responsive_player/responsive-player.php");
      $check_if_expire = get_option('sfp_access_token');
      if (empty($check_if_expire)){
        add_action('admin_notices',array($this,'general_admin_notice'));
      }
     //echo $this->get_fb_access_token_expiry();
     //print_r(get_option('sfp_res4')); exit;
            //require_once("tools/Facebook/autoload.php");

}//end constructor function.
function ssp_shortcode_save( $content ) {
			global $post;
			if (preg_match_all('/(.?)\[(ssp-video)\b(.*?)(?:(\/))?\](?:(.+?)\[\/\2\])?(.?)/s', $content, $matches)){
					$pattern = get_shortcode_regex();
					preg_match_all('/(.?)\[(ssp-video)\b(.*?)(?:(\/))?\](?:(.+?)\[\/\2\])?(.?)/s', $content, $matches);
					$id = $matches[3][0]; 
					$id = str_replace('id=','',$id);
					$id = str_replace('\'','',$id);
					$id = str_replace('"','',$id);
          $stream_id = stripslashes (  $id );
          if (!get_post_meta( $post->ID, '_fb_videoid', true ))
					    add_post_meta( $post->ID, '_fb_videoid', $stream_id, true ) || update_post_meta($post->ID, '_fb_videoid', $stream_id);

			}
		return $content;
}

function ssp_default_post_format( $format )
{
	  global $post_type;
      $sp_settings = get_option('ssp_settings');
      $ssp_post_type = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_cpt_select']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_cpt_select'] : '';
	  $ssp_post_format = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_post_format_select']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_post_format_select'] : '';
	  return ( $post_type ==$ssp_post_type ? $ssp_post_format  : $format );
}
function ssp_metaboxes() {
			add_meta_box( 'ssp_button6', 'SSP Custom Button', array($this,'ssp_setting_metabox_fn'), 'post', 'normal', 'high' );
}

function  ssp_setting_metabox_fn ($post){
		$ssp_btn_custom_name = get_post_meta( $post->ID, '_ssp_btn_custom_name', true );
		$ssp_btn_custom_url = get_post_meta( $post->ID, '_ssp_btn_custom_url', true );
?>
			<div class="well well-1" style="padding-top: 0px;">
					<div class="row-fluid row-fluid-4" >
								<h3 style="margin-top:0px" padding-top:0px"> <small>This will override the existing Custom Button 6</small> </h3>
								<span class="span4" style="height: auto ! important; margin-left:0px;">
									<input type="text" name="_ssp_btn_custom_name" id="ssp_btn_custom_name" style="width:220px" value="<?php echo $ssp_btn_custom_name; ?>" placeholder="Button Name ..." >
								</span>
								<span class="span3"  style="height: auto ! important; width: 19%;">
									<input type="text" name="_ssp_btn_custom_url" id="ssp_btn_custom_url" style="width:250px" value="<?php echo $ssp_btn_custom_url; ?>" placeholder="Enter Button URL ..." >
								</span>
					 </div>
			</div>
<?php
}

function ssp_metabox_save( $post_id )
		{
            // Bail if we're doing an auto save
			if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
			
			// if our current user can't edit this post, bail
			if( !current_user_can( 'edit_posts' ) ) return;
			
	 	if (isset($_POST["_ssp_btn_custom_name"])) {
              $ssp_btn_custom_name = $_POST["_ssp_btn_custom_name"];
              update_post_meta( $post_id,'_ssp_btn_custom_name', $ssp_btn_custom_name);
        }
	 	if (isset($_POST["_ssp_btn_custom_url"])) {
              $ssp_btn_custom_url = $_POST["_ssp_btn_custom_url"];
              update_post_meta( $post_id,'_ssp_btn_custom_url', $ssp_btn_custom_url);
        }
}

function tinymce_register_button($buttons) {
		   array_push($buttons, "|", "sspfbvideo");
		   array_push($buttons, "", "sspfblivevideo");		   
		   return $buttons;
}

function tinymce_register_plugin($plugin_array) {
		   $plugin_array['sspfbvideo'] = plugins_url( '/responsive_player/js/sspfbvideo.js', __FILE__);
		   $plugin_array['sspfblivevideo'] = plugins_url( '/responsive_player/js/sspfblivevideo.js', __FILE__);
		   return $plugin_array;
}
      
function tinymce_button() {
			
      if (!current_user_can('edit_posts') && !current_user_can('edit_pages')) {
          return;
      }

      if (get_user_option('rich_editing') == 'true') {
          add_filter('mce_external_plugins', array($this, 'tinymce_register_plugin'));
          add_filter('mce_buttons', array($this, 'tinymce_register_button'));
      }
			
}

      
function get_excerpt_by_id($post_id){
      $contentpost = get_post($post_id);
      $postcontent = strip_shortcodes($contentpost->post_content);
      $postcontent = str_replace("&nbsp;","", $postcontent);
      $postcontent = preg_replace("/[\r\n]+/", "\n", $postcontent);
	  $postcontent = preg_replace("/\s+/", ' ', $postcontent);
      $postcontent = html_entity_decode(strip_tags($postcontent));
      $postcontent = substr(esc_attr($postcontent), 0, 500);
      return $postcontent;
}
  
function sbp_open_graph(){

      $sbpogp = false;
      $sp_settings = get_option('ssp_settings');     
      $disable_opengraph = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_disable_opengraph']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_disable_opengraph'] : '';
            
      $post_id = get_the_ID();
      $sbpogp = get_post_meta($post_id, 'SSP_OGP', true);
      
      // Legacy for verison 1.0
      if (!$sbpogp)
            $sbpogp = get_post_meta($post_id, 'SBP_OGP', true);     
      
      if (!$disable_opengraph AND is_single() AND $sbpogp) {

          if ( has_post_thumbnail($post_id) )
            $sbpogp["image"] = wp_get_attachment_url( get_post_thumbnail_id($post_id) );
            
          $sbpogpDesc = $this->get_excerpt_by_id( $post_id );
          //$sbpogpDesc = get_post_field('post_content', $post_id);  
          print( PHP_EOL.PHP_EOL."<!-- Simple Social Press Open Graph Meta -->".PHP_EOL );
         
          print( "<meta property='og:site_name' content='".get_bloginfo("site_name")."'/>".PHP_EOL );
          print( "<meta property='og:type' content='website' />".PHP_EOL );
          print( "<meta property='og:title' content='".get_the_title( $post_id )."'/>".PHP_EOL );
          print( "<meta property='og:description' content='".$sbpogpDesc."'/>".PHP_EOL );
          if (isset($sbpogp["image"])) {
                print( "<meta property='og:image' content='".$sbpogp["image"]."'/>".PHP_EOL );
                print( "<meta property='og:image:type' content='image/jpeg' />".PHP_EOL );
          }
          /* 
		  print( "<meta property='og:video:url' content='".$sbpogp["video"]."'/>".PHP_EOL );
          print( "<meta property='og:video:secure_url' content='".$sbpogp["video"]."'/>".PHP_EOL );
          print( "<meta property='og:video:type' content='video/mp4' />".PHP_EOL );
          print( "<meta property='og:video:width' content='640' />".PHP_EOL );
          print( "<meta property='og:video:height' content='385' />".PHP_EOL );
		  */
          print( "<meta property='og:url' content='".get_permalink( $post_id)."'/>".PHP_EOL );
          print( "<!-- END of Simple Social Press Open Graph Meta -->".PHP_EOL.PHP_EOL );
      }
}
function ssp_ts_callback($m)
{
    return empty($m[1]) ? '[ssp-timestamp time="' . $m[0] . '"]' : $m[0];
}
function sbp_the_content($content){
  
      global $post;
      $html = '';
      $hide_email = '';
      $duration = '';
      if (!get_post_meta($post->ID, '_fb_videoid', true)){
        return $content;
      }
      $stream_id =  get_post_meta( $post->ID, '_fb_videoid', true );  

      $sp_settings = get_option('ssp_settings'); 
      
      
      //Turn editor auto format off
      //$wpautop_on = has_filter('the_content', 'wpautop');
      //if ($wpautop_on) {
      //      remove_filter( 'the_content', 'wpautop' );
      //}
      
    // Problem: If the_excerpt is used instead of the_content, both the_exerpt and the_content will be called here.
	// Important to note, get_the_excerpt will be called before the_content is called, so we add a simple little hack
    $hide_player_from_excerpt = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_hide_player_from_excerpt']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_hide_player_from_excerpt'] : '';
    $sbp_force_player_home = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_force_player_home']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_force_player_home'] : '';
   

    
	//Assume we are showing the player
    $show_player = true;

    if ($hide_player_from_excerpt) {
          
        //If on post page and not home, blog, or archive page then show player
        if( is_single() && is_main_query() )
            $show_player = true;
        else 
            $show_player = false;
        
    }
      
    if ($sbp_force_player_home)
          $show_player = true;

    
    $isLicenseValid = get_option('sspress_ls');
        
    if ($isLicenseValid !== 'valid') 
        return $content; 
     
	//if (!in_the_loop())
	//	return $content;	
  $pattern        = '/(<div\s+[^<]*?\bclass="[^<"]*\btimestamp\b[^<]*?>[^<]*)?(?<!:)\d{1,2}:\d{2}(?::\d{2})?(?!(?::\d{2})?\s*[ap]\.?m\.?)(?!.*?[\'])/';
  $replacement    = '[ssp-timestamp time="$0"]';
  $foundTimestamp = preg_replace_callback($pattern, array(
      $this,
      'ssp_ts_callback'
  ), $content);
  
  $foundTimestamp = str_replace('[[ssp', '[ssp', $foundTimestamp);
  $foundTimestamp = str_replace('"]]', '"]', $foundTimestamp);
  $foundTimestamp = str_replace(']"]', ']', $foundTimestamp);
  
  
  if ($foundTimestamp)
      $content = $foundTimestamp;

	//check if shortcode already on there or not, if yes then ...
	if ( (preg_match_all('/(.?)\[(sbp-player)\b(.*?)(?:(\/))?\](?:(.+?)\[\/\2\])?(.?)/s', $content, $matches)) OR (preg_match_all('/(.?)\[(ssp-video)\b(.*?)(?:(\/))?\](?:(.+?)\[\/\2\])?(.?)/s', $content, $matches)) )
	{
    
        // Strip out the shortcode before displaying if player is off
	    if ($show_player == false){
            $content = preg_replace('/\[sbp-player.*?\]/', '', $content);
	        return $content;
        }
        
        else
              return $content;
		
    }

      
    if ($show_player AND $stream_id) {        
		  $blab_player_position = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_blab_player_position']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_blab_player_position'] : '';
                
          $blab_player = new FB_Player();
          $html = $blab_player->sbpressplayer_fn();
    
          if(in_array('the_excerpt', $GLOBALS['wp_current_filter'])) {
                if ( ! has_excerpt( $post->ID ) ) 
                      $content = get_the_content("");
                      
                $content = strip_shortcodes( $content );
                
                $filter_html = wp_strip_all_tags($html, true);
                $content = str_replace($filter_html, '', $content);
                
                $content = wp_trim_words( $content );
          }
          
                    
          switch($blab_player_position){
		
				case 'above' :
                     
				     $content =  $html.PHP_EOL.$content;
		
				break;
		
				case 'below' :

                        $content =  $content.PHP_EOL.$html;	
		
				break;
              
                case 'disabled' :
                
                      $content =  $content.PHP_EOL;
                
		
				break;
                
                default:

                      $content =  $html.$content.PHP_EOL;
		
			}
    } // end of if show_player

      
    //Turn auto format back on
    //if ($wpautop_on) {
    //          add_filter( 'the_content', 'wpautop',9);
    //}
      
      return $content;
}
      
function sbp_plugin_update () {
    require_once(ABSPATH . 'wp-admin/includes/file.php');
    global $sbpress_current_version;
    global $sbp_db_version;
	
      
    $does_image_option_exist = get_option('sbp_ep_art_select',-1);
    if ($does_image_option_exist == -1)
          update_option('sbp_ep_art_select', 0);
      
    $last_savedcss_version = get_option('sbp-currentcss-version');
       
    if ( $last_savedcss_version !== $sbpress_current_version ) {      
         update_option('sbp-currentcss-version', $sbpress_current_version);
         $this->generate_options_css();
    }
 
	 $installed_version = get_option('sbp_db_version');

     if ($installed_version !== $sbp_db_version) {
          global $wpdb;
		  $table_sbp_streams = $wpdb->prefix . "ssp_streams";
		  $sql0='DROP TABLE IF EXISTS '. $table_sbp_streams;
		  $wpdb->query($sql0);
		  $this->install_sbp_db();                
          update_option('sbp_db_version' , $sbp_db_version);
      }
      
    return;
}

function generate_options_css() {

      $uploads = wp_upload_dir();
      $css_dir = dirname( __FILE__ ). '/responsive_player/css/'; // Shorten code, save 1 call
        
      /** Save on different directory if on multisite **/
      if(is_multisite())
            $aq_uploads_dir = trailingslashit($uploads['basedir']);
      else
            $aq_uploads_dir = $css_dir;

      /** Capture CSS output **/
      ob_start();
      require($css_dir . 'sbp-player.php');
      $css = ob_get_clean();
      
      /** Write to options.css file **/
      global $wp_filesystem;
      // protect if the the global filesystem isn't setup yet
      if( is_null( $wp_filesystem ) ) 
            WP_Filesystem();
      if ( ! $wp_filesystem->put_contents( $aq_uploads_dir . 'sbp-player.css', $css) ) {
		  update_option('sbp_writecss', FALSE);
          return false;   
      }
              
      update_option('sbp_writecss', TRUE);
      return true;

}

function manual_sbp_action() {
    $post_id = get_the_ID();
	$sbpogp = get_post_meta($post_id,'SSP_OGP', true );
    
      
      if (!$sbpogp)
            return;
      
      if ( has_post_thumbnail($post_id) )
            $fbChannelImage = wp_get_attachment_url( get_post_thumbnail_id($post_id) );
      else
            $fbChannelImage = get_option('sfp_channel_image');
      
      
      $sbpogp["image"] = $fbChannelImage;
      update_post_meta( $post_id,'SSP_OGP', $sbpogp );
      
}

function sbp_admin_menu(){
			$iconImage = plugins_url() . '/simple-social-press/icons/ssp_icon.png';
			add_menu_page('SimpleSocialPress', 'Simple Social Press', 'manage_options','ssp-settings',array($this,'sbp_view'),$iconImage);
      add_submenu_page('ssp-settings', 'Simple Social Press', 'Support', 'manage_options', 'ssp-support', array(
        $this,
        'ssp_support_page'
    ));
  }  
function ssp_support_page(){
      global $wpdb;
      $table_spp_podcast     = $wpdb->prefix . "ssp_streams";
      $post_meta_table =  $wpdb->prefix .'postmeta';
      $s_html = '';
      $podcast_items         = $wpdb->get_results("SELECT * FROM " . $table_spp_podcast." ORDER BY 	fb_start_time	 DESC");

      $dbsearchhtml = '<table>
      <thead>
          <th>Facebook Video ID</th>
      </thead>
      <tbody>
      <tr>
          <td>
              <form method="get" action="#dbsearch">
                  <input type="hidden" value="ssp-support" name="page">
                  <input type="text" name="search" >
             </form> 
          </td>
      </tr>
          </tbody>
      </table>
      ';
      if ( isset($_GET['search']) ){
          $s = $_GET['search'];
          $results = $wpdb->get_results('SELECT * FROM '.$post_meta_table.' where meta_value like "%'.$s.'%"');
          $dbsearchhtml .= '<table id="dbsearch" class="table table-bordred table-striped">
                      <thead>
                      <th>Post ID</th>
                      <th>Meta Key</th>
                      <th>Meta Value</th>

                      </thead><tbody>';
          foreach($results as $result){
              $postid = $result->post_id;
              $meta_key = $result->meta_key;
              $meta_value = $result->meta_value;

               
              $dbsearchhtml .= '
              <tr>
              <td><a href="'.get_site_url().'/wp-admin/post.php?post='.$postid.'&action=edit">'.$postid.'</a></td>
              <td>'.$meta_key.'</td>
              <td>'.$meta_value.'</td>
              </tr>
              ';
          }
          $dbsearchhtml .= '</tbody></table>';
      }
      $podcasttable = '
      <div class="container">
      <div class="row">
      <div class="col-md-12">
          <div class="table-responsive">
              <table id="fb-table" class="table table-bordred table-striped">
                  <thead>
                  <th>Title</th>
                  <th class="col-md-3">Date</th>
                  <th>Description</th>
                  <th>Image</th>
                  <th>Video ID</th>
                  <th>Live</th>
                  </thead>
                  <tbody>';
                  
      foreach($podcast_items as $p_item){
                $pub_date = date("Y-m-d H:i:s", $p_item->fb_start_time);
                //$fb_captions = $p_item->fb_captions;
                //$fb_srt = $p_item->fb_srt;
                  $podcasttable .= ' <tr>
                      <td>'.$p_item->fb_title.'</td>
                      <td>'.$pub_date.'</td>
                      <td>'.$p_item->fb_description.'</td>
                      <td><img src="'.$p_item->fb_image_file.'" width="200" /></td>
                      <td>'.$p_item->fb_id.'</td>
                      <td>'.$p_item->fb_live.'</td>
                  </tr>';
      }
      

      $podcasttable .= '
                  </tbody>
              </table>
          </div>
      </div>
      </div>
      </div>';
      $html = '
      <div id="tabs">
      <ul>
        <li><a href="#fb-table">Facebook Videos</a></li>
        <li><a href="#dbsearch">Search</a></li>
      </ul>
      <div id="podcast-table">
              '.$podcasttable.'
      </div>
      <div id="dbsearch">
              '.$dbsearchhtml.'
      </div>
    </div>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script type="text/javascript">
    jQuery (document).ready(function(){
      jQuery( "#tabs" ).tabs();
    });
    </script>
    ';
      
    echo $html;
     
  }

function sbp_view(){
      include("sbp_view/sbp_plugin_view.php");
}


function url_get_contents($url) {
    $getresponse = wp_safe_remote_get($url, array( 'timeout' => 60, 'redirection' => 20, 'sslverify' => false, ) );
    $response = wp_remote_retrieve_body($getresponse);
    return $response;
} 
    
function convert_srt_to_text($srt) {
$lines = explode(PHP_EOL, $srt);
    
$subs    = array();
$state   = SRT_STATE_SUBNUMBER;
$subNum  = 0;
$subText = '';
$subTime = '';
foreach($lines as $line) {
    switch($state) {
        case SRT_STATE_SUBNUMBER:
            $subNum = trim($line);
            $state  = SRT_STATE_TIME;
            break;

        case SRT_STATE_TIME:
            $subTime = trim($line);
            $state   = SRT_STATE_TEXT;
            break;

        case SRT_STATE_TEXT:
            if (trim($line) == '') {
                $sub = new stdClass;

                $sub->number = $subNum;
                list($sub->startTime, $sub->stopTime) = explode(' --> ', $subTime);
                $sub->startTime = strtok($sub->startTime,',');
                $sub->startTime  = strtotime("1970-01-01 $sub->startTime UTC");
                $sub->stopTime = strtok($sub->stopTime,',');
                $sub->stopTime  = strtotime("1970-01-01 $sub->stopTime UTC");
                $sub->text = $subText;
               // $sub->text   = $subText;
                $subText     = '';
                $state       = SRT_STATE_SUBNUMBER;

                $subs[]      = $sub;
            } else {
                $subText .= $line;
            }
            break;
    }
}

if ($state == SRT_STATE_TEXT) {
    // if file was missing the trailing newlines, we'll be in this
    // state here.  Append the last read text and add the last sub.

      $sub->text = $subText;
     // $subs[] = $sub;


}

    // sort array in order ot time
    
    return $subs;
} 
    
    
function get_unix_timeoffset() {
      
      // Determine TimeZone Offset in UNIX seconds
      $timeLocal = (int)current_time( 'timestamp', 0 );
      $timeGmt = (int)current_time( 'timestamp', 1 );
      $timeOffset = ($timeGmt - $timeLocal);
      return $timeOffset;
}
function ssp_delete_duplicate_comments($vidPostId) {
    
    global $wpdb;


    
    # First select all comments that belong to Video Posts created by SSP
    $query = "SELECT comment_ID, comment_post_ID, comment_content FROM ".$wpdb->comments." WHERE comment_post_ID = ".$vidPostId;
    $comments = $wpdb->get_results($query);

    
    # Array to hold keeper comment IDs so we don't delete them if there are doops
    $keeper_comments = array();

    # Now check if each comment has any matching comments from the same post
    foreach ($comments as $comment) {
      $query = "SELECT comment_ID FROM ".$wpdb->comments." WHERE comment_ID != ".$comment->comment_ID." AND comment_post_ID = ".$comment->comment_post_ID." AND comment_content = '".addslashes($comment->comment_content)."'";
        $matching_comments = $wpdb->get_results($query);
        if ($wpdb->num_rows > 0) {
            foreach ($matching_comments as $matching_comment) {
                if (!in_array($matching_comment->comment_ID, $keeper_comments)) {
                    $wpdb->query("DELETE FROM ".$wpdb->comments." WHERE comment_ID = ".$matching_comment->comment_ID);
                }
            }
            $keeper_comments[] = $comment->comment_ID;
        }
    }
    
    
}

function blab_insert_comments($post_id =0, $stream_id=0, $access_token=0) {

      global $wpdb;
      $table_sbp_streams	=  $wpdb->prefix . "ssp_streams";
      $timeoffset = $this->get_unix_timeoffset();
	  $starttime = strtotime('now');

       //$comment_stream = 'https://graph.facebook.com/'.FB_API_VER.'/'.$stream_id.'/comments?limit='.rand(50,75).'&filter=toplevel&fields=comments.summary(true),message,from&order=reverse_chronological&date_format=U&access_token='.$access_token; 
	   $comment_stream = 'https://graph.facebook.com/'.FB_API_VER.'/'.$stream_id.'/comments?limit='.rand(50,75).'&fields=message,from,created_time,comments,comment_count&date_format=U&order=reverse_chronological&filter=toplevel&access_token='.$access_token;
		$insertedcomments = 0;
	    
     
            $commentOBJ = json_decode($this->url_get_contents($comment_stream));
            if (isset($commentOBJ->data))
			{
				foreach ($commentOBJ->data as $chats){	
				  $replycount = 0;
				  $comment_parent = 0;

				  $noEmojiMessageChat = $this->remove_emoji($chats->message);
                  $commentdata = array(
                        'comment_post_ID' => $post_id,
                        'comment_author' => $chats->from->name,
                        'comment_author_email' => $chats->from->id.'@facebook.com',
                        'comment_author_url' => 'https://facebook.com/'. $stream_id,
                        'comment_content' => $noEmojiMessageChat,
                        'comment_type' => '',
                        'comment_parent' => 0,
                        'user_id' => 0,
                        'comment_author_IP' => preg_replace( '/[^0-9., ]/', '',$_SERVER['REMOTE_ADDR'] ),
                        'comment_agent' => 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.10) Gecko/2009042316 Firefox/3.0.10 (.NET CLR 3.5.30729)',
                        'comment_date' => date("Y-m-d H:i:s", (int)($chats->created_time) - $timeoffset),
                        'comment_approved' => 1,
                  );

							$recordexist_email = $wpdb->get_var("SELECT comment_ID FROM " . $wpdb->prefix . "comments WHERE comment_author_email = '".$chats->from->id."@facebook.com' LIMIT 1"); 

							$recordexist_content = $wpdb->get_var("SELECT comment_ID FROM ".$wpdb->comments." WHERE  comment_content = '".addslashes($noEmojiMessageChat)."'");
			
						if (empty($recordexist_content) || empty($recordexist_email)) {
							$comment_ID = wp_insert_comment($commentdata);
							$comment_parent = $comment_ID;
							if (!empty($comment_ID)){
								$insertedcomments = $insertedcomments + 1;
							}
						}
						else
							$comment_parent = $recordexist_content;
						//start nested comments code
									$replycount = $chats->comment_count;
										if ($replycount > 0){
												foreach ($chats->comments->data as $n_chats){
													    $noEmojiMessage = $this->remove_emoji($n_chats->message);
                                                        $commentdata = array(
															'comment_post_ID' => $post_id,
															'comment_author' => $n_chats->from->name,
															'comment_author_email' => $n_chats->from->id.'@facebook.com',
															'comment_author_url' => 'https://facebook.com/'. $stream_id,
															'comment_content' => $noEmojiMessage,
															'comment_type' => '',
															'comment_parent' => $comment_parent,
															'user_id' => 0,
															'comment_author_IP' => preg_replace( '/[^0-9., ]/', '',$_SERVER['REMOTE_ADDR'] ),
															'comment_agent' => 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.10) Gecko/2009042316 Firefox/3.0.10 (.NET CLR 3.5.30729)',
															'comment_date' => date("Y-m-d H:i:s", (int)($n_chats->created_time) - $timeoffset),
															'comment_approved' => 1,
													  );
															$recordexist_email = $wpdb->get_var("SELECT comment_ID FROM " . $wpdb->prefix . "comments WHERE comment_author_email = '".$n_chats->from->id."@facebook.com' LIMIT 1");

															$recordexist_content = $wpdb->get_var("SELECT comment_ID FROM ".$wpdb->comments." WHERE  comment_content = '".addslashes($noEmojiMessage)."'");
	
															if (empty($recordexist_content) || empty($recordexist_email)) {
																$comment_ID = wp_insert_comment($commentdata);
																$comment_parent = $comment_ID;
																	if (!empty($comment_ID)){
																		$insertedcomments++;
																	}
															}
												}
										
										}



						//endstart nested comments code


            }//end main foreach
			}
			$this->ssp_delete_duplicate_comments($post_id);
     

      unset($commentOBJ);
      return  (int)$insertedcomments; 

}

function sbp_save_blab_settings() {
                  
        $variable = $_POST["yourpostname"];

		$nonce = $_POST['wpnonce']; 

	if ( !wp_verify_nonce( $nonce, 'settings' ) ) {
          // This nonce is not valid.
	     die( 'Security check' ); 

	} 
    else {
        
		if($variable == 'Save Changes'){
		 	$this->save_ssp_settings();
			$this->generate_options_css(); 
			}
	
		if($variable == 'Import New Facebook Videos Now'){
		 	$this->save_ssp_settings();
            $this->sbp_save_stream_info();
            $this->generate_post_from_sbp_table(); 
		}

    	if($variable == 'Import New Comments Now'){
		 	$this->generate_comments_from_sbp_table();
		}

	unset($fb);
    }
      
      
}
      
function sbp_generate_post_with_cron(){
      $isLicenseValid = get_option('sspress_ls');
      $sp_settings = get_option('ssp_settings');     
      $sbp_import_select = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_import_select']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_import_select'] : '';
      
      if ($isLicenseValid !== 'valid') 
            exit;

      if ($sbp_import_select !== 1) {
            $this->sbp_save_stream_info();
            $this->generate_post_from_sbp_table(); 
      }
      $this->generate_comments_from_sbp_table();
}
    
function delete_sbp_settings(){
  delete_option('sfb_code');
  delete_option('sfp_channel_image');
  delete_option('sfp_access_token');
  delete_option('sbp_fb_userid');
  delete_option('sbp_fb_username');
  delete_option('sbp_fbpages');
  delete_option('sbp_fbgroups');
}

function save_ssp_settings(){
  global $wpdb;
  $sbp_btn_downloadaudio = '';
  $sbp_btn_followblab = '';
  $sbp_btn_share = '';
  $ssp_privacy_page = '';
  $sbp_btn_custom1 = '';
  $sbp_btn_custom2 = '';
  $sbp_btn_custom3 = '';
  $sbp_btn_custom4 = '';
  $sbp_btn_custom5 = '';
  $sbp_btn_custom6 = '';
  $sbp_LeadBox_btn_checkbox = '';
  $ssp_exclude_hashtags = '';
  $ssp_include_hashtags = '';
  $ssp_hash_cat_chk = '';
  $access_token = get_option('sfp_access_token');


  $powered_by_link = 'on';
  $sbp_force_player_home = false;    

  $sp_settings = get_option('ssp_settings');

  if (isset($_POST['sbp_ep_art_select'])) {
        $sp_settings[SSP_CHANNEL]['settings']['sbp_ep_art_select'] = $_POST['sbp_ep_art_select'];
  }
      
  if (isset($_POST['sbp_videotype_select'])) {
        $sp_settings[SSP_CHANNEL]['settings']['sbp_videotype_select'] = $_POST['sbp_videotype_select'];
  }
        
  if (isset($_POST["sbp_two_step_optin"])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_two_step_optin'] = $_POST['sbp_two_step_optin'];
  }

  if (isset($_POST["sbp_cat"])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_post_category'] = $_POST["sbp_cat"]; 
  }
      
  if (isset($_POST["sbp_profile"])) {
      
	  $pageToken = $_POST["sbp_profile"];
	  $sp_settings[SSP_CHANNEL]['settings']['sbp_post_profile'] = $_POST["sbp_profile"];
	  
	  // Save Page Access Token 
	  $fb_api = 'https://graph.facebook.com/'.FB_API_VER.'/'.$_POST["sbp_profile"].'?fields=access_token&access_token='.$access_token;
	  
	  $fbObject = json_decode($this->url_get_contents($fb_api));
      
	  if (isset($fbObject->access_token))
		  update_option('sfp_page_access_token',$fbObject->access_token);
	  else
		  delete_option('sfp_page_access_token');
  }


  if (isset($_POST["sbp_cpt_select"])) {
        $sp_settings[SSP_CHANNEL]['settings']['sbp_cpt_select']	= $_POST["sbp_cpt_select"];
  }
  if (isset($_POST["ssp_post_format_select"])) {
        $sp_settings[SSP_CHANNEL]['settings']['ssp_post_format_select']	= $_POST["ssp_post_format_select"];
  }
  else {
     $sp_settings[SSP_CHANNEL]['settings']['ssp_post_format_select'] =  '0'; 
  }
 
  if (isset($_POST["ssp_exclude_hashtags"]))
      $ssp_exclude_hashtags = $_POST["ssp_exclude_hashtags"];
  if (isset($_POST["ssp_include_hashtags"]))
      $ssp_include_hashtags = $_POST["ssp_include_hashtags"];
  if (isset($_POST["ssp_hash_cat_chk"]))
      $ssp_hash_cat_chk = $_POST["ssp_hash_cat_chk"];
	
	
	if (isset($_POST["ssp_exc_hash_val"]))
      $ssp_exc_hash_val = $_POST["ssp_exc_hash_val"];
	if (isset($_POST["ssp_inc_hash_val"]))
      $ssp_inc_hash_val = $_POST["ssp_inc_hash_val"];
	if (isset($_POST["ssp_cat_hash_val"]))
      $ssp_cat_hash_val = $_POST["ssp_cat_hash_val"];
	if (isset($_POST["ssp_hash_cat"]))
      $ssp_hash_cat = $_POST["ssp_hash_cat"];
	

  if (isset($_POST["sbp_btn_downloadaudio"]))
      $sbp_btn_downloadaudio = $_POST["sbp_btn_downloadaudio"];
  if (isset($_POST["sbp_btn_followblab"]))
        $sbp_btn_followblab = $_POST["sbp_btn_followblab"];
  if (isset($_POST["sbp_btn_share"]))
        $sbp_btn_share = $_POST["sbp_btn_share"];
  if (isset($_POST["sbp_btn_custom1"]))
      $sbp_btn_custom1 = $_POST["sbp_btn_custom1"];
  if (isset($_POST["sbp_btn_custom2"]))
        $sbp_btn_custom2 = $_POST["sbp_btn_custom2"];
  if (isset($_POST["sbp_btn_custom3"]))
        $sbp_btn_custom3 = $_POST["sbp_btn_custom3"];
  if (isset($_POST["sbp_btn_custom4"]))
      $sbp_btn_custom4 = $_POST["sbp_btn_custom4"];
  if (isset($_POST["sbp_btn_custom5"]))
        $sbp_btn_custom5 = $_POST["sbp_btn_custom5"];
  if (isset($_POST["sbp_btn_custom6"]))
        $sbp_btn_custom6 = $_POST["sbp_btn_custom6"];
  if (isset($_POST["sbp_LeadBox_btn_checkbox"]))
        $sbp_LeadBox_btn_checkbox = $_POST["sbp_LeadBox_btn_checkbox"];

  if (isset($_POST["sbp_btn_downloadaudio_color"]))
        $sbp_btn_downloadaudio_color = $_POST["sbp_btn_downloadaudio_color"];
  else
        $sbp_btn_downloadaudio_color = '#3b5998';
  if (isset($_POST["sbp_btn_followblab_color"]))
        $sbp_btn_followblab_color = $_POST["sbp_btn_followblab_color"];
  else
        $sbp_btn_followblab_color = '#3b5998';
  if (isset($_POST["sbp_btn_share_color"]))
        $sbp_btn_share_color = $_POST["sbp_btn_share_color"];
  else
        $sbp_btn_share_color = '#3b5998';
  if (isset($_POST["sbp_btn_custom_color1"]))
        $sbp_btn_custom_color1 = $_POST["sbp_btn_custom_color1"];
  else
        $sbp_btn_custom_color1 = '#3b5998';
  if (isset($_POST["sbp_btn_custom_color2"]))
        $sbp_btn_custom_color2 = $_POST["sbp_btn_custom_color2"];
  else
        $sbp_btn_custom_color2 = '#3b5998';
  if (isset($_POST["sbp_btn_custom_color3"]))
        $sbp_btn_custom_color3 = $_POST["sbp_btn_custom_color3"];
  else
        $sbp_btn_custom_color3 = '#3b5998';
  if (isset($_POST["sbp_btn_custom_color4"]))
        $sbp_btn_custom_color4 = $_POST["sbp_btn_custom_color4"];
  else
        $sbp_btn_custom_color4 = '#3b5998';
  if (isset($_POST["sbp_btn_custom_color5"]))
        $sbp_btn_custom_color5 = $_POST["sbp_btn_custom_color5"];
  else
        $sbp_btn_custom_color5 = '#3b5998';
  if (isset($_POST["sbp_btn_custom_color6"]))
        $sbp_btn_custom_color6 = $_POST["sbp_btn_custom_color6"];
  else
        $sbp_btn_custom_color6 = '#3b5998';
  if (isset($_POST["sbp_LeadBox_btn_color"]))
        $sbp_LeadBox_btn_color = $_POST["sbp_LeadBox_btn_color"];
  else
        $sbp_LeadBox_btn_color = '#3b5998';

  if (isset($_POST["sbp_btn_downloadaudio_name"]))
        $sbp_btn_downloadaudio_name = stripslashes_deep($_POST["sbp_btn_downloadaudio_name"]);
  if (isset($_POST["sbp_btn_followblab_name"])) 
        $sbp_btn_followblab_name = stripslashes_deep($_POST["sbp_btn_followblab_name"]);
  if (isset($_POST["sbp_btn_share_name"])) 
        $sbp_btn_share_name = stripslashes_deep($_POST["sbp_btn_share_name"]);
  if (isset($_POST["sbp_btn_custom_name1"]))
        $sbp_btn_custom_name1 = stripslashes_deep($_POST["sbp_btn_custom_name1"]); 
  if (isset($_POST["sbp_btn_custom_name2"]))
        $sbp_btn_custom_name2 = stripslashes_deep($_POST["sbp_btn_custom_name2"]);
  if (isset($_POST["sbp_btn_custom_name3"]))
        $sbp_btn_custom_name3 = stripslashes_deep($_POST["sbp_btn_custom_name3"]);
  if (isset($_POST["sbp_btn_custom_name4"]))
        $sbp_btn_custom_name4 = stripslashes_deep($_POST["sbp_btn_custom_name4"]);
  if (isset($_POST["sbp_btn_custom_name5"]))
        $sbp_btn_custom_name5 = stripslashes_deep($_POST["sbp_btn_custom_name5"]);
  if (isset($_POST["sbp_btn_custom_name6"]))
        $sbp_btn_custom_name6 = stripslashes_deep($_POST["sbp_btn_custom_name6"]);

  if (isset($_POST["sbp_btn_custom_url1"]))
        $sbp_btn_custom_url1 = $_POST["sbp_btn_custom_url1"]; 
  if (isset($_POST["sbp_btn_custom_url2"]))
        $sbp_btn_custom_url2 = $_POST["sbp_btn_custom_url2"];
  if (isset($_POST["sbp_btn_custom_url3"]))
        $sbp_btn_custom_url3 = $_POST["sbp_btn_custom_url3"];
  if (isset($_POST["sbp_btn_custom_url4"]))
        $sbp_btn_custom_url4 = $_POST["sbp_btn_custom_url4"]; 
  if (isset($_POST["sbp_btn_custom_url5"]))
        $sbp_btn_custom_url5 = $_POST["sbp_btn_custom_url5"];
  if (isset($_POST["sbp_btn_custom_url6"]))
        $sbp_btn_custom_url6 = $_POST["sbp_btn_custom_url6"];
  if (isset($_POST["sbp_LeadBox_btn_code"]))
        $sbp_LeadBox_btn_code = stripslashes(htmlspecialchars($_POST["sbp_LeadBox_btn_code"], ENT_QUOTES));


  if ($sbp_btn_downloadaudio == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio'] = 1;
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio_color'] = $sbp_btn_downloadaudio_color;
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio_name'] = stripslashes_deep($sbp_btn_downloadaudio_name);
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio'] = 0;
  }
    
  if ($ssp_exclude_hashtags == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['ssp_exclude_hashtags'] = 1;
      $sp_settings[SSP_CHANNEL]['settings']['ssp_exc_hash_val'] = $ssp_exc_hash_val;
  
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['ssp_exclude_hashtags'] = 0;
  }

  if ($ssp_include_hashtags == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['ssp_include_hashtags'] = 1;
      $sp_settings[SSP_CHANNEL]['settings']['ssp_inc_hash_val'] = $ssp_inc_hash_val;
  
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['ssp_include_hashtags'] = 0;
  }
  if ($ssp_hash_cat_chk == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['ssp_hash_cat_chk'] = 1;
      $sp_settings[SSP_CHANNEL]['settings']['ssp_cat_hash_val'] = $ssp_cat_hash_val;
      $sp_settings[SSP_CHANNEL]['settings']['ssp_hash_cat'] = $ssp_hash_cat;

  }else{
      $sp_settings[SSP_CHANNEL]['settings']['ssp_hash_cat_chk'] = 0;
  }



  if ($sbp_btn_followblab == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab'] = 1;
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab_color'] = $sbp_btn_followblab_color;
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab_name'] = stripslashes_deep($sbp_btn_followblab_name);
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab'] = 0;
  }
 if ($sbp_btn_share == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share'] = 1;
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share_color'] = $sbp_btn_share_color;
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share_name'] = stripslashes_deep($sbp_btn_share_name);

  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share'] = 0;
  }
    
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color1'] = $sbp_btn_custom_color1;
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name1'] = stripslashes_deep($sbp_btn_custom_name1);
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url1'] = $sbp_btn_custom_url1;
  if ($sbp_btn_custom1 == 'on')
  {
       $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom1'] = 1;

  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom1'] = 0;
  }

  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color2'] = $sbp_btn_custom_color2;
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name2'] = stripslashes_deep($sbp_btn_custom_name2);
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url2'] = $sbp_btn_custom_url2;
  if ($sbp_btn_custom2 == 'on')
  {
       $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom2'] = 1;

  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom2'] = 0;
  }
  
  

  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color3'] = $sbp_btn_custom_color3;
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name3'] = stripslashes_deep($sbp_btn_custom_name3);
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url3'] = $sbp_btn_custom_url3;
  if ($sbp_btn_custom3 == 'on')
  {
       $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom3'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom3'] = 0;
  }

  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color4'] = $sbp_btn_custom_color4;
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name4'] = stripslashes_deep($sbp_btn_custom_name4);
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url4'] = $sbp_btn_custom_url4;
  if ($sbp_btn_custom4 == 'on')
  {
       $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom4'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom4'] = 0;
  }

  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color5'] = $sbp_btn_custom_color5;
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name5'] = stripslashes_deep($sbp_btn_custom_name5);
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url5'] = $sbp_btn_custom_url5;
  if ($sbp_btn_custom5 == 'on')
  {
       $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom5'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom5'] = 0;
  }

  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color6'] = $sbp_btn_custom_color6;
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name6'] = stripslashes_deep($sbp_btn_custom_name6);
  $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url6'] = $sbp_btn_custom_url6;
  if ($sbp_btn_custom6 == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom6'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom6'] = 0;
  }


  $sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_color'] = $sbp_LeadBox_btn_color;
  $sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_code'] = $sbp_LeadBox_btn_code;
  if ($sbp_LeadBox_btn_checkbox == 'on')
  {
       $sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_checkbox'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_checkbox'] = 0;
  }

  if (isset($_POST['sbp_container_width'])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_container_width'] = $_POST['sbp_container_width'];
  }

  if (isset($_POST['sbp_container_height'])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_container_height'] = $_POST['sbp_container_height'];
  }
  if (isset($_POST['sbp_minbutton_width'])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_minbutton_width'] = $_POST['sbp_minbutton_width'];
  }
  if (isset($_POST['ep_art_select'])) {
      $sp_settings[SSP_CHANNEL]['settings']['ep_art_select'] = $_POST['ep_art_select'];
  }
      
  if (isset($_POST["sbp_author"])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_author'] = $_POST["sbp_author"];
   }
      
  if (isset($_POST['sbp_import_select'])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_import_select'] = $_POST['sbp_import_select'];
  }
  if (isset($_POST['sbp_ep_specific_date'])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_ep_specific_date'] = $_POST['sbp_ep_specific_date'];
  }

  if (isset($_POST['blab_player_position'])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_blab_player_position'] = $_POST['blab_player_position'];
  }
  if (isset($_POST['blab_caption_position'])) {
    $sp_settings[SSP_CHANNEL]['settings']['sbp_blab_caption_position'] = $_POST['blab_caption_position'];
  }

  if (isset($_POST["sbp_optin_old_code"])) {
        $sp_settings[SSP_CHANNEL]['settings']['sbp_optin_old_code'] = stripslashes(htmlspecialchars($_POST["sbp_optin_old_code"], ENT_QUOTES));
  }
  if (isset($_POST["sbp_auto_resp_url"])) {
        $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_url'] = htmlspecialchars($_POST["sbp_auto_resp_url"], ENT_QUOTES);
  }
  if (isset($_POST["sbp_auto_resp_heading"])) {
        $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_heading'] = $_POST["sbp_auto_resp_heading"];
  }
  if (isset($_POST["sbp_auto_resp_sub_heading"])) {
        $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_sub_heading'] = $_POST["sbp_auto_resp_sub_heading"];
  }     
  if (isset($_POST['sbp_auto_resp_hidden'])) {
        $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_hidden']  = stripslashes(htmlspecialchars($_POST['sbp_auto_resp_hidden'], ENT_QUOTES)); 
  }
  if (isset($_POST["sbp_auto_resp_name"])) {
        $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_name'] = $_POST["sbp_auto_resp_name"];
  }
  if (isset($_POST["sbp_auto_resp_email"])) {
        $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_email'] = $_POST["sbp_auto_resp_email"]; 
  }
  if (isset($_POST["sbp_auto_resp_submitt"])) {
        $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_submitt'] = $_POST["sbp_auto_resp_submitt"]; 
  }

  if (isset($_POST["sbp_force_player_home"]) AND ($_POST["sbp_force_player_home"] == 'on'))
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_force_player_home'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_force_player_home'] = 0;
  }

  if (isset($_POST["sbp_force_comments_off"]) AND ($_POST["sbp_force_comments_off"] == 'on'))
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_force_comments_off'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_force_comments_off'] = 0;
  }
      
  if (isset($_POST["disable_opengraph"]) AND $_POST["disable_opengraph"] == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_disable_opengraph'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_disable_opengraph'] = 0;
  }


  if (isset($_POST["sbp_optin_box"]) AND $_POST["sbp_optin_box"] == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_optin_box'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_optin_box'] = 0;
  }

  if (isset($_POST["ssp_privacy_policy_text"])) {
      $sp_settings[SSP_CHANNEL]['settings']['ssp_privacy_policy_text'] = $_POST["ssp_privacy_policy_text"];
  }

  if (isset($_POST["sbp_poweredby_url"])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_poweredby_url'] = $_POST["sbp_poweredby_url"];
  }

    
if (isset($_POST["ssp_privacy_page"])) {
      $sp_settings[SSP_CHANNEL]['settings']['ssp_privacy_page'] = $_POST["ssp_privacy_page"];
 } 
else
{
     $sp_settings[SSP_CHANNEL]['settings']['ssp_privacy_page'] = '';
}
  if (isset($_POST["sbp_disable_poweredby"]) AND $_POST["sbp_disable_poweredby"] == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_disable_poweredby'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_disable_poweredby'] = 0;
  }

      
  if (isset($_POST["sbp_submit_button_color"])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_submit_button_color'] 	= $_POST["sbp_submit_button_color"];
  }
  if (isset($_POST["sbp_submit_button_text"])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_submit_button_text']	= $_POST["sbp_submit_button_text"];
  }
  if (isset($_POST["sbp_opt_container_color"])) {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_opt_container_color']	= $_POST["sbp_opt_container_color"];
  }


  if (isset($_POST["sbp_btn_style_round"]) AND $_POST["sbp_btn_style_round"] == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_style_round'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_style_round'] = 0;
  }



  if (isset($_POST["disable_player_excerpt"]) AND $_POST["disable_player_excerpt"] == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_hide_player_from_excerpt'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_hide_player_from_excerpt'] = 0;
  }


  if (isset($_POST["sbp_auto_publish"]) AND $_POST["sbp_auto_publish"] == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_publish'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_publish'] = 0;
  }

 if (isset($_POST["sbp_show_data"]) AND $_POST["sbp_show_data"] == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_show_data'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_show_data'] = 0;
  }


  if (isset($_POST["sbp_email_on_draft"]) AND $_POST["sbp_email_on_draft"] == 'on')
  {
      $sp_settings[SSP_CHANNEL]['settings']['sbp_email_on_draft'] = 1;
  }else{
      $sp_settings[SSP_CHANNEL]['settings']['sbp_email_on_draft'] = 0;
  }
      
  // Update the option once at the end after adding them all to the array
  update_option('ssp_settings',$sp_settings);
}

      
function remove_emoji($text){
    
	$clean_text = "";
	
	$clean_text = preg_replace('/[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0077}\x{E006C}\x{E0073}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0073}\x{E0063}\x{E0074}\x{E007F})|[\x{1F3F4}](?:\x{E0067}\x{E0062}\x{E0065}\x{E006E}\x{E0067}\x{E007F})|[\x{1F3F4}](?:\x{200D}\x{2620}\x{FE0F})|[\x{1F3F3}](?:\x{FE0F}\x{200D}\x{1F308})|[\x{0023}\x{002A}\x{0030}\x{0031}\x{0032}\x{0033}\x{0034}\x{0035}\x{0036}\x{0037}\x{0038}\x{0039}](?:\x{FE0F}\x{20E3})|[\x{1F441}](?:\x{FE0F}\x{200D}\x{1F5E8}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F467})|[\x{1F468}](?:\x{200D}\x{1F468}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467}\x{200D}\x{1F466})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F467})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F469}\x{200D}\x{1F466})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F468})|[\x{1F469}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F469})|[\x{1F469}\x{1F468}](?:\x{200D}\x{2764}\x{FE0F}\x{200D}\x{1F48B}\x{200D}\x{1F468})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B3})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B2})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B1})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F9B0})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F9B0})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2640}\x{FE0F})|[\x{1F575}\x{1F3CC}\x{26F9}\x{1F3CB}](?:\x{FE0F}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2640}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FF}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FE}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FD}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FC}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{1F3FB}\x{200D}\x{2642}\x{FE0F})|[\x{1F46E}\x{1F9B8}\x{1F9B9}\x{1F482}\x{1F477}\x{1F473}\x{1F471}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F9DE}\x{1F9DF}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F46F}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93C}\x{1F93D}\x{1F93E}\x{1F939}](?:\x{200D}\x{2642}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F692})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F680})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2708}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A8})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3A4})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F52C})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F4BC})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3ED})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F527})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F373})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F33E})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2696}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F3EB})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{200D}\x{1F393})|[\x{1F468}\x{1F469}](?:\x{1F3FF}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FE}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FD}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FC}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{1F3FB}\x{200D}\x{2695}\x{FE0F})|[\x{1F468}\x{1F469}](?:\x{200D}\x{2695}\x{FE0F})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FF})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FE})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FD})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FC})|[\x{1F476}\x{1F9D2}\x{1F466}\x{1F467}\x{1F9D1}\x{1F468}\x{1F469}\x{1F9D3}\x{1F474}\x{1F475}\x{1F46E}\x{1F575}\x{1F482}\x{1F477}\x{1F934}\x{1F478}\x{1F473}\x{1F472}\x{1F9D5}\x{1F9D4}\x{1F471}\x{1F935}\x{1F470}\x{1F930}\x{1F931}\x{1F47C}\x{1F385}\x{1F936}\x{1F9D9}\x{1F9DA}\x{1F9DB}\x{1F9DC}\x{1F9DD}\x{1F64D}\x{1F64E}\x{1F645}\x{1F646}\x{1F481}\x{1F64B}\x{1F647}\x{1F926}\x{1F937}\x{1F486}\x{1F487}\x{1F6B6}\x{1F3C3}\x{1F483}\x{1F57A}\x{1F9D6}\x{1F9D7}\x{1F9D8}\x{1F6C0}\x{1F6CC}\x{1F574}\x{1F3C7}\x{1F3C2}\x{1F3CC}\x{1F3C4}\x{1F6A3}\x{1F3CA}\x{26F9}\x{1F3CB}\x{1F6B4}\x{1F6B5}\x{1F938}\x{1F93D}\x{1F93E}\x{1F939}\x{1F933}\x{1F4AA}\x{1F9B5}\x{1F9B6}\x{1F448}\x{1F449}\x{261D}\x{1F446}\x{1F595}\x{1F447}\x{270C}\x{1F91E}\x{1F596}\x{1F918}\x{1F919}\x{1F590}\x{270B}\x{1F44C}\x{1F44D}\x{1F44E}\x{270A}\x{1F44A}\x{1F91B}\x{1F91C}\x{1F91A}\x{1F44B}\x{1F91F}\x{270D}\x{1F44F}\x{1F450}\x{1F64C}\x{1F932}\x{1F64F}\x{1F485}\x{1F442}\x{1F443}](?:\x{1F3FB})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FA}](?:\x{1F1FF})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1FA}](?:\x{1F1FE})|[\x{1F1E6}\x{1F1E8}\x{1F1F2}\x{1F1F8}](?:\x{1F1FD})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F9}\x{1F1FF}](?:\x{1F1FC})|[\x{1F1E7}\x{1F1E8}\x{1F1F1}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1FB})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1FB}](?:\x{1F1FA})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FE}](?:\x{1F1F9})|[\x{1F1E6}\x{1F1E7}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FA}\x{1F1FC}](?:\x{1F1F8})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F7})|[\x{1F1E6}\x{1F1E7}\x{1F1EC}\x{1F1EE}\x{1F1F2}](?:\x{1F1F6})|[\x{1F1E8}\x{1F1EC}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}](?:\x{1F1F5})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EE}\x{1F1EF}\x{1F1F2}\x{1F1F3}\x{1F1F7}\x{1F1F8}\x{1F1F9}](?:\x{1F1F4})|[\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1F3})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1EC}\x{1F1ED}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F4}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FF}](?:\x{1F1F2})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1F1})|[\x{1F1E8}\x{1F1E9}\x{1F1EB}\x{1F1ED}\x{1F1F1}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FD}](?:\x{1F1F0})|[\x{1F1E7}\x{1F1E9}\x{1F1EB}\x{1F1F8}\x{1F1F9}](?:\x{1F1EF})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EB}\x{1F1EC}\x{1F1F0}\x{1F1F1}\x{1F1F3}\x{1F1F8}\x{1F1FB}](?:\x{1F1EE})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F5}\x{1F1F8}\x{1F1F9}](?:\x{1F1ED})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}](?:\x{1F1EC})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F9}\x{1F1FC}](?:\x{1F1EB})|[\x{1F1E6}\x{1F1E7}\x{1F1E9}\x{1F1EA}\x{1F1EC}\x{1F1EE}\x{1F1EF}\x{1F1F0}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F7}\x{1F1F8}\x{1F1FB}\x{1F1FE}](?:\x{1F1EA})|[\x{1F1E6}\x{1F1E7}\x{1F1E8}\x{1F1EC}\x{1F1EE}\x{1F1F2}\x{1F1F8}\x{1F1F9}](?:\x{1F1E9})|[\x{1F1E6}\x{1F1E8}\x{1F1EA}\x{1F1EE}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F8}\x{1F1F9}\x{1F1FB}](?:\x{1F1E8})|[\x{1F1E7}\x{1F1EC}\x{1F1F1}\x{1F1F8}](?:\x{1F1E7})|[\x{1F1E7}\x{1F1E8}\x{1F1EA}\x{1F1EC}\x{1F1F1}\x{1F1F2}\x{1F1F3}\x{1F1F5}\x{1F1F6}\x{1F1F8}\x{1F1F9}\x{1F1FA}\x{1F1FB}\x{1F1FF}](?:\x{1F1E6})|[\x{00A9}\x{00AE}\x{203C}\x{2049}\x{2122}\x{2139}\x{2194}-\x{2199}\x{21A9}-\x{21AA}\x{231A}-\x{231B}\x{2328}\x{23CF}\x{23E9}-\x{23F3}\x{23F8}-\x{23FA}\x{24C2}\x{25AA}-\x{25AB}\x{25B6}\x{25C0}\x{25FB}-\x{25FE}\x{2600}-\x{2604}\x{260E}\x{2611}\x{2614}-\x{2615}\x{2618}\x{261D}\x{2620}\x{2622}-\x{2623}\x{2626}\x{262A}\x{262E}-\x{262F}\x{2638}-\x{263A}\x{2640}\x{2642}\x{2648}-\x{2653}\x{2660}\x{2663}\x{2665}-\x{2666}\x{2668}\x{267B}\x{267E}-\x{267F}\x{2692}-\x{2697}\x{2699}\x{269B}-\x{269C}\x{26A0}-\x{26A1}\x{26AA}-\x{26AB}\x{26B0}-\x{26B1}\x{26BD}-\x{26BE}\x{26C4}-\x{26C5}\x{26C8}\x{26CE}-\x{26CF}\x{26D1}\x{26D3}-\x{26D4}\x{26E9}-\x{26EA}\x{26F0}-\x{26F5}\x{26F7}-\x{26FA}\x{26FD}\x{2702}\x{2705}\x{2708}-\x{270D}\x{270F}\x{2712}\x{2714}\x{2716}\x{271D}\x{2721}\x{2728}\x{2733}-\x{2734}\x{2744}\x{2747}\x{274C}\x{274E}\x{2753}-\x{2755}\x{2757}\x{2763}-\x{2764}\x{2795}-\x{2797}\x{27A1}\x{27B0}\x{27BF}\x{2934}-\x{2935}\x{2B05}-\x{2B07}\x{2B1B}-\x{2B1C}\x{2B50}\x{2B55}\x{3030}\x{303D}\x{3297}\x{3299}\x{1F004}\x{1F0CF}\x{1F170}-\x{1F171}\x{1F17E}-\x{1F17F}\x{1F18E}\x{1F191}-\x{1F19A}\x{1F201}-\x{1F202}\x{1F21A}\x{1F22F}\x{1F232}-\x{1F23A}\x{1F250}-\x{1F251}\x{1F300}-\x{1F321}\x{1F324}-\x{1F393}\x{1F396}-\x{1F397}\x{1F399}-\x{1F39B}\x{1F39E}-\x{1F3F0}\x{1F3F3}-\x{1F3F5}\x{1F3F7}-\x{1F3FA}\x{1F400}-\x{1F4FD}\x{1F4FF}-\x{1F53D}\x{1F549}-\x{1F54E}\x{1F550}-\x{1F567}\x{1F56F}-\x{1F570}\x{1F573}-\x{1F57A}\x{1F587}\x{1F58A}-\x{1F58D}\x{1F590}\x{1F595}-\x{1F596}\x{1F5A4}-\x{1F5A5}\x{1F5A8}\x{1F5B1}-\x{1F5B2}\x{1F5BC}\x{1F5C2}-\x{1F5C4}\x{1F5D1}-\x{1F5D3}\x{1F5DC}-\x{1F5DE}\x{1F5E1}\x{1F5E3}\x{1F5E8}\x{1F5EF}\x{1F5F3}\x{1F5FA}-\x{1F64F}\x{1F680}-\x{1F6C5}\x{1F6CB}-\x{1F6D2}\x{1F6E0}-\x{1F6E5}\x{1F6E9}\x{1F6EB}-\x{1F6EC}\x{1F6F0}\x{1F6F3}-\x{1F6F9}\x{1F910}-\x{1F93A}\x{1F93C}-\x{1F93E}\x{1F940}-\x{1F945}\x{1F947}-\x{1F970}\x{1F973}-\x{1F976}\x{1F97A}\x{1F97C}-\x{1F9A2}\x{1F9B0}-\x{1F9B9}\x{1F9C0}-\x{1F9C2}\x{1F9D0}-\x{1F9FF}]/u', '', $text);

	
	//Removes Square Box Hex fe0f
	$regexEmoticons = '/[\x{fe0f}]/u';
    $clean_text = preg_replace($regexEmoticons, '', $clean_text);
	
	return $clean_text;
		
		
}

	
	function remove_emoji_original($text){
      //return trim( preg_replace('/[\x00-\x1F\x80-\xFF]/', '',mb_convert_encoding( $text, "UTF-8" ) ) );
	$clean_text = "";

    // Match Emoticons
    $regexEmoticons = '/[\x{1F600}-\x{1F64F}]/u';
    $clean_text = preg_replace($regexEmoticons, '', $text);

    // Match Miscellaneous Symbols and Pictographs
    $regexSymbols = '/[\x{1F300}-\x{1F5FF}]/u';
    $clean_text = preg_replace($regexSymbols, '', $clean_text);

    // Match Transport And Map Symbols
    $regexTransport = '/[\x{1F680}-\x{1F6FF}]/u';
    $clean_text = preg_replace($regexTransport, '', $clean_text);

    // Match Miscellaneous Symbols
    $regexMisc = '/[\x{2600}-\x{26FF}]/u';
    $clean_text = preg_replace($regexMisc, '', $clean_text);

    // Match Dingbats
    $regexDingbats = '/[\x{2700}-\x{27BF}]/u';
    $clean_text = preg_replace($regexDingbats, '', $clean_text);

    return $clean_text;
}
	
function make_links_clickable($text){
    return preg_replace('!(((f|ht)tp(s)?://)[-a-zA-Zа-яА-Я()0-9@:%_+.~#?&;//=]+)!i', '<a href="$1" target="_blank">$1</a>', $text);
}
function    sbp_save_stream_info(){
      global $wpdb;
       $inserted  = false;
      $duplicate = false;
      $table_sbp_streams	=  $wpdb->prefix . "ssp_streams";
      $access_token = get_option('sfp_page_access_token');
    //  $wpdb->query("truncate table $table_sbp_streams"); exit;
	  if (!$access_token)
		  $access_token = get_option('sfp_access_token');
      $sp_settings = get_option('ssp_settings');     
      $sbp_videotype_select =  isset($sp_settings[SSP_CHANNEL]['settings']['sbp_videotype_select']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_videotype_select'] : '';
      $fbid = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_post_profile']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_post_profile'] : '';
      
      $user_date='';
      $sbp_import_select = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_import_select']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_import_select'] : '';
      $sbp_ep_specific_date = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_ep_specific_date']) ? strtotime($sp_settings[SSP_CHANNEL]['settings']['sbp_ep_specific_date']) : '';
      if ($sbp_import_select == 2)
          $user_date = date("Y-m-d", $sbp_ep_specific_date);
	
	//$fb_stream = 'https://graph.facebook.com/'.FB_API_VER.'/'.$fbid.'/videos/uploaded?date_format=U&fields=created_time%2Cid%2Cembeddable%2Clive_status%2Csource%2Cdescription%2Cthumbnails%7Buri%2Cis_preferred%7D%2Ctitle%2Ccontent_tags&access_token='.$access_token; 
	
	//$fb_stream = 'https://graph.facebook.com/'.FB_API_VER.'/'.$fbid.'/videos/uploaded?date_format=U&fields=created_time,description,embeddable,live_status,id,title,thumbnails{uri,is_preferred},captions{uri}&since='.$user_date.'&access_token='.$access_token; 
      
    $fb_stream = 'https://graph.facebook.com/'.FB_API_VER.'/'.$fbid.'/videos/uploaded?date_format=U&fields=created_time,description,embeddable,live_status,id,title,thumbnails{uri,is_preferred}&since='.$user_date.'&access_token='.$access_token; 
      
    //$fb_stream = 'https://graph.facebook.com/'.FB_API_VER.'/'.$fbid.'/videos/uploaded?date_format=U&fields=created_time%2Cid%2Cembeddable%2Clive_status%2Csource%2Cdescription%2Cpicture%2Ctitle%2Ccontent_tags&access_token='.$access_token;  
            
      //$fb_stream = 'https://graph.facebook.com/'.FB_API_VER.'/me/videos/uploaded?date_format=U&fields=created_time%2Cid%2Cembeddable%2Clive_status%2Csource%2Cdescription%2Cpicture%2Ctitle&access_token='.$access_token;

      $stream_counter = 0;
      
      while (true) {
            
            
		  
		    $fbObject = json_decode($this->url_get_contents($fb_stream));
          
          
          
			if( !is_object($fbObject) )
			{
                return;
			}
          
            foreach ($fbObject->data as $fbvideo){
                $title = '';
                $tags = ''; 
                $description = '';
		            $image_file = '';
                $fblive = 0;
                //$fb_captions = '';
                  
               if (!$fbvideo->embeddable) 
                         continue;
                   //else if (($sbp_videotype_select == "0") and (!isset($fbvideo->live_status)) ) 
                    //     continue;
                    //else if (($sbp_videotype_select == "0") and (isset($fbvideo->live_status)) and ($fbvideo->live_status !== "VOD")) 
                    //     continue;
                    if ( (isset($fbvideo->live_status)) and ($fbvideo->live_status == "VOD") )
                        $fblive = 1;
                    else if ((isset($fbvideo->live_status)) and ($fbvideo->live_status !== "VOD"))
                        continue;
                
                    
                              $stream_id = $fbvideo->id;
                              if (isset($fbvideo->description))
                                  $cleanDescription = $this->remove_emoji($fbvideo->description);
                              if (isset($fbvideo->title))
                                    $title = $fbvideo->title;
                              else if (isset($fbvideo->description)) {
                                      if (strlen($fbvideo->description) > 200)
										                    $title = substr($cleanDescription,0,200) . '...';
								                    	else
										                    $title = $cleanDescription;
							                      }
                              // If both title and description are empty then skip video
                              // This is required for a FB release and possibly premeire bug
                              else {
                                    continue;
                                  //$title = 'Facebook Video '.$fbvideo->id;
                                }
                              $start_time = $fbvideo->created_time;
                                    
                              foreach ($fbvideo->thumbnails->data as $fbthumb){                                    
                                   $image_file = $fbthumb->uri;
                                   if ($fbthumb->is_preferred) {     
                                          //$image_file = $fbthumb->uri;
                                          break;
                                   }
                              }
                              
                              
                              /* if (isset($fbvideo->content_tags)) {
                                    foreach ($fbvideo->content_tags as $tag) {
                                           $fb_taglookup = 'https://graph.facebook.com/'.FB_API_VER.'/'.$tag.'?fields=name&access_token='.$access_token;
                                           $fbTagObj = json_decode($this->url_get_contents($fb_taglookup));
                                           $tags_list[] = $fbTagObj->name;
                                    }
                                    
                                     $tags = implode(',', $tags_list);
                                     unset($fbTagObj);
                                     unset($tags_list);
                              } */
                  
                              if (isset($fbvideo->description)) {
                                   $description = $this->make_links_clickable($cleanDescription);
                              }
                              
                             /* Remove caption logic during import
                             
                             if (isset($fbvideo->captions->data[0]->uri)) {
                                   $fb_srt = $this->url_get_contents($fbvideo->captions->data[0]->uri);
                                   $subs = $this->convert_srt_to_text($fb_srt);
                                 
                                                           
                                   // Sort by SRT start time (already converted to seconds)
                                  if (!function_exists('sortSrtStartTime')) { 
                                      function sortSrtStartTime($a,$b){
                                        return $b->startTime - $a->startTime;
                                      }
                                  }
                  
                                usort($subs,"sortSrtStartTime");
                                
                                $prev_stop = 0;
                                //echo '<pre>'; print_r($subs); 

                                          foreach($subs as $sub) {
                                              $time_match = $prev_stop - $sub->stopTime;
                                              if ($time_match >= 1){
                                                $fb_captions = '<p>' . strval($sub->text) . '</p>' . strval($fb_captions);
                                              }else{
                                                $fb_captions =  strval($sub->text) . "&nbsp;" . strval($fb_captions) . "&nbsp;";
                                              }
                                              $prev_stop = $sub->startTime;
                                        }
                                        //echo $fb_captions; exit;
                              } */

                              $duplicate = $wpdb->get_row("SELECT * FROM " . $table_sbp_streams . " WHERE fb_id = '$stream_id'");
                                    //start check hashtag in title and post_description, if exist then continue/ skip the post;
                              $skip = false;
                              $ssp_exclude_hashtags = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_exclude_hashtags']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_exclude_hashtags'] : '';
                            
                              $ssp_include_hashtags = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_include_hashtags']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_include_hashtags'] : '';


                              if ( $ssp_exclude_hashtags || $ssp_include_hashtags ){
                               // echo $title; 

                                $ssp_exc_hash_val = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_exc_hash_val']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_exc_hash_val'] : '';


                                preg_match_all('/#(\w+)/',$ssp_exc_hash_val,$hashtags);

                                preg_match_all('/#(\w+)/',$title,$hashtags_in_title);
                                preg_match_all('/#(\w+)/',$description,$hashtags_in_post);

                                foreach ($hashtags[0] as $hashtag){
                                    if ($this->in_array_case_insensitive($hashtag, $hashtags_in_title[0])) 
                                    {
                                        $skip = true;
                                    }      
                                    if ($this->in_array_case_insensitive($hashtag, $hashtags_in_post[0])) 
                                    {
                                        $skip = true;
                                    }      
                                }

                                $ssp_inc_hash_val = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_inc_hash_val']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_inc_hash_val'] : '';

                                preg_match_all('/#(\w+)/',$ssp_inc_hash_val,$hashtags);

                                preg_match_all('/#(\w+)/',$title,$hashtags_in_title);
                                preg_match_all('/#(\w+)/',$description,$hashtags_in_post);

                              
                                foreach ($hashtags[0] as $hashtag){
                                    $skip = true;
                                    if ($this->in_array_case_insensitive($hashtag, $hashtags_in_title[0])) 
                                    {
                                        $skip = false;
                                    }      
                                    if ($this->in_array_case_insensitive($hashtag, $hashtags_in_post[0])) 
                                    {
                                        $skip = false;
                                    }      
                                }

                                if ($skip) {
                                  continue;
                                }
                              }//end hashtag exclude section
                              
//echo $title; exit;
                              if (!$duplicate AND $skip==false){
                                  
				                              $data = array(
                                              'fb_id' => $stream_id,
                                              'fb_title' => $title,
                                              'fb_start_time' => $start_time,
                                              'fb_image_file' => $image_file,
                                              'fb_tags' => $tags,
                                              'fb_description' => $description,
                                              'fb_profile' => $fbid,
                                              'fb_live' => $fblive,
                                      );	

                                   $inserted = $wpdb->insert($table_sbp_streams, $data );
				   
                              }

                              if ($inserted)
                                    $stream_counter++;
                        
            }//end foreach
            
            if (isset($fbObject->paging->next))
                  $fb_stream = $fbObject->paging->next;
            
            else
                  break;
      }
    
unset($fbObject);


return $stream_counter;
}

function register_sbp_admin_scripts( $hook ) {
    if ( (isset($_GET['page'])) AND ($_GET['page'] == 'ssp-settings' )){
        wp_enqueue_script( 'sbp_wp_admin_js_bootstrap_min', SSPRESS_PLUGIN_URL . '/sbp_view/js/bootstrap.min.js', false, null, false);
        wp_enqueue_script('jquery-ui-datepicker');
        wp_enqueue_style('jquery-ui-css', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.2/themes/smoothness/jquery-ui.css');
        wp_enqueue_style( 'wp-color-picker' );
        wp_enqueue_script( 'sbp-admin-script', SSPRESS_PLUGIN_URL . '/sbp_view/js/sbp_admin_scripts.js', array( 'wp-color-picker' ), false, false );
	    wp_enqueue_script( 'spp-re-copy', SSPRESS_PLUGIN_URL . '/sbp_view/js/reCopy.js', array( 'wp-color-picker' ), false, false );


        wp_register_style( 'sbp_wp_admin_css_bootstrap', SSPRESS_PLUGIN_URL . '/sbp_view/css/bootstrap.css', false, '1.0.0' );
        wp_register_style( 'sbp_wp_admin_css_bootstrap_responsive', SSPRESS_PLUGIN_URL . '/sbp_view/css/bootstrap-responsive.css', false, '1.0.0' );
        wp_register_style( 'sbp_wp_admin_css_common', SSPRESS_PLUGIN_URL . '/sbp_view/css/common.css', false, '1.0.0' );
        wp_register_style( 'sbp_wp_admin_css_fontawesome', SSPRESS_PLUGIN_URL . '/sbp_view/css/fontawesome.css', false, '1.0.0' );
        wp_register_style( 'sbp_wp_admin_css', SSPRESS_PLUGIN_URL . '/sbp_view/css/sbp-admin.css', false, '1.0.0' );
        wp_enqueue_style( 'sbp_wp_admin_css_bootstrap' );
        wp_enqueue_style( 'sbp_wp_admin_css_bootstrap_responsive' );
        wp_enqueue_style( 'sbp_wp_admin_css_common' );
        wp_enqueue_style( 'sbp_wp_admin_css_fontawesome' );
        wp_enqueue_style( 'sbp_wp_admin_css' );
    }

        if ( 'widgets.php' != $hook )
              return;
}
                    
function sbp_preserve_draft_date($post){
	//global $post;
    $release_date = get_post_meta($post->ID,'_fb_release_date',TRUE);
       //if ( (!empty($release_date)) && ($post->post_date != date('Y-m-d H:i:s',strtotime($release_date))) ){
    if (! empty($release_date)) {
        $post->edit_date = date('Y-m-d H:i:s',strtotime($release_date));
        $post->post_date = date('Y-m-d H:i:s',strtotime($release_date));
        //$post->post_date_gmt = date('Y-m-d H:i:s',strtotime($release_date));
        wp_update_post($post);
    }
}
 

/*
function sbp_preserve_draft_date_save($new_status, $old_status, $post){
    $release_date = get_post_meta($post->ID,'_fb_release_date',TRUE);
    //if ((!empty($release_date)) && ($old_status == 'draft')) {
    if (! empty($release_date)) {
      $post->edit_date = date('Y-m-d H:i:s',strtotime($release_date));
      $post->post_date = date('Y-m-d H:i:s',strtotime($release_date));
      //$post->post_date_gmt = date('Y-m-d H:i:s',strtotime($release_date));
	  wp_update_post($post); 
    }
}
*/


function generate_comments_from_sbp_table() {
      global $wpdb;
	  $access_token = get_option('sfp_page_access_token');
	  if (!$access_token)
		  $access_token = get_option('sfp_access_token');
      //$table_sbp_streams	=  $wpdb->prefix . "ssp_streams";
   
      $sp_settings = get_option('ssp_settings');  
      $sbp_force_comments_off = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_force_comments_off']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_force_comments_off'] : '';
	  $insertedvideos = isset($_REQUEST['insertedvideos']) ? $_REQUEST['insertedvideos'] : 0 ;
	  $insertedcomments = isset($_REQUEST['insertedcomments']) ? $_REQUEST['insertedcomments'] : 0 ;



      $fbvideoposts = $wpdb->get_results("SELECT post_id, meta_value FROM " . $wpdb->prefix . "postmeta WHERE meta_key LIKE '_fb_videoid' ");
	  $totalvids = count($fbvideoposts);
      $fbvideoposts = $wpdb->get_results("SELECT post_id, meta_value FROM " . $wpdb->prefix . "postmeta WHERE meta_key LIKE '_fb_videoid' LIMIT ".$insertedvideos.",".$totalvids);
	  $totalvids = count($fbvideoposts);

	  $counter = 0;
      if (!$sbp_force_comments_off) {
            foreach ($fbvideoposts as $fbvideopost){
                  $inserted = $this->blab_insert_comments($fbvideopost->post_id, $fbvideopost->meta_value,$access_token);
				   $insertedcomments = $insertedcomments + $inserted;
				if ($counter == 5){
					$counter = $counter + $insertedvideos;
					$result = array( 'insertedcomments' =>  $insertedcomments,
					  'insertedvideos' => $counter,
					  'totalvids' => $totalvids,
					);
				}
				$counter++;
			}
      }
		
		echo $insertedcomments; exit;
}
function in_array_case_insensitive($needle, $haystack) 
{
 return in_array( strtolower($needle), array_map('strtolower', $haystack) );
}            
            
function generate_post_from_sbp_table() {
      global $wpdb;
	  $access_token = get_option('sfp_page_access_token');
	  if (!$access_token)
		  $access_token = get_option('sfp_access_token');
      $table_sbp_streams	=  $wpdb->prefix . "ssp_streams";
		if($wpdb->get_var("SHOW TABLES LIKE '$table_sbp_streams'") != $table_sbp_streams) {
						return;
		}
      
      
      $counterposts = 0;
      $sbp_channel_image = get_option('sfp_channel_image');     

      $sp_settings = get_option('ssp_settings');  
      
      $blab_player_position = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_blab_player_position']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_blab_player_position'] : '';
      $auto_post = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_publish']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_publish'] : '';
      $cpt_select = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_cpt_select']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_cpt_select'] : '';
      $author = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_author']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_author'] : '';
      $sbp_import_select = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_import_select']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_import_select'] : '';
      $sbp_ep_specific_date = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_ep_specific_date']) ? strtotime($sp_settings[SSP_CHANNEL]['settings']['sbp_ep_specific_date']) : '';
      $category[] = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_post_category']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_post_category'] : '';
      $sbp_ep_art_select = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_ep_art_select']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_ep_art_select'] : '';
      $sbp_videotype_select = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_videotype_select']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_videotype_select'] : '';
      $sbp_profile = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_post_profile']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_post_profile'] : '';
      $sbp_force_comments_off = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_force_comments_off']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_force_comments_off'] : '';
	  if (isset($sp_settings[SSP_CHANNEL]['settings']['ssp_post_format_select']))
			$ssp_post_format = $sp_settings[SSP_CHANNEL]['settings']['ssp_post_format_select'];
      
	  $starttime = strtotime('now');

      //update_option('sbp_profile',$sbp_profile);
      $post_description = '';
      $custom_description = 'This is a replay of the live broadcast with ';
      //$sbp_ep_art_select = get_option ('sbp_ep_art_select');
      $thumbnail = null;
      
      //$this->sbp_save_stream_info();
     if (isset($_REQUEST['resultresponse']) AND  $_REQUEST['resultresponse'] != 'NaN'){
          $resultresponse = $_REQUEST['resultresponse'];
     }else{
          $resultresponse = 0;
     }
    
      
      $timeoffset = $this->get_unix_timeoffset();
      //$blab_items = $wpdb->get_results("SELECT * FROM " . $table_sbp_streams . " WHERE fb_live = '1' ORDER BY fb_id DESC" );
       $blab_items = $wpdb->get_results("SELECT * FROM " . $table_sbp_streams . " WHERE fb_profile = '$sbp_profile' ORDER BY fb_start_time DESC" );
       //$blab_items = $wpdb->get_results("SELECT * FROM " . $table_sbp_streams );
		$total_blabs = count($blab_items);
        // Mohammed do we need this?
    //$podcast_items = $wpdb->get_results("SELECT * FROM " . $table_sbp_streams . " ORDER BY fb_start_time DESC LIMIT ".$resultresponse.",".$total_blabs);
    $blab_items = $wpdb->get_results("SELECT * FROM " . $table_sbp_streams . " WHERE fb_profile = '$sbp_profile' ORDER BY fb_start_time DESC LIMIT ".$resultresponse.",".$total_blabs);
      foreach ($blab_items as $blab_item) {
          if ( ($sbp_videotype_select == 0) and ($blab_item->fb_live == 0) )
            continue;
          else if ( ($sbp_videotype_select == 2) and ($blab_item->fb_live == 1) )
              continue;
          
          $stream_id = $blab_item->fb_id;
            $category = array();
            $post_meta = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "postmeta WHERE meta_value = '$stream_id' ");

            if ( (!empty($post_meta->meta_value)) or ($sbp_profile !== $blab_item->fb_profile) )
                  continue;

			      $category[] = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_post_category']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_post_category'] : '';
            $title = $blab_item->fb_title;                          
            $tags = explode(' ,', $blab_item->fb_tags);
            //$post_description = $blab_item->fb_description;
            //$captionTranscript = '';
            //if (isset($blab_item->fb_captions))
            //    $captionTranscript = $blab_item->fb_captions;
            //$post_description = $blab_item->fb_description.$captionTranscript;
            $post_description = $blab_item->fb_description;
            $pub_date = $blab_item->fb_start_time;
			      $skip = '';


			//start check hashtag in title and post_description, if exist then continue/ skip the post;
			$ssp_exclude_hashtags = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_exclude_hashtags']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_exclude_hashtags'] : '';
			if ( $ssp_exclude_hashtags ){

			  $ssp_exc_hash_val = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_exc_hash_val']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_exc_hash_val'] : '';

			  preg_match_all('/#(\w+)/',$ssp_exc_hash_val,$hashtags);

			  preg_match_all('/#(\w+)/',$title,$hashtags_in_title);
			  preg_match_all('/#(\w+)/',$post_description,$hashtags_in_post);

			  foreach ($hashtags[0] as $hashtag){
						if ($this->in_array_case_insensitive($hashtag, $hashtags_in_title[0])) 
						{
								$skip = true;
						}      
						if ($this->in_array_case_insensitive($hashtag, $hashtags_in_post[0])) 
						{
								$skip = true;
						}      
				 }

				if ($skip) {
					continue;
				}
			}//end hashtag exclude section
			

			//start check hashtag in title  and post_description, if exist then import the post;
      $ssp_include_hashtags = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_include_hashtags']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_include_hashtags'] : '';

			if ($ssp_include_hashtags){

			  $ssp_inc_hash_val = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_inc_hash_val']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_inc_hash_val'] : '';

			  preg_match_all('/#(\w+)/',$ssp_inc_hash_val,$hashtags);

			  preg_match_all('/#(\w+)/',$title,$hashtags_in_title);
			  preg_match_all('/#(\w+)/',$post_description,$hashtags_in_post);

			
        foreach ($hashtags[0] as $hashtag){
						$skip = true;
                        if ($this->in_array_case_insensitive($hashtag, $hashtags_in_title[0])) 
						{
								$skip = false;
						}      
						if ($this->in_array_case_insensitive($hashtag, $hashtags_in_post[0])) 
						{
								$skip = false;
						}      
				 }

				if ($skip) {
					continue;
				}
                
        /* Previous Logic
               
               //if(!isset($hashtags_in_title[0][0]) or $hashtags_in_post[0][0] )
                if(!isset($hashtags_in_title[0][0]) and !isset($hashtags_in_post[0][0]) )
				{
					continue;
				}

						if (!$this->in_array_case_insensitive($hashtags_in_title[0][0], $hashtags[0]))
						{
								$skip = true;

						}else{
								$skip = false;
						}
						if (!$this->in_array_case_insensitive($hashtags_in_post[0][0], $hashtags[0]))
						{
								$skip = true;
						}else{
								$skip = false;
						}      
				if ($skip) {
					continue;
				}
                */
                
                
			}//end hashtag import section

//exit;

			//start check hashtag in title and post_description if exist then import the post in specific category;
			$ssp_hash_cat_chk = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_hash_cat_chk']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_hash_cat_chk'] : '';
			if ( $ssp_hash_cat_chk ){
				
			  $ssp_inc_hash_val = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_cat_hash_val']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_cat_hash_val'] : '';
			  $ssp_hash_cat = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_hash_cat']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_hash_cat'] : '';

			  $count = count($ssp_inc_hash_val);

			   for ($i=0; $i<$count; $i++){
					  preg_match_all('/#(\w+)/',$title,$hashtags_in_title);
					  preg_match_all('/#(\w+)/',$post_description,$hashtags_in_post);

								if ($this->in_array_case_insensitive($ssp_inc_hash_val[$i], $hashtags_in_title[0])) 
								{

									$category = array();
									$category[] = $ssp_hash_cat[$i];
									
								} 
								if ($this->in_array_case_insensitive($ssp_inc_hash_val[$i], $hashtags_in_post[0])) 
								{
                  
									$category = array();
                  $category[] = $ssp_hash_cat[$i];
								}
			   }
		
		}//end hashtag import in category section


           $title = htmlspecialchars_decode($title);

           $post_description = htmlspecialchars_decode($post_description);


            if($sbp_import_select == 2){
                  if ( ($pub_date-$timeoffset) <= $sbp_ep_specific_date )
                        break;
            }
  
            $pub_date = date("Y-m-d H:i:s", $pub_date - $timeoffset) ;
		
            if ($auto_post) {
                  $my_post = array(       'post_title'    => $title,       'post_content'  => $post_description,  'post_date'     =>  $pub_date,         'post_status'   => 'publish',  'post_category' =>  $category,       'post_author'   => $author,       'post_type'  => $cpt_select,  'tags_input'  =>  $tags     );
            } else {
                  $my_post = array(       'post_title'    => $title,       'post_content'  => $post_description,  'post_date'     =>  $pub_date,         'post_status'   => 'draft',  'post_category' =>  $category,       'post_author'   => $author,       'post_type'  => $cpt_select,  'tags_input'  =>  $tags     );
            }

            //	Insert the post into the database
            $post_id = wp_insert_post($my_post);
            
            //add_post_meta( $post_id, '_blab_audio', $audio, true ) || update_post_meta($post_id, 'blab_audio', $audio);
            //add_post_meta( $post_id, '_fb_video', $video, true ) || update_post_meta($post_id, '_fb_video', $video);
            add_post_meta( $post_id, '_fb_videoid', $stream_id, true ) || update_post_meta($post_id, '_fb_videoid', $stream_id);
            //add_post_meta( $post_id, 'ssp_captions', $captionTranscript, true ) || update_post_meta($post_id, 'ssp_captions', $captionTranscript);

			      set_post_format($post_id, $ssp_post_format);

            $counterposts++;

            add_post_meta( $post_id, '_fb_release_date', $pub_date, true ) || update_post_meta($post_id, '_fb_release_date', $pub_date);

            // Insert featured image
            switch ($sbp_ep_art_select){
                  case 0:
                        $thumbnail = $blab_item->fb_image_file;
                  break;
            }
            
            if (!empty($thumbnail)){

                  //	Set feature image for post
                  $upload_dir=wp_upload_dir();
                  $image_data=$this->url_get_contents($thumbnail);  
                     

                  $fullThumb = $thumbnail;
                  // Strip out any query strings in the MP3 file (audioboom and other hosts add them in their feed)
                  if (strpos($thumbnail,'?'))
                        $thumbnail = substr($thumbnail, 0, strpos($thumbnail, "?"));
                  $image_array=explode('.',$thumbnail);
                  $total_img=count( $image_array );
                  $ext=end( $image_array );
                  unset($image_array[$total_img-1]);
                  
                  $pcTitleWithDashes = preg_replace('/\%/',' percentage',$title);
                  $pcTitleWithDashes = preg_replace('/\@/',' at ',$pcTitleWithDashes);
                  $pcTitleWithDashes = preg_replace('/\&/',' and ',$pcTitleWithDashes);
                  $pcTitleWithDashes = preg_replace('/\]/',' - ',$pcTitleWithDashes);
                  $pcTitleWithDashes = preg_replace('/\[/',' - ',$pcTitleWithDashes);
                  $pcTitleWithDashes = preg_replace('/\+/',' - ',$pcTitleWithDashes);
                  $pcTitleWithDashes = preg_replace('/\s[\s]+/','-',$pcTitleWithDashes);

                  // Strip off multiple spaces 
                  $pcTitleWithDashes = preg_replace('/[\s\W]+/','-',$pcTitleWithDashes);

                  // Strip off spaces and non-alpha-numeric 
                  $pcTitleWithDashes = preg_replace('/^[\-]+/','',$pcTitleWithDashes);

                  // Strip off the starting hyphens 
                  $pcTitleWithDashes = preg_replace('/[\-]+$/','',$pcTitleWithDashes);

                  // Strip off the ending hyphens 
                  $pcTitleWithDashes = strtolower($pcTitleWithDashes);
                  $new_file=substr($pcTitleWithDashes,0,150).'_thumbnail.'.$ext;
                  
                  $filename=basename($new_file);

                  // TODO: Check if image already exists in Media library and don't reupload it

                  if(wp_mkdir_p($upload_dir['path']))$file = $upload_dir['path'] . '/' . $filename; else $file = $upload_dir['basedir'] . '/' . $filename;
                  
                  $SSP_CHANNELart_upload = file_put_contents($file, $image_data);
                  if (!$SSP_CHANNELart_upload) {
                        global $wp_filesystem;
                        // protect if the the global filesystem isn't setup yet
                        if( is_null( $wp_filesystem ) )
                              WP_Filesystem();
                        $wp_filesystem->put_contents($file, $image_data, FS_CHMOD_FILE);
                  }

                  $wp_filetype = wp_check_filetype($filename, null );
                  $attachment = array('post_mime_type' => $wp_filetype['type'],'post_title' => sanitize_file_name($filename),'post_content' => '','post_status' => 'inherit');
                  $attach_id = wp_insert_attachment( $attachment, $file, $post_id );
                  require_once(ABSPATH . 'wp-admin/includes/image.php');
                  // Improve speed by removing and running later
                  $attach_data = wp_generate_attachment_metadata( $attach_id, $file );
                  wp_update_attachment_metadata( $attach_id, $attach_data );
                  set_post_thumbnail( $post_id, $attach_id );
                  //	End of setting feature image

                  $fbImage = $fullThumb;


            }
            
            // NO thumbnail, use the Channel Image
            else {
                $sbpogp = get_post_meta($post_id,'SSP_OGP', true );
                $sbpogp["image"] = $sbp_channel_image;
                update_post_meta( $post_id,'SSP_OGP', $sbpogp );
            }
            
            // Set FB Open Graph object.   
            
            //$sbpogp["video"] = $video;
            
            //$sbpogp["title"] = $title;
            //if (!empty($fbImage))
              //    $sbpogp["image"] = $fbImage;       
            //else
              //    $sbpogp["image"] = $sbp_channel_image;
            
         if (!$sbp_force_comments_off)
                $this->blab_insert_comments($post_id, $blab_item->fb_id,$access_token);
          
          if ( !defined( 'DOING_CRON' ) ){
			$endtime = strtotime('now');
			if ($endtime - $starttime >= 10) { 
					echo	$counterposts;
					die();
			}
		}

            // End of FB Open Graph object
            
          
            

      }//end foreach

      echo	$counterposts;
      die();

}

function simplesocialpress_token_expire_cron_fn (){
  $days_left = $this->get_fb_access_token_expiry();
  //if ($days_left < 1){
    //update_option('sfp_access_token', '');
  //}
}
function general_admin_notice(){
  global $pagenow;
       echo '<div class="notice notice-warning is-dismissible">
           <p>Simple Social Press: The Connection To Facebook is not valid and requires reconnecting.</p>
       </div>';
  }
function get_fb_access_token_expiry(){
          
          $url = 'https://graph.facebook.com/oauth/access_token?client_id='.SSPFAI.'&client_secret='.SSPFAS.'&grant_type=client_credentials';
          $response = json_decode(file_get_contents($url),true);
          $app_token = $response['access_token'];
          $access_token = get_option('sfp_access_token');
          $url = 'https://graph.facebook.com/debug_token?input_token='.$access_token.'&access_token='.$app_token;
          $res = json_decode(file_get_contents($url));
          update_option('sfp_res4', $res);
    
          $expires_at = strtotime(date('Y-m-d', $res->data->data_access_expires_at));
          $today = strtotime(date("Y-m-d"));
          $diff = $expires_at - $today;
          if ($diff > 0)
            return $diff;
          else
            return 0;
}

function sbp_settings(){

        $sp_settings = get_option('ssp_settings');
            
        $refID = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_poweredby_url']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_poweredby_url'] : '';
        
        $sbp_auto_publish	=	isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_publish']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_publish'] : '';
        $sbp_show_data	=	isset($sp_settings[SSP_CHANNEL]['settings']['sbp_show_data']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_show_data'] : '';

        $sbp_email_on_draft	=	isset($sp_settings[SSP_CHANNEL]['settings']['sbp_email_on_draft']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_email_on_draft'] : '';
        
        $sbp_category			=	isset($sp_settings[SSP_CHANNEL]['settings']['sbp_post_category']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_post_category'] : '';
    		$sbp_profile			=	isset($sp_settings[SSP_CHANNEL]['settings']['sbp_post_profile']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_post_profile'] : '';
		    $ssp_privacy_policy_text			=	isset($sp_settings[SSP_CHANNEL]['settings']['ssp_privacy_policy_text']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_privacy_policy_text'] : '';


        $sbp_optin_box1 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_optin_box']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_optin_box'] : '';
        $sbp_two_step_optin = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_two_step_optin']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_two_step_optin'] : '';
        $sbp_two_step_optin_selected1 = ($sbp_two_step_optin == 1) ? 'selected=selected' : '';
        $sbp_two_step_optin_selected2 = ($sbp_two_step_optin == 2) ? 'selected=selected' : '';
        $sbp_two_step_optin_selected3 = ($sbp_two_step_optin == 3) ? 'selected=selected' : '';
        $sbp_two_step_optin_selected4 = ($sbp_two_step_optin == 4) ? 'selected=selected' : '';

        $sbp_ep_art_select =  isset($sp_settings[SSP_CHANNEL]['settings']['sbp_ep_art_select']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_ep_art_select'] : '';
        $sbp_ep_art_select1 = ($sbp_ep_art_select == 0) ? 'selected=selected' : '';
        $sbp_ep_art_select2 = ($sbp_ep_art_select == 1) ? 'selected=selected' : '';
      
        $sbp_videotype_select =  isset($sp_settings[SSP_CHANNEL]['settings']['sbp_videotype_select']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_videotype_select'] : '';
        $sbp_videotype_select1 = ($sbp_videotype_select == 0) ? 'selected=selected' : '';
        $sbp_videotype_select2 = ($sbp_videotype_select == 1) ? 'selected=selected' : '';
		    $sbp_videotype_select3 = ($sbp_videotype_select == 2) ? 'selected=selected' : '';


        //start custom post type dropdown
        $post_types = get_post_types( array('_builtin' => false,'public' => true ) ); 
        $sbp_cpt_select = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_cpt_select']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_cpt_select'] : '';
        $ssp_post_format_select = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_post_format_select']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_post_format_select'] : '';



        $sbp_cpt_dropdown = '<select name="sbp_cpt_select">';
        if ($sbp_cpt_select == 'post' or empty($sbp_cpt_select)){
        $sbp_cpt_dropdown .= "<option value='post' selected='selected'>Standard Post (Default)</option>";
        }else{
        $sbp_cpt_dropdown .= "<option value='post'>Standard Post (Default)</option>";
        }
        foreach ( $post_types as $post_type ) {
            if ($sbp_cpt_select == $post_type){

               $sbp_cpt_dropdown .= "<option value='".$post_type ."' selected='selected'>".$post_type ."</option>";

            }else{
               $sbp_cpt_dropdown .= "<option value='".$post_type ."'>".$post_type ."</option>";

            }
        }
         $sbp_cpt_dropdown .= '</select>';

        $ssp_post_format = '<select name="ssp_post_format_select">';

	
		  $post_formats = array (
												'0' => 'Standard (Default)',
											    'aside' => 'Aside',
											    'chat' => 'Chat',
											    'gallery' => 'Gallery',
											    'link' => 'Link',
											    'quote' => 'Quote',
											    'status' => 'Status',
											    'video' => 'Video',
											    'audio' => 'Audio'										
									);
        foreach ( $post_formats as $key => $format) {
            if ($ssp_post_format_select == $key){

               $ssp_post_format .= "<option value='".$key ."' selected='selected'>".$format ."</option>";

            }else{
               $ssp_post_format .= "<option value='".$key ."'>".$format ."</option>";

            }
		}
         $ssp_post_format .= '</select>';

		$sbp_auto_publish1 = ($sbp_auto_publish == 1) ? 'checked' : ''; 
		$sbp_show_data = ($sbp_show_data == 1) ? 'checked' : ''; 
        $sbp_force_player_home = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_force_player_home']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_force_player_home'] : '';
        $sbp_force_player_home = ($sbp_force_player_home == 1) ? 'checked' : ''; 
        $sbp_force_comments_off = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_force_comments_off']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_force_comments_off'] : '';
        $sbp_force_comments_off = ($sbp_force_comments_off == 1) ? 'checked' : ''; 
        $sbp_draft_row_display = ($sbp_auto_publish == 1) ? 'display:none;' : ''; 
        $sbp_email_on_draft = ($sbp_email_on_draft == 1) ? 'checked' : '';
        $sbp_disable_poweredby = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_disable_poweredby']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_disable_poweredby'] : '';
        $sbp_disable_poweredby =($sbp_disable_poweredby == 1) ? 'checked' : '';
        $sbp_btn_style_round = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_style_round']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_style_round'] : '';
        $sbp_btn_style_round =($sbp_btn_style_round == 1) ? 'checked' : '';
        $sbp_submit_button_color = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_submit_button_color']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_submit_button_color'] : '';
        $sbp_submit_button_text = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_submit_button_text']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_submit_button_text'] : '';
        $sbp_opt_container_color = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_opt_container_color']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_opt_container_color'] : '';
        //$sbp_btn_download_color = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_download_color']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_download_color'] : '';
        $sbp_poweredby_url = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_poweredby_url']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_poweredby_url'] : '';
        $ssp_privacy_page = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_privacy_page']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_privacy_page'] : '';
        $sbp_optin_box1 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_optin_box']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_optin_box'] : '';
        $sbp_optin_box = ($sbp_optin_box1 == 1) ? 'checked' : '';
        $sbp_optin_row_display = ($sbp_optin_box1 == 0) ? '' : ''; 
        $sbp_optin_old_code_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_optin_old_code']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_optin_old_code'] : '';
        $sbp_auto_resp_url_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_url']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_url'] : '';
        $sbp_auto_resp_heading_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_heading']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_heading'] : '';
        $sbp_auto_resp_sub_heading_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_sub_heading']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_sub_heading'] : '';
        $sbp_auto_resp_hidden_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_hidden']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_hidden'] : '';
        $sbp_auto_resp_name_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_name']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_name'] : '';
        $sbp_auto_resp_email_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_email']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_email'] : '';
        $sbp_auto_resp_submitt_get = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_submitt']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_auto_resp_submitt'] : '';

        $disable_opengraph = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_disable_opengraph']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_disable_opengraph'] : '';
        $disable_opengraph = ($disable_opengraph == 1) ? 'checked' : ''; 
        $disable_player_excerpt  = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_hide_player_from_excerpt']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_hide_player_from_excerpt'] : '';
        $disable_player_excerpt  =($disable_player_excerpt == 1) ? 'checked' : '';
        $direct_download_button = '';
        //$direct_download_button = $sp_settings[SSP_CHANNEL]['settings']['sbp_direct_download_button'];
        //$direct_download_button =($direct_download_button == 1) ? 'checked' : '';

        $sbp_btn_downloadaudio = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio'] : '';
        $sbp_btn_downloadaudio =($sbp_btn_downloadaudio == 1) ? 'checked' : '';
        $sbp_btn_followblab = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab'] : '';
        $sbp_btn_followblab =($sbp_btn_followblab == 1) ? 'checked' : '';
        $sbp_btn_share = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share'] : '';
        $sbp_btn_share =($sbp_btn_share == 1) ? 'checked' : '';
        $sbp_btn_custom1 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom1']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom1'] : '';
        $sbp_btn_custom1 =($sbp_btn_custom1 == 1) ? 'checked' : '';
        $sbp_btn_custom2 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom2']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom2'] : '';
        $sbp_btn_custom2 =($sbp_btn_custom2 == 1) ? 'checked' : '';
        $sbp_btn_custom3 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom3']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom3'] : '';
        $sbp_btn_custom3 =($sbp_btn_custom3 == 1) ? 'checked' : '';
        $sbp_btn_custom4 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom4']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom4'] : '';
        $sbp_btn_custom4 =($sbp_btn_custom4 == 1) ? 'checked' : '';
        $sbp_btn_custom5 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom5']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom5'] : '';
        $sbp_btn_custom5 =($sbp_btn_custom5 == 1) ? 'checked' : '';
        $sbp_btn_custom6 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom6']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom6'] : '';
        $sbp_btn_custom6 =($sbp_btn_custom6 == 1) ? 'checked' : '';
        $sbp_LeadBox_btn_checkbox = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_checkbox']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_checkbox'] : '';
        $sbp_LeadBox_btn_checkbox =($sbp_LeadBox_btn_checkbox == 1) ? 'checked' : '';


        if (isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio_color']))
			$sbp_btn_downloadaudio_color = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio_color'];
		else
			$sbp_btn_downloadaudio_color = '';
        
        
		if (isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab_color']))
			$sbp_btn_followblab_color = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab_color'];
		else
			$sbp_btn_followblab_color = '';
	
	
		if (isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share_color']))
			$sbp_btn_share_color = $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share_color'];
		else
			$sbp_btn_share_color = '';
        
		$sbp_btn_custom_color1 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color1']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color1'] : '';
        $sbp_btn_custom_color2 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color2']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color2'] : '';
        $sbp_btn_custom_color3 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color3']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color3'] : '';
        $sbp_btn_custom_color4 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color4']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color4'] : '';
        $sbp_btn_custom_color5 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color5']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color5'] : '';
        $sbp_btn_custom_color6 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color6']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_color6'] : '';
        $sbp_LeadBox_btn_color = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_color']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_color'] : '';

        $sbp_btn_custom_url1 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url1']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url1'] : '';
        $sbp_btn_custom_url2 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url2']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url2'] : '';
        $sbp_btn_custom_url3 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url3']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url3'] : '';
        $sbp_btn_custom_url4 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url4']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url4'] : '';
        $sbp_btn_custom_url5 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url5']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url5'] : '';
        $sbp_btn_custom_url6 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url6']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_url6'] : '';
        $sbp_LeadBox_btn_code = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_code']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_LeadBox_btn_code'] : '';

        if (isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio_name']))
			$sbp_btn_downloadaudio_name = stripslashes_deep($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_downloadaudio_name']);
		else
			$sbp_btn_downloadaudio_name = '';
      
        
		if (isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab_name']))
			$sbp_btn_followblab_name = stripslashes_deep($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_followblab_name']);
		else	
			$sbp_btn_followblab_name = 'Connect on Facebook';
	
		if (isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share_name']))
			$sbp_btn_share_name = stripslashes_deep($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_share_name']);
		else	
			$sbp_btn_share_name = 'Share';
        $sbp_btn_custom_name1 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name1']) ? stripslashes_deep($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name1']) : '';
        $sbp_btn_custom_name2 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name2']) ? stripslashes_deep($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name2']) : '';
        $sbp_btn_custom_name3 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name3']) ? stripslashes_deep($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name3']) : '';
        $sbp_btn_custom_name4 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name4']) ? stripslashes_deep($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name4']) : '';
        $sbp_btn_custom_name5 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name5']) ? stripslashes_deep($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name5']) : '';
        $sbp_btn_custom_name6 = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name6']) ? stripslashes_deep($sp_settings[SSP_CHANNEL]['settings']['sbp_btn_custom_name6']) : '';

        $sbp_import_select =  isset($sp_settings[SSP_CHANNEL]['settings']['sbp_import_select']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_import_select'] : '';

        $sbp_import_selected1 = ($sbp_import_select == 0) ? 'selected=selected' : '';
        $sbp_import_selected2 = ($sbp_import_select == 1) ? 'selected=selected' : '';
        $sbp_import_selected3 = ($sbp_import_select == 2) ? 'selected=selected' : '';

        $sbp_ep_specific_date = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_ep_specific_date']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_ep_specific_date'] : '';
        $date_textbox_display = ($sbp_import_select == 2) ? 'display:block;' : 'display:none;';

        if (isset($sp_settings[SSP_CHANNEL]['settings']['ssp_exclude_hashtags']))
			$ssp_exclude_hashtags = $sp_settings[SSP_CHANNEL]['settings']['ssp_exclude_hashtags'];
		else
			$ssp_exclude_hashtags = '';
        $ssp_exclude_hashtags =($ssp_exclude_hashtags == 1) ? 'checked' : '';
        if (isset($sp_settings[SSP_CHANNEL]['settings']['ssp_exc_hash_val']))
			$ssp_exc_hash_val =  $sp_settings[SSP_CHANNEL]['settings']['ssp_exc_hash_val'];
	    else
			$ssp_exc_hash_val = '';
	
        if (isset($sp_settings[SSP_CHANNEL]['settings']['ssp_include_hashtags']))
			$ssp_include_hashtags = $sp_settings[SSP_CHANNEL]['settings']['ssp_include_hashtags'];
	    else
			$ssp_include_hashtags = '';
        $ssp_include_hashtags =($ssp_include_hashtags == 1) ? 'checked' : '';
        if (isset($sp_settings[SSP_CHANNEL]['settings']['ssp_inc_hash_val']))
			$ssp_inc_hash_val =  $sp_settings[SSP_CHANNEL]['settings']['ssp_inc_hash_val'];
		else
			$ssp_inc_hash_val = '';
			
        $ssp_hash_cat_chk = isset($sp_settings[SSP_CHANNEL]['settings']['ssp_hash_cat_chk']) ? $sp_settings[SSP_CHANNEL]['settings']['ssp_hash_cat_chk'] : '';
        $ssp_hash_cat_chk =($ssp_hash_cat_chk == 1) ? 'checked' : '';
        if (isset($sp_settings[SSP_CHANNEL]['settings']['ssp_cat_hash_val']))
			$ssp_cat_hash_val =  $sp_settings[SSP_CHANNEL]['settings']['ssp_cat_hash_val'];
		else
			$ssp_cat_hash_val[0] = '';
        if (isset($sp_settings[SSP_CHANNEL]['settings']['ssp_hash_cat']))
			$ssp_hash_cat =  $sp_settings[SSP_CHANNEL]['settings']['ssp_hash_cat'];
		else
			$ssp_hash_cat[0] = '';


        $blab_player_position =  isset($sp_settings[SSP_CHANNEL]['settings']['sbp_blab_player_position']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_blab_player_position'] : '';
        $blab_player_position1 = ($blab_player_position == 'above') ? 'selected=selected' : '';
        $blab_player_position2 = ($blab_player_position == 'below') ? 'selected=selected' : '';
        $blab_player_position3 = ($blab_player_position == 'disabled') ? 'selected=selected' : '';

        $blab_caption_position =  isset($sp_settings[SSP_CHANNEL]['settings']['sbp_blab_caption_position']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_blab_caption_position'] : '';
        $blab_caption_position1 = ($blab_caption_position == 'off') ? 'selected=selected' : '';
        $blab_caption_position2 = ($blab_caption_position == 'top') ? 'selected=selected' : '';
        $blab_caption_position3 = ($blab_caption_position == 'bottom') ? 'selected=selected' : '';

        

        $sbp_allcategories = get_terms('category','hide_empty=0&orderby=name'); 
        $sbp_catselechtml ='<select id="cat" name="sbp_cat" class="postform" >';
       foreach( $sbp_allcategories as $term) { 
                            $selectedcat = '';
                            if($sbp_category == $term->term_id){
                                $selectedcat =  'selected=selected';
                            }
                       $sbp_catselechtml .= '<option  value="'. $term->term_id .'" '.$selectedcat.'>'.$term->name.'</option>';
                        }       
            $sbp_catselechtml .=        '</select>';
      

        
        
       $sbp_profilelist = get_option('sbp_fbpages');
       //$sbp_fbid = get_option('sbp_fb_userid');
       //$sbp_fbname = get_option('sbp_fb_username');
      //echo '<pre>'; print_r($sbp_profilelist); exit;
       $sbp_profileselechtml ='<select id="sbp_profile" name="sbp_profile" class="postform" >';
       //$sbp_profileselechtml .= '<option  value="'. $sbp_fbid .'" '.$selectedprofile.'>Personal Profile</option>';
       foreach( $sbp_profilelist as $profile) { 
                            $selectedprofile = '';
                            if($sbp_profile == $profile['id']){
                                $selectedprofile =  'selected=selected';
                            }
                       $sbp_profileselechtml .= '<option  value="'. $profile['id'] .'" '.$selectedprofile.'>'.$profile['name'].'</option>';
       }       
       $sbp_profileselechtml .=        '</select>';
      
        $sbp_authorlist ='<select id="sbp_author" name="sbp_author" class="postform" >';
            $sbp_author = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_author']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_author'] : '';

        $authors=get_users();
        if (count($authors) > 1000 )
            $authors=get_users('role=administrator');


            $i=0;
            //get all users list
            foreach($authors as $author){
                    $selectedauthor = '';
                    if($sbp_author == $author->data->ID){
                                $selectedauthor =  'selected=selected';
                            }
                $sbp_authorlist .= '<option  value="'. $author->data->ID .'" '.$selectedauthor.'>'.$author->data->display_name.'</option>';
            }
        $sbp_authorlist .='</select>';
        $sbp_channel_image = get_option('sfp_channel_image');
        $sbp_container_width = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_container_width']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_container_width'] : '';
        $sbp_container_height = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_container_height']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_container_height'] : '';
        $sbp_minbutton_width = isset($sp_settings[SSP_CHANNEL]['settings']['sbp_minbutton_width']) ? $sp_settings[SSP_CHANNEL]['settings']['sbp_minbutton_width'] : '';
        $exp_days = $this->get_fb_access_token_expiry();
        if ($exp_days <= 0){
          $message = 'Facebook Connection expired. Click to "Reconnect Facebook Account" button below to continue importing new videos.<br><br>';
        }
        else if ($exp_days <= 7){
          $message = 'Facebook Connection expires in '. $exp_days .' days. Click the "Reconnect Facebook Account" button below to avoid issues importing new videos.<br><br>';
        } else {
          $message = 'Videos not importing? Click the "Reconnect Facebook Account" button below.';
        }
        $html =' 
            <div class="container-fluid">
              <div class="well well-1">
                <div class="row-fluid">
                  <span class="span8">
                    <div class="row-fluid">
                      <div class="sbp-logo">
                      </div>                            
                      <span class="span12">
                                         <h4 style="background-color:#fceaee;">Want to distribute your Facebook Lives + Videos to YouTube, LinkedIn, Instragram, and Twitter?<br>Try our latest <a href="https://repurpose.io/?aff=ssp" target="_new">content distribution platform for FREE today</a>.<br><br></h4>
                      </span>
                      <span class="span12" style="font-size:15px;color:red"><strong>'.$message.'</strong></span><br><br>
                      	
                      <span class="span12" style="font-size:15px">
                                         Need Additional Help? Check out the <a href="http://www.simplesocialpress.com/quickstartguide.pdf" target="_new">Quick Start Guide</a> or <a href="https://support.repurpose.io/en/category/simple-social-press-5t04pn/">Contact Our Support Team</a>.<br><br>
                                         Loving SSP? Share the love on <a href="https://www.facebook.com/sharer/sharer.php?u=http://simplepodcastpress.com/ssp/?ref='.$refID.'" target="_blank">Facebook</a>, <a href="https://twitter.com/intent/tweet?text=I%20love%20%23SimpleSocialPress!%20It%20automatically%20publishes%20Facebook%20Live%20replays%20to%20my%20%23WordPress%20site%20%2D&url=http://simplepodcastpress.com/ssp/?ref='.$refID.'" target="_blank">Twitter</a>, <a href="https://plus.google.com/share?url=http://simplepodcastpress.com/ssp/?ref='.$refID.'" target="_blank">Google Currents</a> (your affiliate link will be shared)
                      </span>
                    </div>
                  </span>
                  <span class="span4">
                    <div class="row-fluid">
                    <span class="span8">
                        <p></p>
                      </span>
                      <span class="span4 userimage" > 
                        <img src="'.$sbp_channel_image.'" class="imagenotround" >
                      </span>
                    </div>
                  </span>
                </div>
              </div>
              ';
     
                $html .= '
            <div class="well well-1">
                <div class="page-header page-header-2">
                  <h1> <small>Publish Settings</small> 
                  </h1>
                </div>
                <div class="row-fluid">
                  <span class="span6">
                    <label class="checkbox">
                      <input type="checkbox" name="sbp_auto_publish" id="sbp_auto_publish"  '.$sbp_auto_publish1.' />
                      <span></span>
                      <span>Auto publish Facebook posts</span>
                      <br>
                    </label>
                  </span>
                  <span class="span6">
                    <div class="row-fluid">
                      <span class="span12">  <a data-content="When this option is selected, Simple Social Press will automatically publish the new live replay posts. If this is deselected, then the live replay posts will remain as drafts." data-original-title="Auto Publish Live Replay Posts" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
                </div>
                 
                <!-- Disable Draft Email For Now
                <div class="row-fluid sbp_emaildraft" style="'.$sbp_draft_row_display.'">
                  <span class="span6" >
                    <label class="checkbox">
                      <input type="checkbox" name="sbp_email_on_draft" id="sbp_email_on_draft" '.$sbp_email_on_draft.'  />
                      <span></span>
                      <span>Email me each time a <strong>draft</strong> Facebook post is created</span>
                      <br>
                    </label>
                  </span>
                  <span class="span6">
                    <div class="row-fluid">
                      <span class="span12"> <a data-content="When this option is selected, you will receive an email each time a draft live replay post is created by Simple Social Press. Note that if the auto publish option is en-abled, you will not receive any emails." data-original-title="Draft Notification" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
                </div>
                -->
                
				<div class="row-fluid">
                  <span class="span6">
                    Choose the Facebook Profile or Page To Import Videos From
                  </span>
                  <span class="span2" style="height:10px; width: 16%;">
						'.$sbp_profileselechtml.'
					   </select>
                  </span>
                </div>
                      
                      <br>
                      
                <div class="row-fluid">
                  <span class="span6">
                    Select Facebook Videos to Import
                  </span>
                  <span class="span2" style="height:10px; width: 16%;">
						<select id="sbp_import_select" name="sbp_import_select" style="width: 200px;">
						<option value="0" '.$sbp_import_selected1.'>All (Default)</option>
						<option value="1" '.$sbp_import_selected2.'>Disable Import</option>
						<option value="2" '.$sbp_import_selected3.'>Only After Specific Date</option>
					   </select>
                  </span>
					<span class="span3 date_textbox" style="'.$date_textbox_display.'">
                    <input class="sbp_ep_specific_date" type="text" placeholder="Select Date ...." value="'.$sbp_ep_specific_date.'" name="sbp_ep_specific_date" style="width:128px">
                    </span>
                </div>                
                
                <br>
                
                 <div class="row-fluid row-fluid-1">
                  <span class="span6">
                    Choose Which Types Of Videos To Import
                  </span>
                  <span class="span6">
						<select name="sbp_videotype_select" style="width: 200px;">
						<option value="0" '.$sbp_videotype_select1.'>Facebook Lives (Default)</option>
						<option value="1" '.$sbp_videotype_select2.'>All Videos</option>
						<option value="2" '.$sbp_videotype_select3.'>Non-Live Videos</option>
					   </select>
                  </span>
                </div>
                      
                      
                <div class="row-fluid row-fluid-1">
                  <span class="span6">
                    Enable Facebook Image Import and Set As Featured Image
                  </span>
                  <span class="span6">
						<select name="sbp_ep_art_select" style="width: 200px;">
						<option value="0" '.$sbp_ep_art_select1.'>On (Default)</option>
						<option value="1" '.$sbp_ep_art_select2.'>Off</option>
					   </select>
                  </span>
                </div>
                
               
                      
                <div class="row-fluid">
                  <span class="span6">
                    Choose a WordPress category for your Facebook posts
                  </span>
                  <span class="span6">
                    <div class="row-fluid">
                      <span class="span7">
                        '.$sbp_catselechtml.'
                      </span>
                      <span class="span5"></span>
                    </div>
                  </span>
                </div>
                <div class="row-fluid">
                  <span class="span6">
                    Choose an author for the Facebook posts
                  </span>
                  <span class="span6">
                    <div class="row-fluid">
                      <span class="span7">
                        '.$sbp_authorlist.'
                      </span>
                      <span class="span5"></span>
                    </div>
                  </span>
                </div>
                <div class="row-fluid">
                  <span class="span6">
                    Choose a custom post type for your Facebook posts
                  </span>
                  <span class="span6">
                    <div class="row-fluid">
                      <span class="span7">
                        '.$sbp_cpt_dropdown.'
                      </span>
                    </div>
                  </span>
                </div>
                <div class="row-fluid">
                  <span class="span6">
                    Choose a post format
                  </span>
                  <span class="span6">
                    <div class="row-fluid">
                      <span class="span7">
                        '.$ssp_post_format.'
                      </span>
                    </div>
                  </span>
                </div>
			<div class="row-fluid">
				<span class="span6" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="ssp_exclude_hashtags" id="ssp_exclude_hashtags" '.$ssp_exclude_hashtags.' >
                      <span>Exclude videos that contain the following hashtags
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span2" style="height:auto !important;">
                    <input type="text" placeholder="#hashtag1, #hashtag2, etc" value="'.$ssp_exc_hash_val.'" name="ssp_exc_hash_val" style="width:190px">
                    </span>
                   <span class="span3">
                    <div class="row-fluid">
                      <span class="span12">  <a data-content="Comma separated list of #hastags that you want to exclude during import if the title or description contains one of these hashtags." data-original-title="Exclude videos that Include the following Hashtags" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
             </div>   
			<div class="row-fluid">
				<span class="span6" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="ssp_include_hashtags" id="ssp_include_hashtags" '.$ssp_include_hashtags.' >
                      <span>Only import videos that contain the following hashtags
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span2" style="height:auto !important;">
                    <input type="text" placeholder="#hashtag1, #hashtag2, etc" value="'.$ssp_inc_hash_val.'" name="ssp_inc_hash_val" style="width:190px">
                    </span>
                   <span class="span3">
                    <div class="row-fluid">
                      <span class="span12">  <a data-content="Comma separated list of #hastags that you want to include during import if the title or description contains one of these hashtags.  Other videos will not be imported." data-original-title="Import videos that Include the following Hashtags" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
             </div>   
			<div class="row-fluid">
				<span class="span6" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="ssp_hash_cat_chk" id="ssp_hash_cat_chk" '.$ssp_hash_cat_chk.' >
                      <span>Import videos into specific categories based on hashtags
                        </br></br>
                      </span> </label>
                    </span>
				</div>';
	$clone_count = count($ssp_cat_hash_val);
	if ($clone_count <= 0)
		$clone_count = 1;
	
	for ($i=0; $i < $clone_count; $i++){
			if ($i >= 1){
				$remove = '<a class="remove" href="#" onclick="jQuery(this).parent().slideUp(function(){ jQuery(this).remove() }); return false">Remove</a>';
			}else{
				$remove = '';
			}
		$sbp_hashtags_cats ='<select id="cat" name="ssp_hash_cat[]" class="postform" >';
			   foreach( $sbp_allcategories as $term) { 
                            $selectedcat = '';
                            if($ssp_hash_cat[$i] == $term->term_id){
                                $selectedcat =  'selected=selected';
                            }
                       $sbp_hashtags_cats .= '<option  value="'. $term->term_id .'" '.$selectedcat.'>'.$term->name.'</option>';
                        }       
				  $sbp_hashtags_cats .=        '</select>';
				//if (!empty($ssp_cat_hash_val[$i])){
					$html .='
						<div class="row-fluid clone">
							<span class="span1" style="height:auto !important;">
							</span>
								<span class="span2" style="height:auto !important;">
								<input type="text" placeholder="#hashtag" value="'.$ssp_cat_hash_val[$i].'" name="ssp_cat_hash_val[]" style="width:180px">
								</span>
							   <span class="span3">
								<div class="row-fluid">
								  '.$sbp_hashtags_cats.'
								</div>
							  </span>
							'.$remove.'
						 </div> '; 
					//}
			}//end for loop
		$html .='
               <div class="row-fluid">
					<span class="span3" style="height:auto !important;">
					</span>
						<span class="span2" style="height:auto !important;">
								<p><a href="#" class="add" rel=".clone">Add More</a></p>
						</span>
					</div>  

        </div>
        ';
        
        $html .= '
         <div class="well">
             <div class="page-header page-header-1">
                  <h1> <small>Player Style Settings</small> 
                  </h1>
                </div>';
      
                           
            
      $html .= '
                <div class="row-fluid">
                    <span class="span6">
                            <label class="span6">
                              <span>Facebook player default location
                                </br>
                              </span> </label>
                     </span>
                    <span class="span7"  style="height: auto ! important; width: 19%;">
                       <select name="blab_player_position">
                          <option value="above" ' . $blab_player_position1 . '>Above page content</option>
                           <option value="below" '. $blab_player_position2.'>Below page content</option>
                           <option value="disabled" '. $blab_player_position3.'>Disabled</option>
                        </select>
                     </span>
                </div>                      
                ';

        /* $html .= '
                <div class="row-fluid">
                    <span class="span6">
                            <label class="span6">
                              <span>Facebook video caption into the post
                                </br>
                              </span> </label>
                     </span>
                    <span class="span7"  style="height: auto ! important; width: 19%;">
                       <select name="blab_caption_position">
                          <option value="off" ' . $blab_caption_position1 . '>Off</option>
                           <option value="top" '. $blab_caption_position2.'>Top</option>
                           <option value="bottom" '. $blab_caption_position3.'>Bottom</option>
                        </select>
                     </span>
                </div>                      
                '; */

          $html .= '
        <br>
        <div class="row-fluid row-fluid-1">
            <span style="height:auto !important;" class="span3">
                    <label>
                      <span>Facebook Player Width
                       <br><br>
                      </span> </label>
                    </span>
                    <span class="span3">
                    <input type="text" placeholder="Auto" value="'.$sbp_container_width.'" name="sbp_container_width" style="width:105px"> px
                    </span>
                                      <span class="span6">
                    <div class="row-fluid">
                      <span class="span12">  <a data-content="Set a custom width for the Facebook video player (including the call to action buttons and opt-in if enabled).  Note that when a value is entered, it may affect the look of the player on mobile sites.  To set an automatic width, simply delete the contents of the input box." data-original-title="Facebook Player Width" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
             </div>   
             <br>
             <div class="row-fluid row-fluid-1">
            <span style="height:auto !important;" class="span3">
                    <label>
                      <span>Facebook Player Height
                       <br><br>
                      </span> </label>
                    </span>
                    <span class="span3">
                    <input type="text" placeholder="Auto" value="'.$sbp_container_height.'" name="sbp_container_height" style="width:105px"> px
                    </span>
                                      <span class="span6">
                    <div class="row-fluid">
                      <span class="span12">  <a data-content="Set a custom height for the Facebook video player (including the call to action buttons and opt-in if enabled).  Note that when a value is entered, it may affect the look of the player on mobile sites.  To set it back to the default height of auto, simply delete the contents of the input box." data-original-title="Facebook Player Height" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
             </div>   
             <br>
             <div class="row-fluid row-fluid-1">
            <span style="height:auto !important;" class="span3">
                    <label>
                      <span>Minimum Button Width
                       <br><br>
                      </span> </label>
                    </span>
                    <span class="span3">
                    <input type="text" placeholder="130" value="'.$sbp_minbutton_width.'" name="sbp_minbutton_width" style="width:105px"> px
                    </span>
                                      <span class="span6">
                    <div class="row-fluid">
                      <span class="span12">  <a data-content="Set a minimum button width for the Facebook video player buttons. This is just a minimum size.  The actual size of the button may be larger depending on the amount of text inside the button.  To set it back to the default value, simply delete the contents of the input box." data-original-title="Button Minimum Width" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
             </div>   
             <br>
                   
             
		
        <!-- Hide This Option For Now
        <div class="row-fluid row-fluid-4" >
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="sbp_btn_downloadaudio" id="sbp_btn_downloadaudio" '.$sbp_btn_downloadaudio.' >
                      <span><i>Listen To Audio</i> button
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span2" style="height: auto ! important;">
                    	<input type="text" name="sbp_btn_downloadaudio_color" id="sbp_btn_downloadaudio_color" style="width:90px" value="'.$sbp_btn_downloadaudio_color.'" >
                    </span>
                    <span class="span3" style="height: auto ! important;">
                   		<input type="text" name="sbp_btn_downloadaudio_name" id="sbp_btn_downloadaudio_name" style="width:220px" value="'.$sbp_btn_downloadaudio_name.'" placeholder="Listen To The Audio Version" >
                    </span>
         </div>
         -->
         
         <div class="row-fluid row-fluid-4" >
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="sbp_btn_followblab" id="sbp_btn_followblab" '.$sbp_btn_followblab.' >
                      <span><i>Connect on Facebook</i> button
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span2" style="height: auto ! important;">
                    	<input type="text" name="sbp_btn_followblab_color" id="sbp_btn_followblab_color" style="width:90px" value="'.$sbp_btn_followblab_color.'" >
                    </span>
                    <span class="span3" style="height: auto ! important;">
                   		<input type="text" name="sbp_btn_followblab_name" id="sbp_btn_followblab_name" style="width:220px" value="'.$sbp_btn_followblab_name.'" placeholder="Connect on Facebook" >
                    </span>
         </div>
         <div class="row-fluid row-fluid-4" >
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="sbp_btn_share" id="sbp_btn_share" '.$sbp_btn_share.' >
                      <span><i>Social Share</i> button
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span2" style="height: auto ! important;">
                    	<input type="text" name="sbp_btn_share_color" id="sbp_btn_share_color" style="width:90px" value="'.$sbp_btn_share_color.'" >
                    </span>
				 <span class="span3" style="height: auto ! important;">
                   		<input type="text" name="sbp_btn_share_name" id="sbp_btn_share_name" style="width:220px" value="'.$sbp_btn_share_name.'" placeholder="Share" >
                    </span>
         </div>
         <div class="row-fluid row-fluid-4" >
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="sbp_btn_custom1" id="sbp_btn_custom1" '.$sbp_btn_custom1.' >
                      <span><i>Custom</i> button
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span2" style="height: auto ! important;">
                    	<input type="text" name="sbp_btn_custom_color1" id="sbp_btn_custom_color1" style="width:90px" value="'.$sbp_btn_custom_color1.'" >
                    </span>
                    <span class="span3" style="height: auto ! important;">
                   		<input type="text" name="sbp_btn_custom_name1" id="sbp_btn_custom_name1" style="width:220px" value="'.$sbp_btn_custom_name1.'" placeholder="Button Name ..." >
                    </span>
                    <span class="span3"  style="height: auto ! important; width: 19%;">
                   		<input type="text" name="sbp_btn_custom_url1" id="sbp_btn_custom_url1" style="width:250px" value="'.$sbp_btn_custom_url1.'" placeholder="Enter Button URL ..." >
                    </span>
         </div>
		<div class="row-fluid row-fluid-4" >
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="sbp_btn_custom2" id="sbp_btn_custom2" '.$sbp_btn_custom2.' >
                      <span><i>Custom</i> button
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span2" style="height: auto ! important;">
                    	<input type="text" name="sbp_btn_custom_color2" id="sbp_btn_custom_color2" style="width:90px" value="'.$sbp_btn_custom_color2.'" >
                    </span>
                    <span class="span3" style="height: auto ! important;">
                   		<input type="text" name="sbp_btn_custom_name2" id="sbp_btn_custom_name2" style="width:220px" value="'.$sbp_btn_custom_name2.'" placeholder="Button Name ..." >
                    </span>
                    <span class="span3"  style="height: auto ! important; width: 19%;">
                   		<input type="text" name="sbp_btn_custom_url2" id="sbp_btn_custom_url2" style="width:250px" value="'.$sbp_btn_custom_url2.'" placeholder="Enter Button URL ..." >
                    </span>
         </div>
		<div class="row-fluid row-fluid-4" >
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="sbp_btn_custom3" id="sbp_btn_custom3" '.$sbp_btn_custom3.' >
                      <span><i>Custom</i> button
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span2" style="height: auto ! important;">
                    	<input type="text" name="sbp_btn_custom_color3" id="sbp_btn_custom_color3" style="width:90px" value="'.$sbp_btn_custom_color3.'" >
                    </span>
                    <span class="span3" style="height: auto ! important;">
                   		<input type="text" name="sbp_btn_custom_name3" id="sbp_btn_custom_name3" style="width:220px" value="'.$sbp_btn_custom_name3.'" placeholder="Button Name ..." >
                    </span>
                    <span class="span3"  style="height: auto ! important; width: 19%;">
                   		<input type="text" name="sbp_btn_custom_url3" id="sbp_btn_custom_url3" style="width:250px" value="'.$sbp_btn_custom_url3.'" placeholder="Enter Button URL ..." >
                    </span>
         </div>
         <div class="row-fluid row-fluid-4" >
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="sbp_btn_custom4" id="sbp_btn_custom4" '.$sbp_btn_custom4.' >
                      <span><i>Custom</i> button
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span2" style="height: auto ! important;">
                    	<input type="text" name="sbp_btn_custom_color4" id="sbp_btn_custom_color4" style="width:90px" value="'.$sbp_btn_custom_color4.'" >
                    </span>
                    <span class="span3" style="height: auto ! important;">
                   		<input type="text" name="sbp_btn_custom_name4" id="sbp_btn_custom_name4" style="width:220px" value="'.$sbp_btn_custom_name4.'" placeholder="Button Name ..." >
                    </span>
                    <span class="span3"  style="height: auto ! important; width: 19%;">
                   		<input type="text" name="sbp_btn_custom_url4" id="sbp_btn_custom_url4" style="width:250px" value="'.$sbp_btn_custom_url4.'" placeholder="Enter Button URL ..." >
                    </span>
         </div>
		<div class="row-fluid row-fluid-4" >
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="sbp_btn_custom5" id="sbp_btn_custom5" '.$sbp_btn_custom5.' >
                      <span><i>Custom</i> button
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span2" style="height: auto ! important;">
                    	<input type="text" name="sbp_btn_custom_color5" id="sbp_btn_custom_color5" style="width:90px" value="'.$sbp_btn_custom_color5.'" >
                    </span>
                    <span class="span3" style="height: auto ! important;">
                   		<input type="text" name="sbp_btn_custom_name5" id="sbp_btn_custom_name5" style="width:220px" value="'.$sbp_btn_custom_name5.'" placeholder="Button Name ..." >
                    </span>
                    <span class="span3"  style="height: auto ! important; width: 19%;">
                   		<input type="text" name="sbp_btn_custom_url5" id="sbp_btn_custom_url5" style="width:250px" value="'.$sbp_btn_custom_url5.'" placeholder="Enter Button URL ..." >
                    </span>
         </div>
		<div class="row-fluid row-fluid-4" >
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="sbp_btn_custom6" id="sbp_btn_custom6" '.$sbp_btn_custom6.' >
                      <span><i>Custom</i> button
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span2" style="height: auto ! important;">
                    	<input type="text" name="sbp_btn_custom_color6" id="sbp_btn_custom_color6" style="width:90px" value="'.$sbp_btn_custom_color6.'" >
                    </span>
                    <span class="span3" style="height: auto ! important;">
                   		<input type="text" name="sbp_btn_custom_name6" id="sbp_btn_custom_name6" style="width:220px" value="'.$sbp_btn_custom_name6.'" placeholder="Button Name ..." >
                    </span>
                    <span class="span3"  style="height: auto ! important; width: 19%;">
                   		<input type="text" name="sbp_btn_custom_url6" id="sbp_btn_custom_url6" style="width:250px" value="'.$sbp_btn_custom_url6.'" placeholder="Enter Button URL ..." >
                    </span>
         </div>
		<div class="row-fluid row-fluid-4" >
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      	<input type="checkbox" name="sbp_LeadBox_btn_checkbox" id="sbp_LeadBox_btn_checkbox" '.$sbp_LeadBox_btn_checkbox.' >
                      <span><i>LeadBox</i> button
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span2" style="height: auto ! important;">
                    	<input type="text" name="sbp_LeadBox_btn_color" id="sbp_LeadBox_btn_color" style="width:90px" value="'.$sbp_LeadBox_btn_color.'" >
                    </span>
                    <span class="span3"  style="height: auto ! important; width: 19%;">
						<textarea id="sbp_LeadBox_btn_code" name="sbp_LeadBox_btn_code" style="width: 576px; height: 117px;" class="span11" placeholder=" Paste LeadPages LeadBox HTML code here.">'. htmlspecialchars_decode($sbp_LeadBox_btn_code, ENT_QUOTES) .'</textarea>
  
                    </span>
         </div>
                             
                   
             <div class="row-fluid row-fluid-1" >
            
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      <input type="checkbox" name="sbp_btn_style_round" id="sbp_btn_style_round" '.$sbp_btn_style_round.' >
                      <span>Enable Round Buttons
                        </br></br>
                      </span> </label>
                    </span>
                   
             </div>
               
            <div class="row-fluid row-fluid-4">
                  <span class="span6">
                    <label class="checkbox">
                      <input type="checkbox" name="disable_player_excerpt" id="disable_player_excerpt" '.$disable_player_excerpt.' >
                      <span>Disable Player and Text from Home, Blog, or Archive Pages
                        </br></br>
                      </span>
                    </label>
                  </span>
                  <span class="span3">
                    <div class="row-fluid">
                      <span class="span12"> <a data-content="When this option is selected, the Simple Social Press embedded player will not appear on the home, blog or archive pages.  This option is also used to remove the random player text that appears on some home or archive pages on some themes" data-original-title="Disable Player on Home Page" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
                </div>
                
             
                  
        <div class="row-fluid">
                  <span class="span6">
                    <label class="checkbox">
                      <input type="checkbox" name="sbp_show_data" id="sbp_show_data"  '.$sbp_show_data.' />
                      <span></span>
                      <span>Show Comments / Likes / Shares Below Video</span>
                      <br>
                    </label>
                  </span>
                  <span class="span6">
                    <div class="row-fluid">
                      <span class="span12">  <a data-content="When this option is selected, Simple Social Press will Show Comments / Likes / Shares Below Video." data-original-title="Show Comments / Likes / Shares Below Video" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
                </div>
                	
					
                <div class="row-fluid row-fluid-4" >
            <span class="span6" style="height:auto !important;">
                    <label class="checkbox">
                      <input type="checkbox" name="sbp_disable_poweredby" id="sbp_disable_poweredby" '.$sbp_disable_poweredby.'>
                      <span></span>
                      <span>Disable "Powered by" Link Below Player 
                        </br></br>
                      </span> </label>
                    </span>
                     <span class="span5" style="height: auto ! important; width: 30%;">
                    <input type="text" name="sbp_poweredby_url" id="sbp_poweredby_url" style="width:350px" value="'.$sbp_poweredby_url.'" placeholder="Only Enter Your Affiliate ID Number Here (i.e 12)" ><a href="http://simplesocialpress.com/affiliate-area/" target="_blank"></br>Earn Commission. Click Here To Get Your Affilliate ID.</a>
                    </span>
             </div>   
             </br>
        </div>';
              $args = array(
    'post_type'      => 'page',
    'posts_per_page' => -1,
    'order'          => 'ASC',
    'orderby'        => 'menu_order'
 );


$parent = new WP_Query( $args );
$pages = '
			<div class="row-fluid" >
            	<span class="span3" style="height:auto !important;">
                	    <label class="checkbox">
                      	<span>Select Privacy Page
                        	</br></br>
                      	</span> </label>
                    </span>
						<span class="span3">
	                    <select name="ssp_privacy_page" id="ssp_privacy_page">';
										
										$pages .=	'<option value="disabled"   selected=selected>Disabled</option>';

						if ( $parent->have_posts() ) : 

							 while ( $parent->have_posts() ) : $parent->the_post(); 
										if ($ssp_privacy_page == get_the_ID()){ $selectedpage = "selected=selected";}else	{$selectedpage='';}	
										$pages .=	'<option value="'.get_the_ID().'"   '.$selectedpage.'>'.get_the_title().'</option>';
							 endwhile; 
						 endif;

						$pages .=
							'</select>
							  </span>
								</div> 
							 <div class="row-fluid">
										<span class="span3" style="height:auto !important;">
												<label class="checkbox">
												  <span>Privacy Policy Text
													</br></br>
												  </span> </label>
												</span>
												<span class="span4">
												<textarea id="ssp_privacy_policy_text" name="ssp_privacy_policy_text" class="span11" placeholder="I have read and agreed to your Privacy Policy">'.$ssp_privacy_policy_text .' </textarea>
												</span>
							</div> ';
					 
		wp_reset_query(); 

$html .= '

        <div class="well well-1">
                <div class="page-header page-header-1">
                  <h1> <small>Opt-in Box Settings</small> 
                  </h1>
                </div>
                <div class="row-fluid row-fluid-4">
                  <span class="span12">
                    <label class="checkbox">
                      <input type="checkbox" name="sbp_optin_box" id="sbp_optin_box" '.$sbp_optin_box .' />
                      <span></span>
                      <span>Automatically Add Opt-in Box Below Player
                        <br>
                      </span>
                    </label>
                  </span>
                </div>
'.$pages.'
			<div class="row-fluid" >
            	<span class="span3" style="height:auto !important;">
                	    <label class="checkbox">
                      	<span>Opt-in Style
                        	</br></br>
                      	</span> </label>
                    </span>
						<span class="span3">
	                    <select name="sbp_two_step_optin" id="sbp_two_step_optin">
							<option value="1" '. $sbp_two_step_optin_selected1 .'>Name and Email</option>
							<option value="2" '. $sbp_two_step_optin_selected2 .'>Email Address Only</option>
							<option value="3" '. $sbp_two_step_optin_selected3 .'>Two Step Opt-in Name and Email</option>
							<option value="4" '. $sbp_two_step_optin_selected4 .'>Two Step Opt-in Email Only</option>
						
						</select>
                    	</span>
		    </div>  
        <div class="optsettings" style="'.$sbp_optin_row_display.'" >
        <div class="row-fluid">
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      <span>Submit Button Color
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span4">
                    <input type="text" name="sbp_submit_button_color" id="sbp_submit_button_color" style="width:90px" value="'.$sbp_submit_button_color.'" >
                    </span>
             </div>   
        <div class="row-fluid" >
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      <span>Submit Button Text Color
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span4">
                    <input type="text" name="sbp_submit_button_text" id="sbp_submit_button_text" style="width:90px" value="'.$sbp_submit_button_text.'" >
                    </span>
             </div>   
        <div class="row-fluid" >
            <span class="span3" style="height:auto !important;">
                    <label class="checkbox">
                      <span>Opt-in Box Container Color
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span4">
                    <input type="text" name="sbp_opt_container_color" id="sbp_opt_container_color" style="width:90px" value="'.$sbp_opt_container_color.'" >
                    </span>
             </div>   
        </br>
                <div class="row-fluid">
                  <span class="span5">
                    <label class="control-label">Opt-in box headline</label>
                    <input class="textinput span12" type="text" name="sbp_auto_resp_heading" placeholder="Enter headline here" value="'. $sbp_auto_resp_heading_get .'">
                  </span>
                  <span class="span7">
                    <div class="row-fluid">
                      <span class="span9 offset1">
                        <label class="control-label">Opt-in box sub headline</label>
                        <input class="textinput span12" type="text"  placeholder="Enter sub headline here" value="'. $sbp_auto_resp_sub_heading_get.'" name="sbp_auto_resp_sub_heading" />
                      </span>
                    </div>
                  </span>
                </div>
                <label class="control-label control-label-2">Opt-in form HTML code</label>
                <textarea id="sbp_jwsqz_autocode" name="sbp_optin_old_code" class="span11" placeholder="Paste your HTML code here.  Opt-in form should only include First Name and Email Address fields.">'. htmlspecialchars_decode($sbp_optin_old_code_get,ENT_QUOTES) .'</textarea>
                <input type="hidden" name="sbp_auto_resp_url" id="sbp_jwsqz_autoformurl" value="'. $sbp_auto_resp_url_get .'">
                <textarea style="display:none;" name="sbp_auto_resp_hidden" cols="70" rows="5" id="sbp_jwsqz_autohidden">'. htmlspecialchars_decode($sbp_auto_resp_hidden_get, ENT_QUOTES).'</textarea>
                 <input type="hidden" name="sbp_auto_resp_name" id="sbp_jwsqz_arnameinput" value="'. htmlspecialchars_decode($sbp_auto_resp_name_get, ENT_QUOTES) .'">
                 <input type="hidden" name="sbp_auto_resp_email" id="sbp_jwsqz_aremailinput" value="'. htmlspecialchars_decode($sbp_auto_resp_email_get, ENT_QUOTES).'"><br>
                <div class="row-fluid">
                  <span class="span12">
                    <label class="control-label">Submit button text</label>
                    <input class="textinput span3" type="text"  placeholder="Enter submit button text here" value="'. stripslashes($sbp_auto_resp_submitt_get).'" name="sbp_auto_resp_submitt">
                  </span>
                </div>
                </div>
              </div>
        <div class="well">
             <div class="page-header page-header-1">
                  <h1> <small>Share Settings</small> 
                  </h1>
                </div>
                         <div class="row-fluid row-fluid-1">
                  <span class="span6">
                    <label class="checkbox">
                      <input type="checkbox" name="disable_opengraph" id="disable_opengraph" '.$disable_opengraph .' />
                      <span></span>
                      <span>Disable Facebook Open Graph Meta
                        <br>
                      </span>
                    </label>
                  </span>
                  <span class="span1">
                    <div class="row-fluid">
                      <span class="span7"> <a data-content="When this option is selected, the Simple Social Press will not output the Facebook Meta data.  This is usually disabled when your theme or another plugin already generates the required Facebook meta data." data-original-title="Disable Facebook Open Graph" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
                </div>           
        </div>
        
        
        <div class="well well-1">
            <div class="page-header page-header-1">
                <h1> <small>Advanced Tweaks (Most Setups Don\'t Require These Settings)</small></h1>
            </div>
                
             
			<!-- Hide This Option For Now
            <div class="row-fluid" >
            	<span class="span6" style="height:auto !important;">
                    <label class="checkbox">
                      <input type="checkbox" name="direct_download_button" id="direct_download_button" '.$direct_download_button.'>
                      <span></span>
                      <span>Force Download Button To Open MP3 In A New Window
                        </br></br>
                      </span> </label>
                    </span>
                    <span class="span1">
                    <div class="row-fluid">
                      <span class="span7"> <a data-content="When this option is selected, the download button will open the MP3 in a new window instead of directly downloading the file.  You can use this option if the Download Audio Button is not working on your website (which can happen on some hosting providers)" data-original-title="Open MP3 In New Window" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
             </div>   
             -->
             
              <div class="row-fluid">
                  <span class="span6">
                    <label class="checkbox">
                      <input type="checkbox" name="sbp_force_player_home" id="sbp_force_player_home" '.$sbp_force_player_home .' />
                      <span></span>
                      <span>Force Facebook Player on Home Page
                        </br></br>
                      </span>
                    </label>
                  </span>
                  <span class="span1">
                    <div class="row-fluid">
                      <span class="span7"> <a data-content="When this option is selected, the Simple Social Press Player is forced to appear on the home page.  This is only required on some themes that do not display the player on the home page. You can choose the location of the player (above or below the post excerpt) in the Player Styles Settings" data-original-title="Force Live Player" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
                </div>
                
                <div class="row-fluid">
                  <span class="span6">
                    <label class="checkbox">
                      <input type="checkbox" name="sbp_force_comments_off" id="sbp_force_comments_off" '.$sbp_force_comments_off .' />
                      <span></span>
                      <span>Disable Comment Importing
                        </br></br>
                      </span>
                    </label>
                  </span>
                  <span class="span1">
                    <div class="row-fluid">
                      <span class="span7"> <a data-content="When this option is selected, Simple Social Press Player will not import comments from WordPress to your posts" data-original-title="Force Live Player" rel="popover" class="icon icon-info-sign sbp_help">&nbsp;</a>
                      </span>
                    </div>
                  </span>
                </div>
                
                
            
        </div> 
              
              
              
              <div class="well">
                <div class="row-fluid">
                  <span class="span7">
                    <table>
                    <tr>
                    <td>
                        <input type="submit" class="btn btn-primary" name="sbp_cbsn_save" id="sbp_cbsn_save" value="Save Changes"> 
                    </td>
                    <td>
                            <span class="saved"></span>
                    </td>
                    </tr>
                    </table>
                  </span>
                                    
                  
                  <span class="span3">
                    <table>
                    <tr>
                    <td>
                    <input type="submit" class="btn" name="sbp_cbsn_reset" id="sbp_cbsn_reset" value="Reconnect Facebook Account">
                    </td>
                    <td>
                            <span class="reset"></span>
                    </td>
                    </tr>
                    </table>
                </span>
             </div>
              </div>
              
                <div class="alert alert-1" id="saved" style="display:none;"> </div>
                
  
                ';
   
                    $html .= '
                          <div class="well well-1 well-2">
                            <div class="page-header page-header-1">
                              <h1> <small>Manual Import (Required for Initial Import)</small> 
                              </h1>
                            </div>
                            <p><strong>The first time you install and configure this plugin, you will need to manually import all your Facebook videos.  This can be done using the button below.</strong>
                    </br></br>Under most circumstances, you won\'t need to use this button. &nbsp;Simple Social Press with automatically check for new live replays (once an hour) &nbsp;and import&nbsp;them automatically. &nbsp;If you need to import new live replays sooner than that, you can use the button below.</p><p><strong>Note: Depending on how many Facebook videos you have, it may take several minutes for the import to complete.</strong></p>
                            <div class="row-fluid">
                              <span class="span7">
                                <table>
                                <tr>
                                <td>
                                <input type="submit" class="btn" name="sbp_chk_new_blabs" id="sbp_chk_new_blabs" value="Import New Facebook Videos Now">
                                </td>
                                <td>
                                        <span  id="fetchresults"></span>
                                </td>
								<td>
								</td>
								</td>
								<td>
								</td>
								</td>
								<td>
                                <input type="submit" class="btn" name="cancel_new_blabs" id="cancel_new_blabs" value="Cancel Import" style="display:none; color:red;">
								</td>
                                </tr>
                                </table>
                              </span>
							<span class="span4">
								<table>
									<tr>
									
									<td>
											<input type="submit" name="manual_update" class="btn" id="fetch_comments" value="Import New Comments Now">
									</td>
									<td>
											<span  id="fetchcomments"></span>
									</td>
									<td>
										<input type="submit" class="btn" name="cancel_new_comments" id="cancel_new_comments" value="Cancel Import" style="display:none; color:red;">
									</td>
									</tr>
									</table>
								  </span>
                            </div>
                          </div>
                          <div class="alert fetchresults  fetchcomments" style="display:none;">       
                        </div>
                    ';
            
        
        echo $html;
}

function sbp_panel(){
 
        $html = '';
    
      
    $isLicenseValid = get_option('sspress_ls');
        
    if ($isLicenseValid !== 'valid') {
        $html = '
        Oops. Your Simple Social Press License Hasn\'t Been Activated Yet.  <a href="admin.php?page=ssp-license">Click Here to Activate It Now.</a></br></br>
        Don\'t Have a Full License Yet? <a target="_blank" href="http://simplesocialpress.com">Grab One from Here.</a></br></br>
        Need Help? Send us an email to <a href="mailto:support@simplesocialpress.com">support@simplesocialpress.com</a> and we will be more than happy to help you.<br><br>
        ';
    return $html;
    }
      
      
    if(isset($_POST['sbp_cbsn_reset']))	{
		global $wpdb;
		$table_sbp_streams	=  $wpdb->prefix . "ssp_streams";
		$sql0='DROP TABLE IF EXISTS '. $table_sbp_streams;
		$wpdb->query($sql0);
		
		//update_option('sfp_channel_image','');
		//update_option('sbp_blab_stream','');
		$this->delete_sbp_settings();
		
	}
      
      if ( (isset($_GET['access_token'])) or (isset($_GET['reload'])) ) {
            
          
            if (isset($_GET['access_token'])) {
            //$code = $_SESSION['sspcode'];
			$code = get_option('sfb_code');
            $response = wp_safe_remote_post( 'https://graph.facebook.com/'.FB_API_VER.'/device/login_status', array(
				'method' => 'POST',
				'timeout' => 45,
				'redirection' => 5,
				'httpversion' => '1.0',
				'blocking' => true,
				'headers' => array(),
				'body' => array( 'access_token' => SSPFAIS, 'code' => $code ),
				'cookies' => array()
				)
			);
		

            $response = json_decode($response['body']); 
            //$access_token = $response->access_token;
            //update_option('spp_token_response', $response);
            
                
            //if (isset($access_token)) 
            if (isset($response->access_token))
                  update_option('sfp_access_token',$response->access_token);
            }
                
            $access_token = get_option('sfp_access_token');  
            
            if (isset($access_token)) {

		         // Get the user ID
                $fb_api = 'https://graph.facebook.com/'.FB_API_VER.'/me?access_token='.$access_token;
                $fbObject = json_decode($this->url_get_contents($fb_api));
                $fbpersonalid = $fbObject->id;
                update_option('sbp_fb_username',$fbObject->name);
                update_option('sbp_fb_userid', $fbObject->id);
                
                // Get list of FB Pages for the user   
                $fb_api = 'https://graph.facebook.com/'.FB_API_VER.'/me/accounts?limit=100&access_token='.$access_token;
                $fbObject = json_decode($this->url_get_contents($fb_api));
                $sp_fbpages[0]['id'] = 'me';
                $sp_fbpages[0]['name'] = 'Personal Profile';
	
		        $i = 1;
                if (isset($fbObject->data)) {
                    foreach ($fbObject->data as $fbPage){
                       $sp_fbpages[$i]['id'] = $fbPage->id;
                       $sp_fbpages[$i]['name'] = $this->remove_emoji($fbPage->name);
                       $i++;
                    }

                }
            
                // Get list of FB Groups for the user   
                 
				$fb_api = 'https://graph.facebook.com/'.FB_API_VER.'/me/groups?fields=administrator,name&limit=100&access_token='.$access_token;
                $fbObject = json_decode($this->url_get_contents($fb_api));     
            	if (isset($fbObject->data)) {
                    foreach ($fbObject->data as $fbPage){
                        if ( (isset($fbPage->administrator)) && ($fbPage->administrator) ){
                            $sp_fbpages[$i]['id'] = $fbPage->id;	
                            $sp_fbpages[$i]['name'] = $this->remove_emoji($fbPage->name);
                            $i++;
                        }
                    }
                }
				
                // Update the option once at the end after adding them all to the array
                update_option('sbp_fbpages',$sp_fbpages);
                  
                // Get the user image
                //$fb_api = 'https://graph.facebook.com/'.FB_API_VER.'/me/picture?type=large&redirect=false&access_token='.$access_token;
				$fb_api = 'https://graph.facebook.com/'.FB_API_VER.'/me/picture?access_token='.$access_token;
                $fbObject = json_decode($this->url_get_contents($fb_api));
				//update_option('ssp_image_response',$fbObject);
				if (isset($fbObject->data->url))
				{
					$user_image = $fbObject->data->url;
					
				}


                 //	Start of getting and saving channel image                       
                 if (isset($user_image)) {
                      if ( !function_exists('media_handle_upload') ) {
                          require_once(ABSPATH . "wp-admin" . '/includes/image.php');
                          require_once(ABSPATH . "wp-admin" . '/includes/file.php');
                          require_once(ABSPATH . "wp-admin" . '/includes/media.php');
                      }

                      $url = $user_image;
                      $tmp = download_url( $url );
                      if( is_wp_error( $tmp ) ){
                          // download failed, handle error
                      }
                      $post_id = 0;
                      $desc = "Facebook Profile Image";
                      $file_array = array();

                      // Set variables for storage
                      // fix file filename for query strings
                      preg_match('/[^\?]+\.(jpg|jpe|jpeg|gif|png)/i', $url, $matches);
                      $file_array['name'] = basename($matches[0]);
                      $file_array['tmp_name'] = $tmp;

                      // If error storing temporarily, unlink
                      if ( is_wp_error( $tmp ) ) {
                          @unlink($file_array['tmp_name']);
                          $file_array['tmp_name'] = '';
                      }

                      // do the validation and storage stuff
                      $id = media_handle_sideload( $file_array, $post_id, $desc );

                      // If error storing permanently, unlink
                      if ( is_wp_error($id) ) {
                          @unlink($file_array['tmp_name']);
                          return $id;
                      }

                      $channel_image = wp_get_attachment_url( $id );

                      update_option('sfp_channel_image',$channel_image);


                  }    //	End of getting and saving channel art


                  $this->install_sbp_db();
                  //$this->sbp_save_stream_info();

            }
      }
      
      $access_token = get_option('sfp_access_token');
      
      if (empty($access_token)) {

            $response = wp_safe_remote_post( 'https://graph.facebook.com/'.FB_API_VER.'/device/login', array(
				'method' => 'POST',
				'timeout' => 45,
				'redirection' => 5,
				'httpversion' => '1.0',
				'blocking' => true,
				'headers' => array(),
				'body' => array( 'access_token' => SSPFAIS, 'scope' => 'user_videos,manage_pages,groups_access_member_info' ),
				'cookies' => array()
				)
			);
          
           /* $response = wp_safe_remote_post( 'https://graph.facebook.com/'.FB_API_VER.'/device/login', array(
				'method' => 'POST',
				'timeout' => 45,
				'redirection' => 5,
				'httpversion' => '1.0',
				'blocking' => true,
				'headers' => array(),
				'body' => array( 'access_token' => SSPFAIS, 'scope' => 'user_videos,manage_pages,business_management,groups_access_member_info' ),
				'cookies' => array()
				)
			);
            */
		  
		   /* $response = wp_safe_remote_post( 'https://graph.facebook.com/'.FB_API_VER.'/device/login', array(
				'method' => 'POST',
				'timeout' => 45,
				'redirection' => 5,
				'httpversion' => '1.0',
				'blocking' => true,
				'headers' => array(),
				'body' => array( 'access_token' => SSPFAIS, 'scope' => 'user_videos,manage_pages,user_managed_groups' ),
				'cookies' => array()
				)
			);
			*/
		  
		    //debug. printing response.
            //echo "Facebook response(debug): ";
            //print_r($response);
		  
            $response = json_decode($response['body']);
		  

		if (!isset($response->error)){

			$codeurl =  'admin.php?page=ssp-settings&access_token=true';
            
            //$_SESSION['sspcode'] = $response->code;
            update_option('sfb_code',$response->code);
             

            echo $html ='<h3>Simple Social Press<h3>
            <h4>
            </br>Step 1: Copy the following code: <em>' . $response ->user_code .'</em></br>
            </br>Step 2: Click the "Connect with Facebook" button below
            <p style="margin-top: 15px;"><a target="_blank" id="FacebookBtn" href="' . $response ->verification_uri . '" id="loginText" >
            <img src="'.SSPRESS_PLUGIN_URL .'/sbp_view/img/fbconnect.jpg" /></a></p>       
            </br>
             Step 3: On the next page, paste the code when prompted.
            </h4>
            </br>
             Once you\'ve done, click the button below to continue to the settings page.
             </br></br>
             <a href="' . $codeurl .'" class="button button-primary">Continue</a>';

		}else{

			if (isset($_POST['access_token'])){
				$access_token = $_POST['access_token'];
				$access_token = update_option('sfp_access_token', $access_token);
			echo "<script type='text/javascript'>window.top.location='".admin_url()."admin.php?page=ssp-settings&access_token=true&reload=true';</script>"; exit;
			}
   echo $html ='<h3>Simple Social Press<h3>
            <h4>
            </br>Step 1: <a href="https://simplesocialpress.com/fb/fbconnect.php" target="_new">Click here</a> and follow the instructions on that page to get your Access Token</h4>
            </br><h4>Step 2: Paste the Access Token below and click the <em>Continue</em> button</h4>
			<form action="'.admin_url().'admin.php?page=ssp-settings&reload=true" method="post" name="access_token_form">
			<input class="span8" type="text" name="access_token" /><br>
			<input type="submit" name="submit_token" value="Continue" class="button-primary" />
            </form>';

		}
            exit;
      }
      
      else {
            $this->sbp_settings();
      }
      unset($fbObject);
      return;
}
                
function install_sbp_db() {
  global $wpdb;
  require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
  $sbpress_collate = " COLLATE utf8_general_ci";

  $table_sbp_streams =  $wpdb->prefix . "ssp_streams";

  $table_sbp_streams="CREATE TABLE IF NOT EXISTS " . $table_sbp_streams . " (
            `fb_id` varchar(50) NOT NULL,
            `fb_title` text NOT NULL,
            `fb_start_time` bigint NOT NULL,
            `fb_image_file` varchar(450) NOT NULL,
            `fb_tags` varchar(255) NOT NULL,
            `fb_description` text NOT NULL,
            `fb_profile` varchar(50) NOT NULL,
            `fb_live` tinyint NOT NULL,
                  PRIMARY KEY (`fb_id`)
              )" . $sbpress_collate .";";
      dbDelta($table_sbp_streams);
}

function simplesocialpress_activate(){
      global $sbp_db_version;
      
      $installed_version = get_option('sbp_db_version');

      if ($installed_version !== $sbp_db_version) {
          global $wpdb;
          $table_sbp_streams =  $wpdb->prefix . "ssp_streams";$sql0='DROP TABLE IF EXISTS '. $table_sbp_streams;
		  $wpdb->query($sql0);
          $this->install_sbp_db();                
          update_option('sbp_db_version' , $sbp_db_version);
      }

      $this->generate_options_css(); 
		
  }

function simplesocialpress_deactivate(){
			$timestamp = wp_next_scheduled( 'simplesocialpress_fetch' );
			wp_unschedule_event($timestamp, 'hourly', 'simplesocialpress_fetch');	

		}
	
}//end class

?>